/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.jmx.mxbeans.ContextLoaderMXBean;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.web.context.support.XmlWebApplicationContext;

@ManagedResource(objectName="org.red5.server:name=contextLoader,type=ContextLoader", description="ContextLoader")
public class ContextLoader
implements ApplicationContextAware,
InitializingBean,
DisposableBean,
ContextLoaderMXBean {
    protected static Logger log = Red5LoggerFactory.getLogger(ContextLoader.class);
    protected ApplicationContext applicationContext;
    protected ApplicationContext parentContext;
    protected String contextsConfig;
    private ObjectName oName;
    protected ConcurrentMap<String, ApplicationContext> contextMap;

    public void afterPropertiesSet() throws Exception {
        log.info("ContextLoader init");
        this.registerJMX();
        this.init();
    }

    public void destroy() throws Exception {
        log.info("ContextLoader un-init");
        this.shutdown();
    }

    @Override
    public void init() throws IOException {
        Properties props = new Properties();
        Resource res = this.applicationContext.getResource(this.contextsConfig);
        if (res.exists()) {
            props.load(res.getInputStream());
            Pattern patt = Pattern.compile("\\$\\{([^\\}]+)\\}");
            Matcher matcher = null;
            for (Object key : props.keySet()) {
                String name = (String)key;
                String config = props.getProperty(name);
                Object configReplaced = config;
                matcher = patt.matcher(config);
                while (matcher.find()) {
                    String sysProp = matcher.group(1);
                    String systemPropValue = System.getProperty(sysProp);
                    if (systemPropValue == null) {
                        systemPropValue = "null";
                    }
                    configReplaced = ((String)configReplaced).replace(String.format("${%s}", sysProp), systemPropValue);
                }
                log.info("Loading: {} = {} => {}", new Object[]{name, config, configReplaced});
                matcher.reset();
                this.loadContext(name, (String)configReplaced);
            }
            patt = null;
            matcher = null;
        } else {
            log.error("Contexts config must be set");
        }
    }

    @Override
    public void loadContext(String name, String config) {
        log.debug("Load context - name: {} config: {}", (Object)name, config);
        try {
            File configFile = new File((String)config);
            if (!configFile.exists()) {
                log.warn("Config file was not found at: {}", (Object)configFile.getCanonicalPath());
                configFile = new File("file://" + (String)config);
                if (!configFile.exists()) {
                    log.warn("Config file was not found at either: {}", (Object)configFile.getCanonicalPath());
                } else {
                    config = "file://" + (String)config;
                }
            }
        }
        catch (IOException e) {
            log.error("Error looking for config file", (Throwable)e);
        }
        ConfigurableListableBeanFactory factory = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        if (factory.containsSingleton(name)) {
            log.warn("Singleton {} already exists, try unload first", (Object)name);
            return;
        }
        if (this.parentContext == null) {
            log.debug("Lookup common - bean:{} local:{} singleton:{}", new Object[]{factory.containsBean("red5.common"), factory.containsLocalBean("red5.common"), factory.containsSingleton("red5.common")});
            this.parentContext = (ApplicationContext)factory.getBean("red5.common");
        }
        if (((String)config).startsWith("/")) {
            String newConfig = "file://" + (String)config;
            log.debug("Resetting {} to {}", config, (Object)newConfig);
            config = newConfig;
        }
        FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(new String[]{config}, this.parentContext);
        log.debug("Adding to context map - name: {} context: {}", (Object)name, (Object)context);
        if (this.contextMap == null) {
            this.contextMap = new ConcurrentHashMap<String, ApplicationContext>(3, 0.9f, 1);
        }
        this.contextMap.put(name, (ApplicationContext)context);
        log.debug("Registering - name: {}", (Object)name);
        factory.registerSingleton(name, (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadContext(String name) {
        String[] bnames;
        log.debug("Un-load context - name: {}", (Object)name);
        ApplicationContext context = (ApplicationContext)this.contextMap.remove(name);
        log.debug("Context from map: {}", (Object)context);
        for (String bname : bnames = BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)context)) {
            log.debug("Bean: {}", (Object)bname);
        }
        ConfigurableListableBeanFactory factory = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        if (factory.containsSingleton(name)) {
            log.debug("Context found in parent, destroying: {}", (Object)name);
            FileSystemXmlApplicationContext ctx = (FileSystemXmlApplicationContext)factory.getSingleton(name);
            if (ctx.isRunning()) {
                log.debug("Context was running, attempting to stop");
                ctx.stop();
            }
            if (ctx.isActive()) {
                log.debug("Context is active, attempting to close");
                ctx.close();
            } else {
                try {
                    factory.destroyBean(name, (Object)ctx);
                }
                catch (Exception e) {
                    log.warn("Context destroy failed for: {}", (Object)name, (Object)e);
                    ctx.destroy();
                }
                finally {
                    if (factory.containsSingleton(name)) {
                        log.debug("Singleton still exists, trying another destroy method");
                        ((DefaultListableBeanFactory)factory).destroySingleton(name);
                    }
                }
            }
        } else {
            log.debug("Context does not contain singleton: {}", (Object)name);
        }
        context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        log.info("Shutting down");
        if (this.contextMap != null) {
            log.debug("Context map: {}", this.contextMap);
            try {
                for (Map.Entry entry : this.contextMap.entrySet()) {
                    String contextName = (String)entry.getKey();
                    log.info("Unloading context {} on shutdown", (Object)contextName);
                    this.unloadContext(contextName);
                }
                this.contextMap.clear();
            }
            catch (Exception e) {
                log.warn("Exception shutting down contexts", (Throwable)e);
            }
            finally {
                this.contextMap = null;
            }
        }
        this.unregisterJMX();
        log.info("Shutdown complete");
    }

    public ApplicationContext getContext(String name) {
        if (this.contextMap != null) {
            return (ApplicationContext)this.contextMap.get(name);
        }
        return null;
    }

    @Override
    public void setParentContext(String parentContextKey, String appContextId) {
        log.debug("Set parent context {} on {}", (Object)parentContextKey, (Object)appContextId);
        ApplicationContext parentContext = this.getContext(parentContextKey);
        if (parentContext != null) {
            XmlWebApplicationContext childContext = (XmlWebApplicationContext)this.getContext(appContextId);
            if (childContext != null) {
                childContext.setParent(parentContext);
            } else {
                log.debug("Child context not found");
            }
        } else {
            log.debug("Parent context not found");
        }
    }

    protected void registerJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            this.oName = new ObjectName("org.red5.server:name=contextLoader,type=ContextLoader");
            if (!mbs.isRegistered(this.oName)) {
                mbs.registerMBean(new StandardMBean(this, ContextLoaderMXBean.class, true), this.oName);
            } else {
                log.debug("ContextLoader is already registered in JMX");
            }
        }
        catch (Exception e) {
            log.warn("Error on jmx registration", (Throwable)e);
        }
    }

    protected void unregisterJMX() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(this.oName);
        }
        catch (Exception e) {
            log.warn("Exception unregistering: {}", (Object)this.oName, (Object)e);
        }
        this.oName = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setParentContext(ApplicationContext parentContext) {
        this.parentContext = parentContext;
    }

    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    @Override
    public void setContextsConfig(String contextsConfig) {
        this.contextsConfig = contextsConfig;
    }

    @Override
    public String getContextsConfig() {
        return this.contextsConfig;
    }
}

