/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.datastore;

import io.antmedia.console.datastore.MapBasedDataStore;
import io.vertx.core.Vertx;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBStore
extends MapBasedDataStore {
    private DB db = DBMaker.fileDB((String)"server.db").fileMmapEnableIfSupported().checksumHeaderBypass().make();
    private long timerId;
    private Vertx vertx;
    protected static Logger logger = LoggerFactory.getLogger(MapDBStore.class);

    public MapDBStore(Vertx vertx) {
        this.userMap = this.db.hashMap("serverdb").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.STRING).counterEnable().createOrOpen();
        this.vertx = vertx;
        this.timerId = vertx.setPeriodic(5000L, id -> this.vertx.executeBlocking(b -> {
            MapDBStore mapDBStore = this;
            synchronized (mapDBStore) {
                if (this.available) {
                    this.db.commit();
                }
            }
        }, false, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            this.userMap.clear();
            this.db.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            this.vertx.cancelTimer(this.timerId);
            this.db.commit();
            this.available = false;
            this.db.close();
        }
    }
}

