/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.datastore;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import dev.morphia.Datastore;
import dev.morphia.Morphia;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import dev.morphia.query.updates.UpdateOperator;
import dev.morphia.query.updates.UpdateOperators;
import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.datastore.db.types.User;
import io.antmedia.rest.model.UserType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStore
extends AbstractConsoleDataStore {
    private Datastore datastore;
    protected static Logger logger = LoggerFactory.getLogger(MongoStore.class);
    protected volatile boolean available = false;
    private MongoClient mongoClient;

    public MongoStore(String dbHost, String dbUser, String dbPassword) {
        String dbName = "serverdb";
        String uri = io.antmedia.datastore.db.MongoStore.getMongoConnectionUri(dbHost, dbUser, dbPassword);
        this.mongoClient = MongoClients.create((String)uri);
        this.datastore = Morphia.createDatastore((MongoClient)this.mongoClient, (String)dbName);
        this.datastore.getMapper().mapPackage("io.antmedia.datastore.db.types");
        this.datastore.ensureIndexes();
        this.available = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> getUserList() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            ArrayList<User> users = new ArrayList();
            try {
                users = this.datastore.find(User.class).iterator().toList();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            return users;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addUser(User user) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            boolean result = false;
            User existingUser = (User)this.datastore.find(User.class).filter(new Filter[]{Filters.eq((String)"email", (Object)user.getEmail())}).first();
            if (existingUser == null) {
                this.datastore.save((Object)user);
                result = true;
            } else {
                logger.warn("user with {} already exist", (Object)user.getEmail());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editUser(User user) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                String username = user.getEmail();
                String password = user.getPassword();
                UserType userType = user.getUserType();
                String scope = user.getScope();
                return this.datastore.find(User.class).filter(new Filter[]{Filters.eq((String)"email", (Object)username)}).update(UpdateOperators.set((String)"password", (Object)password), new UpdateOperator[]{UpdateOperators.set((String)"userType", (Object)((Object)userType)), UpdateOperators.set((String)"scope", (Object)scope)}).execute().getMatchedCount() == 1L;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUser(String username) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            try {
                return this.datastore.find(User.class).filter(new Filter[]{Filters.eq((String)"email", (Object)username)}).delete().getDeletedCount() == 1L;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesUsernameExist(String username) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            User existingUser = (User)this.datastore.find(User.class).filter(new Filter[]{Filters.eq((String)"email", (Object)username)}).first();
            return existingUser != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesUserExist(String username, String password) {
        boolean result = false;
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            User existingUser = (User)this.datastore.find(User.class).filter(new Filter[]{Filters.eq((String)"email", (Object)username), Filters.eq((String)"password", (Object)password)}).first();
            if (existingUser != null) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUser(String username) {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return (User)this.datastore.find(User.class).filter(new Filter[]{Filters.eq((String)"email", (Object)username)}).first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            this.datastore.find(User.class).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            this.available = false;
            this.mongoClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfUserRecords() {
        MongoStore mongoStore = this;
        synchronized (mongoStore) {
            return (int)this.datastore.find(User.class).count();
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }
}

