/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.datastore;

import io.antmedia.console.datastore.MapBasedDataStore;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisStore
extends MapBasedDataStore {
    RedissonClient redisson;
    protected static Logger logger = LoggerFactory.getLogger(RedisStore.class);

    public RedisStore(String redisConnectionUrl) {
        try {
            Config config;
            File file = new File(redisConnectionUrl);
            if (file.exists()) {
                config = Config.fromYAML((File)file);
            } else {
                config = new Config();
                config.useSingleServer().setAddress(redisConnectionUrl);
            }
            this.redisson = Redisson.create((Config)config);
            this.userMap = this.redisson.getMap("users");
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        RedisStore redisStore = this;
        synchronized (redisStore) {
            this.userMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RedisStore redisStore = this;
        synchronized (redisStore) {
            this.available = false;
            this.redisson.shutdown();
        }
    }
}

