/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.rest;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.console.datastore.ConsoleDataStoreFactory;
import io.antmedia.console.rest.CommonRestService;
import io.antmedia.datastore.db.types.User;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.rest.model.UserType;
import io.antmedia.settings.ServerSettings;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class AuthenticationFilter
extends AbstractFilter {
    public static final String DISPATCH_PATH_URL = "_path";
    public static final String JWT_TOKEN = "ProxyAuthorization";
    public static final String FORBIDDEN_ERROR = "Not allowed to access this resource. Contact system admin";

    public AbstractConsoleDataStore getDataStore() {
        Object dataStoreFactory;
        AbstractConsoleDataStore dataStore = null;
        ConfigurableWebApplicationContext appContext = this.getWebApplicationContext();
        if (appContext != null && appContext.isRunning() && (dataStoreFactory = appContext.getBean("dataStoreFactory")) instanceof ConsoleDataStoreFactory) {
            AbstractConsoleDataStore dataStoreTemp = ((ConsoleDataStoreFactory)dataStoreFactory).getDataStore();
            if (dataStoreTemp.isAvailable()) {
                dataStore = dataStoreTemp;
            } else {
                logger.warn("DataStore is not available. It may be closed or not initialized");
            }
        }
        return dataStore;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = ((HttpServletRequest)request).getRequestURI();
        ServerSettings serverSettings = this.getServerSetting();
        if (serverSettings != null && serverSettings.isJwtServerControlEnabled() && httpRequest.getHeader(JWT_TOKEN) != null) {
            if (this.checkJWT(httpRequest.getHeader(JWT_TOKEN))) {
                chain.doFilter(request, response);
            } else {
                ((HttpServletResponse)response).sendError(403, "Invalid Server JWT Token");
            }
        } else if (path.equals("/rest/isAuthenticated") || path.equals("/rest/authenticateUser") || path.equals("/rest/addInitialUser") || path.equals("/rest/isFirstLogin") || path.equals("/rest/v2/authentication-status") || path.equals("/rest/v2/users/initial") || path.equals("/rest/v2/first-login-status") || path.equals("/rest/v2/users/authenticate") || path.equals("/rest/v2/liveness") || path.startsWith("/rest/v2/users/") && path.endsWith("/blocked")) {
            chain.doFilter(request, response);
        } else if (CommonRestService.isAuthenticated(((HttpServletRequest)request).getSession())) {
            String method = httpRequest.getMethod();
            String userEmail = (String)httpRequest.getSession().getAttribute("user.email");
            AbstractConsoleDataStore store = this.getDataStore();
            if (store != null) {
                User currentUser = store.getUser(userEmail);
                if (currentUser != null) {
                    String userScope = currentUser.getScope();
                    String dispatchURL = httpRequest.getParameter(DISPATCH_PATH_URL);
                    boolean scopeAccess = this.scopeAccessGranted(userScope, dispatchURL);
                    if ("GET".equals(method)) {
                        if (scopeAccess || path.equals("/rest/v2/applications/settings/" + userScope) || path.equals("/rest/v2/version") || path.equals("/rest/v2/enterprise-edition") || path.equals("/rest/v2/admin-status")) {
                            chain.doFilter(request, response);
                        } else {
                            ((HttpServletResponse)response).sendError(403, FORBIDDEN_ERROR);
                        }
                    } else if (path.equals("/rest/v2/users/password") || path.startsWith("/rest/v2/support/request")) {
                        chain.doFilter(request, response);
                    } else if (scopeAccess) {
                        if (UserType.ADMIN.equals((Object)currentUser.getUserType()) || currentUser.getUserType() == null) {
                            chain.doFilter(request, response);
                        } else if (UserType.USER.equals((Object)currentUser.getUserType()) && dispatchURL != null && (dispatchURL.contains("/rest/v2/broadcasts") || dispatchURL.contains("/rest/v2/vods"))) {
                            chain.doFilter(request, response);
                        } else {
                            ((HttpServletResponse)response).sendError(403, FORBIDDEN_ERROR);
                        }
                    } else if (UserType.ADMIN.equals((Object)currentUser.getUserType()) && (path.startsWith("/rest/v2/applications/settings/" + userScope) || path.startsWith(userScope) || path.startsWith(userScope, 1))) {
                        chain.doFilter(request, response);
                    } else {
                        ((HttpServletResponse)response).sendError(403, FORBIDDEN_ERROR);
                    }
                } else {
                    ((HttpServletResponse)response).sendError(403, "No user in this session");
                }
            } else {
                ((HttpServletResponse)response).sendError(500, "Database is not available. Please try again");
            }
        } else {
            ((HttpServletResponse)response).sendError(403, "Not authenticated user");
        }
    }

    private boolean scopeAccessGranted(String userScope, String dispatchUrl) {
        boolean granted = false;
        if (userScope == null || userScope.equals("system")) {
            granted = true;
        } else if (dispatchUrl != null && (dispatchUrl.startsWith(userScope) || dispatchUrl.startsWith(userScope, 1))) {
            granted = true;
        }
        return granted;
    }

    private boolean checkJWT(String jwtString) {
        boolean result = true;
        try {
            String jwksURL = this.getServerSetting().getJwksURL();
            if (jwksURL != null && !jwksURL.isEmpty()) {
                DecodedJWT jwt = JWT.decode((String)jwtString);
                UrlJwkProvider provider = new UrlJwkProvider(this.getServerSetting().getJwksURL());
                Jwk jwk = provider.get(jwt.getKeyId());
                Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
                algorithm.verify(jwt);
            } else {
                Algorithm algorithm = Algorithm.HMAC256((String)this.getServerSetting().getJwtServerSecretKey());
                JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
                verifier.verify(jwtString);
            }
        }
        catch (JWTVerificationException ex) {
            logger.error(ex.toString());
            result = false;
        }
        catch (JwkException e) {
            logger.error(e.toString());
            result = false;
        }
        return result;
    }
}

