/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.rest;

import io.antmedia.cluster.ClusterNode;
import io.antmedia.cluster.IClusterNotifier;
import io.antmedia.cluster.IClusterStore;
import io.antmedia.rest.BroadcastRestService;
import io.antmedia.rest.model.Result;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Component
@Path(value="/v2/cluster")
public class ClusterRestServiceV2 {
    protected static Logger logger = LoggerFactory.getLogger(ClusterRestServiceV2.class);
    @Context
    private ServletContext servletContext;

    public IClusterStore getClusterStore() {
        IClusterStore clusterStore = null;
        WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
        if (ctxt != null) {
            IClusterNotifier clusterNotifier = (IClusterNotifier)ctxt.getBean("tomcat.cluster");
            clusterStore = clusterNotifier.getClusterStore();
        }
        return clusterStore;
    }

    @GET
    @Path(value="/node-count")
    public BroadcastRestService.SimpleStat getNodeCount() {
        IClusterStore clusterStore = this.getClusterStore();
        long nodeCount = -1L;
        if (clusterStore != null) {
            nodeCount = clusterStore.getNodeCount();
        }
        return new BroadcastRestService.SimpleStat(nodeCount);
    }

    @GET
    @Path(value="/nodes/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<ClusterNode> getNodeList(@PathParam(value="offset") int offset, @PathParam(value="size") int size) {
        IClusterStore clusterStore = this.getClusterStore();
        List<Object> nodeList = null;
        nodeList = clusterStore != null ? clusterStore.getClusterNodes(offset, size) : new ArrayList();
        return nodeList;
    }

    @DELETE
    @Path(value="/node/{id}")
    @Produces(value={"application/json"})
    public Result deleteNode(@PathParam(value="id") String nodeId) {
        boolean result = false;
        IClusterStore clusterStore = this.getClusterStore();
        if (clusterStore != null) {
            result = clusterStore.deleteNode(nodeId);
        }
        return new Result(result);
    }
}

