/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.rest;

import io.antmedia.AppSettings;
import io.antmedia.console.rest.CommonRestService;
import io.antmedia.datastore.db.types.Licence;
import io.antmedia.datastore.db.types.User;
import io.antmedia.rest.model.Result;
import io.antmedia.settings.ServerSettings;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
@Path(value="/")
public class RestService
extends CommonRestService {
    @Override
    @POST
    @Path(value="/addUser")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result addUser(User user) {
        return super.addUser(user);
    }

    @Override
    @GET
    @Path(value="/isAdmin")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result isAdmin() {
        return super.isAdmin();
    }

    @Override
    @POST
    @Path(value="/addInitialUser")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result addInitialUser(User user) {
        return super.addInitialUser(user);
    }

    @Override
    @GET
    @Path(value="/isFirstLogin")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result isFirstLogin() {
        return super.isFirstLogin();
    }

    @Override
    @POST
    @Path(value="/editUser")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result editUser(User user) {
        return super.editUser(user);
    }

    @Override
    @DELETE
    @Path(value="/deleteUser/{username}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Result deleteUser(@PathParam(value="username") String userName) {
        return super.deleteUser(userName);
    }

    @Override
    @POST
    @Path(value="/authenticateUser")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result authenticateUser(User user) {
        return super.authenticateUser(user);
    }

    @Override
    @POST
    @Path(value="/changeUserPassword")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result changeUserPassword(User user) {
        return super.changeUserPassword(user);
    }

    @Override
    @GET
    @Path(value="/userList")
    @Produces(value={"application/json"})
    public List<User> getUserList() {
        return super.getUserList();
    }

    @Override
    @GET
    @Path(value="/isAuthenticated")
    @Produces(value={"application/json"})
    public Result isAuthenticatedRest() {
        return super.isAuthenticatedRest();
    }

    @Override
    @GET
    @Path(value="/getSystemInfo")
    @Produces(value={"application/json"})
    public String getSystemInfo() {
        return super.getSystemInfo();
    }

    @Override
    @GET
    @Path(value="/getJVMMemoryInfo")
    @Produces(value={"application/json"})
    public String getJVMMemoryInfo() {
        return super.getJVMMemoryInfo();
    }

    @Override
    @GET
    @Path(value="/getSystemMemoryInfo")
    @Produces(value={"application/json"})
    public String getSystemMemoryInfo() {
        return super.getSystemMemoryInfo();
    }

    @Override
    @GET
    @Path(value="/getFileSystemInfo")
    @Produces(value={"application/json"})
    public String getFileSystemInfo() {
        return super.getFileSystemInfo();
    }

    @Override
    @GET
    @Path(value="/getCPUInfo")
    @Produces(value={"application/json"})
    public String getCPUInfo() {
        return super.getCPUInfo();
    }

    @Override
    @GET
    @Path(value="/thread-dump-raw")
    @Produces(value={"text/plain"})
    public String getThreadDump() {
        return super.getThreadDump();
    }

    @Override
    @GET
    @Path(value="/thread-dump-json")
    @Produces(value={"application/json"})
    public String getThreadDumpJSON() {
        return super.getThreadDumpJSON();
    }

    @Override
    @GET
    @Path(value="/threads-info")
    @Produces(value={"application/json"})
    public String getThreadsInfo() {
        return super.getThreadsInfo();
    }

    @Override
    @GET
    @Path(value="/heap-dump")
    @Produces(value={"application/octet-stream"})
    public Response getHeapDump() {
        return super.getHeapDump();
    }

    @Override
    @GET
    @Path(value="/server-time")
    @Produces(value={"application/json"})
    public String getServerTime() {
        return super.getServerTime();
    }

    @Override
    @GET
    @Path(value="/getSystemResourcesInfo")
    @Produces(value={"application/json"})
    public String getSystemResourcesInfo() {
        return super.getSystemResourcesInfo();
    }

    @Override
    @GET
    @Path(value="/getGPUInfo")
    @Produces(value={"application/json"})
    public String getGPUInfo() {
        return super.getGPUInfo();
    }

    @Override
    @GET
    @Path(value="/getVersion")
    @Produces(value={"application/json"})
    public String getVersion() {
        return super.getVersion();
    }

    @Override
    @GET
    @Path(value="/getApplications")
    @Produces(value={"application/json"})
    public String getApplications() {
        return super.getApplications();
    }

    @Override
    @GET
    @Path(value="/getLiveClientsSize")
    @Produces(value={"application/json"})
    public String getLiveClientsSize() {
        return super.getLiveClientsSize();
    }

    @Override
    @GET
    @Path(value="/getApplicationsInfo")
    @Produces(value={"application/json"})
    public String getApplicationInfo() {
        return super.getApplicationInfo();
    }

    @Override
    @Deprecated
    @GET
    @Path(value="/getAppLiveStreams/{appname}")
    @Produces(value={"application/json"})
    public String getAppLiveStreams(@PathParam(value="appname") String name) {
        return super.getAppLiveStreams(name);
    }

    @Override
    @Deprecated
    @POST
    @Path(value="/deleteVoDStream/{appname}")
    @Produces(value={"application/json"})
    public String deleteVoDStream(@PathParam(value="appname") String name, @FormParam(value="streamName") String streamName) {
        return super.deleteVoDStream(name, streamName);
    }

    @Override
    @POST
    @Path(value="/changeSettings/{appname}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String changeSettings(@PathParam(value="appname") String appname, AppSettings newSettings) {
        return super.changeSettings(appname, newSettings);
    }

    @Override
    @Deprecated
    @GET
    @Path(value="/isShutdownProperly")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public boolean getShutdownStatus(@QueryParam(value="appNames") String appNamesArray) {
        return super.getShutdownStatus(appNamesArray);
    }

    @Override
    @GET
    @Path(value="/shutdown-properly")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response isShutdownProperly(@QueryParam(value="appNames") String appNamesArray) {
        return super.isShutdownProperly(appNamesArray);
    }

    @Override
    @GET
    @Path(value="/setShutdownProperly")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public boolean setShutdownStatus(@QueryParam(value="appNames") String appNamesArray) {
        return super.setShutdownStatus(appNamesArray);
    }

    @Override
    @POST
    @Path(value="/changeServerSettings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String changeServerSettings(ServerSettings serverSettings) {
        return super.changeServerSettings(serverSettings);
    }

    @Override
    @GET
    @Path(value="/isEnterpriseEdition")
    @Produces(value={"application/json"})
    public Result isEnterpriseEdition() {
        return super.isEnterpriseEdition();
    }

    @Override
    @GET
    @Path(value="/getSettings/{appname}")
    @Produces(value={"application/json"})
    public AppSettings getSettings(@PathParam(value="appname") String appname) {
        return super.getSettings(appname);
    }

    @Override
    @GET
    @Path(value="/getServerSettings")
    @Produces(value={"application/json"})
    public ServerSettings getServerSettings() {
        return super.getServerSettings();
    }

    @Override
    @GET
    @Path(value="/getLicenceStatus")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Licence getLicenceStatus(@QueryParam(value="key") String key) {
        return super.getLicenceStatus(key);
    }

    @Override
    @GET
    @Path(value="/getLastLicenceStatus")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Licence getLicenceStatus() {
        return super.getLicenceStatus();
    }

    @Override
    @POST
    @Path(value="/reset-broadcasts/{appname}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result resetBroadcast(@PathParam(value="appname") String appname) {
        return super.resetBroadcast(appname);
    }

    @Override
    @GET
    @Path(value="/isInClusterMode")
    @Produces(value={"application/json"})
    public Result isInClusterMode() {
        return super.isInClusterMode();
    }

    @Override
    @GET
    @Path(value="/changeLogLevel/{level}")
    @Produces(value={"application/json"})
    public String changeLogSettings(@PathParam(value="level") String logLevel) {
        return super.changeLogSettings(logLevel);
    }

    @Override
    @GET
    @Path(value="/getLogFile/{offsetSize}/{charSize}")
    @Produces(value={"application/json"})
    public String getLogFile(@PathParam(value="charSize") int charSize, @QueryParam(value="logType") String logType, @PathParam(value="offsetSize") long offsetSize) throws IOException {
        return super.getLogFile(charSize, logType, offsetSize);
    }

    @Override
    @POST
    @Path(value="/applications")
    @Produces(value={"application/json"})
    public Result createApplication(@QueryParam(value="appName") String appName, InputStream inputStream) {
        return super.createApplication(appName, inputStream);
    }

    @Override
    @DELETE
    @Path(value="/applications/{appName}")
    @Produces(value={"application/json"})
    public Result deleteApplication(@PathParam(value="appName") String appName, @QueryParam(value="deleteDB") boolean deleteDB) {
        return super.deleteApplication(appName, deleteDB);
    }
}

