/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.IDataStoreFactory;
import io.antmedia.datastore.db.InMemoryDataStore;
import io.antmedia.datastore.db.MapDBStore;
import io.antmedia.datastore.db.MongoStore;
import io.antmedia.datastore.db.RedisStore;
import io.antmedia.settings.ServerSettings;
import io.vertx.core.Vertx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DataStoreFactory
implements IDataStoreFactory,
ApplicationContextAware {
    public static final String DB_TYPE_MEMORYDB = "memorydb";
    public static final String DB_TYPE_MAPDB = "mapdb";
    public static final String DB_TYPE_MONGODB = "mongodb";
    public static final String DB_TYPE_REDISDB = "redisdb";
    public static final String SETTINGS_DB_NAME = "db.name";
    public static final String SETTINGS_DB_TYPE = "db.type";
    public static final String SETTINGS_DB_HOST = "db.host";
    public static final String SETTINGS_DB_USER = "db.user";
    public static final String SETTINGS_DB_PASS = "db.password";
    private static Logger logger = LoggerFactory.getLogger(DataStoreFactory.class);
    private DataStore dataStore;
    @Value(value="${settings.writeStatsToDatastore:true}")
    private boolean writeStatsToDatastore;
    @Value(value="${db.name:#{null}}")
    private String dbName;
    @Value(value="${db.type:#{null}}")
    private String dbType;
    @Value(value="${db.host:#{null}}")
    private String dbHost;
    @Value(value="${db.user:#{null}}")
    private String dbUser;
    @Value(value="${db.password:#{null}}")
    private String dbPassword;
    private String hostAddress;
    private Vertx vertx;

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void init() {
        if (this.dbType.contentEquals(DB_TYPE_MONGODB)) {
            this.dataStore = new MongoStore(this.dbHost, this.dbUser, this.dbPassword, this.dbName);
        } else if (this.dbType.contentEquals(DB_TYPE_MAPDB)) {
            this.dataStore = new MapDBStore(this.dbName + ".db", this.vertx);
        } else if (this.dbType.contentEquals(DB_TYPE_REDISDB)) {
            this.dataStore = new RedisStore(this.dbHost, this.dbName);
        } else if (this.dbType.contentEquals(DB_TYPE_MEMORYDB)) {
            this.dataStore = new InMemoryDataStore(this.dbName);
        } else {
            logger.error("Undefined Datastore:{}  db name:{}", (Object)this.dbType, (Object)this.dbName);
        }
        logger.info("Used Datastore:{}  db name:{}", (Object)this.getDbType(), (Object)this.getDbName());
        if (this.dataStore != null) {
            this.dataStore.setWriteStatsToDatastore(this.writeStatsToDatastore);
        }
    }

    @Override
    public DataStore getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public boolean isWriteStatsToDatastore() {
        return this.writeStatsToDatastore;
    }

    public void setWriteStatsToDatastore(boolean writeStatsToDatastore) {
        this.writeStatsToDatastore = writeStatsToDatastore;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.vertx = (Vertx)applicationContext.getBean("vertxCore");
        ServerSettings serverSettings = (ServerSettings)applicationContext.getBean("ant.media.server.settings");
        this.hostAddress = serverSettings.getHostAddress();
        this.init();
    }
}

