/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.filter.TokenFilterManager;
import io.antmedia.statistic.IStreamStats;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HlsStatisticsFilter
extends AbstractFilter {
    protected static Logger logger = LoggerFactory.getLogger(HlsStatisticsFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod();
        if ("GET".equals(method) && httpRequest.getRequestURI().endsWith("m3u8")) {
            String sessionId = httpRequest.getSession().getId();
            String streamId = TokenFilterManager.getStreamId(httpRequest.getRequestURI());
            String subscriberId = ((HttpServletRequest)request).getParameter("subscriberId");
            Broadcast broadcast = this.getBroadcast(streamId);
            if (broadcast != null && broadcast.getHlsViewerLimit() != -1 && broadcast.getHlsViewerCount() >= broadcast.getHlsViewerLimit()) {
                ((HttpServletResponse)response).sendError(403, "Viewer Limit Reached");
                return;
            }
            chain.doFilter(request, response);
            int status = ((HttpServletResponse)response).getStatus();
            if (200 <= status && status <= 400 && streamId != null) {
                logger.debug("req ip {} session id {} stream id {} status {}", new Object[]{request.getRemoteHost(), sessionId, streamId, status});
                IStreamStats stats = this.getStreamStats("hls.viewerstats");
                if (stats != null) {
                    stats.registerNewViewer(streamId, sessionId, subscriberId);
                }
            }
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }
}

