/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.antmedia.AppSettings;
import io.antmedia.filter.AbstractFilter;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTFilter
extends AbstractFilter {
    protected static Logger log = LoggerFactory.getLogger(JWTFilter.class);
    public static final String JWT_TOKEN = "Authorization";
    private AppSettings appSettings;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.appSettings = this.getAppSettings();
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.appSettings != null && !this.appSettings.isJwtControlEnabled() || httpRequest.getHeader(JWT_TOKEN) != null && this.checkJWT(httpRequest.getHeader(JWT_TOKEN))) {
            chain.doFilter(request, response);
            return;
        }
        ((HttpServletResponse)response).sendError(403, "Invalid App JWT Token");
    }

    private boolean checkJWT(String jwtString) {
        boolean result = true;
        try {
            String jwksURL = this.appSettings.getJwksURL();
            if (jwksURL != null && !jwksURL.isEmpty()) {
                DecodedJWT jwt = JWT.decode((String)jwtString);
                UrlJwkProvider provider = new UrlJwkProvider(this.appSettings.getJwksURL());
                Jwk jwk = provider.get(jwt.getKeyId());
                Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
                algorithm.verify(jwt);
            } else {
                Algorithm algorithm = Algorithm.HMAC256((String)this.appSettings.getJwtSecretKey());
                JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
                verifier.verify(jwtString);
            }
        }
        catch (JWTVerificationException ex) {
            logger.error(ex.toString());
            result = false;
        }
        catch (JwkException e) {
            logger.error(e.toString());
            result = false;
        }
        return result;
    }
}

