/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.rest.servlet.EndpointProxy;
import java.io.File;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class RestProxyFilter
extends AbstractFilter {
    protected static Logger log = LoggerFactory.getLogger(RestProxyFilter.class);
    private DataStore dataStore;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        String reqURI = httpReq.getRequestURI();
        String method = httpReq.getMethod();
        if ("POST".equals(method) || "PUT".equals(method) || "DELETE".equals(method)) {
            String streamId = this.getStreamId(reqURI);
            if (streamId != null && !streamId.isEmpty()) {
                Broadcast broadcast = this.getDataStore().get(streamId);
                log.debug("STREAM ID = {} BROADCAST = {} ", (Object)streamId, (Object)broadcast);
                if (broadcast == null || !"broadcasting".equals(broadcast.getStatus()) || this.isInSameNodeInCluster(request.getRemoteAddr(), broadcast.getOriginAdress())) {
                    chain.doFilter(request, response);
                } else {
                    AppSettings settings = this.getAppSettings();
                    String originAdress = "http://" + broadcast.getOriginAdress() + ":" + this.getServerSetting().getDefaultHttpPort() + File.separator + settings.getAppName() + "/rest";
                    log.info("Redirecting request to origin {}", (Object)originAdress);
                    EndpointProxy endpointProxy = new EndpointProxy();
                    endpointProxy.initTarget(originAdress);
                    endpointProxy.service(request, response);
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public String getStreamId(String reqURI) {
        try {
            reqURI = reqURI.split("broadcasts/")[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        if (reqURI.contains("/")) {
            reqURI = reqURI.substring(0, reqURI.indexOf("/"));
        }
        return reqURI;
    }

    public boolean isInSameNodeInCluster(String requestAddress, String streamOriginAddress) {
        ConfigurableWebApplicationContext context = this.getAppContext();
        boolean isCluster = context.containsBean("tomcat.cluster");
        return !isCluster || requestAddress.equals(this.getServerSetting().getHostAddress()) || this.getServerSetting().getHostAddress().equals(streamOriginAddress);
    }

    public DataStore getDataStore() {
        if (this.dataStore == null) {
            ConfigurableWebApplicationContext context = this.getAppContext();
            if (context != null) {
                this.dataStore = ((DataStoreFactory)context.getBean("dataStoreFactory")).getDataStore();
            } else {
                log.error("RestProxyFilter is not initialized because context returns null");
            }
        }
        return this.dataStore;
    }
}

