/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.security;

import com.google.gson.JsonObject;
import io.antmedia.AppSettings;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AcceptOnlyStreamsWithWebhook
implements IStreamPublishSecurity {
    @Autowired
    private AppSettings appSettings = null;
    public static final String BEAN_NAME = "acceptOnlyStreamsWithWebhook";
    protected static Logger logger = LoggerFactory.getLogger(AcceptOnlyStreamsWithWebhook.class);

    @Override
    public synchronized boolean isPublishAllowed(IScope scope, String streamId, String mode, Map<String, String> queryParams) {
        String webhookAuthURL;
        AtomicBoolean result = new AtomicBoolean(false);
        if (this.appSettings == null) {
            this.appSettings = (AppSettings)scope.getContext().getBean("app.settings");
        }
        if ((webhookAuthURL = this.appSettings.getWebhookAuthenticateURL()) != null && !webhookAuthURL.isEmpty()) {
            try (CloseableHttpClient client = this.getHttpClient();){
                JsonObject instance = new JsonObject();
                instance.addProperty("appName", scope.getName());
                instance.addProperty("name", streamId);
                instance.addProperty("streamId", streamId);
                instance.addProperty("mode", mode);
                if (queryParams != null) {
                    instance.addProperty("queryParams", queryParams.toString());
                }
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(5000).build();
                HttpRequestBase post = (HttpRequestBase)RequestBuilder.post().setUri(webhookAuthURL).setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(instance.toString())).build();
                post.setConfig(requestConfig);
                CloseableHttpResponse response = client.execute((HttpUriRequest)post);
                int statuscode = response.getStatusLine().getStatusCode();
                logger.info("Response from webhook is: {} for stream:{}", (Object)statuscode, (Object)streamId);
                result.set(statuscode == 200);
            }
            catch (Exception e) {
                logger.error("Couldn't connect Webhook for Stream Authentication {} ", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        } else {
            logger.info("AcceptOnlyStreamsWithWebhook is not activated for stream {}", (Object)streamId);
            result.set(true);
        }
        if (!result.get()) {
            IConnection connectionLocal = Red5.getConnectionLocal();
            if (connectionLocal != null) {
                connectionLocal.close();
            } else {
                logger.warn("Connection object is null for {}", (Object)streamId);
            }
        }
        return result.get();
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    public int readHttpResponse(HttpResponse response) {
        int statuscode = response.getStatusLine().getStatusCode();
        logger.info("Response from webhook is: {}", (Object)statuscode);
        return statuscode;
    }
}

