/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.streamsource;

import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.licence.ILicenceService;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.rest.model.Result;
import io.antmedia.streamsource.StreamFetcher;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.tika.utils.ExceptionUtils;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFetcherManager {
    protected static Logger logger = LoggerFactory.getLogger(StreamFetcherManager.class);
    private int streamCheckerCount = 0;
    private Queue<StreamFetcher> streamFetcherList = new ConcurrentLinkedQueue<StreamFetcher>();
    private int streamCheckerIntervalMs = 10000;
    private DataStore datastore;
    private IScope scope;
    private long streamFetcherScheduleJobName = -1L;
    protected AtomicBoolean isJobRunning = new AtomicBoolean(false);
    private boolean restartStreamAutomatically = true;
    private Vertx vertx;
    private int lastRestartCount;
    private AppSettings appSettings;
    private ILicenceService licenseService;

    public StreamFetcherManager(Vertx vertx, DataStore datastore, IScope scope) {
        this.vertx = vertx;
        this.datastore = datastore;
        this.scope = scope;
        this.appSettings = (AppSettings)scope.getContext().getBean("app.settings");
        this.licenseService = (ILicenceService)scope.getContext().getBean(ILicenceService.BeanName.LICENCE_SERVICE.toString());
    }

    public StreamFetcher make(Broadcast stream, IScope scope, Vertx vertx) {
        return new StreamFetcher(stream.getStreamUrl(), stream.getStreamId(), stream.getType(), scope, vertx);
    }

    public int getStreamCheckerInterval() {
        return this.streamCheckerIntervalMs;
    }

    public void setStreamCheckerInterval(int streamCheckerInterval) {
        this.streamCheckerIntervalMs = streamCheckerInterval;
    }

    public boolean isStreamRunning(String streamId) {
        boolean alreadyFetching = false;
        for (StreamFetcher streamFetcher : this.streamFetcherList) {
            if (!streamFetcher.getStreamId().equals(streamId)) continue;
            alreadyFetching = true;
            break;
        }
        return alreadyFetching;
    }

    public Result startStreamScheduler(StreamFetcher streamScheduler) {
        Result result = new Result(false);
        result.setDataId(streamScheduler.getStreamId());
        if (!this.licenseService.isLicenceSuspended()) {
            streamScheduler.startStream();
            if (!this.streamFetcherList.contains(streamScheduler)) {
                this.streamFetcherList.add(streamScheduler);
            }
            if (this.streamFetcherScheduleJobName == -1L) {
                this.scheduleStreamFetcherJob();
            }
            result.setSuccess(true);
        } else {
            logger.error("License is suspend and new stream scheduler is not started {}", (Object)streamScheduler.getStreamUrl());
            result.setMessage("License is suspended");
        }
        return result;
    }

    public Result startStreaming(@Nonnull Broadcast broadcast) {
        boolean alreadyFetching = this.isStreamRunning(broadcast.getStreamId());
        StreamFetcher streamScheduler = null;
        Result result = new Result(false);
        if (!alreadyFetching) {
            try {
                streamScheduler = this.make(broadcast, this.scope, this.vertx);
                streamScheduler.setRestartStream(this.restartStreamAutomatically);
                streamScheduler.setDataStore(this.getDatastore());
                result = this.startStreamScheduler(streamScheduler);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                result.setMessage("Problem occured while fetching the stream");
            }
        } else {
            result.setMessage("Stream is already active. It's already streaming or trying to connect");
        }
        return result;
    }

    public Result stopStreaming(String streamId) {
        logger.warn("inside of stopStreaming for {}", (Object)streamId);
        Result result = new Result(false);
        for (StreamFetcher scheduler : this.streamFetcherList) {
            if (!scheduler.getStreamId().equals(streamId)) continue;
            scheduler.stopStream();
            this.streamFetcherList.remove(scheduler);
            result.setSuccess(true);
            break;
        }
        result.setMessage((String)(result.isSuccess() ? "Stream stopped" : "No matching stream source in this server:" + streamId));
        result.setDataId(streamId);
        return result;
    }

    public void stopCheckerJob() {
        if (this.streamFetcherScheduleJobName != -1L) {
            this.vertx.cancelTimer(this.streamFetcherScheduleJobName);
            this.streamFetcherScheduleJobName = -1L;
        }
    }

    public static Result checkStreamUrlWithHTTP(String url) {
        Result result = new Result(false);
        try {
            URL checkUrl = new URL(url);
            HttpURLConnection huc = (HttpURLConnection)checkUrl.openConnection();
            int responseCode = huc.getResponseCode();
            if (responseCode >= 200 && responseCode < 301) {
                result.setSuccess(true);
                return result;
            }
            result.setSuccess(false);
            result.setMessage("URL " + url + "responded:" + responseCode);
            return result;
        }
        catch (IOException e) {
            result.setSuccess(false);
            return result;
        }
    }

    public void playNextItemInList(String streamId, StreamFetcher.IStreamFetcherListener listener) {
        this.stopStreaming(streamId);
        Broadcast playlist = this.datastore.get(streamId);
        if (playlist != null && !"finished".equals(playlist.getPlayListStatus()) && this.skipNextPlaylistQueue(playlist) != null) {
            int currentStreamIndex = playlist.getCurrentPlayIndex();
            if (StreamFetcherManager.checkStreamUrlWithHTTP(playlist.getPlayListItemList().get(currentStreamIndex).getStreamUrl()).isSuccess()) {
                Broadcast.PlayListItem fetchedBroadcast = playlist.getPlayListItemList().get(currentStreamIndex);
                Result result = new Result(false);
                result.setSuccess(this.datastore.updateBroadcastFields(streamId, playlist));
                StreamFetcher newStreamScheduler = new StreamFetcher(fetchedBroadcast.getStreamUrl(), streamId, fetchedBroadcast.getType(), this.scope, this.vertx);
                newStreamScheduler.setStreamFetcherListener(listener);
                newStreamScheduler.setRestartStream(false);
                this.startStreamScheduler(newStreamScheduler);
            } else {
                logger.info("Current Playlist Stream URL -> {} is invalid", (Object)playlist.getPlayListItemList().get(currentStreamIndex).getStreamUrl());
                playlist = this.skipNextPlaylistQueue(playlist);
                this.startPlaylist(playlist);
            }
        }
    }

    public Result startPlaylist(Broadcast playlist) {
        Result result = new Result(false);
        List<Broadcast.PlayListItem> playListItemList = playlist.getPlayListItemList();
        if (this.isStreamRunning(playlist.getStreamId())) {
            String msg = "Playlist is already running for stream:" + playlist.getStreamId();
            logger.warn(msg);
            result.setMessage(msg);
        } else if (playListItemList != null && !playListItemList.isEmpty()) {
            Broadcast.PlayListItem playlistBroadcastItem;
            if (playlist.getCurrentPlayIndex() >= playlist.getPlayListItemList().size() || playlist.getCurrentPlayIndex() < 0) {
                logger.warn("Resetting current play index to 0 because it's not in correct range for id: {}", (Object)playlist.getStreamId());
                playlist.setCurrentPlayIndex(0);
            }
            if (StreamFetcherManager.checkStreamUrlWithHTTP((playlistBroadcastItem = playlist.getPlayListItemList().get(playlist.getCurrentPlayIndex())).getStreamUrl()).isSuccess()) {
                StreamFetcher streamScheduler = new StreamFetcher(playlistBroadcastItem.getStreamUrl(), playlist.getStreamId(), playlistBroadcastItem.getType(), this.scope, this.vertx);
                playlist.setPlayListStatus("broadcasting");
                this.datastore.updateBroadcastFields(playlist.getStreamId(), playlist);
                String streamId = playlist.getStreamId();
                streamScheduler.setStreamFetcherListener(listener -> this.playNextItemInList(streamId, listener));
                streamScheduler.setRestartStream(false);
                this.startStreamScheduler(streamScheduler);
                result.setSuccess(true);
            } else {
                logger.warn("Current Playlist Stream URL -> {} is invalid", (Object)playlistBroadcastItem.getStreamUrl());
                playlist = this.skipNextPlaylistQueue(playlist);
                if (StreamFetcherManager.checkStreamUrlWithHTTP(playlist.getPlayListItemList().get(playlist.getCurrentPlayIndex()).getStreamUrl()).isSuccess()) {
                    result = this.startPlaylist(playlist);
                } else {
                    playlist.setStatus("finished");
                    this.datastore.updateBroadcastFields(playlist.getStreamId(), playlist);
                    result.setSuccess(false);
                }
            }
        } else {
            String msg = "There is no playlist for stream id:" + playlist.getStreamId();
            logger.warn(msg);
            result.setMessage(msg);
        }
        return result;
    }

    public Broadcast skipNextPlaylistQueue(Broadcast playlist) {
        int currentStreamIndex = playlist.getCurrentPlayIndex() + 1;
        if (playlist.getPlayListItemList().size() <= currentStreamIndex) {
            playlist.setCurrentPlayIndex(0);
            if (!playlist.isPlaylistLoopEnabled()) {
                logger.info("Play list looping is not enabled. It will be stopped for stream: {}", (Object)playlist.getStreamId());
                playlist.setPlayListStatus("finished");
                this.datastore.updateBroadcastFields(playlist.getStreamId(), playlist);
                return null;
            }
        } else {
            playlist.setCurrentPlayIndex(currentStreamIndex);
            logger.info("Next index to play in play list is {} for stream: {}", (Object)playlist.getCurrentPlayIndex(), (Object)playlist.getStreamId());
        }
        return playlist;
    }

    public void startStreams(List<Broadcast> streams) {
        for (int i = 0; i < streams.size(); ++i) {
            this.startStreaming(streams.get(i));
        }
        this.scheduleStreamFetcherJob();
    }

    private void scheduleStreamFetcherJob() {
        if (this.streamFetcherScheduleJobName != -1L) {
            this.vertx.cancelTimer(this.streamFetcherScheduleJobName);
        }
        this.streamFetcherScheduleJobName = this.vertx.setPeriodic((long)this.streamCheckerIntervalMs, l -> {
            if (!this.streamFetcherList.isEmpty()) {
                ++this.streamCheckerCount;
                logger.debug("StreamFetcher Check Count:{}", (Object)this.streamCheckerCount);
                int countToRestart = 0;
                int restartStreamFetcherPeriodSeconds = this.appSettings.getRestartStreamFetcherPeriod();
                if (restartStreamFetcherPeriodSeconds > 0) {
                    int streamCheckIntervalSec = this.streamCheckerIntervalMs / 1000;
                    countToRestart = this.streamCheckerCount * streamCheckIntervalSec / restartStreamFetcherPeriodSeconds;
                }
                if (countToRestart > this.lastRestartCount) {
                    this.lastRestartCount = countToRestart;
                    logger.info("This is {} times that restarting streams", (Object)this.lastRestartCount);
                    this.restartStreamFetchers();
                } else {
                    this.checkStreamFetchersStatus();
                }
            }
        });
        logger.info("StreamFetcherSchedule job name {}", (Object)this.streamFetcherScheduleJobName);
    }

    public void checkStreamFetchersStatus() {
        for (StreamFetcher streamScheduler : this.streamFetcherList) {
            String streamId = streamScheduler.getStreamId();
            if (streamScheduler.isStreamAlive() || this.datastore == null || streamId == null) continue;
            MuxAdaptor muxAdaptor = streamScheduler.getMuxAdaptor();
            if (muxAdaptor != null) {
                muxAdaptor.changeStreamQualityParameters(streamId, null, 0.01, 0);
                continue;
            }
            logger.warn("Mux adaptor is not initialized for stream fetcher with stream id: {} It's likely that stream fetching is not started yet", (Object)streamId);
        }
    }

    public void restartStreamFetchers() {
        for (StreamFetcher streamScheduler : this.streamFetcherList) {
            if (streamScheduler.isStreamAlive()) {
                logger.info("Calling stop stream {}", (Object)streamScheduler.getStreamId());
                streamScheduler.stopStream();
            } else {
                logger.info("Stream is not alive {}", (Object)streamScheduler.getStreamId());
            }
            streamScheduler.startStream();
        }
    }

    public DataStore getDatastore() {
        return this.datastore;
    }

    public void setDatastore(DataStore datastore) {
        this.datastore = datastore;
    }

    public Queue<StreamFetcher> getStreamFetcherList() {
        return this.streamFetcherList;
    }

    public StreamFetcher getStreamFetcher(String streamId) {
        for (StreamFetcher streamFetcher : this.streamFetcherList) {
            if (!streamFetcher.getStreamId().equals(streamId)) continue;
            return streamFetcher;
        }
        return null;
    }

    public void setStreamFetcherList(Queue<StreamFetcher> streamFetcherList) {
        this.streamFetcherList = streamFetcherList;
    }

    public boolean isRestartStreamAutomatically() {
        return this.restartStreamAutomatically;
    }

    public void setRestartStreamAutomatically(boolean restartStreamAutomatically) {
        this.restartStreamAutomatically = restartStreamAutomatically;
    }

    public int getStreamCheckerCount() {
        return this.streamCheckerCount;
    }

    public void setStreamCheckerCount(int streamCheckerCount) {
        this.streamCheckerCount = streamCheckerCount;
    }

    public Result stopPlayList(String streamId) {
        logger.info("Stopping playlist for stream: {}", (Object)streamId);
        Result result = this.stopStreaming(streamId);
        if (result.isSuccess()) {
            result = new Result(false);
            Broadcast broadcast = this.datastore.get(streamId);
            if (broadcast != null && "playlist".equals(broadcast.getType())) {
                broadcast.setPlayListStatus("finished");
                result.setSuccess(this.datastore.updateBroadcastFields(streamId, broadcast));
            } else {
                String msg = "Broadcast's type is not play list for stream:" + streamId;
                result.setMessage(msg);
                result.setDataId(streamId);
                logger.error(msg);
            }
        } else {
            logger.warn("Stop streamming returned false for stream:{} message:{}", (Object)streamId, (Object)result.getMessage());
        }
        return result;
    }
}

