/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.classloading;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class ServerClassLoader
extends URLClassLoader {
    private static String PLATFORM;

    public ServerClassLoader(ClassLoader parent) {
        super(ServerClassLoader.getJars(), parent);
    }

    public static URL[] getJars() {
        File[] libFiles;
        String classLocation;
        ArrayList<URL> urlList = new ArrayList<URL>();
        JarFileFilter jarFileFilter = new JarFileFilter();
        String home = System.getProperty("red5.root");
        if ((home == null || ".".equals(home)) && (home = (classLocation = ServerClassLoader.class.getProtectionDomain().getCodeSource().getLocation().toString()).substring(0, classLocation.lastIndexOf(47))).startsWith("file:")) {
            home = home.substring("file:".length());
        }
        String libPath = home + File.separator + "lib";
        File libDir = new File(libPath);
        for (File lib : libFiles = libDir.listFiles(jarFileFilter)) {
            try {
                urlList.add(lib.toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        String conf = home + File.separator + "conf";
        try {
            URL confUrl = new File(conf).toURI().toURL();
            if (!urlList.contains(confUrl)) {
                urlList.add(confUrl);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        try {
            String serverJar = home + File.separator + "ant-media-server.jar";
            URL serverJarURL = new File(serverJar).toURI().toURL();
            urlList.add(serverJarURL);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        String pluginsPath = home + File.separator + "plugins";
        File pluginsDir = new File(pluginsPath);
        try {
            URL pluginsUrl = pluginsDir.toURI().toURL();
            if (!urlList.contains(pluginsUrl)) {
                urlList.add(pluginsUrl);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        File[] pluginsFiles = pluginsDir.listFiles(jarFileFilter);
        ServerClassLoader.loadPlugins(pluginsFiles, urlList, PLATFORM);
        URL[] urls = urlList.toArray(new URL[0]);
        System.out.println("Selected libraries: (" + urls.length + " items)");
        return urls;
    }

    public static void loadPlugins(File[] pluginsFiles, List<URL> urlList, String platform) {
        if (pluginsFiles != null) {
            for (File plugin : pluginsFiles) {
                try {
                    String parseUrl = ServerClassLoader.parseUrl(plugin.toURI().toURL());
                    if (parseUrl.endsWith("x86") || parseUrl.endsWith("x86-gpl") || parseUrl.endsWith("x86_64") || parseUrl.endsWith("x86_64-gpl") || parseUrl.endsWith("arm64") || parseUrl.endsWith("arm64-gpl") || parseUrl.endsWith("armhf") || parseUrl.endsWith("armhf-gpl") || parseUrl.endsWith("ppc64le") || parseUrl.endsWith("ppc64le-gpl") || parseUrl.endsWith("arm") || parseUrl.endsWith("arm-gpl")) {
                        if (!parseUrl.contains(platform)) continue;
                        urlList.add(plugin.toURI().toURL());
                        continue;
                    }
                    urlList.add(plugin.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String parseUrl(URL url) {
        String external = url.toExternalForm().toLowerCase();
        String[] parts = external.split("/");
        String libName = parts[parts.length - 1];
        libName = libName.substring(0, libName.length() - 4);
        return libName;
    }

    static {
        String jvmName = System.getProperty("java.vm.name", "").toLowerCase();
        String osName = System.getProperty("os.name", "").toLowerCase();
        String osArch = System.getProperty("os.arch", "").toLowerCase();
        String abiType = System.getProperty("sun.arch.abi", "").toLowerCase();
        String libPath = System.getProperty("sun.boot.library.path", "").toLowerCase();
        if (jvmName.startsWith("dalvik") && osName.startsWith("linux")) {
            osName = "android";
        } else if (jvmName.startsWith("robovm") && osName.startsWith("darwin")) {
            osName = "ios";
            osArch = "arm";
        } else if (osName.startsWith("mac os x") || osName.startsWith("darwin")) {
            osName = "macosx";
        } else {
            int spaceIndex = osName.indexOf(32);
            if (spaceIndex > 0) {
                osName = osName.substring(0, spaceIndex);
            }
        }
        if (osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686")) {
            osArch = "x86";
        } else if (osArch.equals("amd64") || osArch.equals("x86-64") || osArch.equals("x64")) {
            osArch = "x86_64";
        } else if (osArch.startsWith("aarch64") || osArch.startsWith("armv8") || osArch.startsWith("arm64")) {
            osArch = "arm64";
        } else if (osArch.startsWith("arm") && (abiType.equals("gnueabihf") || libPath.contains("openjdk-armhf"))) {
            osArch = "armhf";
        } else if (osArch.startsWith("arm")) {
            osArch = "arm";
        }
        PLATFORM = osName + "-" + osArch;
    }

    public static final class JarFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

