/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import io.antmedia.AppSettings;
import io.antmedia.StreamIdValidator;
import io.antmedia.statistic.IStatsCollector;
import java.util.HashMap;
import java.util.Map;
import org.red5.io.object.StreamAction;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.IServer;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.scope.IScopeHandler;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IServiceCall;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IClientStream;
import org.red5.server.api.stream.IStreamService;
import org.red5.server.exception.ClientRejectedException;
import org.red5.server.exception.ScopeNotFoundException;
import org.red5.server.exception.ScopeShuttingDownException;
import org.red5.server.messaging.IConsumer;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.net.ICommand;
import org.red5.server.net.rtmp.BaseRTMPHandler;
import org.red5.server.net.rtmp.Channel;
import org.red5.server.net.rtmp.DeferredResult;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.red5.server.net.rtmp.event.ChunkSize;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Ping;
import org.red5.server.net.rtmp.event.SetBuffer;
import org.red5.server.net.rtmp.event.StreamActionEvent;
import org.red5.server.net.rtmp.message.Header;
import org.red5.server.net.rtmp.status.Status;
import org.red5.server.net.rtmp.status.StatusObject;
import org.red5.server.net.rtmp.status.StatusObjectService;
import org.red5.server.stream.StreamService;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;

public class RTMPHandler
extends BaseRTMPHandler {
    protected static Logger log = Red5LoggerFactory.getLogger(RTMPHandler.class);
    private static final String HIGH_RESOURCE_USAGE = "current system resources not enough";
    private static final String INVALID_STREAM_NAME = "stream name is invalid. Don't use special characters.";
    protected StatusObjectService statusObjectService;
    protected IServer server;
    private boolean unvalidatedConnectionAllowed;
    private boolean dispatchStreamActions;

    public void setServer(IServer server) {
        this.server = server;
    }

    public void setStatusObjectService(StatusObjectService statusObjectService) {
        this.statusObjectService = statusObjectService;
    }

    public boolean isUnvalidatedConnectionAllowed() {
        return this.unvalidatedConnectionAllowed;
    }

    public void setUnvalidatedConnectionAllowed(boolean unvalidatedConnectionAllowed) {
        this.unvalidatedConnectionAllowed = unvalidatedConnectionAllowed;
    }

    public boolean isDispatchStreamActions() {
        return this.dispatchStreamActions;
    }

    public void setDispatchStreamActions(boolean dispatchStreamActions) {
        this.dispatchStreamActions = dispatchStreamActions;
    }

    @Override
    protected void onChunkSize(RTMPConnection conn, Channel channel, Header source, ChunkSize chunkSize) {
        int requestedChunkSize = chunkSize.getSize();
        log.debug("Chunk size: {}", (Object)requestedChunkSize);
        RTMP state = conn.getState();
        state.setReadChunkSize(requestedChunkSize);
        for (IClientStream stream : conn.getStreams()) {
            IClientBroadcastStream bs;
            IBroadcastScope scope;
            if (!(stream instanceof IClientBroadcastStream) || (scope = (bs = (IClientBroadcastStream)stream).getScope().getBroadcastScope(bs.getPublishedName())) == null) continue;
            OOBControlMessage setChunkSize = new OOBControlMessage();
            setChunkSize.setTarget("ClientBroadcastStream");
            setChunkSize.setServiceName("chunkSize");
            if (setChunkSize.getServiceParamMap() == null) {
                setChunkSize.setServiceParamMap(new HashMap<String, Object>());
            }
            setChunkSize.getServiceParamMap().put("chunkSize", requestedChunkSize);
            scope.sendOOBControlMessage((IConsumer)null, setChunkSize);
            log.debug("Sending chunksize {} to {}", (Object)chunkSize, (Object)bs.getProvider());
        }
    }

    protected void invokeCall(RTMPConnection conn, IServiceCall call) {
        IScope scope = conn.getScope();
        if (scope != null) {
            if (scope.hasHandler()) {
                IScopeHandler handler = scope.getHandler();
                log.debug("Scope: {} handler: {}", (Object)scope, (Object)handler);
                if (!handler.serviceCall(conn, call)) {
                    log.warn("Scope: {} handler failed on service call", (Object)scope.getName(), (Object)new Exception("Service call failed"));
                    return;
                }
            }
            IContext context = scope.getContext();
            log.debug("Context: {}", (Object)context);
            context.getServiceInvoker().invoke(call, scope);
        } else {
            log.warn("Scope was null for invoke: {} connection state: {}", (Object)call.getServiceMethodName(), (Object)conn.getStateCode());
        }
    }

    private boolean invokeCall(RTMPConnection conn, IServiceCall call, Object service) {
        IScope scope = conn.getScope();
        IContext context = scope.getContext();
        if (log.isTraceEnabled()) {
            log.trace("Scope: {} context: {} service: {}", new Object[]{scope, context, service});
        }
        return context.getServiceInvoker().invoke(call, service);
    }

    @Override
    protected void onCommand(RTMPConnection conn, Channel channel, Header source, ICommand command) {
        String action;
        log.debug("onCommand {}", (Object)command);
        int transId = command.getTransactionId();
        IServiceCall call = command.getCall();
        if (log.isTraceEnabled()) {
            log.trace("call: {}", (Object)call);
        }
        if ("_result".equals(action = call.getServiceMethodName()) || "_error".equals(action)) {
            this.handlePendingCallResult(conn, (Invoke)command);
            return;
        }
        boolean disconnectOnReturn = false;
        boolean connected = conn.isConnected();
        if (connected) {
            if (call.getServiceName() == null) {
                StreamAction streamAction = StreamAction.getEnum((String)action);
                if (log.isDebugEnabled()) {
                    log.debug("Stream action: {}", (Object)streamAction.toString());
                }
                if (this.dispatchStreamActions) {
                    try {
                        conn.getScope().getHandler().handleEvent(new StreamActionEvent(streamAction));
                    }
                    catch (Exception ex) {
                        log.warn("Exception passing stream action: {} to the scope handler", (Object)streamAction, (Object)ex);
                    }
                }
                switch (streamAction) {
                    case DISCONNECT: {
                        conn.close();
                        break;
                    }
                    case CREATE_STREAM: 
                    case INIT_STREAM: 
                    case CLOSE_STREAM: 
                    case RELEASE_STREAM: 
                    case DELETE_STREAM: 
                    case PUBLISH: 
                    case PLAY: 
                    case PLAY2: 
                    case SEEK: 
                    case PAUSE: 
                    case PAUSE_RAW: 
                    case RECEIVE_VIDEO: 
                    case RECEIVE_AUDIO: {
                        IStreamService streamService = (IStreamService)ScopeUtils.getScopeService(conn.getScope(), IStreamService.class, StreamService.class);
                        try {
                            if (streamAction == StreamAction.PUBLISH && conn.getScope().getContext().hasBean("statsCollector")) {
                                String streamId = (String)call.getArguments()[0];
                                if (streamId.startsWith("/")) {
                                    streamId = streamId.substring(1);
                                    call.getArguments()[0] = streamId;
                                }
                                if (streamId.contains("?") && streamId.contains("=")) {
                                    streamId = streamId.split("\\?")[0];
                                }
                                if (!StreamIdValidator.isStreamIdValid(streamId)) {
                                    Status status = this.getStatus("NetStream.Failed").asStatus();
                                    status.setDescription("stream name is invalid. Don't use special characters. setream name:" + streamId);
                                    channel.sendStatus(status);
                                    return;
                                }
                                IStatsCollector resourceMonitor = (IStatsCollector)conn.getScope().getContext().getBean("statsCollector");
                                boolean systemResult = resourceMonitor.enoughResource();
                                if (!systemResult) {
                                    log.info("There is not enough resource to rtmp ingest stream: {}", (Object)streamId);
                                    Status status = this.getStatus("NetStream.Failed").asStatus();
                                    status.setDescription(HIGH_RESOURCE_USAGE);
                                    channel.sendStatus(status);
                                    return;
                                }
                            } else if (!this.isAllowedIfRtmpPlayback(conn, channel, streamAction)) {
                                return;
                            }
                            log.debug("Invoking {} from {} with service: {}", new Object[]{call, conn.getSessionId(), streamService});
                            if (this.invokeCall(conn, call, streamService)) {
                                log.debug("Stream service invoke {} success", (Object)action);
                                break;
                            }
                            Status status = this.getStatus("NetStream.InvalidArg").asStatus();
                            status.setDescription(String.format("Failed to %s (stream id: %d)", action, source.getStreamId()));
                            channel.sendStatus(status);
                        }
                        catch (Throwable err) {
                            log.error("Error while invoking {} on stream service. {}", (Object)action, (Object)err);
                            Status status = this.getStatus("NetStream.Failed").asStatus();
                            status.setDescription(String.format("Error while invoking %s (stream id: %d)", action, source.getStreamId()));
                            status.setDetails(err.getMessage());
                            channel.sendStatus(status);
                        }
                        break;
                    }
                    default: {
                        log.debug("Defaulting to invoke for: {}", (Object)action);
                        this.invokeCall(conn, call);
                    }
                }
            } else {
                this.invokeCall(conn, call);
            }
        } else if (StreamAction.CONNECT.equals(action)) {
            Map<String, Object> params;
            block60: {
                log.debug("connect - transaction id: {}", (Object)transId);
                params = command.getConnectionParams();
                String host = this.getHostname((String)params.get("tcUrl"));
                String path = (String)params.get("app");
                if (path.indexOf("?") != -1) {
                    int idx = path.indexOf("?");
                    params.put("queryString", path.substring(idx));
                    path = path.substring(0, idx);
                }
                params.put("path", path);
                conn.setup(host, path, params);
                try {
                    IGlobalScope global = this.server.lookupGlobal(host, path);
                    log.trace("Global lookup result: {}", (Object)global);
                    if (global != null) {
                        IContext context = global.getContext();
                        IScope scope = null;
                        try {
                            scope = context.resolveScope(global, path);
                            if (scope == null) break block60;
                            if (log.isDebugEnabled()) {
                                log.debug("Connecting to: {}", (Object)scope.getName());
                                log.debug("Conn {}, scope {}, call {} args {}", new Object[]{conn, scope, call, call.getArguments()});
                            }
                            if (scope.isConnectionAllowed(conn)) {
                                try {
                                    boolean connectSuccess = call.getArguments() != null ? conn.connect(scope, call.getArguments()) : conn.connect(scope);
                                    if (connectSuccess) {
                                        log.debug("Connected - {}", (Object)conn.getClient());
                                        call.setStatus((byte)2);
                                        if (call instanceof IPendingServiceCall) {
                                            IPendingServiceCall pc = (IPendingServiceCall)call;
                                            StatusObject result = this.getStatus("NetConnection.Connect.Success");
                                            result.setAdditional("fmsVer", Red5.getFMSVersion());
                                            result.setAdditional("capabilities", Red5.getCapabilities());
                                            result.setAdditional("mode", 1);
                                            result.setAdditional("data", Red5.getDataVersion());
                                            pc.setResult(result);
                                        }
                                        conn.ping(new Ping(0, 0, -1));
                                        break block60;
                                    }
                                    log.debug("Connect failed");
                                    call.setStatus((byte)18);
                                    if (call instanceof IPendingServiceCall) {
                                        IPendingServiceCall pc = (IPendingServiceCall)call;
                                        pc.setResult(this.getStatus("NetConnection.Connect.Rejected"));
                                    }
                                    disconnectOnReturn = true;
                                }
                                catch (ClientRejectedException rejected) {
                                    log.debug("Connect rejected");
                                    call.setStatus((byte)18);
                                    if (call instanceof IPendingServiceCall) {
                                        IPendingServiceCall pc = (IPendingServiceCall)call;
                                        StatusObject status = this.getStatus("NetConnection.Connect.Rejected");
                                        Object reason = rejected.getReason();
                                        if (reason != null) {
                                            status.setApplication(reason);
                                            status.setDescription(reason.toString());
                                        }
                                        pc.setResult(status);
                                    }
                                    disconnectOnReturn = true;
                                }
                                break block60;
                            }
                            log.debug("Connect to specified scope is not allowed");
                            call.setStatus((byte)18);
                            if (call instanceof IPendingServiceCall) {
                                IPendingServiceCall pc = (IPendingServiceCall)call;
                                StatusObject status = this.getStatus("NetConnection.Connect.Rejected");
                                status.setDescription(String.format("Connection to '%s' denied.", path));
                                pc.setResult(status);
                            }
                            disconnectOnReturn = true;
                        }
                        catch (ScopeNotFoundException err) {
                            log.warn("Scope not found", (Throwable)err);
                            call.setStatus((byte)16);
                            if (call instanceof IPendingServiceCall) {
                                StatusObject status = this.getStatus("NetConnection.Connect.Rejected");
                                status.setDescription(String.format("No scope '%s' on this server.", path));
                                ((IPendingServiceCall)call).setResult(status);
                            }
                            log.info("Scope {} not found on {}", (Object)path, (Object)host);
                            disconnectOnReturn = true;
                        }
                        catch (ScopeShuttingDownException err) {
                            log.warn("Scope shutting down", (Throwable)err);
                            call.setStatus((byte)21);
                            if (call instanceof IPendingServiceCall) {
                                StatusObject status = this.getStatus("NetConnection.Connect.AppShutdown");
                                status.setDescription(String.format("Application at '%s' is currently shutting down.", path));
                                ((IPendingServiceCall)call).setResult(status);
                            }
                            log.info("Application at {} currently shutting down on {}", (Object)path, (Object)host);
                            disconnectOnReturn = true;
                        }
                        break block60;
                    }
                    log.warn("Scope {} not found", (Object)path);
                    call.setStatus((byte)16);
                    if (call instanceof IPendingServiceCall) {
                        StatusObject status = this.getStatus("NetConnection.Connect.InvalidApp");
                        status.setDescription(String.format("No scope '%s' on this server.", path));
                        ((IPendingServiceCall)call).setResult(status);
                    }
                    log.info("No application scope found for {} on host {}", (Object)path, (Object)host);
                    disconnectOnReturn = true;
                }
                catch (RuntimeException e) {
                    call.setStatus((byte)20);
                    if (call instanceof IPendingServiceCall) {
                        IPendingServiceCall pc = (IPendingServiceCall)call;
                        pc.setResult(this.getStatus("NetConnection.Connect.Failed"));
                    }
                    log.error("Error connecting {}", (Throwable)e);
                    disconnectOnReturn = true;
                }
            }
            if (new Double(3.0).equals(params.get("objectEncoding"))) {
                if (call instanceof IPendingServiceCall) {
                    HashMap<String, Integer> result;
                    Object pcResult = ((IPendingServiceCall)call).getResult();
                    if (pcResult instanceof Map) {
                        result = (HashMap<String, Integer>)pcResult;
                        result.put("objectEncoding", 3);
                    } else if (pcResult instanceof StatusObject) {
                        result = new HashMap<String, Integer>();
                        StatusObject status = (StatusObject)pcResult;
                        result.put("code", (Integer)((Object)status.getCode()));
                        result.put("description", (Integer)((Object)status.getDescription()));
                        result.put("application", (Integer)status.getApplication());
                        result.put("level", (Integer)((Object)status.getLevel()));
                        result.put("objectEncoding", 3);
                        ((IPendingServiceCall)call).setResult(result);
                    }
                }
                conn.getState().setEncoding(IConnection.Encoding.AMF3);
            }
        } else {
            log.warn("Not connected, closing connection");
            conn.close();
        }
        if (command instanceof Invoke) {
            IPendingServiceCall psc;
            Object result;
            if (log.isDebugEnabled()) {
                log.debug("Command type Invoke");
            }
            if (source.getStreamId().intValue() != 0 && (call.getStatus() == 4 || call.getStatus() == 3)) {
                log.debug("Method does not have return value, do not reply");
                return;
            }
            boolean sendResult = true;
            if (call instanceof IPendingServiceCall && (result = (psc = (IPendingServiceCall)call).getResult()) instanceof DeferredResult) {
                DeferredResult dr = (DeferredResult)result;
                dr.setServiceCall(psc);
                dr.setChannel(channel);
                dr.setTransactionId(transId);
                conn.registerDeferredResult(dr);
                sendResult = false;
            }
            if (sendResult) {
                Invoke reply = new Invoke();
                reply.setCall(call);
                reply.setTransactionId(transId);
                channel.write(reply);
                if (disconnectOnReturn) {
                    log.debug("Close connection due to connect handling exception: {}", (Object)conn.getSessionId());
                    conn.close();
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Command type: {}", (Object)command.getClass().getName());
        }
    }

    public boolean isAllowedIfRtmpPlayback(RTMPConnection conn, Channel channel, StreamAction streamAction) {
        AppSettings appSettings;
        if (!(streamAction != StreamAction.PLAY && streamAction != StreamAction.PLAY2 || (appSettings = (AppSettings)conn.getScope().getContext().getBean("app.settings")).isRtmpPlaybackEnabled())) {
            log.info("RTMP playback is disabled");
            Status status = this.getStatus("NetStream.Failed").asStatus();
            status.setDesciption("RTMP playback is disabled");
            channel.sendStatus(status);
            return false;
        }
        return true;
    }

    public StatusObject getStatus(String code) {
        return this.statusObjectService.getStatusObject(code);
    }

    @Override
    protected void onPing(RTMPConnection conn, Channel channel, Header source, Ping ping) {
        switch (ping.getEventType()) {
            case 3: {
                SetBuffer setBuffer = (SetBuffer)ping;
                int streamId = setBuffer.getStreamId();
                int buffer = setBuffer.getBufferLength();
                log.debug("Client sent a buffer size: {} ms for stream id: {}", (Object)buffer, (Object)streamId);
                IClientStream stream = null;
                if (streamId != 0 && (stream = conn.getStreamById(streamId)) != null) {
                    stream.setClientBufferDuration(buffer);
                    log.trace("Stream type: {}", (Object)stream.getClass().getName());
                }
                if (stream != null) break;
                conn.rememberStreamBufferDuration(streamId, buffer);
                log.debug("Remembering client buffer on stream: {}", (Object)buffer);
                break;
            }
            case 7: {
                conn.pingReceived(ping);
                break;
            }
            default: {
                log.warn("Unhandled ping: {}", (Object)ping);
            }
        }
    }

    protected void onBWDone() {
        log.debug("onBWDone");
    }
}

