/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.IAudioStreamCodec;
import org.red5.codec.IStreamCodecInfo;
import org.red5.codec.IVideoStreamCodec;
import org.red5.codec.StreamCodecInfo;
import org.red5.server.api.IContext;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IPlaylistController;
import org.red5.server.api.stream.IServerStream;
import org.red5.server.api.stream.IStreamAwareScopeHandler;
import org.red5.server.api.stream.IStreamListener;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.api.stream.StreamState;
import org.red5.server.api.stream.support.SimplePlayItem;
import org.red5.server.messaging.IFilter;
import org.red5.server.messaging.IMessage;
import org.red5.server.messaging.IMessageComponent;
import org.red5.server.messaging.IMessageInput;
import org.red5.server.messaging.IMessageOutput;
import org.red5.server.messaging.IPassive;
import org.red5.server.messaging.IPipe;
import org.red5.server.messaging.IPipeConnectionListener;
import org.red5.server.messaging.IProvider;
import org.red5.server.messaging.IPushableConsumer;
import org.red5.server.messaging.OOBControlMessage;
import org.red5.server.messaging.PipeConnectionEvent;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.stream.AbstractStream;
import org.red5.server.stream.IProviderService;
import org.red5.server.stream.IRecordingListener;
import org.red5.server.stream.ISeekableProvider;
import org.red5.server.stream.RecordingListener;
import org.red5.server.stream.SimplePlaylistController;
import org.red5.server.stream.message.RTMPMessage;
import org.red5.server.stream.message.ResetMessage;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStream
extends AbstractStream
implements IServerStream,
IFilter,
IPushableConsumer,
IPipeConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(ServerStream.class);
    private static final long WAIT_THRESHOLD = 0L;
    protected String publishedName;
    protected IPlaylistController controller;
    protected IPlaylistController defaultController;
    private boolean isRewind;
    private boolean isRandom;
    private boolean isRepeat;
    protected CopyOnWriteArrayList<IPlayItem> items;
    private int currentItemIndex;
    protected IPlayItem currentItem;
    private IMessageInput msgIn;
    private IMessageOutput msgOut;
    private IProviderService providerService;
    private ISchedulingService scheduler;
    private volatile String liveJobName;
    private volatile String vodJobName;
    private long vodStartTS;
    private long serverStartTS;
    private long nextTS;
    private RTMPMessage nextRTMPMessage;
    private CopyOnWriteArraySet<IStreamListener> listeners = new CopyOnWriteArraySet();
    private WeakReference<IRecordingListener> recordingListener;

    public ServerStream() {
        this.defaultController = new SimplePlaylistController();
        this.items = new CopyOnWriteArrayList();
    }

    @Override
    public void addItem(IPlayItem item) {
        this.items.add(item);
    }

    @Override
    public void addItem(IPlayItem item, int index) {
        IPlayItem prev = this.items.get(index);
        if (prev != null && prev instanceof SimplePlayItem) {
            ((SimplePlayItem)item).setCreated(((SimplePlayItem)prev).getCreated() - 1L);
        }
        this.items.add(index, item);
        if (index <= this.currentItemIndex) {
            ++this.currentItemIndex;
        }
    }

    @Override
    public void removeItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        this.items.remove(index);
        if (index < this.currentItemIndex) {
            --this.currentItemIndex;
        } else if (index == this.currentItemIndex) {
            --this.currentItemIndex;
        }
    }

    @Override
    public void removeAllItems() {
        this.currentItemIndex = 0;
        this.items.clear();
    }

    @Override
    public int getItemSize() {
        return this.items.size();
    }

    public CopyOnWriteArrayList<IPlayItem> getItems() {
        return this.items;
    }

    @Override
    public int getCurrentItemIndex() {
        return this.currentItemIndex;
    }

    @Override
    public IPlayItem getCurrentItem() {
        return this.currentItem;
    }

    @Override
    public IPlayItem getItem(int index) {
        try {
            return this.items.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public void previousItem() {
        this.stop();
        this.moveToPrevious();
        if (this.currentItemIndex == -1) {
            return;
        }
        IPlayItem item = this.items.get(this.currentItemIndex);
        this.play(item);
    }

    @Override
    public boolean hasMoreItems() {
        int nextItem = this.currentItemIndex + 1;
        return nextItem < this.items.size() || this.isRepeat;
    }

    @Override
    public void nextItem() {
        this.stop();
        this.moveToNext();
        if (this.currentItemIndex == -1) {
            return;
        }
        IPlayItem item = this.items.get(this.currentItemIndex);
        this.play(item);
    }

    @Override
    public void setItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        this.stop();
        this.currentItemIndex = index;
        IPlayItem item = this.items.get(this.currentItemIndex);
        this.play(item);
    }

    @Override
    public boolean isRandom() {
        return this.isRandom;
    }

    @Override
    public void setRandom(boolean random) {
        this.isRandom = random;
    }

    @Override
    public boolean isRewind() {
        return this.isRewind;
    }

    @Override
    public void setRewind(boolean rewind) {
        this.isRewind = rewind;
    }

    @Override
    public boolean isRepeat() {
        return this.isRepeat;
    }

    @Override
    public void setRepeat(boolean repeat) {
        this.isRepeat = repeat;
    }

    @Override
    public void setPlaylistController(IPlaylistController controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAs(String name, boolean isAppend) throws IOException {
        if (this.recordingListener == null) {
            IScope scope = this.getScope();
            IRecordingListener listener = (IRecordingListener)ScopeUtils.getScopeService(scope, IRecordingListener.class, RecordingListener.class);
            if (listener.init(scope, name, isAppend)) {
                IStreamCodecInfo codecInfo = this.getCodecInfo();
                log.debug("Codec info: {}", (Object)codecInfo);
                if (codecInfo instanceof StreamCodecInfo) {
                    StreamCodecInfo info = (StreamCodecInfo)codecInfo;
                    IVideoStreamCodec videoCodec = info.getVideoCodec();
                    log.debug("Video codec: {}", (Object)videoCodec);
                    if (videoCodec != null) {
                        IoBuffer config = videoCodec.getDecoderConfiguration();
                        if (config != null) {
                            log.debug("Decoder configuration is available for {}", (Object)videoCodec.getName());
                            VideoData videoConf = new VideoData(config.asReadOnlyBuffer());
                            try {
                                log.debug("Setting decoder configuration for recording");
                                listener.getFileConsumer().setVideoDecoderConfiguration(videoConf);
                            }
                            finally {
                                videoConf.release();
                            }
                        }
                    } else {
                        log.debug("Could not initialize stream output, videoCodec is null.");
                    }
                    IAudioStreamCodec audioCodec = info.getAudioCodec();
                    log.debug("Audio codec: {}", (Object)audioCodec);
                    if (audioCodec != null) {
                        IoBuffer config = audioCodec.getDecoderConfiguration();
                        if (config != null) {
                            log.debug("Decoder configuration is available for {}", (Object)audioCodec.getName());
                            AudioData audioConf = new AudioData(config.asReadOnlyBuffer());
                            try {
                                log.debug("Setting decoder configuration for recording");
                                listener.getFileConsumer().setAudioDecoderConfiguration(audioConf);
                            }
                            finally {
                                audioConf.release();
                            }
                        }
                    } else {
                        log.debug("No decoder configuration available, audioCodec is null.");
                    }
                }
                this.recordingListener = new WeakReference<IRecordingListener>(listener);
                this.addStreamListener(listener);
                listener.start();
            } else {
                log.warn("Recording listener failed to initialize for stream: {}", (Object)name);
            }
        } else {
            log.info("Recording listener already exists for stream: {}", (Object)name);
        }
    }

    @Override
    public String getSaveFilename() {
        if (this.recordingListener != null) {
            return ((IRecordingListener)this.recordingListener.get()).getFileName();
        }
        return null;
    }

    @Override
    public IProvider getProvider() {
        return this;
    }

    @Override
    public String getPublishedName() {
        return this.publishedName;
    }

    @Override
    public void setPublishedName(String name) {
        this.publishedName = name;
    }

    @Override
    public void start() {
        if (this.state != StreamState.UNINIT) {
            throw new IllegalStateException("State " + this.state + " not valid to start");
        }
        if (this.items.size() == 0) {
            throw new IllegalStateException("At least one item should be specified to start");
        }
        if (this.publishedName == null) {
            throw new IllegalStateException("A published name is needed to start");
        }
        try {
            IScope scope = this.getScope();
            IContext context = scope.getContext();
            this.providerService = (IProviderService)context.getBean("providerService");
            this.providerService.registerBroadcastStream(scope, this.publishedName, this);
            this.scheduler = (ISchedulingService)context.getBean("schedulingService");
        }
        catch (NullPointerException npe) {
            log.warn("Context beans were not available; this is ok during unit testing", (Throwable)npe);
        }
        this.setState(StreamState.STOPPED);
        this.currentItemIndex = -1;
        this.nextItem();
    }

    @Override
    public void stop() {
        if (this.state == StreamState.PLAYING || this.state == StreamState.PAUSED) {
            if (this.liveJobName != null) {
                this.scheduler.removeScheduledJob(this.liveJobName);
                this.liveJobName = null;
            }
            if (this.vodJobName != null) {
                this.scheduler.removeScheduledJob(this.vodJobName);
                this.vodJobName = null;
            }
            if (this.msgIn != null) {
                this.msgIn.unsubscribe(this);
                this.msgIn = null;
            }
            if (this.nextRTMPMessage != null) {
                this.nextRTMPMessage.getBody().release();
            }
            this.stopRecording();
            this.setState(StreamState.STOPPED);
        }
    }

    public void stopRecording() {
        IRecordingListener listener = null;
        if (this.recordingListener != null && (listener = (IRecordingListener)this.recordingListener.get()).isRecording()) {
            this.notifyRecordingStop();
            this.removeStreamListener(listener);
            listener.stop(true);
            this.recordingListener.clear();
            this.recordingListener = null;
        }
    }

    @Override
    public void pause() {
        switch (this.state) {
            case PLAYING: {
                this.setState(StreamState.PAUSED);
                break;
            }
            case PAUSED: {
                this.setState(StreamState.PLAYING);
                this.vodStartTS = 0L;
                this.serverStartTS = System.currentTimeMillis();
                this.scheduleNextMessage();
            }
        }
    }

    @Override
    public void seek(int position) {
        if (this.state == StreamState.PLAYING || this.state == StreamState.PAUSED) {
            this.sendVODSeekCM(this.msgIn, position);
        }
    }

    @Override
    public void close() {
        if (this.state == StreamState.PLAYING || this.state == StreamState.PAUSED) {
            this.stop();
        }
        if (this.msgOut != null) {
            this.msgOut.unsubscribe(this);
        }
        this.notifyBroadcastClose();
        this.setState(StreamState.CLOSED);
    }

    @Override
    public void onOOBControlMessage(IMessageComponent source, IPipe pipe, OOBControlMessage oobCtrlMsg) {
    }

    @Override
    public void pushMessage(IPipe pipe, IMessage message) throws IOException {
        this.pushMessage(message);
    }

    @Override
    public void onPipeConnectionEvent(PipeConnectionEvent event) {
        switch (event.getType()) {
            case PROVIDER_CONNECT_PUSH: {
                if (event.getProvider() != this || event.getParamMap() != null && event.getParamMap().containsKey("record")) break;
                this.msgOut = (IMessageOutput)event.getSource();
                break;
            }
            case PROVIDER_DISCONNECT: {
                if (this.msgOut != event.getSource()) break;
                this.msgOut = null;
                break;
            }
        }
    }

    protected void play(IPlayItem item) {
        if (this.state == StreamState.STOPPED) {
            boolean isLive = false;
            if (this.providerService != null) {
                this.msgIn = this.providerService.getVODProviderInput(this.getScope(), item.getName());
                if (this.msgIn == null) {
                    this.msgIn = this.providerService.getLiveProviderInput(this.getScope(), item.getName(), true);
                    isLive = true;
                }
                if (this.msgIn == null) {
                    log.warn("ABNORMAL Can't get both VOD and Live input from providerService");
                    return;
                }
            }
            this.setState(StreamState.PLAYING);
            this.currentItem = item;
            this.sendResetMessage();
            if (this.msgIn != null) {
                this.msgIn.subscribe(this, null);
            }
            if (isLive) {
                if (item.getLength() >= 0L) {
                    this.liveJobName = this.scheduler.addScheduledOnceJob(item.getLength(), new IScheduledJob(){

                        @Override
                        public void execute(ISchedulingService service) {
                            if (ServerStream.this.liveJobName == null) {
                                return;
                            }
                            ServerStream.this.liveJobName = null;
                            ServerStream.this.onItemEnd();
                        }
                    });
                }
            } else {
                long start = item.getStart();
                if (start < 0L) {
                    start = 0L;
                }
                this.sendVODInitCM(this.msgIn, (int)start);
                this.startBroadcastVOD();
            }
        }
    }

    protected void onItemEnd() {
        this.nextItem();
    }

    private void pushMessage(IMessage message) throws IOException {
        IRTMPEvent rtmpEvent;
        if (this.msgOut != null) {
            this.msgOut.pushMessage(message);
        }
        if (message instanceof RTMPMessage && (rtmpEvent = ((RTMPMessage)message).getBody()) instanceof IStreamPacket) {
            for (IStreamListener listener : this.getStreamListeners()) {
                try {
                    listener.packetReceived(this, (IStreamPacket)((Object)rtmpEvent));
                }
                catch (Exception e) {
                    log.error("Error while notifying listener " + listener, (Throwable)e);
                }
            }
        }
    }

    private void sendResetMessage() {
        try {
            this.pushMessage(new ResetMessage());
        }
        catch (IOException err) {
            log.error("Error while sending reset message.", (Throwable)err);
        }
    }

    protected void startBroadcastVOD() {
        this.nextRTMPMessage = null;
        this.vodStartTS = 0L;
        this.serverStartTS = System.currentTimeMillis();
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            if (this.recordingListener != null && ((IRecordingListener)this.recordingListener.get()).isRecording()) {
                handler.streamRecordStart(this);
            } else {
                handler.streamPublishStart(this);
            }
        }
        this.notifyBroadcastStart();
        this.scheduleNextMessage();
    }

    protected void notifyBroadcastClose() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamBroadcastClose(this);
            }
            catch (Throwable t) {
                log.error("error notify streamBroadcastStop", t);
            }
        }
    }

    private void notifyRecordingStop() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamRecordStop(this);
            }
            catch (Throwable t) {
                log.error("Error in notifyBroadcastClose", t);
            }
        }
    }

    protected void notifyBroadcastStart() {
        IStreamAwareScopeHandler handler = this.getStreamAwareHandler();
        if (handler != null) {
            try {
                handler.streamBroadcastStart(this);
            }
            catch (Throwable t) {
                log.error("error notify streamBroadcastStart", t);
            }
        }
    }

    protected void scheduleNextMessage() {
        boolean first = this.nextRTMPMessage == null;
        long delta = 0L;
        do {
            this.nextRTMPMessage = this.getNextRTMPMessage();
            if (this.nextRTMPMessage != null) {
                IRTMPEvent rtmpEvent = this.nextRTMPMessage.getBody();
                if (!(rtmpEvent instanceof VideoData) && !(rtmpEvent instanceof AudioData)) continue;
                rtmpEvent = this.nextRTMPMessage.getBody();
                this.nextTS = rtmpEvent.getTimestamp();
                if (first) {
                    this.vodStartTS = this.nextTS;
                    first = false;
                }
                if ((delta = this.nextTS - this.vodStartTS - (System.currentTimeMillis() - this.serverStartTS)) >= 0L) continue;
                if (this.doPushMessage()) {
                    if (this.state == StreamState.PLAYING) continue;
                    this.nextRTMPMessage = null;
                    continue;
                }
                this.nextRTMPMessage = null;
                continue;
            }
            this.onItemEnd();
        } while (this.nextRTMPMessage != null || delta < 0L);
        this.vodJobName = this.scheduler.addScheduledOnceJob(delta, new IScheduledJob(){

            @Override
            public void execute(ISchedulingService service) {
                if (ServerStream.this.vodJobName != null) {
                    ServerStream.this.vodJobName = null;
                    if (ServerStream.this.doPushMessage()) {
                        if (ServerStream.this.state == StreamState.PLAYING) {
                            ServerStream.this.scheduleNextMessage();
                        } else {
                            ServerStream.this.nextRTMPMessage = null;
                        }
                    }
                }
            }
        });
    }

    private boolean doPushMessage() {
        boolean sent = false;
        long start = this.currentItem.getStart();
        if (start < 0L) {
            start = 0L;
        }
        if (this.currentItem.getLength() >= 0L && this.nextTS - start > this.currentItem.getLength()) {
            this.onItemEnd();
            return sent;
        }
        if (this.nextRTMPMessage != null) {
            sent = true;
            try {
                this.pushMessage(this.nextRTMPMessage);
            }
            catch (IOException err) {
                log.error("Error while sending message.", (Throwable)err);
            }
            this.nextRTMPMessage.getBody().release();
        }
        return sent;
    }

    protected RTMPMessage getNextRTMPMessage() {
        IMessage message;
        do {
            try {
                message = this.msgIn.pullMessage();
            }
            catch (Exception err) {
                log.error("Error while pulling message.", (Throwable)err);
                message = null;
            }
            if (message != null) continue;
            return null;
        } while (!(message instanceof RTMPMessage));
        return (RTMPMessage)message;
    }

    private void sendVODInitCM(IMessageInput msgIn, int start) {
        if (msgIn != null) {
            OOBControlMessage oobCtrlMsg = new OOBControlMessage();
            oobCtrlMsg.setTarget(IPassive.KEY);
            oobCtrlMsg.setServiceName("init");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
            paramMap.put("startTS", start);
            oobCtrlMsg.setServiceParamMap(paramMap);
            msgIn.sendOOBControlMessage(this, oobCtrlMsg);
        }
    }

    private void sendVODSeekCM(IMessageInput msgIn, int position) {
        OOBControlMessage oobCtrlMsg = new OOBControlMessage();
        oobCtrlMsg.setTarget(ISeekableProvider.KEY);
        oobCtrlMsg.setServiceName("seek");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("position", position);
        oobCtrlMsg.setServiceParamMap(paramMap);
        msgIn.sendOOBControlMessage(this, oobCtrlMsg);
        this.vodStartTS = 0L;
        this.serverStartTS = System.currentTimeMillis();
        if (this.nextRTMPMessage != null) {
            try {
                this.pushMessage(this.nextRTMPMessage);
            }
            catch (IOException err) {
                log.error("Error while sending message.", (Throwable)err);
            }
            this.nextRTMPMessage.getBody().release();
            this.nextRTMPMessage = null;
        }
        ResetMessage reset = new ResetMessage();
        try {
            this.pushMessage(reset);
        }
        catch (IOException err) {
            log.error("Error while sending message.", (Throwable)err);
        }
        this.scheduleNextMessage();
    }

    protected void moveToNext() {
        if (this.currentItemIndex >= this.items.size()) {
            this.currentItemIndex = this.items.size() - 1;
        }
        this.currentItemIndex = this.controller != null ? this.controller.nextItem(this, this.currentItemIndex) : this.defaultController.nextItem(this, this.currentItemIndex);
    }

    protected void moveToPrevious() {
        if (this.currentItemIndex >= this.items.size()) {
            this.currentItemIndex = this.items.size() - 1;
        }
        this.currentItemIndex = this.controller != null ? this.controller.previousItem(this, this.currentItemIndex) : this.defaultController.previousItem(this, this.currentItemIndex);
    }

    @Override
    public void addStreamListener(IStreamListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Collection<IStreamListener> getStreamListeners() {
        return this.listeners;
    }

    @Override
    public void removeStreamListener(IStreamListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "ServerStream [publishedName=" + this.publishedName + ", controller=" + this.controller + ", defaultController=" + this.defaultController + ", isRewind=" + this.isRewind + ", isRandom=" + this.isRandom + ", isRepeat=" + this.isRepeat + ", items=" + this.items + ", currentItemIndex=" + this.currentItemIndex + ", currentItem=" + this.currentItem + ", providerService=" + this.providerService + ", scheduler=" + this.scheduler + ", liveJobName=" + this.liveJobName + ", vodJobName=" + this.vodJobName + ", vodStartTS=" + this.vodStartTS + ", serverStartTS=" + this.serverStartTS + ", nextTS=" + this.nextTS + "]";
    }
}

