/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.preference;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceStore {
    private Properties prop;
    private String path;
    protected static Logger logger = LoggerFactory.getLogger(PreferenceStore.class);

    public PreferenceStore(String path) {
        this.path = path;
    }

    public void put(String key, String value) {
        Properties properties = this.getProperties();
        properties.put(key, value);
    }

    public String get(String key) {
        Properties properties = this.getProperties();
        return properties.getProperty(key);
    }

    public void remove(String key) {
        this.getProperties().remove(key);
    }

    private Properties getProperties() {
        if (this.prop == null) {
            this.prop = new Properties();
            FileInputStream input = null;
            try {
                input = new FileInputStream(this.path);
                this.prop.load(input);
            }
            catch (Exception e) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
        }
        return this.prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        boolean result = false;
        if (this.prop != null) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(this.path);
                this.prop.store(output, null);
                result = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
        }
        return result;
    }
}

