/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.filters.CorsFilter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tomcat.util.http.ResponseUtil;
import org.apache.tomcat.util.res.StringManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorsHeaderFilter
extends CorsFilter {
    protected static Logger logger = LoggerFactory.getLogger(CorsHeaderFilter.class);
    private static final StringManager sm = StringManager.getManager(CorsFilter.class);

    public void handleSimpleCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CorsFilter.CORSRequestType requestType = this.checkRequestType(request);
        if (requestType != CorsFilter.CORSRequestType.SIMPLE && requestType != CorsFilter.CORSRequestType.ACTUAL) {
            throw new IllegalArgumentException(sm.getString("corsFilter.wrongType2", new Object[]{CorsFilter.CORSRequestType.SIMPLE, CorsFilter.CORSRequestType.ACTUAL}));
        }
        String origin = request.getHeader("Origin");
        String method = request.getMethod();
        if (!this.isOriginAllowedInternal(origin)) {
            this.handleInvalidCORSInternal(request, response, filterChain);
            return;
        }
        if (!this.getAllowedHttpMethods().contains(method)) {
            this.handleInvalidCORSInternal(request, response, filterChain);
            return;
        }
        this.addStandardHeadersInternal(request, response, origin);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void addStandardHeadersInternal(HttpServletRequest request, HttpServletResponse response, String origin) {
        String method = request.getMethod();
        if (!this.isAnyOriginAllowed()) {
            ResponseUtil.addVaryFieldName((HttpServletResponse)response, (String)"Origin");
        }
        if (this.isAnyOriginAllowed() && !this.internalOriginCheck(origin, request)) {
            response.addHeader("Access-Control-Allow-Origin", "*");
        } else {
            try {
                if (!origin.matches("^http.*") && !origin.matches("^ws.*")) {
                    throw new IOException("origin does not start http or ws. It is " + origin);
                }
                response.addHeader("Access-Control-Allow-Origin", origin);
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (this.isSupportsCredentials() || this.internalOriginCheck(origin, request)) {
            response.addHeader("Access-Control-Allow-Credentials", "true");
        }
        if (this.getExposedHeaders() != null && !this.getExposedHeaders().isEmpty()) {
            String exposedHeadersString = CorsHeaderFilter.join((Collection)this.getExposedHeaders(), (String)",");
            response.addHeader("Access-Control-Expose-Headers", exposedHeadersString);
        }
        if ("OPTIONS".equals(method)) {
            ResponseUtil.addVaryFieldName((HttpServletResponse)response, (String)"Access-Control-Request-Method");
            ResponseUtil.addVaryFieldName((HttpServletResponse)response, (String)"Access-Control-Request-Headers");
            if (this.getPreflightMaxAge() > 0L) {
                response.addHeader("Access-Control-Max-Age", String.valueOf(this.getPreflightMaxAge()));
            }
            if (this.getAllowedHttpMethods() != null && !this.getAllowedHttpMethods().isEmpty()) {
                response.addHeader("Access-Control-Allow-Methods", CorsHeaderFilter.join((Collection)this.getAllowedHttpMethods(), (String)","));
            }
            if (this.getAllowedHttpHeaders() != null && !this.getAllowedHttpHeaders().isEmpty()) {
                response.addHeader("Access-Control-Allow-Headers", CorsHeaderFilter.join((Collection)this.getAllowedHttpHeaders(), (String)","));
            }
        }
    }

    private boolean internalOriginCheck(String origin, HttpServletRequest request) {
        return origin.equals("http://localhost:4200") || request.getHeader("Authorization") != null || request.getHeader("Access-Control-Request-Headers") != null && request.getHeader("Access-Control-Request-Headers").contains("authorization") || request.getHeader("ProxyAuthorization") != null || request.getHeader("Access-Control-Request-Headers") != null && request.getHeader("Access-Control-Request-Headers").contains("ProxyAuthorization");
    }

    private boolean isOriginAllowedInternal(String origin) {
        if (this.isAnyOriginAllowed()) {
            return true;
        }
        return this.getAllowedOrigins().contains(origin);
    }

    private void handleInvalidCORSInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) {
        response.setContentType("text/plain");
        response.setStatus(403);
        response.resetBuffer();
    }

    public void handlePreflightCORS(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        CorsFilter.CORSRequestType requestType = this.checkRequestType(request);
        if (requestType != CorsFilter.CORSRequestType.PRE_FLIGHT) {
            throw new IllegalArgumentException(sm.getString("corsFilter.wrongType1", new Object[]{CorsFilter.CORSRequestType.PRE_FLIGHT.name().toLowerCase(Locale.ENGLISH)}));
        }
        String origin = request.getHeader("Origin");
        if (!this.isOriginAllowedInternal(origin)) {
            this.handleInvalidCORSInternal(request, response, filterChain);
            return;
        }
        String accessControlRequestMethod = request.getHeader("Access-Control-Request-Method");
        if (accessControlRequestMethod == null) {
            this.handleInvalidCORSInternal(request, response, filterChain);
            return;
        }
        accessControlRequestMethod = accessControlRequestMethod.trim();
        String accessControlRequestHeadersHeader = request.getHeader("Access-Control-Request-Headers");
        LinkedList<String> accessControlRequestHeaders = new LinkedList<String>();
        if (accessControlRequestHeadersHeader != null && !accessControlRequestHeadersHeader.trim().isEmpty()) {
            String[] headers;
            for (String header : headers = accessControlRequestHeadersHeader.trim().split(",")) {
                accessControlRequestHeaders.add(header.trim().toLowerCase(Locale.ENGLISH));
            }
        }
        if (!this.getAllowedHttpMethods().contains(accessControlRequestMethod)) {
            this.handleInvalidCORSInternal(request, response, filterChain);
            return;
        }
        if (!accessControlRequestHeaders.isEmpty()) {
            for (String header : accessControlRequestHeaders) {
                if (this.getAllowedHttpHeaders().contains(header)) continue;
                this.handleInvalidCORSInternal(request, response, filterChain);
                return;
            }
        }
        this.addStandardHeadersInternal(request, response, origin);
    }
}

