/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.filter.JWTFilter;
import io.antmedia.rest.servlet.EndpointProxy;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class RestProxyFilter
extends AbstractFilter {
    protected static Logger log = LoggerFactory.getLogger(RestProxyFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = httpRequest.getMethod();
        if ("POST".equals(method) || "PUT".equals(method) || "DELETE".equals(method)) {
            String streamId = this.getStreamId(httpRequest.getRequestURI());
            if (streamId != null && !streamId.isEmpty()) {
                Broadcast broadcast = this.getBroadcast(httpRequest, streamId);
                log.debug("STREAM ID = {} BROADCAST = {} ", (Object)streamId, (Object)broadcast);
                if (broadcast != null && AntMediaApplicationAdapter.isStreaming(broadcast) && !this.isRequestDestinedForThisNode(request.getRemoteAddr(), broadcast.getOriginAdress())) {
                    this.forwardRequestToOrigin(request, response, broadcast);
                } else {
                    chain.doFilter(request, response);
                }
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void forwardRequestToOrigin(ServletRequest request, ServletResponse response, Broadcast broadcast) throws ServletException, IOException {
        String jwtToken = RestProxyFilter.generateJwtToken(this.getAppSettings().getClusterCommunicationKey(), System.currentTimeMillis() + 5000L);
        AppSettings settings = this.getAppSettings();
        String originAdress = "http://" + broadcast.getOriginAdress() + ":" + this.getServerSetting().getDefaultHttpPort() + File.separator + settings.getAppName() + "/rest";
        log.info("Redirecting the request({}) to origin {}", (Object)((HttpServletRequest)request).getRequestURI(), (Object)originAdress);
        EndpointProxy endpointProxy = new EndpointProxy(jwtToken);
        endpointProxy.initTarget(originAdress);
        endpointProxy.service(request, response);
    }

    public String getStreamId(String reqURI) {
        try {
            reqURI = reqURI.split("broadcasts/")[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        if (reqURI.contains("/")) {
            reqURI = reqURI.substring(0, reqURI.indexOf("/"));
        }
        return reqURI;
    }

    public boolean isRequestDestinedForThisNode(String requestAddress, String streamOriginAddress) {
        ConfigurableWebApplicationContext context = this.getAppContext();
        boolean isCluster = context.containsBean("tomcat.cluster");
        return !isCluster || requestAddress.equals(this.getServerSetting().getHostAddress()) || this.getServerSetting().getHostAddress().equals(streamOriginAddress);
    }

    public static String generateJwtToken(String jwtSecretKey, long expireDateUnixTimeStampMs) {
        Date expireDateType = new Date(expireDateUnixTimeStampMs);
        String jwtTokenId = null;
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)jwtSecretKey);
            jwtTokenId = JWT.create().withExpiresAt(expireDateType).sign(algorithm);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return jwtTokenId;
    }

    public static boolean isNodeCommunicationTokenValid(String jwtInternalCommunicationToken, String jwtSecretKey, String requestURI) {
        boolean result = false;
        if (jwtInternalCommunicationToken != null) {
            result = JWTFilter.isJWTTokenValid(jwtSecretKey, jwtInternalCommunicationToken);
            if (result) {
                logger.info("Request forwarded:{} by another node is validated successfully", (Object)requestURI);
            } else {
                logger.warn("Requested forwarded:{} by another node is failed because cluster jwt token is valid", (Object)requestURI);
            }
        } else {
            logger.debug("Node communicaiton header:{} is not found ", (Object)"ClusterAuthorization");
        }
        return result;
    }
}

