/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera;

import io.antmedia.ipcamera.IOnvifCamera;
import io.antmedia.ipcamera.onvif.soap.OnvifDevice;
import io.antmedia.ipcamera.onvif.soap.devices.PtzDevices;
import java.net.ConnectException;
import java.sql.Time;
import java.util.Date;
import java.util.List;
import javax.xml.soap.SOAPException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.onvif.ver10.schema.AutoFocusMode;
import org.onvif.ver10.schema.FocusConfiguration20;
import org.onvif.ver10.schema.ImagingSettings20;
import org.onvif.ver10.schema.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnvifCamera
implements IOnvifCamera {
    OnvifDevice nvt;
    PtzDevices ptzDevices;
    List<Profile> profiles;
    public static final int CONNECTION_SUCCESS = 0;
    public static final int CONNECT_ERROR = -1;
    public static final int AUTHENTICATION_ERROR = -2;
    String profileToken;
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    protected static Logger logger = LoggerFactory.getLogger(OnvifCamera.class);

    @Override
    public int connect(String address, String username, String password) {
        int result = -1;
        String camIP = "";
        try {
            camIP = this.getIPAddress(address);
            String protocol = this.getProtocol(address);
            this.nvt = new OnvifDevice(camIP, protocol, username, password);
            this.nvt.getSoap().setLogging(false);
            this.nvt.getDevices().getCapabilities().getDevice();
            this.nvt.getDevices().getServices(false);
            this.ptzDevices = this.nvt.getPtz();
            this.profiles = this.nvt.getDevices().getProfiles();
            if (this.profiles != null) {
                for (Profile profile : this.profiles) {
                    if (profile.getPTZConfiguration() == null) continue;
                    this.profileToken = profile.getToken();
                    break;
                }
                if (this.profileToken == null) {
                    this.profileToken = this.profiles.get(0).getToken();
                }
                result = 0;
            } else {
                result = -2;
            }
        }
        catch (ConnectException | SOAPException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            result = -1;
        }
        return result;
    }

    public String getProtocol(String address) {
        String protocol = null;
        if (address.startsWith(HTTP_PREFIX)) {
            protocol = "http";
        } else if (address.startsWith(HTTPS_PREFIX)) {
            protocol = "https";
        }
        return protocol;
    }

    @Override
    public String[] getProfiles() {
        String[] profilesStr = null;
        try {
            List profilesLocal = this.nvt.getDevices().getProfiles();
            if (profilesLocal != null) {
                int i = 0;
                profilesStr = new String[profilesLocal.size()];
                for (Profile profile : profilesLocal) {
                    if (profile.getPTZConfiguration() == null) continue;
                    profilesStr[i++] = this.nvt.getMedia().getRTSPStreamUri(profile.getToken());
                }
            }
        }
        catch (ConnectException | SOAPException throwable) {
            // empty catch block
        }
        return profilesStr;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public String getRTSPStreamURI() {
        String rtspURL = null;
        try {
            rtspURL = this.nvt.getMedia().getRTSPStreamUri(this.profileToken);
        }
        catch (NullPointerException | ConnectException | SOAPException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return rtspURL;
    }

    @Override
    public String getTCPStreamURI() {
        String rtspURL = null;
        try {
            rtspURL = this.nvt.getMedia().getTCPStreamUri(this.profileToken);
        }
        catch (ConnectException | SOAPException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return rtspURL;
    }

    @Override
    public boolean moveContinous(float x, float y, float zoom) {
        return this.ptzDevices.continuousMove(this.profileToken, x, y, zoom);
    }

    @Override
    public boolean moveRelative(float x, float y, float zoom) {
        return this.ptzDevices.relativeMove(this.profileToken, x, y, zoom);
    }

    @Override
    public boolean moveAbsolute(float x, float y, float zoom) {
        boolean result = false;
        try {
            result = this.ptzDevices.absoluteMove(this.profileToken, x, y, zoom);
        }
        catch (SOAPException e) {
            result = false;
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return result;
    }

    @Override
    public boolean moveStop() {
        return this.ptzDevices.stopMove(this.profileToken);
    }

    @Override
    public String getAlarms() {
        return null;
    }

    @Override
    public boolean enableDhcp() {
        return false;
    }

    @Override
    public boolean disableDhcp(String ipaddress, String netmask, String gateway) {
        return false;
    }

    @Override
    public Date getTime() {
        return this.nvt.getDate();
    }

    @Override
    public boolean setBrightness(float brightness) {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        image_set.setBrightness(Float.valueOf(brightness));
        return true;
    }

    @Override
    public float getBrightness() {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        return image_set.getBrightness().floatValue();
    }

    @Override
    public boolean setSaturation(float saturation) {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        image_set.setColorSaturation(Float.valueOf(saturation));
        return true;
    }

    @Override
    public float getSaturation() {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        return image_set.getColorSaturation().floatValue();
    }

    @Override
    public boolean setContrast(float contrast) {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        image_set.setContrast(Float.valueOf(contrast));
        return true;
    }

    @Override
    public float getContrast() {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        return image_set.getContrast().floatValue();
    }

    @Override
    public boolean setSharpness(float sharpness) {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        image_set.setSharpness(Float.valueOf(sharpness));
        return true;
    }

    @Override
    public float getSharpness() {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        return image_set.getSharpness().floatValue();
    }

    @Override
    public boolean setFocusMode(boolean auto) {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        FocusConfiguration20 focus = image_set.getFocus();
        AutoFocusMode foc_mode = auto ? AutoFocusMode.fromValue((String)"AUTO") : AutoFocusMode.fromValue((String)"MANUAL");
        focus.setAutoFocusMode(foc_mode);
        return true;
    }

    @Override
    public boolean isFocusModeAuto() {
        ImagingSettings20 image_set = this.nvt.getImaging().getImagingSettings(this.profileToken);
        FocusConfiguration20 focus = image_set.getFocus();
        return "AUTO".equals(focus.getAutoFocusMode().value());
    }

    @Override
    public boolean setDateTime(java.sql.Date date, Time time) {
        return false;
    }

    public String getIPAddress(String url) {
        String[] ipAddrParts = null;
        String ipAddr = url;
        if (url != null && (url.startsWith(HTTP_PREFIX) || url.startsWith(HTTPS_PREFIX) || url.startsWith("rtmp://") || url.startsWith("rtmps://") || url.startsWith("rtsp://"))) {
            ipAddrParts = url.split("//");
            ipAddr = ipAddrParts[1];
        }
        if (ipAddr != null) {
            if (ipAddr.contains("/")) {
                ipAddrParts = ipAddr.split("/");
                ipAddr = ipAddrParts[0];
            }
            logger.info("IP: {}", (Object)ipAddr);
        }
        return ipAddr;
    }
}

