/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.logger;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.AppenderBase;
import com.google.gson.JsonObject;
import io.antmedia.logger.LoggerEnvironment;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.red5.server.Launcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntmediaAppender
extends AppenderBase<ILoggingEvent> {
    protected static final Logger logger = LoggerFactory.getLogger(AntmediaAppender.class);
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private int numberOfCalls = 0;
    private int numberOfException = 0;

    public void append(ILoggingEvent iLoggingEvent) {
        if (LoggerEnvironment.isManagingThread()) {
            return;
        }
        LoggerEnvironment.startManagingThread();
        try {
            IThrowableProxy throwbleProxy = iLoggingEvent.getThrowableProxy();
            if (throwbleProxy != null) {
                this.sendErrorToAnalytic(throwbleProxy);
            }
        }
        catch (Exception e) {
            this.addError("An exception occurred", e);
        }
        finally {
            LoggerEnvironment.stopManagingThread();
        }
    }

    public void stop() {
        LoggerEnvironment.startManagingThread();
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
        }
        catch (Exception e) {
            this.addError("An exception occurred", e);
        }
        finally {
            LoggerEnvironment.stopManagingThread();
        }
    }

    public void sendErrorToAnalytic(IThrowableProxy throwbleProxy) {
        executor.submit(() -> {
            try (CloseableHttpClient client = AntmediaAppender.getHttpClient();){
                String errorDetail = ThrowableProxyUtil.asString((IThrowableProxy)throwbleProxy);
                String instanceId = Launcher.getInstanceId();
                String version = Launcher.getVersion();
                String type = Launcher.getVersionType();
                JsonObject instance = new JsonObject();
                instance.addProperty("instanceId", instanceId);
                instance.addProperty("instanceType", type);
                instance.addProperty("instanceVersion", version);
                instance.addProperty("errorDetail", errorDetail);
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(5000).build();
                HttpRequestBase post = (HttpRequestBase)RequestBuilder.post().setUri("https://us-central1-ant-media-server-analytics.cloudfunctions.net/sendErrorDetail").setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(instance.toString())).build();
                post.setConfig(requestConfig);
                client.execute((HttpUriRequest)post);
                ++this.numberOfCalls;
            }
            catch (Exception e) {
                logger.error("Couldn't connect Ant Media Server Analytics: {} ", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                ++this.numberOfException;
            }
        });
    }

    public static CloseableHttpClient getHttpClient() {
        return HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
    }

    public int getNumberOfCalls() {
        return this.numberOfCalls;
    }
}

