/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.antmedia.muxer.Muxer;
import io.antmedia.storage.StorageClient;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;

public class HLSMuxer
extends Muxer {
    private static final String SEGMENT_SUFFIX_TS = "%09d.ts";
    protected static Logger logger = LoggerFactory.getLogger(HLSMuxer.class);
    private String hlsListSize = "20";
    private String hlsTime = "5";
    private String hlsPlayListType = null;
    private long totalSize;
    private long startTime;
    private long currentTime;
    private boolean deleteFileOnExit = true;
    private String hlsFlags;
    private String hlsEncryptionKeyInfoFile = null;
    protected StorageClient storageClient = null;
    private String subFolder = null;
    private String s3StreamsFolderPath = "streams";
    private boolean uploadHLSToS3 = true;
    private String segmentFilename;
    private String httpEndpoint;
    public static final int S3_CONSTANT = 2;

    public HLSMuxer(Vertx vertx, StorageClient storageClient, String s3StreamsFolderPath, int uploadExtensionsToS3, String httpEndpoint, boolean addDateTimeToResourceName) {
        super(vertx);
        this.storageClient = storageClient;
        if ((2 & uploadExtensionsToS3) == 0) {
            this.uploadHLSToS3 = false;
        }
        this.extension = ".m3u8";
        this.format = "hls";
        this.firstKeyFrameReceived = false;
        this.firstAudioDts = -1L;
        this.firstVideoDts = -1L;
        this.s3StreamsFolderPath = s3StreamsFolderPath;
        this.httpEndpoint = httpEndpoint;
        this.setAddDateTimeToSourceName(addDateTimeToResourceName);
    }

    public void setHlsParameters(String hlsListSize, String hlsTime, String hlsPlayListType, String hlsFlags, String hlsEncryptionKeyInfoFile) {
        if (hlsListSize != null && !hlsListSize.isEmpty()) {
            this.hlsListSize = hlsListSize;
        }
        if (hlsTime != null && !hlsTime.isEmpty()) {
            this.hlsTime = hlsTime;
        }
        if (hlsPlayListType != null && !hlsPlayListType.isEmpty()) {
            this.hlsPlayListType = hlsPlayListType;
        }
        this.hlsFlags = hlsFlags != null && !hlsFlags.isEmpty() ? hlsFlags : "";
        if (hlsEncryptionKeyInfoFile != null && !hlsEncryptionKeyInfoFile.isEmpty()) {
            this.hlsEncryptionKeyInfoFile = hlsEncryptionKeyInfoFile;
        }
    }

    @Override
    public void init(IScope scope, String name, int resolutionHeight, String subFolder, int bitrate) {
        if (!this.isInitialized) {
            super.init(scope, name, resolutionHeight, subFolder, bitrate);
            this.streamId = name;
            this.subFolder = subFolder;
            this.options.put("hls_list_size", this.hlsListSize);
            this.options.put("hls_time", this.hlsTime);
            if (this.hlsEncryptionKeyInfoFile != null) {
                this.options.put("hls_key_info_file", this.hlsEncryptionKeyInfoFile);
            }
            logger.info("hls time: {}, hls list size: {} for stream:{}", new Object[]{this.hlsTime, this.hlsListSize, this.streamId});
            this.segmentFilename = StringUtils.isNotBlank((CharSequence)this.httpEndpoint) ? this.httpEndpoint + File.separator + (this.subFolder != null ? subFolder : "") + this.initialResourceNameWithoutExtension : this.file.getParentFile() + File.separator + this.initialResourceNameWithoutExtension;
            this.segmentFilename = this.segmentFilename + SEGMENT_SUFFIX_TS;
            this.options.put("hls_segment_filename", this.segmentFilename);
            if (this.hlsPlayListType != null && (this.hlsPlayListType.equals("event") || this.hlsPlayListType.equals("vod"))) {
                this.options.put("hls_playlist_type", this.hlsPlayListType);
            }
            if (this.hlsFlags != null && !this.hlsFlags.isEmpty()) {
                this.options.put("hls_flags", this.hlsFlags);
            }
            this.isInitialized = true;
        }
    }

    @Override
    public String getOutputURL() {
        if (StringUtils.isNotBlank((CharSequence)this.httpEndpoint)) {
            return this.httpEndpoint + File.separator + this.initialResourceNameWithoutExtension + this.extension;
        }
        return super.getOutputURL();
    }

    @Override
    public AVFormatContext getOutputFormatContext() {
        if (this.outputFormatContext == null) {
            this.outputFormatContext = new AVFormatContext(null);
            int ret = avformat.avformat_alloc_output_context2((AVFormatContext)this.outputFormatContext, null, (String)this.format, (String)this.getOutputURL());
            if (ret < 0) {
                logger.info("Could not create output context for {}", (Object)this.getOutputURL());
                return null;
            }
        }
        return this.outputFormatContext;
    }

    @Override
    public boolean isCodecSupported(int codecId) {
        return codecId == 27 || codecId == 86018 || codecId == 86017 || codecId == 173;
    }

    public long getAverageBitrate() {
        long duration = this.currentTime - this.startTime;
        if (duration > 0L) {
            return this.totalSize / duration * 8L;
        }
        return 0L;
    }

    @Override
    public synchronized void writePacket(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, int codecType) {
        this.totalSize += (long)pkt.size();
        this.currentTime = avutil.av_rescale_q((long)pkt.dts(), (AVRational)inputTimebase, (AVRational)avRationalTimeBase);
        if (this.startTime == 0L) {
            this.startTime = this.currentTime;
        }
        super.writePacket(pkt, inputTimebase, outputTimebase, codecType);
    }

    @Override
    public synchronized void writeTrailer() {
        super.writeTrailer();
        if (!StringUtils.isNotBlank((CharSequence)this.httpEndpoint)) {
            logger.info("Delete File onexit:{} upload to S3:{} stream:{} hls time:{} hlslist size:{}", new Object[]{this.deleteFileOnExit, this.uploadHLSToS3, this.streamId, this.hlsTime, this.hlsListSize});
            this.vertx.setTimer((long)(Integer.parseInt(this.hlsTime) * Integer.parseInt(this.hlsListSize) * 1000), l -> {
                String filenameWithoutExtension = this.file.getName().substring(0, this.file.getName().lastIndexOf(this.extension));
                String segmentFileWithoutSuffixTS = this.segmentFilename.substring(this.segmentFilename.lastIndexOf("/") + 1, this.segmentFilename.indexOf(SEGMENT_SUFFIX_TS));
                String regularExpression = segmentFileWithoutSuffixTS + "[0-9]*\\.ts$";
                File[] files = this.file.getParentFile().listFiles((dir, name) -> name.equals(this.file.getName()) || name.matches(regularExpression));
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            if (!files[i].exists()) continue;
                            if (this.uploadHLSToS3 && this.storageClient.isEnabled()) {
                                this.storageClient.save(this.s3StreamsFolderPath + File.separator + (String)(this.subFolder != null ? this.subFolder + File.separator : "") + files[i].getName(), files[i], this.deleteFileOnExit);
                                continue;
                            }
                            if (!this.deleteFileOnExit) continue;
                            Files.delete(files[i].toPath());
                            continue;
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
            });
        } else {
            logger.info("http endpoint is {} so skipping delete or upload the m3u8 or ts files", (Object)this.httpEndpoint);
        }
    }

    @Override
    public synchronized boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        AVCodecParameters codecParameter = new AVCodecParameters();
        int ret = avcodec.avcodec_parameters_from_context((AVCodecParameters)codecParameter, (AVCodecContext)codecContext);
        if (ret < 0) {
            logger.error("Cannot get codec parameters for {}", (Object)this.streamId);
        }
        return super.addStream(codecParameter, codecContext.time_base(), streamIndex);
    }

    @Override
    public synchronized boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        this.bsfVideoName = "h264_mp4toannexb";
        return super.addStream(codecParameters, timebase, streamIndex);
    }

    public String getHlsListSize() {
        return this.hlsListSize;
    }

    public void setHlsListSize(String hlsListSize) {
        this.hlsListSize = hlsListSize;
    }

    public String getHlsTime() {
        return this.hlsTime;
    }

    public void setHlsTime(String hlsTime) {
        this.hlsTime = hlsTime;
    }

    public String getHlsPlayListType() {
        return this.hlsPlayListType;
    }

    public void setHlsPlayListType(String hlsPlayListType) {
        this.hlsPlayListType = hlsPlayListType;
    }

    public boolean isDeleteFileOnExit() {
        return this.deleteFileOnExit;
    }

    public void setDeleteFileOnExit(boolean deleteFileOnExist) {
        this.deleteFileOnExit = deleteFileOnExist;
    }

    public boolean isUploadingToS3() {
        return this.uploadHLSToS3;
    }

    public String getSegmentFilename() {
        return this.segmentFilename;
    }
}

