/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer.parser;

public abstract class Parser {
    protected int currentBit;
    protected byte[] data;
    protected boolean errorOccured = false;

    public Parser(byte[] data, int offset) {
        this.data = data;
        this.currentBit = offset * 8;
        this.parse();
    }

    protected abstract void parse();

    protected int readBit() {
        int nIndex = this.currentBit / 8;
        int nOffset = this.currentBit % 8 + 1;
        ++this.currentBit;
        return this.data[nIndex] >> 8 - nOffset & 1;
    }

    protected int readBits(int n) {
        int r = 0;
        for (int i = 0; i < n; ++i) {
            r |= this.readBit() << n - i - 1;
        }
        return r;
    }

    protected int readExponentialGolombCode() {
        int i;
        int r = 0;
        for (i = 0; this.readBit() == 0 && i < 32; ++i) {
        }
        r = this.readBits(i);
        return r += (1 << i) - 1;
    }

    protected int readSE() {
        int r = this.readExponentialGolombCode();
        r = (r & 1) != 0 ? (r + 1) / 2 : -(r / 2);
        return r;
    }

    public boolean isErrorOccured() {
        return this.errorOccured;
    }
}

