/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer.parser.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AudioCodec;
import org.red5.codec.IAudioStreamCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AACAudio
implements IAudioStreamCodec {
    private static Logger log = LoggerFactory.getLogger(AACAudio.class);
    public static final int[] AAC_SAMPLERATES = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350};
    static final String CODEC_NAME = "AAC";
    private byte[] blockDataAACDCR;

    public AACAudio() {
        this.reset();
    }

    public String getName() {
        return CODEC_NAME;
    }

    public void reset() {
        this.blockDataAACDCR = null;
    }

    public boolean canHandleData(IoBuffer data) {
        if (data.limit() == 0) {
            return false;
        }
        byte first = data.get();
        boolean result = (first & 0xF0) >> 4 == AudioCodec.AAC.getId();
        data.rewind();
        return result;
    }

    public boolean addData(IoBuffer data) {
        if (data.hasRemaining()) {
            int start = data.position();
            data.rewind();
            byte frameType = data.get();
            log.trace("Frame type: {}", (Object)frameType);
            byte header = data.get();
            if (header == 0) {
                log.debug("AACDecoderConfigurationRecord is received");
                if ((frameType & 0xF0) >> 4 == AudioCodec.AAC.getId()) {
                    data.rewind();
                    this.blockDataAACDCR = new byte[data.remaining()];
                    data.get(this.blockDataAACDCR);
                }
            }
            data.position(start);
        }
        return true;
    }

    public IoBuffer getDecoderConfiguration() {
        if (this.blockDataAACDCR == null) {
            return null;
        }
        IoBuffer result = IoBuffer.allocate((int)4);
        result.setAutoExpand(true);
        result.put(this.blockDataAACDCR);
        result.rewind();
        return result;
    }
}

