/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.statistic;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ContentType;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.FFmpegUtilities;
import io.antmedia.SystemUtils;
import io.antmedia.console.AdminApplication;
import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.datastore.db.types.Licence;
import io.antmedia.datastore.db.types.User;
import io.antmedia.licence.ILicenceService;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.WebRTCClientStats;
import io.antmedia.rest.model.UserType;
import io.antmedia.settings.ServerSettings;
import io.antmedia.statistic.DashViewerStats;
import io.antmedia.statistic.GPUUtils;
import io.antmedia.statistic.HlsViewerStats;
import io.antmedia.statistic.IStatsCollector;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.vertx.core.Vertx;
import io.vertx.ext.dropwizard.MetricsService;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.bytedeco.javacpp.Pointer;
import org.red5.server.Launcher;
import org.red5.server.api.IServer;
import org.red5.server.api.listeners.IScopeListener;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class StatsCollector
implements IStatsCollector,
ApplicationContextAware,
DisposableBean {
    public static final String FREE_NATIVE_MEMORY = "freeNativeMemory";
    public static final String TOTAL_NATIVE_MEMORY = "totalNativeMemory";
    public static final String IN_USE_NATIVE_MEMORY = "inUseNativeMemory";
    public static final String AVAILABLE_MEMORY = "availableMemory";
    public static final String IN_USE_SWAP_SPACE = "inUseSwapSpace";
    public static final String FREE_SWAP_SPACE = "freeSwapSpace";
    public static final String TOTAL_SWAP_SPACE = "totalSwapSpace";
    public static final String VIRTUAL_MEMORY = "virtualMemory";
    public static final String PROCESSOR_COUNT = "processorCount";
    public static final String JAVA_VERSION = "javaVersion";
    public static final String OS_ARCH = "osArch";
    public static final String OS_NAME = "osName";
    public static final String IN_USE_SPACE = "inUseSpace";
    public static final String FREE_SPACE = "freeSpace";
    public static final String TOTAL_SPACE = "totalSpace";
    public static final String USABLE_SPACE = "usableSpace";
    public static final String IN_USE_MEMORY = "inUseMemory";
    public static final String FREE_MEMORY = "freeMemory";
    public static final String TOTAL_MEMORY = "totalMemory";
    public static final String MAX_MEMORY = "maxMemory";
    public static final String PROCESS_CPU_LOAD = "processCPULoad";
    public static final String SYSTEM_CPU_LOAD = "systemCPULoad";
    public static final String PROCESS_CPU_TIME = "processCPUTime";
    public static final String CPU_USAGE = "cpuUsage";
    public static final String INSTANCE_ID = "instanceId";
    public static final String MARKETPLACE_NAME = "marketplace";
    public static final String USER_EMAIL = "userEmail";
    public static final String LICENSE_VALID = "licenseValid";
    public static final String INSTANCE_TYPE = "instanceType";
    public static final String INSTANCE_VERSION = "instanceVersion";
    public static final String JVM_MEMORY_USAGE = "jvmMemoryUsage";
    public static final String NATIVE_MEMORY_USAGE = "nativeMemoryUsage";
    public static final String SYSTEM_INFO = "systemInfo";
    public static final String SYSTEM_MEMORY_INFO = "systemMemoryInfo";
    public static final String FILE_SYSTEM_INFO = "fileSystemInfo";
    public static final String GPU_UTILIZATION = "gpuUtilization";
    public static final String GPU_DEVICE_INDEX = "index";
    public static final String GPU_MEMORY_UTILIZATION = "memoryUtilization";
    public static final String GPU_MEMORY_TOTAL = "memoryTotal";
    public static final String GPU_MEMORY_FREE = "memoryFree";
    public static final String GPU_MEMORY_USED = "memoryUsed";
    public static final String GPU_DEVICE_NAME = "deviceName";
    public static final String GPU_USAGE_INFO = "gpuUsageInfo";
    public static final String FFMPEG_BUILD_INFO = "ffmpegBuildInfo";
    public static final String TOTAL_LIVE_STREAMS = "totalLiveStreamSize";
    public static final String LOCAL_WEBRTC_LIVE_STREAMS = "localWebRTCLiveStreams";
    public static final String LOCAL_LIVE_STREAMS = "localLiveStreams";
    public static final String LOCAL_WEBRTC_VIEWERS = "localWebRTCViewers";
    public static final String LOCAL_HLS_VIEWERS = "localHLSViewers";
    public static final String LOCAL_DASH_VIEWERS = "localDASHViewers";
    private static final String TIME = "time";
    protected static final Logger logger = LoggerFactory.getLogger(StatsCollector.class);
    private static final String MEASURED_BITRATE = "measured_bitrate";
    private static final String SEND_BITRATE = "send_bitrate";
    private static final String AUDIO_FRAME_SEND_PERIOD = "audio_frame_send_period";
    private static final String VIDEO_FRAME_SEND_PERIOD = "video_frame_send_period";
    private static final String STREAM_ID = "streamId";
    private static final String WEBRTC_CLIENT_ID = "webrtcClientId";
    private static final String WEBRTC_VIEWER_INFO = "webrtcViewerInfo";
    private Queue<IScope> scopes = new ConcurrentLinkedQueue<IScope>();
    public static final String GA_TRACKING_ID = "UA-93263926-3";
    private Vertx vertx;
    private Queue<Integer> cpuMeasurements = new ConcurrentLinkedQueue<Integer>();
    Gson gson = new Gson();
    private int windowSize = 5;
    private int measurementPeriod = 1000;
    private int staticSendPeriod = 15000;
    private int cpuLoad;
    private int cpuLimit = 70;
    private int minFreeRamSize = 50;
    private String kafkaBrokers = null;
    public static final String INSTANCE_STATS_TOPIC_NAME = "ams-instance-stats";
    public static final String WEBRTC_STATS_TOPIC_NAME = "ams-webrtc-stats";
    public static final String UP_TIME = "up-time";
    public static final String START_TIME = "start-time";
    public static final String SERVER_TIMING = "server-timing";
    private static final String ENCODERS_BLOCKED = "encoders-blocked";
    private static final String ENCODERS_NOT_OPENED = "encoders-not-opened";
    private static final String PUBLISH_TIMEOUT_ERRORS = "publish-timeout-errors";
    private static final String THREAD_DUMP = "thread-dump";
    public static final String DEAD_LOCKED_THREAD = "dead-locked-thread";
    public static final String THREAD_COUNT = "thread-count";
    public static final String THREAD_PEEK_COUNT = "thread-peek-count";
    private static final String THREAD_NAME = "thread-name";
    private static final String THREAD_ID = "thread-id";
    private static final String THREAD_BLOCKED_TIME = "blocked-time";
    private static final String THREAD_BLOCKED_COUNT = "blocked-count";
    private static final String THREAD_WAITED_TIME = "waited-time";
    private static final String THREAD_WAITED_COUNT = "waited-count";
    private static final String THREAD_LOCK_NAME = "lock-name";
    private static final String THREAD_LOCK_OWNER_ID = "lock-owner-id";
    private static final String THREAD_LOCK_OWNER_NAME = "lock-owner-name";
    private static final String THREAD_IN_NATIVE = "in-native";
    private static final String THREAD_SUSPENDED = "suspended";
    private static final String THREAD_STATE = "state";
    private static final String THREAD_CPU_TIME = "cpu-time";
    private static final String THREAD_USER_TIME = "user-time";
    public static final String IN_USE_JVM_NATIVE_MEMORY = "inUseMemory";
    public static final String MAX_JVM_NATIVE_MEMORY = "maxMemory";
    public static final String JVM_NATIVE_MEMORY_USAGE = "jvmNativeMemoryUsage";
    private static final String HOST_ADDRESS = "host-address";
    private static final String IP_ADDRESS = "ip-address";
    private static final String VERTX_WORKER_QUEUE_SIZE = "vertx.pools.worker.vert.x-worker-thread.queue-size";
    private static final String VERTX_WORKER_THREAD_QUEUE_SIZE = "vertx-worker-thread-queue-size";
    private static final String WEBRTC_VERTX_WORKER_THREAD_QUEUE_SIZE = "webrtc-vertx-worker-thread-queue-size";
    public static final String HOOK_HIGH_RESOURCE_USAGE = "highResourceUsage";
    public static final String HOOK_UNEXPECTED_SERVER_SHUTDOWN = "unexpectedServerShutdown";
    private Producer<Long, String> kafkaProducer = null;
    private long cpuMeasurementTimerId = -1L;
    private long kafkaTimerId = -1L;
    private boolean heartBeatEnabled = true;
    private long hearbeatPeriodicTask;
    private int heartbeatPeriodMs = 300000;
    private String hostAddress;
    private Vertx webRTCVertx;
    private int time2Log = 0;
    private String marketplace;
    private static MetricsService vertXMetrics;
    private static MetricsService webRTCVertxMetrics;
    private ILicenceService licenseService;
    private String userEmail;
    private String webhookURL;
    private long unexpectedShutDownDelayMs = 30000L;

    public void start() {
        this.cpuMeasurementTimerId = this.getVertx().setPeriodic((long)this.measurementPeriod, l -> {
            this.addCpuMeasurement(SystemUtils.getSystemCpuLoad());
            if (300000 / this.measurementPeriod == this.time2Log) {
                if (logger != null) {
                    logger.info("System cpu load:{} process cpu load:{} available memory: {} KB used memory(RSS): {} KB", new Object[]{this.cpuLoad, SystemUtils.getProcessCpuLoad(), SystemUtils.convertByteSize(SystemUtils.osAvailableMemory(), "KB"), SystemUtils.convertByteSize(Pointer.physicalBytes(), "KB")});
                    int vertxWorkerQueueSize = StatsCollector.getVertWorkerQueueSizeStatic();
                    int webRTCVertxWorkerQueueSize = StatsCollector.getWebRTCVertxWorkerQueueSizeStatic();
                    logger.info("Vertx worker queue size:{} WebRTCVertx worker queue size:{}", (Object)vertxWorkerQueueSize, (Object)webRTCVertxWorkerQueueSize);
                }
                this.time2Log = 0;
            }
            ++this.time2Log;
        });
        this.startKafkaProducer();
        if (this.heartBeatEnabled) {
            logger.warn("Starting heartbeats for the version:{} and type:{}", (Object)Launcher.getVersion(), (Object)Launcher.getVersionType());
            this.getVertx().setPeriodic((long)this.heartbeatPeriodMs, l -> this.startAnalytic());
        } else {
            logger.info("Heartbeats are disabled for this instance");
        }
        if (this.webhookURL != null && !this.webhookURL.isEmpty()) {
            this.getVertx().setTimer(this.unexpectedShutDownDelayMs, h -> {
                ArrayList<String> appNames = new ArrayList<String>();
                for (IScope scope : this.scopes) {
                    AntMediaApplicationAdapter adaptor = null;
                    adaptor = StatsCollector.getAppAdaptor(scope.getContext().getApplicationContext());
                    if (adaptor == null || adaptor.isShutdownProperly()) continue;
                    appNames.add(scope.getName());
                }
                if (!appNames.isEmpty()) {
                    this.sendUnexpectedShutdownHook(appNames);
                }
            });
        }
    }

    private void startKafkaProducer() {
        if (this.kafkaBrokers != null && !this.kafkaBrokers.isEmpty()) {
            this.kafkaProducer = this.createKafkaProducer();
            this.kafkaTimerId = this.getVertx().setPeriodic((long)this.staticSendPeriod, l -> {
                this.sendInstanceStats(this.scopes);
                this.sendWebRTCClientStats();
            });
        }
    }

    private static int getVertWorkerQueueSizeStatic() {
        io.vertx.core.json.JsonObject queueSizeMetrics = vertXMetrics.getMetricsSnapshot(VERTX_WORKER_QUEUE_SIZE);
        io.vertx.core.json.JsonObject jsonObject = null;
        if (queueSizeMetrics != null) {
            jsonObject = queueSizeMetrics.getJsonObject(VERTX_WORKER_QUEUE_SIZE);
        }
        return jsonObject != null ? jsonObject.getInteger("count") : -1;
    }

    public int getVertWorkerQueueSize() {
        return StatsCollector.getVertWorkerQueueSizeStatic();
    }

    private static int getWebRTCVertxWorkerQueueSizeStatic() {
        io.vertx.core.json.JsonObject queueSizeMetrics = webRTCVertxMetrics.getMetricsSnapshot(VERTX_WORKER_QUEUE_SIZE);
        io.vertx.core.json.JsonObject jsonObject = null;
        if (queueSizeMetrics != null) {
            jsonObject = queueSizeMetrics.getJsonObject(VERTX_WORKER_QUEUE_SIZE);
        }
        return jsonObject != null ? jsonObject.getInteger("count") : -1;
    }

    public int getWebRTCVertxWorkerQueueSize() {
        return StatsCollector.getWebRTCVertxWorkerQueueSizeStatic();
    }

    private void sendWebRTCClientStats() {
        this.getVertx().executeBlocking(b -> {
            this.collectAndSendWebRTCClientsStats();
            b.complete();
        }, null);
    }

    public void collectAndSendWebRTCClientsStats() {
        for (IScope scope : this.scopes) {
            if (!scope.getContext().getApplicationContext().containsBean("webrtc.adaptor")) continue;
            IWebRTCAdaptor webrtcAdaptor = (IWebRTCAdaptor)scope.getContext().getApplicationContext().getBean("webrtc.adaptor");
            Set<String> streams = webrtcAdaptor.getStreams();
            for (String streamId : streams) {
                List<WebRTCClientStats> webRTCClientStats = webrtcAdaptor.getWebRTCClientStats(streamId);
                this.sendWebRTCClientStats2Kafka(webRTCClientStats, streamId);
            }
        }
    }

    public void sendWebRTCClientStats2Kafka(List<WebRTCClientStats> webRTCClientStatList, String streamId) {
        String dateTime = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
        for (WebRTCClientStats webRTCClientStat : webRTCClientStatList) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(STREAM_ID, streamId);
            jsonObject.addProperty(WEBRTC_CLIENT_ID, (Number)webRTCClientStat.getClientId());
            jsonObject.addProperty(AUDIO_FRAME_SEND_PERIOD, (Number)((int)webRTCClientStat.getAudioFrameSendPeriod()));
            jsonObject.addProperty(VIDEO_FRAME_SEND_PERIOD, (Number)((int)webRTCClientStat.getVideoFrameSendPeriod()));
            jsonObject.addProperty(MEASURED_BITRATE, (Number)webRTCClientStat.getMeasuredBitrate());
            jsonObject.addProperty(SEND_BITRATE, (Number)webRTCClientStat.getSendBitrate());
            jsonObject.addProperty(TIME, dateTime);
            jsonObject.addProperty(HOST_ADDRESS, this.hostAddress);
            jsonObject.addProperty(WEBRTC_VIEWER_INFO, webRTCClientStat.getClientInfo());
            jsonObject.addProperty(IP_ADDRESS, webRTCClientStat.getClientIp());
            this.send2Kafka((JsonElement)jsonObject, WEBRTC_STATS_TOPIC_NAME);
        }
    }

    public Producer<Long, String> createKafkaProducer() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.kafkaBrokers);
        props.put("client.id", Launcher.getInstanceId());
        props.put("key.serializer", LongSerializer.class.getName());
        props.put("value.serializer", StringSerializer.class.getName());
        props.put("max.block.ms", (Object)10000);
        return new KafkaProducer(props);
    }

    public static JsonObject getFileSystemInfoJSObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(USABLE_SPACE, (Number)SystemUtils.osHDUsableSpace(null));
        jsonObject.addProperty(TOTAL_SPACE, (Number)SystemUtils.osHDTotalSpace(null));
        jsonObject.addProperty(FREE_SPACE, (Number)SystemUtils.osHDFreeSpace(null));
        jsonObject.addProperty(IN_USE_SPACE, (Number)SystemUtils.osHDInUseSpace(null));
        return jsonObject;
    }

    public static JsonObject getGPUInfoJSObject(int deviceIndex, GPUUtils gpuUtils) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(GPU_DEVICE_INDEX, (Number)deviceIndex);
        jsonObject.addProperty(GPU_UTILIZATION, (Number)gpuUtils.getGPUUtilization(deviceIndex));
        jsonObject.addProperty(GPU_MEMORY_UTILIZATION, (Number)gpuUtils.getMemoryUtilization(deviceIndex));
        GPUUtils.MemoryStatus memoryStatus = gpuUtils.getMemoryStatus(deviceIndex);
        jsonObject.addProperty(GPU_MEMORY_TOTAL, (Number)memoryStatus.getMemoryTotal());
        jsonObject.addProperty(GPU_MEMORY_FREE, (Number)memoryStatus.getMemoryFree());
        jsonObject.addProperty(GPU_MEMORY_USED, (Number)memoryStatus.getMemoryUsed());
        jsonObject.addProperty(GPU_DEVICE_NAME, GPUUtils.getInstance().getDeviceName(deviceIndex));
        return jsonObject;
    }

    public static JsonArray getGPUInfoJSObject() {
        int deviceCount = GPUUtils.getInstance().getDeviceCount();
        JsonArray jsonArray = new JsonArray();
        if (deviceCount > 0) {
            for (int i = 0; i < deviceCount; ++i) {
                jsonArray.add((JsonElement)StatsCollector.getGPUInfoJSObject(i, GPUUtils.getInstance()));
            }
        }
        return jsonArray;
    }

    public static JsonObject getCPUInfoJSObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(PROCESS_CPU_TIME, (Number)SystemUtils.getProcessCpuTime());
        jsonObject.addProperty(SYSTEM_CPU_LOAD, (Number)SystemUtils.getSystemCpuLoad());
        jsonObject.addProperty(PROCESS_CPU_LOAD, (Number)SystemUtils.getProcessCpuLoad());
        return jsonObject;
    }

    public static ThreadInfo[] getThreadDump() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        return threadMXBean.dumpAllThreads(true, true);
    }

    public static JsonArray getThreadDumpJSON() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadDump = threadMXBean.dumpAllThreads(true, true);
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < threadDump.length; ++i) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(THREAD_NAME, threadDump[i].getThreadName());
            jsonObject.addProperty(THREAD_ID, (Number)threadDump[i].getThreadId());
            jsonObject.addProperty(THREAD_BLOCKED_TIME, (Number)threadDump[i].getBlockedTime());
            jsonObject.addProperty(THREAD_BLOCKED_COUNT, (Number)threadDump[i].getBlockedCount());
            jsonObject.addProperty(THREAD_WAITED_TIME, (Number)threadDump[i].getWaitedTime());
            jsonObject.addProperty(THREAD_WAITED_COUNT, (Number)threadDump[i].getWaitedCount());
            jsonObject.addProperty(THREAD_LOCK_NAME, threadDump[i].getLockName());
            jsonObject.addProperty(THREAD_LOCK_OWNER_ID, (Number)threadDump[i].getLockOwnerId());
            jsonObject.addProperty(THREAD_LOCK_OWNER_NAME, threadDump[i].getLockOwnerName());
            jsonObject.addProperty(THREAD_IN_NATIVE, Boolean.valueOf(threadDump[i].isInNative()));
            jsonObject.addProperty(THREAD_SUSPENDED, Boolean.valueOf(threadDump[i].isSuspended()));
            jsonObject.addProperty(THREAD_STATE, threadDump[i].getThreadState().toString());
            jsonObject.addProperty(THREAD_CPU_TIME, (Number)threadMXBean.getThreadCpuTime(threadDump[i].getThreadId()));
            jsonObject.addProperty(THREAD_USER_TIME, (Number)threadMXBean.getThreadUserTime(threadDump[i].getThreadId()));
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }

    private static JsonArray getDeadLockedThreads(long[] deadLockedThreads) {
        JsonArray jsonArray = new JsonArray();
        if (deadLockedThreads != null) {
            for (int i = 0; i < deadLockedThreads.length; ++i) {
                jsonArray.add((Number)deadLockedThreads[i]);
            }
        }
        return jsonArray;
    }

    public static JsonObject getThreadInfoJSONObject() {
        JsonObject jsonObject = new JsonObject();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        jsonObject.add(DEAD_LOCKED_THREAD, (JsonElement)StatsCollector.getDeadLockedThreads(threadMXBean.findDeadlockedThreads()));
        jsonObject.addProperty(THREAD_COUNT, (Number)threadMXBean.getThreadCount());
        jsonObject.addProperty(THREAD_PEEK_COUNT, (Number)threadMXBean.getPeakThreadCount());
        return jsonObject;
    }

    public static JsonObject getJVMMemoryInfoJSObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("maxMemory", (Number)SystemUtils.jvmMaxMemory());
        jsonObject.addProperty(TOTAL_MEMORY, (Number)SystemUtils.jvmTotalMemory());
        jsonObject.addProperty(FREE_MEMORY, (Number)SystemUtils.jvmFreeMemory());
        jsonObject.addProperty("inUseMemory", (Number)SystemUtils.jvmInUseMemory());
        return jsonObject;
    }

    public static JsonObject getSystemInfoJSObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(OS_NAME, SystemUtils.osName);
        jsonObject.addProperty(OS_ARCH, SystemUtils.osArch);
        jsonObject.addProperty(JAVA_VERSION, SystemUtils.jvmVersion);
        jsonObject.addProperty(PROCESSOR_COUNT, (Number)SystemUtils.osProcessorX);
        return jsonObject;
    }

    public static JsonObject getSysteMemoryInfoJSObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(VIRTUAL_MEMORY, (Number)SystemUtils.osCommittedVirtualMemory());
        jsonObject.addProperty(TOTAL_MEMORY, (Number)SystemUtils.osTotalPhysicalMemory());
        jsonObject.addProperty(FREE_MEMORY, (Number)SystemUtils.osFreePhysicalMemory());
        jsonObject.addProperty("inUseMemory", (Number)SystemUtils.osInUsePhysicalMemory());
        try {
            jsonObject.addProperty(TOTAL_SWAP_SPACE, (Number)SystemUtils.osTotalSwapSpace());
            jsonObject.addProperty(FREE_SWAP_SPACE, (Number)SystemUtils.osFreeSwapSpace());
            jsonObject.addProperty(IN_USE_SWAP_SPACE, (Number)SystemUtils.osInUseSwapSpace());
        }
        catch (Exception e) {
            logger.error("swap memory statistic can not be read");
        }
        jsonObject.addProperty(AVAILABLE_MEMORY, (Number)SystemUtils.osAvailableMemory());
        return jsonObject;
    }

    public static JsonObject getJVMNativeMemoryInfoJSObject() {
        JsonObject jsonObject = new JsonObject();
        long maxPhysicalBytes = Pointer.maxPhysicalBytes();
        long inUsephysicalBytes = Pointer.physicalBytes();
        jsonObject.addProperty("inUseMemory", (Number)inUsephysicalBytes);
        jsonObject.addProperty("maxMemory", (Number)maxPhysicalBytes);
        return jsonObject;
    }

    public static JsonObject getServerTime() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(UP_TIME, (Number)ManagementFactory.getRuntimeMXBean().getUptime());
        jsonObject.addProperty(START_TIME, (Number)ManagementFactory.getRuntimeMXBean().getStartTime());
        return jsonObject;
    }

    public static AdminApplication getAdminAppAdaptor(ApplicationContext appContext) {
        Object appHandler;
        AdminApplication adaptor = null;
        if (appContext.containsBean("web.handler") && (appHandler = appContext.getBean("web.handler")) instanceof AdminApplication) {
            adaptor = (AdminApplication)appHandler;
        }
        return adaptor;
    }

    public static AntMediaApplicationAdapter getAppAdaptor(ApplicationContext appContext) {
        Object appHandler;
        AntMediaApplicationAdapter adaptor = null;
        if (appContext.containsBean("web.handler") && (appHandler = appContext.getBean("web.handler")) instanceof AntMediaApplicationAdapter) {
            adaptor = (AntMediaApplicationAdapter)appHandler;
        }
        return adaptor;
    }

    public static JsonObject getSystemResourcesInfo(Queue<IScope> scopes) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(INSTANCE_ID, Launcher.getInstanceId());
        jsonObject.add(CPU_USAGE, (JsonElement)StatsCollector.getCPUInfoJSObject());
        jsonObject.add(JVM_MEMORY_USAGE, (JsonElement)StatsCollector.getJVMMemoryInfoJSObject());
        jsonObject.add(SYSTEM_INFO, (JsonElement)StatsCollector.getSystemInfoJSObject());
        jsonObject.add(SYSTEM_MEMORY_INFO, (JsonElement)StatsCollector.getSysteMemoryInfoJSObject());
        jsonObject.add(FILE_SYSTEM_INFO, (JsonElement)StatsCollector.getFileSystemInfoJSObject());
        jsonObject.add(JVM_NATIVE_MEMORY_USAGE, (JsonElement)StatsCollector.getJVMNativeMemoryInfoJSObject());
        jsonObject.add(GPU_USAGE_INFO, (JsonElement)StatsCollector.getGPUInfoJSObject());
        jsonObject.addProperty(FFMPEG_BUILD_INFO, FFmpegUtilities.getBuildConfiguration());
        int localHlsViewers = 0;
        int localDashViewers = 0;
        int localWebRTCViewers = 0;
        int localWebRTCStreams = 0;
        int localStreams = 0;
        int encodersBlocked = 0;
        int encodersNotOpened = 0;
        int publishTimeoutError = 0;
        if (scopes != null) {
            for (IScope scope : scopes) {
                localHlsViewers += StatsCollector.getHLSViewers(scope);
                localDashViewers += StatsCollector.getDASHViewers(scope);
                if (scope.getContext().getApplicationContext().containsBean("webrtc.adaptor")) {
                    IWebRTCAdaptor webrtcAdaptor = (IWebRTCAdaptor)scope.getContext().getApplicationContext().getBean("webrtc.adaptor");
                    localWebRTCStreams += webrtcAdaptor.getNumberOfLiveStreams();
                    localWebRTCViewers += webrtcAdaptor.getNumberOfTotalViewers();
                }
                AntMediaApplicationAdapter adaptor = null;
                adaptor = StatsCollector.getAppAdaptor(scope.getContext().getApplicationContext());
                if (adaptor == null) continue;
                encodersBlocked += adaptor.getNumberOfEncodersBlocked();
                encodersNotOpened += adaptor.getNumberOfEncoderNotOpenedErrors();
                publishTimeoutError += adaptor.getNumberOfPublishTimeoutError();
                localStreams += adaptor.getMuxAdaptors().size();
            }
        }
        jsonObject.addProperty(LOCAL_WEBRTC_LIVE_STREAMS, (Number)localWebRTCStreams);
        jsonObject.addProperty(LOCAL_LIVE_STREAMS, (Number)localStreams);
        jsonObject.addProperty(LOCAL_WEBRTC_VIEWERS, (Number)localWebRTCViewers);
        jsonObject.addProperty(LOCAL_HLS_VIEWERS, (Number)localHlsViewers);
        jsonObject.addProperty(LOCAL_DASH_VIEWERS, (Number)localDashViewers);
        jsonObject.addProperty(ENCODERS_BLOCKED, (Number)encodersBlocked);
        jsonObject.addProperty(ENCODERS_NOT_OPENED, (Number)encodersNotOpened);
        jsonObject.addProperty(PUBLISH_TIMEOUT_ERRORS, (Number)publishTimeoutError);
        jsonObject.addProperty(VERTX_WORKER_THREAD_QUEUE_SIZE, (Number)StatsCollector.getVertWorkerQueueSizeStatic());
        jsonObject.addProperty(WEBRTC_VERTX_WORKER_THREAD_QUEUE_SIZE, (Number)StatsCollector.getWebRTCVertxWorkerQueueSizeStatic());
        jsonObject.add(SERVER_TIMING, (JsonElement)StatsCollector.getServerTime());
        return jsonObject;
    }

    private static int getHLSViewers(IScope scope) {
        if (scope.getContext().getApplicationContext().containsBean("hls.viewerstats")) {
            HlsViewerStats hlsViewerStats = (HlsViewerStats)scope.getContext().getApplicationContext().getBean("hls.viewerstats");
            return hlsViewerStats.getTotalViewerCount();
        }
        return 0;
    }

    private static int getDASHViewers(IScope scope) {
        if (scope.getContext().getApplicationContext().containsBean("dash.viewerstats")) {
            DashViewerStats dashViewerStats = (DashViewerStats)scope.getContext().getApplicationContext().getBean("dash.viewerstats");
            return dashViewerStats.getTotalViewerCount();
        }
        return 0;
    }

    public void sendInstanceStats(Queue<IScope> scopes) {
        JsonObject jsonObject = StatsCollector.getSystemResourcesInfo(scopes);
        jsonObject.addProperty(TIME, DateTimeFormatter.ISO_INSTANT.format(Instant.now()));
        jsonObject.addProperty(HOST_ADDRESS, this.hostAddress);
        jsonObject.addProperty(IP_ADDRESS, ServerSettings.getGlobalHostAddress());
        this.send2Kafka((JsonElement)jsonObject, INSTANCE_STATS_TOPIC_NAME);
    }

    public void send2Kafka(JsonElement jsonElement, String topicName) {
        ProducerRecord record = new ProducerRecord(topicName, (Object)this.gson.toJson(jsonElement));
        try {
            this.kafkaProducer.send(record).get();
        }
        catch (ExecutionException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InterruptedException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
        }
    }

    public void addCpuMeasurement(int measurment) {
        this.cpuMeasurements.add(measurment);
        if (this.cpuMeasurements.size() > this.windowSize) {
            this.cpuMeasurements.poll();
        }
        int total = 0;
        Iterator iterator = this.cpuMeasurements.iterator();
        while (iterator.hasNext()) {
            int msrmnt = (Integer)iterator.next();
            total += msrmnt;
        }
        this.cpuLoad = total / this.cpuMeasurements.size();
    }

    @Override
    public boolean enoughResource() {
        boolean enoughResource = false;
        if (this.getCpuLoad() < this.getCpuLimit()) {
            int freeRam = this.getFreeRam();
            if (freeRam > this.getMinFreeRamSize() || freeRam == -1) {
                enoughResource = true;
            } else {
                logger.error("Not enough resource. Due to not free RAM. Free RAM should be more than  {} but it is: {}", (Object)this.minFreeRamSize, (Object)this.getFreeRam());
            }
        } else {
            logger.error("Not enough resource. Due to high cpu load: {} cpu limit: {}", (Object)this.cpuLoad, (Object)this.cpuLimit);
        }
        if (!enoughResource && this.webhookURL != null && !this.webhookURL.isEmpty()) {
            logger.info("Setting timer to call high resource usage hook.");
            this.vertx.setTimer(10L, e -> {
                try {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("action", HOOK_HIGH_RESOURCE_USAGE);
                    jsonObject.addProperty("host", this.hostAddress);
                    jsonObject.addProperty("resourceInfo", StatsCollector.getSystemResourcesInfo(this.scopes).toString());
                    this.sendPOST(this.webhookURL, jsonObject);
                }
                catch (Exception ex) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)ex));
                }
            });
        }
        return enoughResource;
    }

    public void sendUnexpectedShutdownHook(List<String> appNames) {
        logger.info("Setting timer to call unexpected server shutdown hook.");
        this.vertx.setTimer(10L, e -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("action", HOOK_HIGH_RESOURCE_USAGE);
            jsonObject.addProperty("host", this.hostAddress);
            jsonObject.addProperty("appNames", String.join((CharSequence)",", appNames));
            try {
                this.sendPOST(this.webhookURL, jsonObject);
            }
            catch (Exception ex) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)ex));
            }
        });
    }

    public int sendPOST(String url, JsonObject json) throws IOException {
        int statusCode = -1;
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(2000).setSocketTimeout(2000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            httpPost.setEntity((HttpEntity)new StringEntity(json.toString()));
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
                logger.info("POST Response Status:: {}", (Object)httpResponse.getStatusLine().getStatusCode());
                statusCode = httpResponse.getStatusLine().getStatusCode();
            }
        }
        return statusCode;
    }

    @Override
    public int getFreeRam() {
        long availableMemory = SystemUtils.osAvailableMemory();
        if (availableMemory != 0L) {
            return (int)SystemUtils.convertByteSize(availableMemory, "MB");
        }
        return -1;
    }

    @Override
    public int getMinFreeRamSize() {
        return this.minFreeRamSize;
    }

    public void setMinFreeRamSize(int ramLimit) {
        this.minFreeRamSize = ramLimit;
    }

    public void setCpuLoad(int cpuLoad) {
        this.cpuLoad = cpuLoad;
    }

    @Override
    public int getCpuLoad() {
        return this.cpuLoad;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
        vertXMetrics = MetricsService.create((Vertx)vertx);
    }

    public void setWebRTCVertx(Vertx webRTCVertx) {
        this.webRTCVertx = webRTCVertx;
        webRTCVertxMetrics = MetricsService.create((Vertx)webRTCVertx);
    }

    public void setCpuLimit(int cpuLimit) {
        this.cpuLimit = cpuLimit > 100 ? 100 : (cpuLimit < 10 ? 10 : cpuLimit);
    }

    @Override
    public int getCpuLimit() {
        return this.cpuLimit;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        IServer server = (IServer)applicationContext.getBean("red5.server");
        server.addListener(new IScopeListener(){

            @Override
            public void notifyScopeRemoved(IScope scope) {
                StatsCollector.this.scopes.remove(scope);
            }

            @Override
            public void notifyScopeCreated(IScope scope) {
                StatsCollector.this.scopes.add(scope);
            }
        });
        ServerSettings serverSettings = (ServerSettings)applicationContext.getBean("ant.media.server.settings");
        this.heartBeatEnabled = serverSettings.isHeartbeatEnabled();
        this.hostAddress = serverSettings.getHostAddress();
        this.measurementPeriod = serverSettings.getCpuMeasurementPeriodMs();
        this.windowSize = serverSettings.getCpuMeasurementWindowSize();
        this.marketplace = serverSettings.getMarketplace();
        this.webhookURL = serverSettings.getServerStatusWebHookURL();
        this.licenseService = (ILicenceService)applicationContext.getBean(ILicenceService.BeanName.LICENCE_SERVICE.toString());
        this.setVertx((Vertx)applicationContext.getBean("vertxCore"));
        this.setWebRTCVertx((Vertx)applicationContext.getBean("webRTCVertx"));
    }

    public int getStaticSendPeriod() {
        return this.staticSendPeriod;
    }

    public void setStaticSendPeriod(int staticSendPeriod) {
        this.staticSendPeriod = staticSendPeriod;
    }

    public void setKafkaProducer(Producer<Long, String> kafkaProducer) {
        this.kafkaProducer = kafkaProducer;
    }

    public String getKafkaBrokers() {
        return this.kafkaBrokers;
    }

    public void setKafkaBrokers(String kafkaBrokers) {
        this.kafkaBrokers = kafkaBrokers;
    }

    public void setScopes(Queue<IScope> scopes) {
        this.scopes = scopes;
    }

    public void cancelHeartBeat() {
        this.vertx.cancelTimer(this.hearbeatPeriodicTask);
    }

    public boolean isHeartBeatEnabled() {
        return this.heartBeatEnabled;
    }

    public void setHeartBeatEnabled(boolean heartBeatEnabled) {
        this.heartBeatEnabled = heartBeatEnabled;
    }

    public int getHeartbeatPeriodMs() {
        return this.heartbeatPeriodMs;
    }

    public void setHeartbeatPeriodMs(int heartbeatPeriodMs) {
        this.heartbeatPeriodMs = heartbeatPeriodMs;
    }

    public void destroy() throws Exception {
        if (logger != null) {
            logger.info("Shutting down stats collector ");
        }
        if (this.heartBeatEnabled && logger != null) {
            logger.info("Ending analytic session");
        }
        this.vertx.close();
        this.webRTCVertx.close();
        if (logger != null) {
            logger.info("Closing vertx ");
        }
    }

    public int getMeasurementPeriod() {
        return this.measurementPeriod;
    }

    public void startAnalytic() {
        String instanceId = Launcher.getInstanceId();
        String version = Launcher.getVersion();
        String type = Launcher.getVersionType();
        JsonObject instance = new JsonObject();
        instance.addProperty(INSTANCE_ID, instanceId);
        instance.addProperty(INSTANCE_TYPE, type);
        instance.addProperty(INSTANCE_VERSION, version);
        instance.addProperty(MARKETPLACE_NAME, this.marketplace);
        instance.addProperty(USER_EMAIL, this.getUserEmail());
        if (RestServiceBase.isEnterprise()) {
            Licence lastLicenseStatus = this.licenseService.getLastLicenseStatus();
            String status = "invalid";
            if (lastLicenseStatus != null) {
                status = lastLicenseStatus.getStatus();
            }
            instance.addProperty(LICENSE_VALID, status);
        }
        try (CloseableHttpClient client = this.getHttpClient();){
            HttpRequestBase post = (HttpRequestBase)RequestBuilder.post().setUri("https://us-central1-ant-media-server-analytics.cloudfunctions.net/sendHeartbeat").setHeader("Content-Type", "application/json").setEntity((HttpEntity)new StringEntity(instance.toString())).build();
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(5000).build();
            post.setConfig(requestConfig);
            client.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            logger.error("Couldn't connect Ant Media Server Analytics");
        }
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserEmail() {
        if (this.userEmail == null) {
            for (IScope scope : this.scopes) {
                AdminApplication adaptor = null;
                adaptor = StatsCollector.getAdminAppAdaptor(scope.getContext().getApplicationContext());
                if (adaptor == null) continue;
                AbstractConsoleDataStore dataStore = adaptor.getDataStoreFactory().getDataStore();
                List<User> userList = dataStore.getUserList();
                this.userEmail = this.findAdminUser(userList);
                break;
            }
        }
        return this.userEmail;
    }

    private String findAdminUser(List<User> userList) {
        String email = null;
        for (User user : userList) {
            if (user.getUserType() != UserType.ADMIN || !"system".equals(user.getScope())) continue;
            email = user.getEmail();
            break;
        }
        return email;
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
    }

    public long getUnexpectedShutDownDelayMs() {
        return this.unexpectedShutDownDelayMs;
    }

    public void setUnexpectedShutDownDelayMs(long unexpectedShutDownDelayMs) {
        this.unexpectedShutDownDelayMs = unexpectedShutDownDelayMs;
    }

    public void setWebhookURL(String webhookURL) {
        this.webhookURL = webhookURL;
    }
}

