/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationDebugger {
    private static AllocationDebugger instance = new AllocationDebugger();
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ConcurrentMap<BaseEvent, Info> events = new ConcurrentHashMap<BaseEvent, Info>();

    public static AllocationDebugger getInstance() {
        return instance;
    }

    private AllocationDebugger() {
    }

    protected void create(BaseEvent event) {
        this.events.put(event, new Info());
    }

    protected void retain(BaseEvent event) {
        Info info = (Info)this.events.get(event);
        if (info != null) {
            info.refcount.incrementAndGet();
        } else {
            this.log.warn("Retain called on already released event.");
        }
    }

    protected void release(BaseEvent event) {
        Info info = (Info)this.events.get(event);
        if (info != null) {
            if (info.refcount.decrementAndGet() == 0) {
                this.events.remove(event);
            }
        } else {
            this.log.warn("Release called on already released event.");
        }
    }

    public synchronized void dump() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("dumping allocations {}", (Object)this.events.size());
            for (Map.Entry entry : this.events.entrySet()) {
                this.log.debug("{} {}", entry.getKey(), (Object)((Info)entry.getValue()).refcount);
            }
        }
    }

    private static class Info {
        public AtomicInteger refcount = new AtomicInteger(1);
    }
}

