/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia;

import io.antmedia.AppSettings;
import io.antmedia.EncoderSettings;
import io.antmedia.cluster.IClusterNotifier;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.datastore.preference.PreferenceStore;
import io.antmedia.filter.StreamAcceptFilter;
import io.antmedia.ipcamera.OnvifCamera;
import io.antmedia.muxer.IAntMediaStreamHandler;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.muxer.Muxer;
import io.antmedia.plugin.api.IClusterStreamFetcher;
import io.antmedia.plugin.api.IFrameListener;
import io.antmedia.plugin.api.IPacketListener;
import io.antmedia.plugin.api.IStreamListener;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.model.Result;
import io.antmedia.security.AcceptOnlyStreamsInDataStore;
import io.antmedia.settings.ServerSettings;
import io.antmedia.shutdown.AMSShutdownManager;
import io.antmedia.shutdown.IShutdownListener;
import io.antmedia.statistic.DashViewerStats;
import io.antmedia.statistic.HlsViewerStats;
import io.antmedia.statistic.type.RTMPToWebRTCStats;
import io.antmedia.statistic.type.WebRTCAudioReceiveStats;
import io.antmedia.statistic.type.WebRTCAudioSendStats;
import io.antmedia.statistic.type.WebRTCVideoReceiveStats;
import io.antmedia.statistic.type.WebRTCVideoSendStats;
import io.antmedia.storage.StorageClient;
import io.antmedia.streamsource.StreamFetcher;
import io.antmedia.streamsource.StreamFetcherManager;
import io.antmedia.track.ISubtrackPoller;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.antmedia.webrtc.api.IWebRTCClient;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.dropwizard.MetricsService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.validation.constraints.NotNull;
import net.sf.ehcache.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONObject;
import org.red5.server.adapter.MultiThreadedApplicationAdapter;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.red5.server.api.stream.ISubscriberStream;
import org.red5.server.stream.ClientBroadcastStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntMediaApplicationAdapter
extends MultiThreadedApplicationAdapter
implements IAntMediaStreamHandler,
IShutdownListener {
    public static final String BEAN_NAME = "web.handler";
    public static final int BROADCAST_STATS_RESET = 0;
    public static final String HOOK_ACTION_END_LIVE_STREAM = "liveStreamEnded";
    public static final String HOOK_ACTION_START_LIVE_STREAM = "liveStreamStarted";
    public static final String HOOK_ACTION_VOD_READY = "vodReady";
    public static final String HOOK_ACTION_PUBLISH_TIMEOUT_ERROR = "publishTimeoutError";
    public static final String HOOK_ACTION_ENCODER_NOT_OPENED_ERROR = "encoderNotOpenedError";
    public static final String HOOK_ACTION_ENDPOINT_FAILED = "endpointFailed";
    public static final String STREAMS = "streams";
    public static final String DEFAULT_LOCALHOST = "127.0.0.1";
    protected static Logger logger = LoggerFactory.getLogger(AntMediaApplicationAdapter.class);
    private ServerSettings serverSettings;
    public static final String VOD = "VoD";
    public static final String LIVE_STREAM = "liveStream";
    public static final String IP_CAMERA = "ipCamera";
    public static final String STREAM_SOURCE = "streamSource";
    public static final String PLAY_LIST = "playlist";
    protected static final int END_POINT_LIMIT = 20;
    public static final String WEBAPPS_PATH = "webapps/";
    private static final String VOD_IMPORT_ALLOWED_DIRECTORY = "/";
    private List<IStreamPublishSecurity> streamPublishSecurityList;
    private Map<String, OnvifCamera> onvifCameraList = new ConcurrentHashMap();
    protected StreamFetcherManager streamFetcherManager;
    protected Map<String, MuxAdaptor> muxAdaptors = new ConcurrentHashMap();
    private DataStore dataStore;
    private DataStoreFactory dataStoreFactory;
    private StreamAcceptFilter streamAcceptFilter;
    private AppSettings appSettings;
    private Vertx vertx;
    protected List<String> encoderBlockedStreams = new ArrayList<String>();
    private int numberOfEncoderNotOpenedErrors = 0;
    protected int publishTimeoutStreams = 0;
    private List<String> publishTimeoutStreamsList = new ArrayList<String>();
    private boolean shutdownProperly = true;
    protected WebRTCVideoReceiveStats webRTCVideoReceiveStats = new WebRTCVideoReceiveStats();
    protected WebRTCAudioReceiveStats webRTCAudioReceiveStats = new WebRTCAudioReceiveStats();
    protected WebRTCVideoSendStats webRTCVideoSendStats = new WebRTCVideoSendStats();
    protected WebRTCAudioSendStats webRTCAudioSendStats = new WebRTCAudioSendStats();
    private IClusterNotifier clusterNotifier;
    protected boolean serverShuttingDown = false;
    protected StorageClient storageClient;
    protected Queue<IStreamListener> streamListeners = new ConcurrentLinkedQueue<IStreamListener>();
    IClusterStreamFetcher clusterStreamFetcher;
    protected ISubtrackPoller subtrackPoller;

    @Override
    public boolean appStart(IScope app) {
        this.setScope(app);
        for (IStreamPublishSecurity streamPublishSecurity : this.getStreamPublishSecurityList()) {
            this.registerStreamPublishSecurity(streamPublishSecurity);
        }
        this.getVertx();
        this.getDataStore();
        Result result = this.createInitializationProcess(app.getName());
        this.storageClient = (StorageClient)app.getContext().getBean("app.storageClient");
        if (!result.isSuccess()) {
            this.shutdownProperly = false;
            this.resetBroadcasts();
        }
        if (app.getContext().hasBean("tomcat.cluster")) {
            this.clusterNotifier = (IClusterNotifier)app.getContext().getBean("tomcat.cluster");
            logger.info("Registering settings listener to the cluster notifier for app: {}", (Object)app.getName());
            this.clusterNotifier.registerSettingUpdateListener(this.getAppSettings().getAppName(), settings -> this.updateSettings(settings, false, true));
            AppSettings storedSettings = this.clusterNotifier.getClusterStore().getSettings(app.getName());
            boolean updateClusterSettings = false;
            if (storedSettings == null) {
                logger.warn("There is not a stored settings for the app:{}. It will update the database for app settings", (Object)app.getName());
                storedSettings = this.appSettings;
                updateClusterSettings = true;
            } else if (this.getServerSettings().getHostAddress().equals(storedSettings.getWarFileOriginServerAddress()) && storedSettings.isPullWarFile()) {
                logger.info("This instance is the host of the app:{} to be deployed to the cluster", (Object)app.getName());
                boolean isPullWarFile = storedSettings.isPullWarFile();
                storedSettings = this.appSettings;
                updateClusterSettings = true;
                storedSettings.setPullWarFile(isPullWarFile);
                storedSettings.setWarFileOriginServerAddress(this.getServerSettings().getHostAddress());
            }
            logger.info("Updating settings while app({}) is being started. AppSettings will be saved to Cluster db? Answer -> {}", (Object)app.getName(), (Object)(updateClusterSettings ? "yes" : "no"));
            this.updateSettings(storedSettings, updateClusterSettings, false);
        }
        this.vertx.setTimer(10L, l -> {
            this.getStreamFetcherManager();
            if (this.appSettings.isStartStreamFetcherAutomatically()) {
                List<Broadcast> streams = this.getDataStore().getExternalStreamsList();
                logger.info("Stream source size: {}", (Object)streams.size());
                this.streamFetcherManager.startStreams(streams);
            }
            this.synchUserVoDFolder(null, this.appSettings.getVodFolder());
        });
        AMSShutdownManager.getInstance().subscribe(this);
        if (app.getContext().hasBean("webrtc.adaptor")) {
            IWebRTCAdaptor webRTCAdaptor = (IWebRTCAdaptor)app.getContext().getBean("webrtc.adaptor");
            webRTCAdaptor.setExcessiveBandwidthValue(this.appSettings.getExcessiveBandwidthValue());
            webRTCAdaptor.setExcessiveBandwidthCallThreshold(this.appSettings.getExcessiveBandwidthCallThreshold());
            webRTCAdaptor.setTryCountBeforeSwitchback(this.appSettings.getExcessiveBandwithTryCountBeforeSwitchback());
            webRTCAdaptor.setExcessiveBandwidthAlgorithmEnabled(this.appSettings.isExcessiveBandwidthAlgorithmEnabled());
            webRTCAdaptor.setPacketLossDiffThresholdForSwitchback(this.appSettings.getPacketLossDiffThresholdForSwitchback());
            webRTCAdaptor.setRttMeasurementDiffThresholdForSwitchback(this.appSettings.getRttMeasurementDiffThresholdForSwitchback());
        }
        this.setStorageclientSettings(this.appSettings);
        logger.info("{} started", (Object)app.getName());
        return true;
    }

    public Result resetBroadcasts() {
        logger.info("Resetting streams viewer numbers because there is an unexpected stop happened in app: {}", (Object)(this.getScope() != null ? this.getScope().getName() : "[scope is null]"));
        int operationCount = this.getDataStore().resetBroadcasts(this.getServerSettings().getHostAddress());
        logger.info("Resetting subscriber connection status");
        this.getDataStore().resetSubscribersConnectedStatus();
        Result result = new Result(true);
        result.setMessage("Successfull operations: " + operationCount);
        return result;
    }

    public boolean synchUserVoDFolder(String oldFolderPath, String vodFolderPath) {
        boolean result = false;
        File streamsFolder = new File(WEBAPPS_PATH + this.getScope().getName() + "/streams");
        if (oldFolderPath != null && !oldFolderPath.equals("")) {
            this.deleteSymbolicLink(new File(oldFolderPath), streamsFolder);
        }
        if (vodFolderPath != null && !vodFolderPath.equals("")) {
            File f = new File(vodFolderPath);
            this.createSymbolicLink(streamsFolder, f);
            this.getDataStore().fetchUserVodList(f);
            result = true;
        }
        return result;
    }

    public Result createSymbolicLink(File streamsFolder, File vodFolder) {
        Result result = null;
        try {
            if (!streamsFolder.exists()) {
                streamsFolder.mkdirs();
            }
            if (vodFolder.exists() && vodFolder.isDirectory()) {
                File newLinkFile = new File(streamsFolder, vodFolder.getName());
                if (!Files.isSymbolicLink(newLinkFile.toPath())) {
                    Path target = vodFolder.toPath();
                    Files.createSymbolicLink(newLinkFile.toPath(), target, new FileAttribute[0]);
                    result = new Result(true);
                } else {
                    result = new Result(false, "There is already a file with the name " + vodFolder.getName() + " in the streams directory");
                }
            } else {
                result = new Result(false, vodFolder.getAbsolutePath() + " does not exist or is not a directory");
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            result = new Result(false, "Exception in creating symbolic link");
        }
        return result;
    }

    public Result importVoDFolder(String vodFolderPath) {
        File streamsFolder = new File(WEBAPPS_PATH + this.getScope().getName() + "/streams");
        File directory = new File(vodFolderPath == null ? "" : vodFolderPath);
        File allowedDirectory = new File(VOD_IMPORT_ALLOWED_DIRECTORY);
        Result result = null;
        try {
            if (FileUtils.directoryContains((File)allowedDirectory, (File)directory)) {
                result = this.createSymbolicLink(streamsFolder, directory);
                if (result.isSuccess()) {
                    int numberOfFilesImported = this.importToDB(directory, directory);
                    result.setMessage(numberOfFilesImported + " files are imported");
                }
            } else {
                result = new Result(false, "VoD import directory is allowed under /");
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            result = new Result(false, "VoD import directory is allowed under /");
        }
        return result;
    }

    public Result unlinksVoD(String directory) {
        File folder = new File(directory == null ? "" : directory);
        Result result = null;
        if (folder.exists() && folder.isDirectory()) {
            File streamsFolder = new File(WEBAPPS_PATH + this.getScope().getName() + "/streams");
            this.deleteSymbolicLink(folder, streamsFolder);
            int deletedRecords = this.deleteUserVoDByStreamId(folder.getName());
            result = new Result(true, deletedRecords + " of records are deleted");
        } else {
            result = new Result(false, directory + " does not exist or it's not a directory");
        }
        return result;
    }

    private int deleteUserVoDByStreamId(String streamId) {
        List<VoD> vodList;
        int numberOfDeletedRecords = 0;
        do {
            if ((vodList = this.getDataStore().getVodList(0, 50, null, null, streamId, null)) == null || vodList.isEmpty()) continue;
            for (VoD voD : vodList) {
                if (!"userVod".equals(voD.getType()) || !this.getDataStore().deleteVod(voD.getVodId())) continue;
                ++numberOfDeletedRecords;
            }
        } while (vodList != null && !vodList.isEmpty());
        return numberOfDeletedRecords;
    }

    public int importToDB(File subDirectory, File baseDirectory) {
        File[] listOfFiles = subDirectory.listFiles();
        int numberOfFilesImported = 0;
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                String fileExtension = FilenameUtils.getExtension((String)file.getName());
                if (file.isFile() && ("mp4".equals(fileExtension) || "flv".equals(fileExtension) || "mkv".equals(fileExtension) || "m3u8".equals(fileExtension))) {
                    long fileSize = file.length();
                    long unixTime = System.currentTimeMillis();
                    String relativePath = STREAMS + File.separator + subDirectory.getAbsolutePath().substring(baseDirectory.getAbsolutePath().length() - baseDirectory.getName().length()) + File.separator + file.getName();
                    String vodId = RandomStringUtils.randomNumeric((int)24);
                    VoD newVod = new VoD(baseDirectory.getName(), baseDirectory.getName(), relativePath, file.getName(), unixTime, 0L, Muxer.getDurationInMs(file, null), fileSize, "userVod", vodId, null);
                    if (this.getDataStore().addVod(newVod) == null) continue;
                    ++numberOfFilesImported;
                    continue;
                }
                if (!file.isDirectory()) continue;
                numberOfFilesImported += this.importToDB(file, baseDirectory);
            }
        }
        return numberOfFilesImported;
    }

    public boolean deleteSymbolicLink(File vodDirectory, File streamsFolder) {
        boolean result = false;
        try {
            if (vodDirectory != null && streamsFolder != null) {
                File linkFile = new File(streamsFolder.getAbsolutePath(), vodDirectory.getName());
                if (!streamsFolder.getAbsolutePath().equals(linkFile.getAbsolutePath()) && Files.isSymbolicLink(linkFile.toPath())) {
                    Files.delete(linkFile.toPath());
                    result = true;
                }
            }
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return result;
    }

    public String getListenerHookURL(@NotNull Broadcast broadcast) {
        String listenerHookURL = broadcast.getListenerHookURL();
        if (listenerHookURL == null || listenerHookURL.isEmpty()) {
            listenerHookURL = this.getAppSettings().getListenerHookURL();
        }
        return listenerHookURL;
    }

    public void closeBroadcast(String streamId) {
        try {
            logger.info("Closing broadcast stream id: {}", (Object)streamId);
            this.getDataStore().updateStatus(streamId, "finished");
            Broadcast broadcast = this.getDataStore().get(streamId);
            if (broadcast != null) {
                String listenerHookURL = this.getListenerHookURL(broadcast);
                if (listenerHookURL != null && !listenerHookURL.isEmpty()) {
                    String name = broadcast.getName();
                    String category = broadcast.getCategory();
                    String metaData = broadcast.getMetaData();
                    logger.info("Setting timer to call live stream ended hook for stream:{}", (Object)streamId);
                    this.vertx.runOnContext(e -> this.notifyHook(listenerHookURL, streamId, HOOK_ACTION_END_LIVE_STREAM, name, category, null, null, metaData));
                }
                if (broadcast.isZombi()) {
                    if (broadcast.getMainTrackStreamId() != null && !broadcast.getMainTrackStreamId().isEmpty()) {
                        this.updateMainBroadcast(broadcast);
                    }
                    logger.info("Deleting streamId:{} because it's a zombi stream", (Object)streamId);
                    this.getDataStore().delete(streamId);
                } else {
                    this.resetHLSStats(streamId);
                    this.resetDASHStats(streamId);
                }
                for (IStreamListener listener : this.streamListeners) {
                    listener.streamFinished(broadcast.getStreamId());
                }
                logger.info("Leaving closeBroadcast for streamId:{}", (Object)streamId);
            }
        }
        catch (Exception e2) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e2));
        }
    }

    public synchronized void updateMainBroadcast(Broadcast broadcast) {
        Broadcast mainBroadcast = this.getDataStore().get(broadcast.getMainTrackStreamId());
        mainBroadcast.getSubTrackStreamIds().remove(broadcast.getStreamId());
        if (mainBroadcast.getSubTrackStreamIds().isEmpty() && mainBroadcast.isZombi()) {
            this.getDataStore().delete(mainBroadcast.getStreamId());
        } else {
            this.getDataStore().updateBroadcastFields(mainBroadcast.getStreamId(), mainBroadcast);
        }
    }

    public void resetHLSStats(String streamId) {
        if (this.scope.getContext().getApplicationContext().containsBean("hls.viewerstats")) {
            HlsViewerStats hlsViewerStats = (HlsViewerStats)this.scope.getContext().getApplicationContext().getBean("hls.viewerstats");
            hlsViewerStats.resetViewerMap(streamId, "hls");
        }
    }

    public void resetDASHStats(String streamId) {
        if (this.scope.getContext().getApplicationContext().containsBean("dash.viewerstats")) {
            DashViewerStats dashViewerStats = (DashViewerStats)this.scope.getContext().getApplicationContext().getBean("dash.viewerstats");
            dashViewerStats.resetViewerMap(streamId, "dash");
        }
    }

    @Override
    public void streamPlayItemPlay(ISubscriberStream stream, IPlayItem item, boolean isLive) {
        this.vertx.setTimer(1L, l -> this.getDataStore().updateRtmpViewerCount(item.getName(), true));
    }

    @Override
    public void streamPlayItemStop(ISubscriberStream stream, IPlayItem item) {
        this.vertx.setTimer(1L, l -> this.getDataStore().updateRtmpViewerCount(item.getName(), false));
    }

    @Override
    public void streamSubscriberClose(ISubscriberStream stream) {
        this.vertx.setTimer(1L, l -> this.getDataStore().updateRtmpViewerCount(stream.getBroadcastStreamPublishName(), false));
    }

    @Override
    public void startPublish(String streamId, long absoluteStartTimeMs, String publishType) {
        this.vertx.executeBlocking(() -> {
            try {
                Broadcast broadcast = this.updateBroadcastStatus(streamId, absoluteStartTimeMs, publishType, this.getDataStore().get(streamId));
                String listenerHookURL = this.getListenerHookURL(broadcast);
                if (listenerHookURL != null && !listenerHookURL.isEmpty()) {
                    String name = broadcast.getName();
                    String category = broadcast.getCategory();
                    String metaData = broadcast.getMetaData();
                    logger.info("Setting timer to call live stream started hook for stream:{}", (Object)streamId);
                    this.vertx.setTimer(10L, e -> this.notifyHook(listenerHookURL, streamId, HOOK_ACTION_START_LIVE_STREAM, name, category, null, null, metaData));
                }
                int ingestingStreamLimit = this.appSettings.getIngestingStreamLimit();
                long activeBroadcastNumber = this.dataStore.getActiveBroadcastCount();
                if (ingestingStreamLimit != -1 && activeBroadcastNumber > (long)ingestingStreamLimit) {
                    logger.info("Active broadcast count({}) is more than ingesting stream limit:{} so stopping broadcast:{}", new Object[]{activeBroadcastNumber, ingestingStreamLimit, broadcast.getStreamId()});
                    this.stopStreaming(broadcast);
                }
                for (IStreamListener listener : this.streamListeners) {
                    listener.streamStarted(broadcast.getStreamId());
                }
            }
            catch (Exception e2) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e2));
            }
            return null;
        });
        if (absoluteStartTimeMs == 0L) {
            this.vertx.setTimer(2000L, h -> {
                IBroadcastStream broadcastStream = this.getBroadcastStream(this.getScope(), streamId);
                if (broadcastStream instanceof ClientBroadcastStream) {
                    long absoluteStarTime = ((ClientBroadcastStream)broadcastStream).getAbsoluteStartTimeMs();
                    if (absoluteStarTime != 0L) {
                        Broadcast broadcast = this.getDataStore().get(streamId);
                        if (broadcast != null) {
                            broadcast.setAbsoluteStartTimeMs(absoluteStarTime);
                            this.getDataStore().save(broadcast);
                            logger.info("Updating broadcast absolute time {} ms for stream:{}", (Object)absoluteStarTime, (Object)streamId);
                        } else {
                            logger.info("Broadcast is not available in the database to update the absolute start time for stream:{}", (Object)streamId);
                        }
                    } else {
                        logger.info("Broadcast absolute time is not available for stream:{}", (Object)streamId);
                    }
                }
            });
        }
        logger.info("start publish leaved for stream:{}", (Object)streamId);
    }

    @Override
    public Broadcast updateBroadcastStatus(String streamId, long absoluteStartTimeMs, String publishType, Broadcast broadcast) {
        return this.updateBroadcastStatus(streamId, absoluteStartTimeMs, publishType, broadcast, "broadcasting");
    }

    public Broadcast updateBroadcastStatus(String streamId, long absoluteStartTimeMs, String publishType, Broadcast broadcast, String status) {
        if (broadcast == null) {
            logger.info("Saving zombi broadast to data store with streamId:{}", (Object)streamId);
            broadcast = AntMediaApplicationAdapter.saveUndefinedBroadcast(streamId, null, this, status, absoluteStartTimeMs, publishType, "", "");
        } else {
            broadcast.setStatus(status);
            long now = System.currentTimeMillis();
            broadcast.setStartTime(now);
            broadcast.setUpdateTime(now);
            broadcast.setOriginAdress(this.getServerSettings().getHostAddress());
            broadcast.setWebRTCViewerCount(0);
            broadcast.setHlsViewerCount(0);
            broadcast.setDashViewerCount(0);
            broadcast.setPublishType(publishType);
            boolean result = this.getDataStore().updateBroadcastFields(broadcast.getStreamId(), broadcast);
            logger.info(" Status of stream {} is set to {} with result: {}", new Object[]{broadcast.getStreamId(), status, result});
        }
        return broadcast;
    }

    public ServerSettings getServerSettings() {
        if (this.serverSettings == null) {
            this.serverSettings = (ServerSettings)this.scope.getContext().getApplicationContext().getBean("ant.media.server.settings");
        }
        return this.serverSettings;
    }

    public static Broadcast saveUndefinedBroadcast(String streamId, String streamName, AntMediaApplicationAdapter appAdapter, String streamStatus, long absoluteStartTimeMs, String publishType, String mainTrackStreamId, String metaData) {
        Broadcast newBroadcast = new Broadcast();
        long now = System.currentTimeMillis();
        newBroadcast.setDate(now);
        newBroadcast.setStartTime(now);
        newBroadcast.setUpdateTime(now);
        newBroadcast.setZombi(true);
        newBroadcast.setName(streamName);
        newBroadcast.setMainTrackStreamId(mainTrackStreamId);
        newBroadcast.setMetaData(metaData);
        try {
            newBroadcast.setStreamId(streamId);
            newBroadcast.setPublishType(publishType);
            return RestServiceBase.saveBroadcast(newBroadcast, streamStatus, appAdapter.getScope().getName(), appAdapter.getDataStore(), appAdapter.getAppSettings().getListenerHookURL(), appAdapter.getServerSettings(), absoluteStartTimeMs);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    @Override
    public void muxingFinished(String streamId, File file, long startTime, long duration, int resolution, String previewFilePath, String vodId) {
        String muxerFinishScript;
        int index;
        String vodName = file.getName();
        String filePath = file.getPath();
        long fileSize = file.length();
        long systemTime = System.currentTimeMillis();
        String relativePath = AntMediaApplicationAdapter.getRelativePath(filePath);
        String listenerHookURL = null;
        String streamName = file.getName();
        Broadcast broadcast = this.getDataStore().get(streamId);
        if (broadcast != null) {
            listenerHookURL = broadcast.getListenerHookURL();
            if (broadcast.getName() != null) {
                String string = streamName = resolution != 0 ? broadcast.getName() + " (" + resolution + "p)" : broadcast.getName();
            }
        }
        if (listenerHookURL == null || listenerHookURL.isEmpty()) {
            listenerHookURL = this.appSettings.getListenerHookURL();
        }
        String vodIdFinal = vodId != null ? vodId : RandomStringUtils.randomAlphanumeric((int)24);
        VoD newVod = new VoD(streamName, streamId, relativePath, vodName, systemTime, startTime, duration, fileSize, "streamVod", vodIdFinal, previewFilePath);
        if (this.getDataStore().addVod(newVod) == null) {
            logger.warn("Stream vod with stream id {} cannot be added to data store", (Object)streamId);
        }
        if (listenerHookURL != null && !listenerHookURL.isEmpty() && (index = vodName.lastIndexOf(".mp4")) != -1 || (index = vodName.lastIndexOf(".webm")) != -1) {
            String baseName = vodName.substring(0, index);
            String metaData = broadcast != null ? broadcast.getMetaData() : null;
            String finalListenerHookURL = listenerHookURL;
            logger.info("Setting timer for calling vod ready hook for stream:{}", (Object)streamId);
            this.vertx.runOnContext(e -> this.notifyHook(finalListenerHookURL, streamId, HOOK_ACTION_VOD_READY, null, null, baseName, vodIdFinal, metaData));
        }
        if ((muxerFinishScript = this.appSettings.getMuxerFinishScript()) != null && !muxerFinishScript.isEmpty()) {
            this.runScript(muxerFinishScript + "  " + file.getAbsolutePath());
        }
    }

    public void runScript(String scriptFile) {
        this.vertx.executeBlocking(future -> {
            try {
                logger.info("running muxer finish script: {}", (Object)scriptFile);
                Process exec = Runtime.getRuntime().exec(scriptFile);
                int result = exec.waitFor();
                logger.info("completing script: {} with return value {}", (Object)scriptFile, (Object)result);
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            catch (InterruptedException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
            future.complete();
        }, null);
    }

    public static String getRelativePath(String filePath) {
        StringBuilder relativePath = new StringBuilder();
        String[] subDirs = filePath.split(STREAMS);
        if (subDirs.length == 2) {
            relativePath = new StringBuilder(STREAMS + subDirs[1]);
        } else {
            for (int i = 1; i < subDirs.length; ++i) {
                relativePath.append(STREAMS).append(subDirs[i]);
            }
        }
        return relativePath.toString();
    }

    public StringBuilder notifyHook(String url, String id, String action, String streamName, String category, String vodName, String vodId, String metadata) {
        StringBuilder response = null;
        logger.info("Running notify hook url:{} stream id: {} action:{} vod name:{} vod id:{}", new Object[]{url, id, action, vodName, vodId});
        if (url != null && url.length() > 0) {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("id", id);
            variables.put("action", action);
            if (streamName != null) {
                variables.put("streamName", streamName);
            }
            if (category != null) {
                variables.put("category", category);
            }
            if (vodName != null) {
                variables.put("vodName", vodName);
            }
            if (vodId != null) {
                variables.put("vodId", vodId);
            }
            if (metadata != null) {
                variables.put("metadata", metadata);
            }
            try {
                response = this.sendPOST(url, variables);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return response;
    }

    public StringBuilder sendPOST(String url, Map<String, String> variables) throws IOException {
        StringBuilder response = null;
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(2000).setSocketTimeout(2000).build();
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = variables.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                urlParameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity postParams = new UrlEncodedFormEntity(urlParameters);
            httpPost.setEntity((HttpEntity)postParams);
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
                logger.info("POST Response Status:: {}", (Object)httpResponse.getStatusLine().getStatusCode());
                HttpEntity entity = httpResponse.getEntity();
                if (entity != null) {
                    String inputLine;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
                    response = new StringBuilder();
                    while ((inputLine = reader.readLine()) != null) {
                        response.append(inputLine);
                    }
                    reader.close();
                }
            }
        }
        return response;
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    public List<IStreamPublishSecurity> getStreamPublishSecurityList() {
        return this.streamPublishSecurityList;
    }

    public void setStreamPublishSecurityList(List<IStreamPublishSecurity> streamPublishSecurityList) {
        this.streamPublishSecurityList = streamPublishSecurityList;
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public StreamAcceptFilter getStreamAcceptFilter() {
        return this.streamAcceptFilter;
    }

    public void setStreamAcceptFilter(StreamAcceptFilter streamAcceptFilter) {
        this.streamAcceptFilter = streamAcceptFilter;
    }

    @Override
    public boolean isValidStreamParameters(int width, int height, int fps, int bitrate, String streamId) {
        return this.streamAcceptFilter.isValidStreamParameters(width, height, fps, bitrate, streamId);
    }

    public static final boolean isStreaming(Broadcast broadcast) {
        return System.currentTimeMillis() - broadcast.getUpdateTime() < 10000L && ("broadcasting".equals(broadcast.getStatus()) || "preparing".equals(broadcast.getStatus()));
    }

    public Result startStreaming(Broadcast broadcast) {
        Result result = new Result(false);
        if (broadcast.getType().equals(IP_CAMERA) || broadcast.getType().equals(STREAM_SOURCE) || broadcast.getType().equals(VOD)) {
            result = this.getStreamFetcherManager().startStreaming(broadcast);
        } else if (broadcast.getType().equals(PLAY_LIST)) {
            result = this.getStreamFetcherManager().startPlaylist(broadcast);
        }
        return result;
    }

    public Result stopStreaming(Broadcast broadcast) {
        IBroadcastStream broadcastStream;
        Result result = new Result(false);
        logger.info("stopStreaming is called for stream:{}", (Object)broadcast.getStreamId());
        if (broadcast.getType().equals(IP_CAMERA) || broadcast.getType().equals(STREAM_SOURCE) || broadcast.getType().equals(VOD)) {
            result = this.getStreamFetcherManager().stopStreaming(broadcast.getStreamId());
        } else if (broadcast.getType().equals(PLAY_LIST)) {
            result = this.getStreamFetcherManager().stopPlayList(broadcast.getStreamId());
        } else if (broadcast.getType().equals(LIVE_STREAM) && (broadcastStream = this.getBroadcastStream(this.getScope(), broadcast.getStreamId())) != null) {
            IStreamCapableConnection connection = ((IClientBroadcastStream)broadcastStream).getConnection();
            if (connection != null) {
                connection.close();
            } else {
                logger.warn("Connection is null. It should not happen for stream: {}. Analyze the logs", (Object)broadcast.getStreamId());
            }
            result.setSuccess(true);
        }
        return result;
    }

    public OnvifCamera getOnvifCamera(String id) {
        Broadcast camera;
        OnvifCamera onvifCamera = this.onvifCameraList.get(id);
        if (onvifCamera == null && (camera = this.getDataStore().get(id)) != null) {
            onvifCamera = new OnvifCamera();
            onvifCamera.connect(camera.getIpAddr(), camera.getUsername(), camera.getPassword());
            this.onvifCameraList.put(id, onvifCamera);
        }
        return onvifCamera;
    }

    public StreamFetcherManager getStreamFetcherManager() {
        if (this.streamFetcherManager == null) {
            this.streamFetcherManager = new StreamFetcherManager(this.vertx, this.getDataStore(), this.getScope());
        }
        return this.streamFetcherManager;
    }

    public void setStreamFetcherManager(StreamFetcherManager streamFetcherManager) {
        this.streamFetcherManager = streamFetcherManager;
    }

    @Override
    public void setQualityParameters(String id, String quality, double speed, int pendingPacketSize, long updateTimeMs) {
        this.vertx.setTimer(500L, h -> {
            Broadcast broadcastLocal = this.getDataStore().get(id);
            if (broadcastLocal != null) {
                double roundedSpeed = (double)Math.round(speed * 1000.0) / 1000.0;
                logger.debug("update source quality for stream: {} quality:{} speed:{}", new Object[]{id, quality, speed});
                broadcastLocal.setSpeed(roundedSpeed);
                broadcastLocal.setPendingPacketSize(pendingPacketSize);
                broadcastLocal.setUpdateTime(updateTimeMs);
                broadcastLocal.setQuality(quality);
                this.getDataStore().updateBroadcastFields(id, broadcastLocal);
            }
        });
    }

    public DataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.dataStoreFactory.getDataStore();
        }
        return this.dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public DataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRTMPStreams() {
        Collection<MuxAdaptor> adaptors;
        Collection<MuxAdaptor> collection = adaptors = this.getMuxAdaptors();
        synchronized (collection) {
            for (MuxAdaptor adaptor : adaptors) {
                if (!adaptor.getBroadcast().getType().equals(LIVE_STREAM)) continue;
                ClientBroadcastStream broadcastStream = adaptor.getBroadcastStream();
                if (broadcastStream != null) {
                    broadcastStream.stop();
                }
                adaptor.stop(true);
            }
        }
    }

    public void closeStreamFetchers() {
        if (this.streamFetcherManager != null) {
            Map<String, StreamFetcher> fetchers = this.streamFetcherManager.getStreamFetcherList();
            for (StreamFetcher streamFetcher : fetchers.values()) {
                streamFetcher.stopStream();
            }
            fetchers.clear();
        }
    }

    public void waitUntilLiveStreamsStopped() {
        int i = 0;
        int waitPeriod = 1000;
        boolean everythingHasStopped = true;
        while (this.getDataStore().getLocalLiveBroadcastCount(this.getServerSettings().getHostAddress()) > 0L) {
            try {
                if (i > 3) {
                    logger.warn("Waiting for active broadcasts number decrease to zero for app: {}total wait time: {}ms", (Object)this.getScope().getName(), (Object)(i * waitPeriod));
                }
                if (i > 10) {
                    logger.error("Not all live streams're stopped gracefully. It will update the streams' status to finished explicitly");
                    everythingHasStopped = false;
                    break;
                }
                ++i;
                Thread.sleep(waitPeriod);
            }
            catch (InterruptedException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
        }
        if (!everythingHasStopped) {
            List<Broadcast> localLiveBroadcasts = this.getDataStore().getLocalLiveBroadcasts(this.getServerSettings().getHostAddress());
            ArrayList<String> streamIdList = new ArrayList<String>();
            for (Broadcast broadcast : localLiveBroadcasts) {
                broadcast.setStatus("finished");
                broadcast.setPlayListStatus("finished");
                broadcast.setWebRTCViewerCount(0);
                broadcast.setHlsViewerCount(0);
                broadcast.setDashViewerCount(0);
                this.getDataStore().updateBroadcastFields(broadcast.getStreamId(), broadcast);
                streamIdList.add(broadcast.getStreamId());
            }
            if (logger.isWarnEnabled()) {
                logger.warn("Following streams status set to finished explicitly because they're not stopped properly: {}", (Object)String.join((CharSequence)",", streamIdList));
            }
        }
    }

    public void waitUntilThreadsStop() {
        int i = 0;
        int waitPeriod = 1000;
        int activeVertxThreadCount = 0;
        while ((activeVertxThreadCount = this.getActiveVertxThreadCount()) > 0) {
            try {
                if (i > 3) {
                    logger.warn("Waiting for active vertx threads count({}) decrease to zero for app: {} total wait time: {}ms", new Object[]{activeVertxThreadCount, this.getScope().getName(), i * waitPeriod});
                }
                if (i > 10) {
                    logger.error("*********************************************************************");
                    logger.error("Not all active vertx threads are stopped. It's even breaking the loop");
                    logger.error("*********************************************************************");
                    break;
                }
                ++i;
                Thread.sleep(waitPeriod);
            }
            catch (InterruptedException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
        }
    }

    private int getActiveVertxThreadCount() {
        int activeVertexThreadCount = 0;
        try {
            MetricsService metricsService = MetricsService.create((Vertx)this.vertx);
            String activeThreadKey = "vertx.pools.worker.vert.x-worker-thread.in-use";
            JsonObject metrics = metricsService.getMetricsSnapshot(activeThreadKey);
            if (metrics != null) {
                activeVertexThreadCount = metrics.getJsonObject(activeThreadKey).getInteger("count");
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return activeVertexThreadCount;
    }

    @Override
    public void serverShuttingdown() {
        this.stopApplication(false);
    }

    @Override
    public void appStop(IScope app) {
        super.appStop(app);
        logger.info("appStop is being called for {}", (Object)app.getName());
    }

    public void stopApplication(boolean deleteDB) {
        logger.info("{} is closing streams", (Object)this.getScope().getName());
        this.serverShuttingDown = true;
        this.closeStreamFetchers();
        this.closeRTMPStreams();
        this.waitUntilLiveStreamsStopped();
        this.waitUntilThreadsStop();
        this.createShutdownFile(this.getScope().getName());
        this.closeDB(deleteDB);
    }

    public void closeDB(boolean deleteDB) {
        boolean isClusterMode = this.getScope().getContext().hasBean("tomcat.cluster");
        if (deleteDB && isClusterMode) {
            this.getVertx().setTimer(6000L, l -> this.getDataStore().close(deleteDB));
        } else {
            this.getDataStore().close(deleteDB);
        }
    }

    public Result createInitializationProcess(String appName) {
        Result result = new Result(false);
        String initializedFilePath = WEBAPPS_PATH + appName + "/.initialized";
        File initializedFile = new File(initializedFilePath);
        String closedFilePath = WEBAPPS_PATH + appName + "/.closed";
        File closedFile = new File(closedFilePath);
        try {
            if (!initializedFile.exists() && !closedFile.exists()) {
                this.createInitializationFile(appName, result, initializedFile);
            } else if (initializedFile.exists() && closedFile.exists()) {
                Files.delete(closedFile.toPath());
                if (!closedFile.exists()) {
                    result.setMessage("System works, deleted closed file in " + appName);
                    result.setSuccess(true);
                    logger.info("Delete the \".closed\" file in {}", (Object)appName);
                } else {
                    result.setMessage("Delete couldn't closed file in " + appName);
                    result.setSuccess(false);
                    logger.info("Not deleted the \".closed\" file in {}", (Object)appName);
                }
            } else if (initializedFile.exists() && !closedFile.exists()) {
                result.setMessage("Something wrong in " + appName);
                result.setSuccess(false);
                logger.error("Something wrong in {}", (Object)appName);
            } else {
                this.createInitializationFile(appName, result, initializedFile);
                Files.deleteIfExists(closedFile.toPath());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    public void createInitializationFile(String appName, Result result, File initializedFile) throws IOException {
        if (initializedFile.createNewFile()) {
            result.setMessage("Initialized file created in " + appName);
            result.setSuccess(true);
            logger.info("Initialized file is created in {}", (Object)appName);
        } else {
            result.setMessage("Initialized file couldn't create in " + appName);
            result.setSuccess(false);
            logger.info("Initialized file couldn't be created in {}", (Object)appName);
        }
    }

    public void createShutdownFile(String appName) {
        String closedFilePath = WEBAPPS_PATH + appName + "/.closed";
        File closedFile = new File(closedFilePath);
        try {
            if (!closedFile.exists()) {
                if (closedFile.createNewFile()) {
                    logger.info("Closed file created in {}", (Object)appName);
                } else {
                    logger.error("Closed file couldn't create in {}", (Object)appName);
                }
            } else {
                logger.warn("Closed file already exists for app: {}", (Object)appName);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    public boolean isShutdownProperly() {
        return this.shutdownProperly;
    }

    public void setShutdownProperly(boolean shutdownProperly) {
        this.shutdownProperly = shutdownProperly;
    }

    @Override
    public void muxAdaptorAdded(MuxAdaptor muxAdaptor) {
        this.muxAdaptors.put(muxAdaptor.getStreamId(), muxAdaptor);
    }

    @Override
    public void muxAdaptorRemoved(MuxAdaptor muxAdaptor) {
        this.muxAdaptors.remove(muxAdaptor.getStreamId());
    }

    @Override
    public MuxAdaptor getMuxAdaptor(String streamId) {
        return this.muxAdaptors.get(streamId);
    }

    public Collection<MuxAdaptor> getMuxAdaptors() {
        return this.muxAdaptors.values();
    }

    public int getNumberOfEncodersBlocked() {
        return this.encoderBlockedStreams.size();
    }

    public synchronized void encoderBlocked(String streamId, boolean blocked) {
        if (blocked) {
            this.encoderBlockedStreams.add(streamId);
        } else {
            this.encoderBlockedStreams.remove(streamId);
        }
    }

    public synchronized void incrementEncoderNotOpenedError(String streamId) {
        String listenerHookURL;
        ++this.numberOfEncoderNotOpenedErrors;
        Broadcast broadcast = this.getDataStore().get(streamId);
        if (broadcast != null && (listenerHookURL = this.getListenerHookURL(broadcast)) != null && listenerHookURL.length() > 0) {
            String name = broadcast.getName();
            String category = broadcast.getCategory();
            String metaData = broadcast.getMetaData();
            logger.info("Setting timer to call encoder not opened error for stream:{}", (Object)streamId);
            this.vertx.runOnContext(e -> this.notifyHook(listenerHookURL, streamId, HOOK_ACTION_ENCODER_NOT_OPENED_ERROR, name, category, null, null, metaData));
        }
    }

    public int getNumberOfEncoderNotOpenedErrors() {
        return this.numberOfEncoderNotOpenedErrors;
    }

    public int getNumberOfPublishTimeoutError() {
        return this.publishTimeoutStreams;
    }

    public synchronized void publishTimeoutError(String streamId, String subscriberId) {
        String listenerHookURL;
        ++this.publishTimeoutStreams;
        this.publishTimeoutStreamsList.add(streamId);
        Broadcast broadcast = this.getDataStore().get(streamId);
        if (broadcast != null && (listenerHookURL = this.getListenerHookURL(broadcast)) != null && listenerHookURL.length() > 0) {
            String name = broadcast.getName();
            String category = broadcast.getCategory();
            logger.info("Setting timer to call hook that means live stream is not started to the publish timeout for stream:{}", (Object)streamId);
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put((Object)"subscriberId", (Object)subscriberId);
            this.vertx.runOnContext(e -> this.notifyHook(listenerHookURL, streamId, HOOK_ACTION_PUBLISH_TIMEOUT_ERROR, name, category, null, null, jsonResponse.toJSONString()));
        }
    }

    public WebRTCAudioReceiveStats getWebRTCAudioReceiveStats() {
        return this.webRTCAudioReceiveStats;
    }

    public WebRTCVideoReceiveStats getWebRTCVideoReceiveStats() {
        return this.webRTCVideoReceiveStats;
    }

    public WebRTCAudioSendStats getWebRTCAudioSendStats() {
        return this.webRTCAudioSendStats;
    }

    public WebRTCVideoSendStats getWebRTCVideoSendStats() {
        return this.webRTCVideoSendStats;
    }

    public Vertx getVertx() {
        if (this.vertx == null) {
            this.vertx = (Vertx)this.getScope().getContext().getBean("vertxCore");
        }
        return this.vertx;
    }

    public synchronized boolean updateSettings(AppSettings newSettings, boolean notifyCluster, boolean checkUpdateTime) {
        boolean result = false;
        if (checkUpdateTime && !this.isIncomingTimeValid(newSettings)) {
            logger.info("Not saving the settings because current appsettings update time({}) is later than incoming settings update time({}) ", (Object)this.appSettings.getUpdateTime(), (Object)newSettings.getUpdateTime());
            return result;
        }
        List<EncoderSettings> encoderSettingsList = newSettings.getEncoderSettings();
        if (!this.isEncoderSettingsValid(encoderSettingsList)) {
            return result;
        }
        newSettings.setEncoderSettings(encoderSettingsList);
        if (newSettings.getHlsListSize() == null || Integer.valueOf(newSettings.getHlsListSize()) < 5) {
            newSettings.setHlsListSize("5");
        }
        if (newSettings.getHlsTime() == null || Integer.valueOf(newSettings.getHlsTime()) < 1) {
            newSettings.setHlsTime("1");
        }
        if (AntMediaApplicationAdapter.updateAppSettingsFile(this.getScope().getName(), newSettings)) {
            AcceptOnlyStreamsInDataStore securityHandler = (AcceptOnlyStreamsInDataStore)this.getScope().getContext().getBean("acceptOnlyStreamsInDataStore");
            securityHandler.setEnabled(newSettings.isAcceptOnlyStreamsInDataStore());
            this.updateAppSettingsBean(this.appSettings, newSettings);
            if (notifyCluster && this.clusterNotifier != null) {
                this.appSettings.setToBeDeleted(newSettings.isToBeDeleted());
                boolean saveSettings = this.clusterNotifier.getClusterStore().saveSettings(this.appSettings);
                logger.info("Saving settings to cluster db -> {} for app: {} and updateTime:{}", new Object[]{saveSettings, this.getScope().getName(), this.appSettings.getUpdateTime()});
            }
            result = true;
        } else {
            logger.warn("Settings cannot be saved for {}", (Object)this.getScope().getName());
        }
        return result;
    }

    private boolean isEncoderSettingsValid(List<EncoderSettings> encoderSettingsList) {
        if (encoderSettingsList != null) {
            for (EncoderSettings encoderSettings : encoderSettingsList) {
                if (encoderSettings.getHeight() > 0) continue;
                logger.error("Unexpected encoder parameter. None of the parameters(height:{}, video bitrate:{}, audio bitrate:{}) can be zero or less", new Object[]{encoderSettings.getHeight(), encoderSettings.getVideoBitrate(), encoderSettings.getAudioBitrate()});
                return false;
            }
        }
        return true;
    }

    public boolean isIncomingTimeValid(AppSettings newSettings) {
        return this.appSettings.getUpdateTime() != 0L && newSettings.getUpdateTime() != 0L && this.appSettings.getUpdateTime() < newSettings.getUpdateTime();
    }

    public void setClusterNotifier(IClusterNotifier clusterNotifier) {
        this.clusterNotifier = clusterNotifier;
    }

    public static boolean updateAppSettingsFile(String appName, AppSettings newAppsettings) {
        Field[] declaredFields;
        PreferenceStore store = new PreferenceStore(WEBAPPS_PATH + appName + "/WEB-INF/red5-web.properties");
        for (Field field : declaredFields = newAppsettings.getClass().getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !field.trySetAccessible()) continue;
            try {
                Object value = field.get(newAppsettings);
                if (value instanceof List) {
                    store.put(field.getName(), AppSettings.encodersList2Str(newAppsettings.getEncoderSettings()));
                } else {
                    store.put(field.getName(), value != null ? String.valueOf(value) : "");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            field.setAccessible(false);
        }
        return store.save();
    }

    public void updateAppSettingsBean(AppSettings appSettings, AppSettings newSettings) {
        Field[] declaredFields;
        for (Field field : declaredFields = appSettings.getClass().getDeclaredFields()) {
            AntMediaApplicationAdapter.setAppSettingsFieldValue(appSettings, newSettings, field);
        }
        appSettings.setUpdateTime(System.currentTimeMillis());
        String oldVodFolder = appSettings.getVodFolder();
        this.synchUserVoDFolder(oldVodFolder, newSettings.getVodFolder());
        this.setStorageclientSettings(newSettings);
        logger.warn("app settings bean updated for {}", (Object)this.getScope().getName());
    }

    public void setStorageclientSettings(AppSettings settings) {
        this.storageClient.setEndpoint(settings.getS3Endpoint());
        this.storageClient.setStorageName(settings.getS3BucketName());
        this.storageClient.setAccessKey(settings.getS3AccessKey());
        this.storageClient.setSecretKey(settings.getS3SecretKey());
        this.storageClient.setRegion(settings.getS3RegionName());
        this.storageClient.setEnabled(settings.isS3RecordingEnabled());
        this.storageClient.setPermission(settings.getS3Permission());
        this.storageClient.setStorageClass(settings.getS3StorageClass());
        this.storageClient.setCacheControl(settings.getS3CacheControl());
        this.storageClient.reset();
    }

    public static boolean setAppSettingsFieldValue(AppSettings appSettings, AppSettings newSettings, Field field) {
        boolean result = false;
        try {
            if (!Modifier.isFinal(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
                if (field.trySetAccessible()) {
                    field.set(appSettings, field.get(newSettings));
                    field.setAccessible(false);
                    result = true;
                } else {
                    logger.warn("Cannot set the value this field: {}", (Object)field.getName());
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return result;
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public RTMPToWebRTCStats getRTMPToWebRTCStats(String streamId) {
        return new RTMPToWebRTCStats(streamId);
    }

    public boolean isDataChannelEnabled() {
        return false;
    }

    public boolean isDataChannelMessagingSupported() {
        return false;
    }

    public boolean sendDataChannelMessage(String streamId, String message) {
        return false;
    }

    public boolean doesWebRTCStreamExist(String streamId) {
        return false;
    }

    @Override
    public boolean addPacketListener(String streamId, IPacketListener listener) {
        boolean isAdded = false;
        MuxAdaptor muxAdaptorsLocal = this.getMuxAdaptor(streamId);
        if (muxAdaptorsLocal != null) {
            muxAdaptorsLocal.addPacketListener(listener);
            logger.info("Packet listener({}) is added to streamId:{}", (Object)listener.getClass().getSimpleName(), (Object)streamId);
            isAdded = true;
        }
        if (!isAdded) {
            logger.info("Stream:{} is not in this server. It's creating cluster stream fetcher to get the stream", (Object)streamId);
            if (this.clusterStreamFetcher == null) {
                this.clusterStreamFetcher = this.createClusterStreamFetcher();
            }
            isAdded = this.clusterStreamFetcher.register(streamId, listener);
        }
        return isAdded;
    }

    public void endpointFailedUpdate(String streamId, String url) {
        String listenerHookURL;
        Broadcast broadcast = this.getDataStore().get(streamId);
        if (broadcast != null && (listenerHookURL = this.getListenerHookURL(broadcast)) != null && listenerHookURL.length() > 0) {
            String name = broadcast.getName();
            String category = broadcast.getCategory();
            logger.info("Setting timer to call rtmp endpoint failed hook for stream:{}", (Object)streamId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"rtmp-url", (Object)url);
            this.vertx.runOnContext(e -> this.notifyHook(listenerHookURL, streamId, HOOK_ACTION_ENDPOINT_FAILED, name, category, null, null, jsonObject.toJSONString()));
        }
    }

    @Override
    public boolean removePacketListener(String streamId, IPacketListener listener) {
        boolean isRemoved = false;
        MuxAdaptor muxAdaptorsLocal = this.getMuxAdaptor(streamId);
        if (muxAdaptorsLocal != null) {
            isRemoved = muxAdaptorsLocal.removePacketListener(listener);
        }
        if (!isRemoved) {
            if (this.clusterStreamFetcher != null) {
                isRemoved = this.clusterStreamFetcher.remove(streamId, listener);
            } else {
                logger.warn("Cluster stream fetcher is null so that packet listener cannot be removed for streamId:{}", (Object)streamId);
            }
        }
        if (isRemoved) {
            logger.info("Packet listener is removed succesfully from adaptor for streamId:{}", (Object)streamId);
        } else {
            logger.warn("Packet listener cannot be removed from adaptor for streamId:{}", (Object)streamId);
        }
        return isRemoved;
    }

    @Override
    public void addFrameListener(String streamId, IFrameListener listener) {
    }

    @Override
    public IFrameListener createCustomBroadcast(String streamId) {
        throw new IllegalStateException("This method is not implemented in Community Edition");
    }

    @Override
    public void stopCustomBroadcast(String streamId) {
    }

    @Override
    public void removeFrameListener(String streamId, IFrameListener listener) {
    }

    @Override
    public boolean isServerShuttingDown() {
        return this.serverShuttingDown;
    }

    public void setStorageClient(StorageClient storageClient) {
        this.storageClient = storageClient;
    }

    public StorageClient getStorageClient() {
        return this.storageClient;
    }

    @Override
    public void addStreamListener(IStreamListener listener) {
        this.streamListeners.add(listener);
    }

    @Override
    public void removeStreamListener(IStreamListener listener) {
        this.streamListeners.remove(listener);
    }

    public boolean stopPlaying(String viewerId) {
        return false;
    }

    public boolean stopPlayingBySubscriberId(String subscriberId) {
        return false;
    }

    public boolean stopPublishingBySubscriberId(String subscriberId) {
        return false;
    }

    @Override
    public void stopPublish(String streamId) {
        this.vertx.executeBlocking(handler -> this.closeBroadcast(streamId), null);
    }

    public void joinedTheRoom(String roomId, String streamId) {
    }

    public void leftTheRoom(String roomId, String streamId) {
    }

    public IClusterStreamFetcher createClusterStreamFetcher() {
        return null;
    }

    public Map<String, Queue<IWebRTCClient>> getWebRTCClientsMap() {
        return Collections.emptyMap();
    }

    public ISubtrackPoller getSubtrackPoller() {
        return this.subtrackPoller;
    }

    public void setSubtrackPoller(ISubtrackPoller subtrackPoller) {
        this.subtrackPoller = subtrackPoller;
    }
}

