/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import io.antmedia.EncoderSettings;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.catalina.util.NetMask;
import org.apache.commons.lang3.RandomStringUtils;
import org.bson.types.ObjectId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;

@Entity(value="AppSettings")
@Indexes(value={@Index(fields={@Field(value="appName")})})
@PropertySource(value={"/WEB-INF/red5-web.properties"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class AppSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    @Id
    private ObjectId dbId;
    public static final String PROPERTIES_FILE_PATH = "/WEB-INF/red5-web.properties";
    public static final String BEAN_NAME = "app.settings";
    private static final String SETTINGS_ENCODING_SPECIFIC = "settings.encoding.specific";
    private static final String SETTINGS_ADD_DATE_TIME_TO_MP4_FILE_NAME = "settings.addDateTimeToMp4FileName";
    private static final String SETTINGS_HLS_MUXING_ENABLED = "settings.hlsMuxingEnabled";
    private static final String SETTINGS_DASH_MUXING_ENABLED = "settings.dashMuxingEnabled";
    private static final String SETTINGS_DASH_WINDOW_SIZE = "settings.dashWindowSize";
    private static final String SETTINGS_DASH_EXTRA_WINDOW_SIZE = "settings.dashExtraWindowSize";
    private static final String SETTINGS_ENCODER_SETTINGS_STRING = "settings.encoderSettingsString";
    private static final String SETTINGS_HLS_LIST_SIZE = "settings.hlsListSize";
    private static final String SETTINGS_HLS_TIME = "settings.hlsTime";
    private static final String SETTINGS_HLS_HTTP_ENDPOINT = "settings.hlsHttpEndpoint";
    private static final String SETTINGS_DASH_SEG_DURATION = "settings.dashSegDuration";
    private static final String SETTINGS_DASH_FRAGMENT_DURATION = "settings.dashFragmentDuration";
    private static final String SETTINGS_DASH_TARGET_LATENCY = "settings.dashTargetLatency";
    private static final String SETTINGS_WEBRTC_ENABLED = "settings.webRTCEnabled";
    private static final String SETTINGS_USE_ORIGINAL_WEBRTC_ENABLED = "settings.useOriginalWebRTCEnabled";
    private static final String SETTINGS_DELETE_HLS_FILES_ON_ENDED = "settings.deleteHLSFilesOnEnded";
    private static final String SETTINGS_DELETE_DASH_FILES_ON_ENDED = "settings.deleteDASHFilesOnEnded";
    private static final String SETTINGS_LISTENER_HOOK_URL = "settings.listenerHookURL";
    private static final String SETTINGS_ACCEPT_ONLY_STREAMS_IN_DATA_STORE = "settings.acceptOnlyStreamsInDataStore";
    private static final String SETTINGS_TOKEN_CONTROL_ENABLED = "settings.tokenControlEnabled";
    private static final String SETTINGS_PUBLISH_TOKEN_CONTROL_ENABLED = "settings.publishTokenControlEnabled";
    private static final String SETTINGS_PLAY_TOKEN_CONTROL_ENABLED = "settings.playTokenControlEnabled";
    private static final String SETTINGS_TIME_TOKEN_SUBSCRIBER_ONLY = "settings.timeTokenSubscriberOnly";
    private static final String SETTINGS_TIME_TOKEN_PERIOD = "settings.timeTokenPeriod";
    private static final String SETTINGS_HLS_PLAY_LIST_TYPE = "settings.hlsPlayListType";
    private static final String SETTINGS_VOD_FOLDER = "settings.vodFolder";
    private static final String SETTINGS_PREVIEW_OVERWRITE = "settings.previewOverwrite";
    private static final String SETTINGS_STALKER_DB_SERVER = "settings.stalkerDBServer";
    private static final String SETTINGS_STALKER_DB_USER_NAME = "settings.stalkerDBUsername";
    private static final String SETTINGS_STALKER_DB_PASSWORD = "settings.stalkerDBPassword";
    private static final String SETTINGS_OBJECT_DETECTION_ENABLED = "settings.objectDetectionEnabled";
    private static final String SETTINGS_CREATE_PREVIEW_PERIOD = "settings.createPreviewPeriod";
    private static final String SETTINGS_MP4_MUXING_ENABLED = "settings.mp4MuxingEnabled";
    private static final String SETTINGS_WEBM_MUXING_ENABLED = "settings.webMMuxingEnabled";
    private static final String SETTINGS_STREAM_FETCHER_RESTART_PERIOD = "settings.streamFetcherRestartPeriod";
    private static final String SETTINGS_STREAM_FETCHER_AUTO_START = "settings.streamFetcherAutoStart";
    private static final String SETTINGS_MUXER_FINISH_SCRIPT = "settings.muxerFinishScript";
    private static final String SETTINGS_WEBRTC_FRAME_RATE = "settings.webRTCFrameRate";
    private static final String SETTINGS_HASH_CONTROL_PUBLISH_ENABLED = "settings.hashControlPublishEnabled";
    private static final String SETTINGS_HASH_CONTROL_PLAY_ENABLED = "settings.hashControlPlayEnabled";
    private static final String TOKEN_HASH_SECRET = "tokenHashSecret";
    private static final String SETTINGS_WEBRTC_PORT_RANGE_MIN = "settings.webrtc.portRangeMin";
    private static final String SETTINGS_WEBRTC_PORT_RANGE_MAX = "settings.webrtc.portRangeMax";
    private static final String SETTINGS_WEBRTC_STUN_SERVER_URI = "settings.webrtc.stunServerURI";
    private static final String SETTINGS_WEBRTC_TURN_SERVER_USERNAME = "settings.webrtc.turnServerUsername";
    private static final String SETTINGS_WEBRTC_TURN_SERVER_CREDENTIAL = "settings.webrtc.turnServerCredential";
    private static final String SETTINGS_WEBRTC_TCP_CANDIDATE_ENABLED = "settings.webrtc.tcpCandidateEnabled";
    private static final String SETTINGS_WEBRTC_SDP_SEMANTICS = "settings.webrtc.sdpSemantics";
    private static final String SETTINGS_SIGNALING_ENABLED = "signaling.enabled";
    private static final String SETTINGS_SIGNALING_ADDRESS = "signaling.address";
    private static final String SETTINGS_ENCODING_ENCODER_NAME = "settings.encoding.encoderName";
    private static final String SETTINGS_ENCODING_PRESET = "settings.encoding.preset";
    private static final String SETTINGS_ENCODING_PROFILE = "settings.encoding.profile";
    private static final String SETTINGS_ENCODING_LEVEL = "settings.encoding.level";
    private static final String SETTINGS_ENCODING_RC = "settings.encoding.rc";
    private static final String SETTINGS_ENCODING_THREAD_COUNT = "settings.encoding.threadCount";
    private static final String SETTINGS_ENCODING_THREAD_TYPE = "settings.encoding.threadType";
    private static final String SETTINGS_PREVIEW_HEIGHT = "settings.previewHeight";
    private static final String SETTINGS_ENCODING_VP8_THREAD_COUNT = "settings.encoding.vp8.threadCount";
    private static final String SETTINGS_ENCODING_VP8_SPEED = "settings.encoding.vp8.speed";
    private static final String SETTINGS_ENCODING_VP8_DEADLINE = "settings.encoding.vp8.deadline";
    private static final String SETTINGS_GENERATE_PREVIEW = "settings.previewGenerate";
    private static final String SETTINGS_REMOTE_ALLOWED_CIDR = "settings.remoteAllowedCIDR";
    private static final String SETTINGS_WRITE_STATS_TO_DATASTORE = "settings.writeStatsToDatastore";
    private static final String SETTINGS_ENCODER_SELECTION_PREFERENCE = "settings.encoderSelectionPreference";
    private static final String SETTINGS_ALLOWED_PUBLISHER_IPS = "settings.allowedPublisherCIDR";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_THRESHOLD = "settings.excessiveBandwidth.threshold";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_CALL_THRESHOLD = "settings.excessiveBandwidth.call.threshold";
    private static final String SETTINGS_PORT_ALLOCATOR_FLAGS = "settings.portAllocator.flags";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_TRY_COUNT_BEFORE_SWITCH_BACK = "settings.excessiveBandwith.tryCount.beforeSwitchback";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_ENABLED = "settings.excessiveBandwidth_enabled";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_PACKET_LOSS_DIFF_THRESHOLD_FOR_SWITCH_BACK = "settings.excessiveBandwidth.packetLossDiffThreshold.forSwitchback";
    private static final String SETTINGS_EXCESSIVE_BANDWIDTH_RTT_MEASUREMENT_THRESHOLD_FOR_SWITCH_BACK = "settings.excessiveBandwidth.rttMeasurementDiffThreshold.forSwitchback";
    private static final String SETTINGS_REPLACE_CANDIDATE_ADDR_WITH_SERVER_ADDR = "settings.replaceCandidateAddrWithServerAddr";
    public static final String SETTINGS_DB_APP_NAME = "db.app.name";
    private static final String SETTINGS_ENCODING_TIMEOUT = "settings.encoding.timeout";
    private static final String SETTINGS_WEBRTC_CLIENT_START_TIMEOUT = "settings.webrtc.client.start.timeoutMs";
    private static final String SETTINGS_DEFAULT_DECODERS_ENABLED = "settings.defaultDecodersEnabled";
    private static final String SETTINGS_HTTP_FORWARDING_EXTENSION = "settings.httpforwarding.extension";
    private static final String SETTINGS_HTTP_FORWARDING_BASE_URL = "settings.httpforwarding.baseURL";
    private static final String SETTINGS_RTMP_MAX_ANALYZE_DURATION_MS = "settings.rtmp.maxAnalyzeDurationMS";
    private static final String SETTINGS_DISABLE_IPV6_CANDIDATES = "settings.disableIPv6Candidates";
    private static final String SETTINGS_RTSP_PULL_TRANSPORT_TYPE = "settings.rtspPullTransportType";
    private static final String SETTINGS_H264_ENABLED = "settings.h264Enabled";
    private static final String SETTINGS_VP8_ENABLED = "settings.vp8Enabled";
    private static final String SETTINGS_H265_ENABLED = "settings.h265Enabled";
    private static final String SETTINGS_MAX_FPS_ACCEPT = "settings.maxFpsAccept";
    private static final String SETTINGS_DATA_CHANNEL_ENABLED = "settings.dataChannelEnabled";
    private static final String SETTINGS_DATA_CHANNEL_PLAYER_DISTRIBUTION = "settings.dataChannelPlayerDistrubution";
    private static final String SETTINGS_MAX_RESOLUTION_ACCEPT = "settings.maxResolutionAccept";
    private static final String SETTINGS_MAX_BITRATE_ACCEPT = "settings.maxBitrateAccept";
    private static final String SETTINGS_AUDIO_BITRATE_SFU = "settings.audioBitrateSFU";
    private static final String SETTINGS_ENDPOINT_REPUBLISH_LIMIT = "settings.endpoint.republishLimit";
    private static final String SETTINGS_ENDPOINT_HEALTH_CHECK_PERIOD_MS = "settings.endpoint.healthCheckPeriodMs";
    public static final String DATA_CHANNEL_PLAYER_TO_NONE = "none";
    public static final String DATA_CHANNEL_PLAYER_TO_PUBLISHER = "publisher";
    public static final String DATA_CHANNEL_PLAYER_TO_ALL = "all";
    private static final String SETTINGS_HLS_FLAGS = "settings.hlsflags";
    private static final String SETTINGS_UPLOAD_EXTENSIONS_TO_S3 = "settings.uploadExtensionsToS3";
    private static final String SETTINGS_S3_STORAGE_CLASS = "settings.s3StorageClass";
    private static final String SETTINGS_RTSP_TIMEOUT_DURATION_MS = "settings.rtspTimeoutDurationMs";
    private static final String SETTINGS_RTMP_INGEST_BUFFER_TIME_MS = "settings.rtmpIngestBufferTimeMs";
    private static final String SETTINGS_ACCEPT_ONLY_ROOMS_IN_DATA_STORE = "settings.acceptOnlyRoomsInDataStore";
    private static final String SETTINGS_DATA_CHANNEL_WEBHOOK_URL = "settings.dataChannelWebHook";
    public static final String SDP_SEMANTICS_PLAN_B = "planB";
    public static final String SDP_SEMANTICS_UNIFIED_PLAN = "unifiedPlan";
    private static final String SETTINGS_HEIGHT_RTMP_FORWARDING = "settings.heightRtmpForwarding";
    private static final String SETTINGS_AAC_ENCODING_ENABLED = "settings.aacEncodingEnabled";
    private static final String SETTINGS_GOP_SIZE = "settings.gopSize";
    private static final String SETTINGS_CONSTANT_RATE_FACTOR = "settings.constantRateFactor";
    private static final String SETTINGS_WEBRTC_VIEWER_LIMIT = "settings.webRTCViewerLimit";
    private static final String SETTINGS_JWT_SECRET_KEY = "settings.jwtSecretKey";
    private static final String SETTINGS_JWT_CONTROL_ENABLED = "settings.jwtControlEnabled";
    private static final String SETTINGS_IP_FILTER_ENABLED = "settings.ipFilterEnabled";
    private static final String SETTINGS_INGESTING_STREAM_LIMIT = "settings.ingestingStreamLimit";
    private static final String SETTINGS_WEBRTC_KEYFRAME_TIME = "settings.webRTCKeyframeTime";
    private static final String SETTINGS_JWT_STREAM_SECRET_KEY = "settings.jwtStreamSecretKey";
    private static final String SETTINGS_PLAY_JWT_CONTROL_ENABLED = "settings.playJwtControlEnabled";
    private static final String SETTINGS_PUBLISH_JWT_CONTROL_ENABLED = "settings.publishJwtControlEnabled";
    private static final String SETTINGS_DASH_ENABLE_LOW_LATENCY = "settings.dash.llEnabled";
    private static final String SETTINGS_HLS_ENABLE_LOW_LATENCY = "settings.dash.llHlsEnabled";
    private static final String SETTINGS_HLS_ENABLED_VIA_DASH_LOW_LATENCY = "settings.dash.hlsEnabled";
    private static final String SETTINGS_USE_TIMELINE_DASH_MUXING = "settings.dash.useTimeline";
    private static final String SETTINGS_DASH_HTTP_STREAMING = "settings.dash.httpStreaming";
    private static final String SETTINGS_S3_STREAMS_FOLDER_PATH = "settings.s3.streams.folder.path";
    private static final String SETTINGS_S3_PREVIEWS_FOLDER_PATH = "settings.s3.previews.folder.path";
    private static final String SETTINGS_DASH_HTTP_ENDPOINT = "settings.dash.httpEndpoint";
    private static final String SETTINGS_FORCE_DECODING = "settings.forceDecoding";
    private static final String SETTINGS_ADD_ORIGINAL_MUXER_INTO_HLS_PLAYLIST = "settings.addOriginalMuxerIntoHlsPlaylist";
    private static final String SETTINGS_S3_RECORDING_ENABLED = "settings.s3RecordingEnabled";
    private static final String SETTINGS_S3_ACCESS_KEY = "settings.s3AccessKey";
    private static final String SETTINGS_S3_SECRET_KEY = "settings.s3SecretKey";
    private static final String SETTINGS_S3_REGION_NAME = "settings.s3RegionName";
    private static final String SETTINGS_S3_BUCKET_NAME = "settings.s3BucketName";
    private static final String SETTINGS_S3_ENDPOINT = "settings.s3Endpoint";
    private static final String SETTINGS_S3_PERMISSION = "settings.s3Permission";
    private static final String SETTINGS_S3_CACHE_CONTROL = "settings.s3CacheControl";
    private static final String SETTINGS_ENABLE_TIME_TOKEN_PLAY = "settings.enableTimeTokenForPlay";
    private static final String SETTINGS_ENABLE_TIME_TOKEN_PUBLISH = "settings.enableTimeTokenForPublish";
    private static final String SETTINGS_HLS_ENCRYPTION_KEY_INFO_FILE = "settings.hlsEncryptionKeyInfoFile";
    private static final String SETTINGS_JWKS_URL = "settings.jwksURL";
    private static final String SETTINGS_WEBHOOK_AUTHENTICATE_URL = "settings.webhookAuthenticateURL";
    private static final String SETTINGS_FORCE_ASPECT_RATIO_IN_TRANSCODING = "settings.forceAspectRationInTranscoding";
    private static final String SETTINGS_VOD_UPLOAD_FINISH_SCRIPT = "settings.vodUploadFinishScript";
    private static final String SETTINGS_FILE_NAME_FORMAT = "settings.fileNameFormat";
    private static final String SETTINGS_CONTENT_SECURITY_POLICY_HEADER_VALUE = "settings.contentSecurityPolicyHeaderValue";
    private static final String SETTINGS_MAX_AUDIO_TRACK_COUNT = "settings.maxAudioTrackCount";
    private static final String SETTINGS_MAX_VIDEO_TRACK_COUNT = "settings.maxVideoTrackCount";
    private static final String SETTINGS_RTMP_PLAYBACK_ENABLED = "settings.rtmpPlaybackEnabled";
    private static final String SETTINGS_ORIGIN_EDGE_CONNECTION_IDLE_TIMEOUT = "settings.originEdgeIdleTimeout";
    private static final String SETTINGS_ADD_DATE_TIME_TO_HLS_FILE_NAME = "settings.addDateTimeToHlsFileName";
    private static final String SETTINGS_PLAY_WEBRTC_STREAM_ONCE_FOR_EACH_SESSION = "settings.playWebRTCStreamOnceForEachSession";
    private static final String SETTINGS_STATS_BASED_ABR_ALGORITHM_ENABLED = "settings.statsBasedABREnabled";
    private static final String SETTINGS_ABR_DOWN_SCALE_PACKET_LOST_RATIO = "settings.abrDownScalePacketLostRatio";
    private static final String SETTINGS_ABR_UP_SCALE_PACKET_LOST_RATIO = "settings.abrUpScalePacketLostRatio";
    private static final String SETTINGS_ABR_UP_SCALE_RTT_MS = "settings.abrUpScaleRTTMs";
    private static final String SETTINGS_ABR_UP_SCALE_JITTER_MS = "settings.abrUpScaleJitterMs";
    private static final String SETTINGS_CLUSTER_COMMUNICATION_KEY = "settings.clusterCommunicationKey";
    @Value(value="${remoteAllowedCIDR:${settings.remoteAllowedCIDR:127.0.0.1}}")
    private String remoteAllowedCIDR = "127.0.0.1";
    @Value(value="${mp4MuxingEnabled:${settings.mp4MuxingEnabled:false}}")
    private boolean mp4MuxingEnabled;
    @Value(value="${webMMuxingEnabled:${settings.webMMuxingEnabled:false}}")
    private boolean webMMuxingEnabled;
    @Value(value="${addDateTimeToMp4FileName:${settings.addDateTimeToMp4FileName:false}}")
    private boolean addDateTimeToMp4FileName;
    @Value(value="${fileNameFormat:${settings.fileNameFormat:%r%b}}")
    private String fileNameFormat = "%r%b";
    @Value(value="${hlsMuxingEnabled:${settings.hlsMuxingEnabled:true}}")
    private boolean hlsMuxingEnabled = true;
    @Value(value="${encoderSettingsString:${settings.encoderSettingsString:}}")
    private String encoderSettingsString = "";
    @Value(value="${signalingEnabled:${signaling.enabled:false}}")
    private boolean signalingEnabled = false;
    @Value(value="${signalingAddress:${signaling.address:}}")
    private String signalingAddress = "";
    @Value(value="${hlsListSize:${settings.hlsListSize:5}}")
    private String hlsListSize = "5";
    @Value(value="${hlsTime:${settings.hlsTime:2}}")
    private String hlsTime = "2";
    @Value(value="${uploadExtensionsToS3:${settings.uploadExtensionsToS3:7}}")
    private int uploadExtensionsToS3 = 7;
    @Value(value="${s3StorageClass:${settings.s3StorageClass:STANDARD}}")
    private String s3StorageClass = "STANDARD";
    @Value(value="${endpointHealthCheckPeriodMs:${settings.endpoint.healthCheckPeriodMs:2000}}")
    private int endpointHealthCheckPeriodMs = 2000;
    @Value(value="${endpointRepublishLimit:${settings.endpoint.republishLimit:3}}")
    private int endpointRepublishLimit = 3;
    @Value(value="${dashSegDuration:${settings.dashSegDuration:6}}")
    private String dashSegDuration = "6";
    @Value(value="${dashFragmentDuration:${settings.dashFragmentDuration:0.5}}")
    private String dashFragmentDuration = "0.5";
    @Value(value="${dashTargetLatency:${settings.dashTargetLatency:3.5}}")
    private String targetLatency = "3.5";
    @Value(value="${dashWindowSize:${settings.dashWindowSize:5}}")
    private String dashWindowSize = "5";
    @Value(value="${dashExtraWindowSize:${settings.dashExtraWindowSize:5}}")
    private String dashExtraWindowSize = "5";
    @Value(value="${dashEnableLowLatency:${settings.dash.llEnabled:true}}")
    private boolean lLDashEnabled = true;
    @Value(value="${hlsEnableLowLatency:${settings.dash.llHlsEnabled:false}}")
    private boolean lLHLSEnabled = false;
    @Value(value="${hlsEnabledViaDash:${settings.dash.hlsEnabled:false}}")
    private boolean hlsEnabledViaDash = false;
    @Value(value="${useTimelineDashMuxing:${settings.dash.useTimeline:false}}")
    private boolean useTimelineDashMuxing = false;
    @Value(value="${webRTCEnabled:${settings.webRTCEnabled:true}}")
    private boolean webRTCEnabled = true;
    @Value(value="${useOriginalWebRTCEnabled:${settings.useOriginalWebRTCEnabled:false}}")
    private boolean useOriginalWebRTCEnabled = false;
    @Value(value="${deleteHLSFilesOnEnded:${settings.deleteHLSFilesOnEnded:true}}")
    private boolean deleteHLSFilesOnEnded = true;
    @Value(value="${deleteDASHFilesOnEnded:${settings.deleteDASHFilesOnEnded:true}}")
    private boolean deleteDASHFilesOnEnded = true;
    @Value(value="${tokenHashSecret:${tokenHashSecret:}}")
    private String tokenHashSecret = "";
    @Value(value="${hashControlPublishEnabled:${settings.hashControlPublishEnabled:false}}")
    private boolean hashControlPublishEnabled;
    @Value(value="${hashControlPlayEnabled:${settings.hashControlPlayEnabled:false}}")
    private boolean hashControlPlayEnabled;
    @Value(value="${listenerHookURL:${settings.listenerHookURL:}}")
    private String listenerHookURL = "";
    @Value(value="${acceptOnlyStreamsInDataStore:${settings.acceptOnlyStreamsInDataStore:false}}")
    private boolean acceptOnlyStreamsInDataStore;
    @Value(value="${acceptOnlyRoomsInDataStore:${settings.acceptOnlyRoomsInDataStore:false}}")
    private boolean acceptOnlyRoomsInDataStore;
    @Value(value="${publishTokenControlEnabled:${settings.publishTokenControlEnabled:false}}")
    private boolean publishTokenControlEnabled;
    @Value(value="${playTokenControlEnabled:${settings.playTokenControlEnabled:false}}")
    private boolean playTokenControlEnabled;
    @Value(value="${timeTokenSubscriberOnly:${settings.timeTokenSubscriberOnly:false}}")
    private boolean timeTokenSubscriberOnly;
    @Value(value="${enableTimeTokenForPlay:${settings.enableTimeTokenForPlay:false}}")
    private boolean enableTimeTokenForPlay;
    @Value(value="${timeTokenSecretForPlay:#{null}}")
    private String timeTokenSecretForPlay;
    @Value(value="${enableTimeTokenForPublish:${settings.enableTimeTokenForPublish:false}}")
    private boolean enableTimeTokenForPublish;
    @Value(value="${timeTokenSecretForPublish:#{null}}")
    private String timeTokenSecretForPublish;
    @Value(value="${timeTokenPeriod:${settings.timeTokenPeriod:60}}")
    private int timeTokenPeriod = 60;
    @Value(value="${hlsPlayListType:${settings.hlsPlayListType:}}")
    private String hlsPlayListType = "";
    @Value(value="${vodFolder:${settings.vodFolder:}}")
    private String vodFolder = "";
    @Value(value="${previewOverwrite:${settings.previewOverwrite:false}}")
    private boolean previewOverwrite;
    @Value(value="${stalkerDBServer:${settings.stalkerDBServer:}}")
    private String stalkerDBServer = "";
    @Value(value="${stalkerDBUsername:${settings.stalkerDBUsername:}}")
    private String stalkerDBUsername = "";
    @Value(value="${stalkerDBPassword:${settings.stalkerDBPassword:}}")
    private String stalkerDBPassword = "";
    @Value(value="${objectDetectionEnabled:${settings.objectDetectionEnabled:false}}")
    private boolean objectDetectionEnabled;
    @Value(value="${createPreviewPeriod:${settings.createPreviewPeriod:5000}}")
    private int createPreviewPeriod = 5000;
    @Value(value="${restartStreamFetcherPeriod:${settings.streamFetcherRestartPeriod:0}}")
    private int restartStreamFetcherPeriod;
    @Value(value="${streamFetcherAutoStart:${settings.streamFetcherAutoStart:false}}")
    private boolean startStreamFetcherAutomatically;
    @Value(value="${streamFetcherBufferTime:0}")
    private int streamFetcherBufferTime = 0;
    @Value(value="${hlsflags:${settings.hlsflags:delete_segments}}")
    private String hlsflags = "delete_segments";
    private String mySqlClientPath = "/usr/local/antmedia/mysql";
    @Value(value="${muxerFinishScript:${settings.muxerFinishScript:}}")
    private String muxerFinishScript = "";
    @Value(value="${webRTCFrameRate:${settings.webRTCFrameRate:30}}")
    private int webRTCFrameRate = 30;
    @Value(value="${webRTCPortRangeMin:${settings.webrtc.portRangeMin:50000}}")
    private int webRTCPortRangeMin = 50000;
    @Value(value="${webRTCPortRangeMax:${settings.webrtc.portRangeMax:60000}}")
    private int webRTCPortRangeMax = 60000;
    @Value(value="${stunServerURI:${settings.webrtc.stunServerURI:stun:stun1.l.google.com:19302}}")
    private String stunServerURI = "stun:stun1.l.google.com:19302";
    @Value(value="${turnServerUsername:${settings.webrtc.turnServerUsername:}}")
    private String turnServerUsername = "";
    @Value(value="${turnServerCredential:${settings.webrtc.turnServerCredential:}}")
    private String turnServerCredential = "";
    @Value(value="${webRTCTcpCandidatesEnabled:${settings.webrtc.tcpCandidateEnabled:false}}")
    private boolean webRTCTcpCandidatesEnabled;
    @Value(value="${webRTCSdpSemantics:${settings.webrtc.sdpSemantics:unifiedPlan}}")
    private String webRTCSdpSemantics = "unifiedPlan";
    @Value(value="${portAllocatorFlags:${settings.portAllocator.flags:0}}")
    private int portAllocatorFlags;
    @Value(value="${encoderName:${settings.encoding.encoderName:}}")
    private String encoderName = "";
    @Value(value="${encoderPreset:${settings.encoding.preset:}}")
    private String encoderPreset = "";
    @Value(value="${encoderProfile:${settings.encoding.profile:}}")
    private String encoderProfile = "";
    @Value(value="${encoderLevel:${settings.encoding.level:}}")
    private String encoderLevel = "";
    @Value(value="${encoderRc:${settings.encoding.rc:}}")
    private String encoderRc = "";
    @Value(value="${encoderSpecific:${settings.encoding.specific:}}")
    private String encoderSpecific = "";
    @Value(value="${encoderThreadCount:${settings.encoding.threadCount:0}}")
    private int encoderThreadCount;
    @Value(value="${encoderThreadType:${settings.encoding.threadType:0}}")
    private int encoderThreadType;
    @Value(value="${vp8EncoderSpeed:${settings.encoding.vp8.speed:4}}")
    private int vp8EncoderSpeed = 4;
    @Value(value="${vp8EncoderDeadline:${settings.encoding.vp8.deadline:realtime}}")
    private String vp8EncoderDeadline = "realtime";
    @Value(value="${vp8EncoderThreadCount:${settings.encoding.vp8.threadCount:1}}")
    private int vp8EncoderThreadCount = 1;
    @Value(value="${previewHeight:${settings.previewHeight:480}}")
    private int previewHeight = 480;
    @Value(value="${generatePreview:${settings.previewGenerate:false}}")
    private boolean generatePreview;
    @Value(value="${writeStatsToDatastore:${settings.writeStatsToDatastore:true}}")
    private boolean writeStatsToDatastore = true;
    @Value(value="${encoderSelectionPreference:${settings.encoderSelectionPreference:gpu_and_cpu}}")
    private String encoderSelectionPreference = "gpu_and_cpu";
    @Value(value="${allowedPublisherCIDR:${settings.allowedPublisherCIDR:}}")
    private String allowedPublisherCIDR = "";
    @Value(value="${excessiveBandwidthValue:${settings.excessiveBandwidth.threshold:300000}}")
    private int excessiveBandwidthValue = 300000;
    @Value(value="${excessiveBandwidthCallThreshold:${settings.excessiveBandwidth.call.threshold:3}}")
    private int excessiveBandwidthCallThreshold = 3;
    @Value(value="${excessiveBandwithTryCountBeforeSwitchback:${settings.excessiveBandwith.tryCount.beforeSwitchback:4}}")
    private int excessiveBandwithTryCountBeforeSwitchback = 4;
    @Value(value="${excessiveBandwidthAlgorithmEnabled:${settings.excessiveBandwidth_enabled:false}}")
    private boolean excessiveBandwidthAlgorithmEnabled;
    @Value(value="${packetLossDiffThresholdForSwitchback:${settings.excessiveBandwidth.packetLossDiffThreshold.forSwitchback:10}}")
    private int packetLossDiffThresholdForSwitchback = 10;
    @Value(value="${rttMeasurementDiffThresholdForSwitchback:${settings.excessiveBandwidth.rttMeasurementDiffThreshold.forSwitchback:20}}")
    private int rttMeasurementDiffThresholdForSwitchback = 20;
    @Value(value="${replaceCandidateAddrWithServerAddr:${settings.replaceCandidateAddrWithServerAddr:false}}")
    private boolean replaceCandidateAddrWithServerAddr;
    @Value(value="${appName:${db.app.name:}}")
    private String appName = "";
    @Value(value="${encodingTimeout:${settings.encoding.timeout:5000}}")
    private int encodingTimeout = 5000;
    @Value(value="${webRTCClientStartTimeoutMs:${settings.webrtc.client.start.timeoutMs:10000}}")
    private int webRTCClientStartTimeoutMs = 10000;
    @Deprecated
    @Value(value="${defaultDecodersEnabled:${settings.defaultDecodersEnabled:false}}")
    private boolean defaultDecodersEnabled;
    private long updateTime = 0L;
    @Value(value="${httpForwardingExtension:${settings.httpforwarding.extension:}}")
    private String httpForwardingExtension = "";
    @Value(value="${httpForwardingBaseURL:${settings.httpforwarding.baseURL:}}")
    private String httpForwardingBaseURL = "";
    @Value(value="${maxAnalyzeDurationMS:${settings.rtmp.maxAnalyzeDurationMS:1500}}")
    private int maxAnalyzeDurationMS = 1500;
    @Value(value="${disableIPv6Candidates:${settings.disableIPv6Candidates:true}}")
    private boolean disableIPv6Candidates = true;
    @Value(value="${rtspPullTransportType:${settings.rtspPullTransportType:3}}")
    private String rtspPullTransportType = "3";
    @Value(value="${rtspTimeoutDurationMs:${settings.rtspTimeoutDurationMs:5000}}")
    private int rtspTimeoutDurationMs = 5000;
    @Value(value="${maxFpsAccept:${settings.maxFpsAccept:0}}")
    private int maxFpsAccept;
    @Value(value="${maxResolutionAccept:${settings.maxResolutionAccept:0}}")
    private int maxResolutionAccept;
    @Value(value="${maxBitrateAccept:${settings.maxBitrateAccept:0}}")
    private int maxBitrateAccept;
    @Value(value="${h264Enabled:${settings.h264Enabled:true}}")
    private boolean h264Enabled = true;
    @Value(value="${vp8Enabled:${settings.vp8Enabled:false}}")
    private boolean vp8Enabled;
    @Value(value="${h265Enabled:${settings.h265Enabled:false}}")
    private boolean h265Enabled;
    @Value(value="${dataChannelEnabled:${settings.dataChannelEnabled:true}}")
    private boolean dataChannelEnabled = true;
    @Value(value="${dataChannelPlayerDistribution:${settings.dataChannelPlayerDistrubution:all}}")
    private String dataChannelPlayerDistribution = "all";
    @Value(value="${rtmpIngestBufferTimeMs:${settings.rtmpIngestBufferTimeMs:0}}")
    private long rtmpIngestBufferTimeMs;
    @Value(value="${dataChannelWebHookURL:${settings.dataChannelWebHook:}}")
    private String dataChannelWebHookURL = "";
    private String h265EncoderPreset;
    private String h265EncoderProfile;
    private String h265EncoderRc;
    private String h265EncoderSpecific;
    private String h265EncoderLevel;
    @Value(value="${heightRtmpForwarding:${settings.heightRtmpForwarding:360}}")
    private int heightRtmpForwarding = 360;
    @Value(value="${audioBitrateSFU:${settings.audioBitrateSFU:96000}}")
    private int audioBitrateSFU = 96000;
    @Value(value="${dashMuxingEnabled:${settings.dashMuxingEnabled:false}}")
    private boolean dashMuxingEnabled;
    @Value(value="${aacEncodingEnabled:${settings.aacEncodingEnabled:true}}")
    private boolean aacEncodingEnabled = true;
    @Value(value="${gopSize:${settings.gopSize:0}}")
    private int gopSize;
    @Value(value="${constantRateFactor:${settings.constantRateFactor:23}}")
    private String constantRateFactor = "23";
    @Value(value="${webRTCViewerLimit:${settings.webRTCViewerLimit:-1}}")
    private int webRTCViewerLimit = -1;
    private boolean toBeDeleted = false;
    private boolean pullWarFile = false;
    private String warFileOriginServerAddress = "";
    @Value(value="${jwtSecretKey:${settings.jwtSecretKey:}}")
    private String jwtSecretKey = "";
    @Value(value="${jwtControlEnabled:${settings.jwtControlEnabled:false}}")
    private boolean jwtControlEnabled;
    @Value(value="${ipFilterEnabled:${settings.ipFilterEnabled:true}}")
    private boolean ipFilterEnabled = true;
    @Value(value="${ingestingStreamLimit:${settings.ingestingStreamLimit:-1}}")
    private int ingestingStreamLimit = -1;
    @Value(value="${webRTCKeyframeTime:${settings.webRTCKeyframeTime:2000}}")
    private int webRTCKeyframeTime = 2000;
    @Value(value="${jwtStreamSecretKey:${settings.jwtStreamSecretKey:}}")
    private String jwtStreamSecretKey = "";
    @Value(value="${publishJwtControlEnabled:${settings.publishJwtControlEnabled:false}}")
    private boolean publishJwtControlEnabled;
    @Value(value="${playJwtControlEnabled:${settings.playJwtControlEnabled:false}}")
    private boolean playJwtControlEnabled;
    @Value(value="${dashHttpStreaming:${settings.dash.httpStreaming:true}}")
    private boolean dashHttpStreaming = true;
    @Value(value="${s3StreamsFolderPath:${settings.s3.streams.folder.path:streams}}")
    private String s3StreamsFolderPath = "streams";
    @Value(value="${s3PreviewsFolderPath:${settings.s3.previews.folder.path:previews}}")
    private String s3PreviewsFolderPath = "previews";
    @Value(value="${dashHttpEndpoint:${settings.dash.httpEndpoint:}}")
    private String dashHttpEndpoint = "";
    @Value(value="${hlsHttpEndpoint:${settings.hlsHttpEndpoint:}}")
    private String hlsHttpEndpoint = "";
    @Value(value="${forceDecoding:${settings.forceDecoding:false}}")
    private boolean forceDecoding;
    @Value(value="${addOriginalMuxerIntoHLSPlaylist:${settings.addOriginalMuxerIntoHlsPlaylist:true}}")
    private boolean addOriginalMuxerIntoHLSPlaylist = true;
    @Value(value="${s3RecordingEnabled:${settings.s3RecordingEnabled:false}}")
    private boolean s3RecordingEnabled;
    @Value(value="${s3AccessKey:${settings.s3AccessKey:}}")
    private String s3AccessKey = "";
    @Value(value="${s3SecretKey:${settings.s3SecretKey:}}")
    private String s3SecretKey = "";
    @Value(value="${s3BucketName:${settings.s3BucketName:}}")
    private String s3BucketName = "";
    @Value(value="${s3RegionName:${settings.s3RegionName:}}")
    private String s3RegionName = "";
    @Value(value="${s3Endpoint:${settings.s3Endpoint:}}")
    private String s3Endpoint = "";
    @Value(value="${s3CacheControl:${settings.s3CacheControl:no-store, no-cache, must-revalidate, max-age=0}}")
    private String s3CacheControl = "no-store, no-cache, must-revalidate, max-age=0";
    @Value(value="${s3Permission:${settings.s3Permission:public-read}}")
    private String s3Permission = "public-read";
    @Value(value="${hlsEncryptionKeyInfoFile:${settings.hlsEncryptionKeyInfoFile:}}")
    private String hlsEncryptionKeyInfoFile = "";
    @Value(value="${jwksURL:${settings.jwksURL:}}")
    private String jwksURL = "";
    @Value(value="${forceAspectRatioInTranscoding:${settings.forceAspectRationInTranscoding:false}}")
    private boolean forceAspectRatioInTranscoding;
    @Value(value="${webhookAuthenticateURL:${settings.webhookAuthenticateURL:}}")
    private String webhookAuthenticateURL = "";
    @Value(value="${maxAudioTrackCount:${settings.maxAudioTrackCount:-1}}")
    private int maxAudioTrackCount = -1;
    @Value(value="${maxVideoTrackCount:${settings.maxVideoTrackCount:-1}}")
    private int maxVideoTrackCount = -1;
    @Value(value="${vodUploadFinishScript:${settings.vodUploadFinishScript:}}")
    private String vodUploadFinishScript = "";
    @Value(value="${contentSecurityPolicyHeaderValue:${settings.contentSecurityPolicyHeaderValue:}}")
    private String contentSecurityPolicyHeaderValue = "";
    @Value(value="${rtmpPlaybackEnabled:${settings.rtmpPlaybackEnabled:false}}")
    private boolean rtmpPlaybackEnabled = false;
    @Value(value="${originEdgeConnectionIdleTimeout:${settings.originEdgeIdleTimeout:2}}")
    private int originEdgeIdleTimeout = 2;
    @Value(value="${addDateTimeToHlsFileName:${settings.addDateTimeToHlsFileName:false}}")
    private boolean addDateTimeToHlsFileName;
    @Value(value="${playWebRTCStreamOnceForEachSession:${settings.playWebRTCStreamOnceForEachSession:true}}")
    private boolean playWebRTCStreamOnceForEachSession = true;
    @Value(value="${statsBasedABRAlgorithmEnabled:${settings.statsBasedABREnabled:true}}")
    private boolean statsBasedABREnabled = true;
    @Value(value="${abrDownScalePacketLostRatio:${settings.abrDownScalePacketLostRatio:1}}")
    private float abrDownScalePacketLostRatio = 1.0f;
    @Value(value="${abrUpScalePacketLostRatio:${settings.abrUpScalePacketLostRatio:0.1f}}")
    private float abrUpScalePacketLostRatio = 0.1f;
    @Value(value="${abrUpScaleRTTMs:${settings.abrUpScaleRTTMs:150}}")
    private int abrUpScaleRTTMs = 150;
    @Value(value="${abrUpScaleJitterMs:${settings.abrUpScaleJitterMs:30}}")
    private int abrUpScaleJitterMs = 30;
    @Value(value="${clusterCommunicationKey:${settings.clusterCommunicationKey:#{ T(org.apache.commons.lang3.RandomStringUtils).randomAlphanumeric(32)}}}")
    private String clusterCommunicationKey = RandomStringUtils.randomAlphanumeric((int)32);
    @Value(value="${id3TagEnabled:false}")
    private boolean id3TagEnabled = false;
    @Value(value="${sendAudioLevelToViewers:true}")
    private boolean sendAudioLevelToViewers = true;

    public boolean isWriteStatsToDatastore() {
        return this.writeStatsToDatastore;
    }

    public void setWriteStatsToDatastore(boolean writeStatsToDatastore) {
        this.writeStatsToDatastore = writeStatsToDatastore;
    }

    public boolean isAddDateTimeToMp4FileName() {
        return this.addDateTimeToMp4FileName;
    }

    public void setAddDateTimeToMp4FileName(boolean addDateTimeToMp4FileName) {
        this.addDateTimeToMp4FileName = addDateTimeToMp4FileName;
    }

    public boolean isMp4MuxingEnabled() {
        return this.mp4MuxingEnabled;
    }

    public void setMp4MuxingEnabled(boolean mp4MuxingEnabled) {
        this.mp4MuxingEnabled = mp4MuxingEnabled;
    }

    public void setFileNameFormat(String fileNameFormat) {
        this.fileNameFormat = fileNameFormat;
    }

    public String getFileNameFormat() {
        return this.fileNameFormat;
    }

    public boolean isHlsMuxingEnabled() {
        return this.hlsMuxingEnabled;
    }

    public void setHlsMuxingEnabled(boolean hlsMuxingEnabled) {
        this.hlsMuxingEnabled = hlsMuxingEnabled;
    }

    public boolean isDashMuxingEnabled() {
        return this.dashMuxingEnabled;
    }

    public void setSignalingEnabled(boolean signalingEnabled) {
        this.signalingEnabled = signalingEnabled;
    }

    public boolean isSignalingEnabled() {
        return this.signalingEnabled;
    }

    public void setSignalingAddress(String signalingAddress) {
        this.signalingAddress = signalingAddress;
    }

    public String getSignalingAddress() {
        return this.signalingAddress;
    }

    public void setDashMuxingEnabled(boolean dashMuxingEnabled) {
        this.dashMuxingEnabled = dashMuxingEnabled;
    }

    public int getEndpointRepublishLimit() {
        return this.endpointRepublishLimit;
    }

    public void setEndpointRepublishLimit(int endpointRepublishLimit) {
        this.endpointRepublishLimit = endpointRepublishLimit;
    }

    public int getEndpointHealthCheckPeriodMs() {
        return this.endpointHealthCheckPeriodMs;
    }

    public void setEndpointHealthCheckPeriodMs(int endpointHealthCheckPeriodMs) {
        this.endpointHealthCheckPeriodMs = endpointHealthCheckPeriodMs;
    }

    public String getHlsPlayListType() {
        return this.hlsPlayListType;
    }

    public void setHlsPlayListType(String hlsPlayListType) {
        this.hlsPlayListType = hlsPlayListType;
    }

    public void setUploadExtensionsToS3(int uploadExtensionsToS3) {
        this.uploadExtensionsToS3 = uploadExtensionsToS3;
    }

    public int getUploadExtensionsToS3() {
        return this.uploadExtensionsToS3;
    }

    public void setS3StorageClass(String s3StorageClass) {
        this.s3StorageClass = s3StorageClass;
    }

    public String getS3StorageClass() {
        return this.s3StorageClass;
    }

    public String getHlsTime() {
        return this.hlsTime;
    }

    public void setHlsTime(String hlsTime) {
        this.hlsTime = hlsTime;
    }

    public String getHlsListSize() {
        return this.hlsListSize;
    }

    public void setHlsListSize(String hlsListSize) {
        this.hlsListSize = hlsListSize;
    }

    public boolean isWebRTCEnabled() {
        return this.webRTCEnabled;
    }

    public void setWebRTCEnabled(boolean webRTCEnabled) {
        this.webRTCEnabled = webRTCEnabled;
    }

    public static String encodersList2Str(List<EncoderSettings> encoderSettingsList) {
        if (encoderSettingsList == null) {
            return "";
        }
        JSONArray jsonArray = new JSONArray();
        for (EncoderSettings encoderSettings : encoderSettingsList) {
            JSONObject encoderJSON = new JSONObject();
            encoderJSON.put((Object)"height", (Object)encoderSettings.getHeight());
            encoderJSON.put((Object)"videoBitrate", (Object)encoderSettings.getVideoBitrate());
            encoderJSON.put((Object)"audioBitrate", (Object)encoderSettings.getAudioBitrate());
            encoderJSON.put((Object)"forceEncode", (Object)encoderSettings.isForceEncode());
            jsonArray.add((Object)encoderJSON);
        }
        return jsonArray.toJSONString();
    }

    public static List<EncoderSettings> encodersStr2List(String encoderSettingsString) {
        ArrayList<EncoderSettings> encoderSettingsList;
        block5: {
            if (encoderSettingsString == null) {
                return null;
            }
            encoderSettingsList = new ArrayList<EncoderSettings>();
            try {
                JSONParser jsonParser = new JSONParser();
                JSONArray jsonArray = (JSONArray)jsonParser.parse(encoderSettingsString);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsObject = (JSONObject)jsonArray.get(i);
                    int height = Integer.parseInt(jsObject.get((Object)"height").toString());
                    int videoBitrate = Integer.parseInt(jsObject.get((Object)"videoBitrate").toString());
                    int audioBitrate = Integer.parseInt(jsObject.get((Object)"audioBitrate").toString());
                    boolean forceEncode = (Boolean)jsObject.get((Object)"forceEncode");
                    encoderSettingsList.add(new EncoderSettings(height, videoBitrate, audioBitrate, forceEncode));
                }
            }
            catch (ParseException e) {
                String[] values = encoderSettingsString.split(",");
                if (values.length < 3) break block5;
                for (int i = 0; i < values.length; ++i) {
                    int height = Integer.parseInt(values[i]);
                    int videoBitrate = Integer.parseInt(values[++i]);
                    int audioBitrate = Integer.parseInt(values[++i]);
                    encoderSettingsList.add(new EncoderSettings(height, videoBitrate, audioBitrate, true));
                }
            }
        }
        return encoderSettingsList;
    }

    public String getEncoderSettingsString() {
        return this.encoderSettingsString;
    }

    public List<EncoderSettings> getEncoderSettings() {
        return AppSettings.encodersStr2List(this.encoderSettingsString);
    }

    public void setEncoderSettings(List<EncoderSettings> settings) {
        this.encoderSettingsString = AppSettings.encodersList2Str(settings);
    }

    public void setEncoderSettingsString(String encoderSettingsString) {
        this.encoderSettingsString = encoderSettingsString;
    }

    public boolean isDeleteHLSFilesOnEnded() {
        return this.deleteHLSFilesOnEnded;
    }

    public void setDeleteHLSFilesOnEnded(boolean deleteHLSFilesOnEnded) {
        this.deleteHLSFilesOnEnded = deleteHLSFilesOnEnded;
    }

    public String getListenerHookURL() {
        return this.listenerHookURL;
    }

    public void setListenerHookURL(String listenerHookURL) {
        this.listenerHookURL = listenerHookURL;
    }

    public boolean isAcceptOnlyStreamsInDataStore() {
        return this.acceptOnlyStreamsInDataStore;
    }

    public void setAcceptOnlyStreamsInDataStore(boolean acceptOnlyStreamsInDataStore) {
        this.acceptOnlyStreamsInDataStore = acceptOnlyStreamsInDataStore;
    }

    public boolean isAcceptOnlyRoomsInDataStore() {
        return this.acceptOnlyRoomsInDataStore;
    }

    public void setAcceptOnlyRoomsInDataStore(boolean acceptOnlyRoomsInDataStore) {
        this.acceptOnlyRoomsInDataStore = acceptOnlyRoomsInDataStore;
    }

    public boolean isObjectDetectionEnabled() {
        return this.objectDetectionEnabled;
    }

    public String getVodFolder() {
        return this.vodFolder;
    }

    public void setVodFolder(String vodFolder) {
        this.vodFolder = vodFolder;
    }

    public int getCreatePreviewPeriod() {
        return this.createPreviewPeriod;
    }

    public void setCreatePreviewPeriod(int period) {
        this.createPreviewPeriod = period;
    }

    public boolean isPreviewOverwrite() {
        return this.previewOverwrite;
    }

    public void setPreviewOverwrite(boolean previewOverwrite) {
        this.previewOverwrite = previewOverwrite;
    }

    public String getStalkerDBServer() {
        return this.stalkerDBServer;
    }

    public void setStalkerDBServer(String stalkerDBServer) {
        this.stalkerDBServer = stalkerDBServer;
    }

    public String getStalkerDBUsername() {
        return this.stalkerDBUsername;
    }

    public void setStalkerDBUsername(String stalkerDBUsername) {
        this.stalkerDBUsername = stalkerDBUsername;
    }

    public String getStalkerDBPassword() {
        return this.stalkerDBPassword;
    }

    public void setStalkerDBPassword(String stalkerDBPassword) {
        this.stalkerDBPassword = stalkerDBPassword;
    }

    public int getRestartStreamFetcherPeriod() {
        return this.restartStreamFetcherPeriod;
    }

    public void setRestartStreamFetcherPeriod(int restartStreamFetcherPeriod) {
        this.restartStreamFetcherPeriod = restartStreamFetcherPeriod;
    }

    public int getStreamFetcherBufferTime() {
        return this.streamFetcherBufferTime;
    }

    public void setStreamFetcherBufferTime(int streamFetcherBufferTime) {
        this.streamFetcherBufferTime = streamFetcherBufferTime;
    }

    public String getHlsflags() {
        return this.hlsflags;
    }

    public void setHlsflags(String hlsflags) {
        this.hlsflags = hlsflags;
    }

    public String getMySqlClientPath() {
        return this.mySqlClientPath;
    }

    public void setMySqlClientPath(String mySqlClientPath) {
        this.mySqlClientPath = mySqlClientPath;
    }

    public boolean isPublishTokenControlEnabled() {
        return this.publishTokenControlEnabled;
    }

    public void setPublishTokenControlEnabled(boolean publishTokenControlEnabled) {
        this.publishTokenControlEnabled = publishTokenControlEnabled;
    }

    public boolean isPlayTokenControlEnabled() {
        return this.playTokenControlEnabled;
    }

    public void setPlayTokenControlEnabled(boolean playTokenControlEnabled) {
        this.playTokenControlEnabled = playTokenControlEnabled;
    }

    @Deprecated
    public boolean isTimeTokenSubscriberOnly() {
        return this.timeTokenSubscriberOnly;
    }

    @Deprecated
    public void setTimeTokenSubscriberOnly(boolean timeTokenSubscriberOnly) {
        this.timeTokenSubscriberOnly = timeTokenSubscriberOnly;
    }

    public boolean isEnableTimeTokenForPlay() {
        return this.enableTimeTokenForPlay;
    }

    public void setEnableTimeTokenForPlay(boolean enableTimeTokenForPlay) {
        this.enableTimeTokenForPlay = enableTimeTokenForPlay;
    }

    public boolean isEnableTimeTokenForPublish() {
        return this.enableTimeTokenForPublish;
    }

    public void setEnableTimeTokenForPublish(boolean enableTimeTokenForPublish) {
        this.enableTimeTokenForPublish = enableTimeTokenForPublish;
    }

    public String getMuxerFinishScript() {
        return this.muxerFinishScript;
    }

    public void setMuxerFinishScript(String muxerFinishScript) {
        this.muxerFinishScript = muxerFinishScript;
    }

    public int getWebRTCFrameRate() {
        return this.webRTCFrameRate;
    }

    public void setWebRTCFrameRate(int webRTCFrameRate) {
        this.webRTCFrameRate = webRTCFrameRate;
    }

    public String getTokenHashSecret() {
        return this.tokenHashSecret;
    }

    public void setTokenHashSecret(String tokenHashSecret) {
        this.tokenHashSecret = tokenHashSecret;
    }

    public boolean isHashControlPlayEnabled() {
        return this.hashControlPlayEnabled;
    }

    public void setHashControlPlayEnabled(boolean hashControlPlayEnabled) {
        this.hashControlPlayEnabled = hashControlPlayEnabled;
    }

    public boolean isHashControlPublishEnabled() {
        return this.hashControlPublishEnabled;
    }

    public void setHashControlPublishEnabled(boolean hashControlPublishEnabled) {
        this.hashControlPublishEnabled = hashControlPublishEnabled;
    }

    public void resetDefaults() {
        this.mp4MuxingEnabled = false;
        this.addDateTimeToMp4FileName = false;
        this.hlsMuxingEnabled = true;
        this.hlsListSize = null;
        this.hlsTime = null;
        this.webRTCEnabled = false;
        this.deleteHLSFilesOnEnded = true;
        this.deleteDASHFilesOnEnded = true;
        this.acceptOnlyStreamsInDataStore = false;
        this.publishTokenControlEnabled = false;
        this.playTokenControlEnabled = false;
        this.timeTokenSubscriberOnly = false;
        this.enableTimeTokenForPlay = false;
        this.enableTimeTokenForPublish = false;
        this.hlsPlayListType = null;
        this.previewOverwrite = false;
        this.objectDetectionEnabled = false;
        this.createPreviewPeriod = 5000;
        this.restartStreamFetcherPeriod = 0;
        this.webRTCFrameRate = 20;
        this.hashControlPlayEnabled = false;
        this.hashControlPublishEnabled = false;
        this.tokenHashSecret = "";
        this.encoderSettingsString = "";
        this.remoteAllowedCIDR = "127.0.0.1";
        this.aacEncodingEnabled = true;
        this.ipFilterEnabled = true;
        this.ingestingStreamLimit = -1;
    }

    public int getWebRTCPortRangeMax() {
        return this.webRTCPortRangeMax;
    }

    public void setWebRTCPortRangeMax(int webRTCPortRangeMax) {
        this.webRTCPortRangeMax = webRTCPortRangeMax;
    }

    public int getWebRTCPortRangeMin() {
        return this.webRTCPortRangeMin;
    }

    public void setWebRTCPortRangeMin(int webRTCPortRangeMin) {
        this.webRTCPortRangeMin = webRTCPortRangeMin;
    }

    public String getStunServerURI() {
        return this.stunServerURI;
    }

    public void setStunServerURI(String stunServerURI) {
        this.stunServerURI = stunServerURI;
    }

    public boolean isWebRTCTcpCandidatesEnabled() {
        return this.webRTCTcpCandidatesEnabled;
    }

    public void setWebRTCTcpCandidatesEnabled(boolean webRTCTcpCandidatesEnabled) {
        this.webRTCTcpCandidatesEnabled = webRTCTcpCandidatesEnabled;
    }

    public String getEncoderName() {
        return this.encoderName;
    }

    public void setEncoderName(String encoderName) {
        this.encoderName = encoderName;
    }

    public String getEncoderPreset() {
        return this.encoderPreset;
    }

    public void setEncoderPreset(String encoderPreset) {
        this.encoderPreset = encoderPreset;
    }

    public String getEncoderProfile() {
        return this.encoderProfile;
    }

    public void setEncoderProfile(String encoderProfile) {
        this.encoderProfile = encoderProfile;
    }

    public String getEncoderLevel() {
        return this.encoderLevel;
    }

    public void setEncoderLevel(String encoderLevel) {
        this.encoderLevel = encoderLevel;
    }

    public String getEncoderRc() {
        return this.encoderRc;
    }

    public void setEncoderRc(String encoderRc) {
        this.encoderRc = encoderRc;
    }

    public String getEncoderSpecific() {
        return this.encoderSpecific;
    }

    public void setEncoderSpecific(String encoderSpecific) {
        this.encoderSpecific = encoderSpecific;
    }

    public int getPreviewHeight() {
        return this.previewHeight;
    }

    public void setPreviewHeight(int previewHeight) {
        this.previewHeight = previewHeight;
    }

    public boolean isUseOriginalWebRTCEnabled() {
        return this.useOriginalWebRTCEnabled;
    }

    public void setUseOriginalWebRTCEnabled(boolean useOriginalWebRTCEnabled) {
        this.useOriginalWebRTCEnabled = useOriginalWebRTCEnabled;
    }

    public synchronized String getRemoteAllowedCIDR() {
        return this.remoteAllowedCIDR;
    }

    public synchronized void setRemoteAllowedCIDR(String remoteAllowedCIDR) {
        this.remoteAllowedCIDR = remoteAllowedCIDR;
    }

    @JsonIgnore
    public synchronized Queue<NetMask> getAllowedCIDRList() {
        ConcurrentLinkedQueue<NetMask> allowedCIDRList = new ConcurrentLinkedQueue<NetMask>();
        this.fillFromInput(this.remoteAllowedCIDR, allowedCIDRList);
        return allowedCIDRList;
    }

    public String getAllowedPublisherCIDR() {
        return this.allowedPublisherCIDR;
    }

    public void setAllowedPublisherCIDR(String allowedPublisherCIDR) {
        this.allowedPublisherCIDR = allowedPublisherCIDR;
    }

    @JsonIgnore
    public synchronized Queue<NetMask> getAllowedPublisherCIDRList() {
        ConcurrentLinkedQueue<NetMask> allowedPublisherCIDRList = new ConcurrentLinkedQueue<NetMask>();
        this.fillFromInput(this.allowedPublisherCIDR, allowedPublisherCIDRList);
        return allowedPublisherCIDRList;
    }

    private List<String> fillFromInput(String input, Queue<NetMask> target) {
        target.clear();
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<CallSite> messages = new LinkedList<CallSite>();
        for (String s : input.split("\\s*,\\s*")) {
            try {
                NetMask nm = new NetMask(s);
                target.add(nm);
            }
            catch (IllegalArgumentException e) {
                messages.add((CallSite)((Object)(s + ": " + e.getMessage())));
            }
        }
        return Collections.unmodifiableList(messages);
    }

    public String getEncoderSelectionPreference() {
        return this.encoderSelectionPreference;
    }

    public void setEncoderSelectionPreference(String encoderSelectionPreference) {
        this.encoderSelectionPreference = encoderSelectionPreference;
    }

    public int getExcessiveBandwidthCallThreshold() {
        return this.excessiveBandwidthCallThreshold;
    }

    public void setExcessiveBandwidthCallThreshold(int excessiveBandwidthCallThreshold) {
        this.excessiveBandwidthCallThreshold = excessiveBandwidthCallThreshold;
    }

    public int getExcessiveBandwidthValue() {
        return this.excessiveBandwidthValue;
    }

    public void setExcessiveBandwidthValue(int excessiveBandwidthValue) {
        this.excessiveBandwidthValue = excessiveBandwidthValue;
    }

    public int getPortAllocatorFlags() {
        return this.portAllocatorFlags;
    }

    public void setPortAllocatorFlags(int flags) {
        this.portAllocatorFlags = flags;
    }

    public int getExcessiveBandwithTryCountBeforeSwitchback() {
        return this.excessiveBandwithTryCountBeforeSwitchback;
    }

    public boolean isExcessiveBandwidthAlgorithmEnabled() {
        return this.excessiveBandwidthAlgorithmEnabled;
    }

    public int getPacketLossDiffThresholdForSwitchback() {
        return this.packetLossDiffThresholdForSwitchback;
    }

    public int getRttMeasurementDiffThresholdForSwitchback() {
        return this.rttMeasurementDiffThresholdForSwitchback;
    }

    public void setExcessiveBandwithTryCountBeforeSwitchback(int excessiveBandwithTryCountBeforeSwitchback) {
        this.excessiveBandwithTryCountBeforeSwitchback = excessiveBandwithTryCountBeforeSwitchback;
    }

    public void setExcessiveBandwidthAlgorithmEnabled(boolean excessiveBandwidthAlgorithmEnabled) {
        this.excessiveBandwidthAlgorithmEnabled = excessiveBandwidthAlgorithmEnabled;
    }

    public void setPacketLossDiffThresholdForSwitchback(int packetLossDiffThresholdForSwitchback) {
        this.packetLossDiffThresholdForSwitchback = packetLossDiffThresholdForSwitchback;
    }

    public void setRttMeasurementDiffThresholdForSwitchback(int rttMeasurementDiffThresholdForSwitchback) {
        this.rttMeasurementDiffThresholdForSwitchback = rttMeasurementDiffThresholdForSwitchback;
    }

    public boolean isReplaceCandidateAddrWithServerAddr() {
        return this.replaceCandidateAddrWithServerAddr;
    }

    public void setReplaceCandidateAddrWithServerAddr(boolean replaceCandidateAddrWithServerAddr) {
        this.replaceCandidateAddrWithServerAddr = replaceCandidateAddrWithServerAddr;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public int getEncodingTimeout() {
        return this.encodingTimeout;
    }

    public void setEncodingTimeout(int encodingTimeout) {
        this.encodingTimeout = encodingTimeout;
    }

    public boolean isDefaultDecodersEnabled() {
        return this.defaultDecodersEnabled;
    }

    public void setDefaultDecodersEnabled(boolean defaultDecodersEnabled) {
        this.defaultDecodersEnabled = defaultDecodersEnabled;
    }

    public String getHttpForwardingExtension() {
        return this.httpForwardingExtension;
    }

    public void setHttpForwardingExtension(String httpForwardingExtension) {
        this.httpForwardingExtension = httpForwardingExtension;
    }

    public String getHttpForwardingBaseURL() {
        return this.httpForwardingBaseURL;
    }

    public void setHttpForwardingBaseURL(String httpForwardingBaseURL) {
        this.httpForwardingBaseURL = httpForwardingBaseURL;
    }

    public int getMaxAnalyzeDurationMS() {
        return this.maxAnalyzeDurationMS;
    }

    public void setMaxAnalyzeDurationMS(int maxAnalyzeDurationMS) {
        this.maxAnalyzeDurationMS = maxAnalyzeDurationMS;
    }

    public boolean isGeneratePreview() {
        return this.generatePreview;
    }

    public void setGeneratePreview(boolean generatePreview) {
        this.generatePreview = generatePreview;
    }

    public boolean isDisableIPv6Candidates() {
        return this.disableIPv6Candidates;
    }

    public void setDisableIPv6Candidates(boolean disableIPv6Candidates) {
        this.disableIPv6Candidates = disableIPv6Candidates;
    }

    public String getRtspPullTransportType() {
        return this.rtspPullTransportType;
    }

    public void setRtspPullTransportType(String rtspPullTransportType) {
        this.rtspPullTransportType = rtspPullTransportType;
    }

    public int getRtspTimeoutDurationMs() {
        return this.rtspTimeoutDurationMs;
    }

    public void setRtspTimeoutDurationMs(int rtspTimeoutDurationMs) {
        this.rtspTimeoutDurationMs = rtspTimeoutDurationMs;
    }

    public int getMaxResolutionAccept() {
        return this.maxResolutionAccept;
    }

    public void setMaxResolutionAccept(int maxResolutionAccept) {
        this.maxResolutionAccept = maxResolutionAccept;
    }

    public boolean isH264Enabled() {
        return this.h264Enabled;
    }

    public void setH264Enabled(boolean h264Enabled) {
        this.h264Enabled = h264Enabled;
    }

    public boolean isVp8Enabled() {
        return this.vp8Enabled;
    }

    public void setVp8Enabled(boolean vp8Enabled) {
        this.vp8Enabled = vp8Enabled;
    }

    public boolean isH265Enabled() {
        return this.h265Enabled;
    }

    public void setH265Enabled(boolean h265Enabled) {
        this.h265Enabled = h265Enabled;
    }

    public boolean isDataChannelEnabled() {
        return this.dataChannelEnabled;
    }

    public void setDataChannelEnabled(boolean dataChannelEnabled) {
        this.dataChannelEnabled = dataChannelEnabled;
    }

    public String getDataChannelPlayerDistribution() {
        return this.dataChannelPlayerDistribution;
    }

    public void setDataChannelPlayerDistribution(String dataChannelPlayerDistribution) {
        this.dataChannelPlayerDistribution = dataChannelPlayerDistribution;
    }

    public long getRtmpIngestBufferTimeMs() {
        return this.rtmpIngestBufferTimeMs;
    }

    public void setRtmpIngestBufferTimeMs(long rtmpIngestBufferTimeMs) {
        this.rtmpIngestBufferTimeMs = rtmpIngestBufferTimeMs;
    }

    public void setDataChannelWebHookURL(String dataChannelWebHookURL) {
        this.dataChannelWebHookURL = dataChannelWebHookURL;
    }

    public int getEncoderThreadCount() {
        return this.encoderThreadCount;
    }

    public void setEncoderThreadCount(int encoderThreadCount) {
        this.encoderThreadCount = encoderThreadCount;
    }

    public int getEncoderThreadType() {
        return this.encoderThreadType;
    }

    public void setEncoderThreadType(int encoderThreadType) {
        this.encoderThreadType = encoderThreadType;
    }

    public int getWebRTCClientStartTimeoutMs() {
        return this.webRTCClientStartTimeoutMs;
    }

    public void setWebRTCClientStartTimeoutMs(int webRTCClientStartTimeout) {
        this.webRTCClientStartTimeoutMs = webRTCClientStartTimeout;
    }

    public String getH265EncoderProfile() {
        return this.h265EncoderProfile;
    }

    public String getH265EncoderPreset() {
        return this.h265EncoderPreset;
    }

    public String getH265EncoderLevel() {
        return this.h265EncoderLevel;
    }

    public String getH265EncoderSpecific() {
        return this.h265EncoderSpecific;
    }

    public String getH265EncoderRc() {
        return this.h265EncoderRc;
    }

    public void setH265EncoderLevel(String encoderLevel) {
        this.h265EncoderLevel = encoderLevel;
    }

    public void setH265EncoderPreset(String preset) {
        this.h265EncoderPreset = preset;
    }

    public void setH265EncoderProfile(String profile) {
        this.h265EncoderProfile = profile;
    }

    public void setH265EncoderRc(String encoderRc) {
        this.h265EncoderRc = encoderRc;
    }

    public void setH265EncoderSpecific(String encoderSpecific) {
        this.h265EncoderSpecific = encoderSpecific;
    }

    public boolean isWebMMuxingEnabled() {
        return this.webMMuxingEnabled;
    }

    public void setWebMMuxingEnabled(boolean webMMuxingEnabled) {
        this.webMMuxingEnabled = webMMuxingEnabled;
    }

    public int getVp8EncoderSpeed() {
        return this.vp8EncoderSpeed;
    }

    public void setVp8EncoderSpeed(int vp8EncoderSpeed) {
        this.vp8EncoderSpeed = vp8EncoderSpeed;
    }

    public String getVp8EncoderDeadline() {
        return this.vp8EncoderDeadline;
    }

    public void setVp8EncoderDeadline(String vp8EncoderDeadline) {
        this.vp8EncoderDeadline = vp8EncoderDeadline;
    }

    public int getVp8EncoderThreadCount() {
        return this.vp8EncoderThreadCount;
    }

    public void setVp8EncoderThreadCount(int vp8EncoderThreadCount) {
        this.vp8EncoderThreadCount = vp8EncoderThreadCount;
    }

    public String getWebRTCSdpSemantics() {
        return this.webRTCSdpSemantics;
    }

    public void setWebRTCSdpSemantics(String webRTCSdpSemantics) {
        this.webRTCSdpSemantics = webRTCSdpSemantics;
    }

    public boolean isStartStreamFetcherAutomatically() {
        return this.startStreamFetcherAutomatically;
    }

    public void setStartStreamFetcherAutomatically(boolean startStreamFetcherAutomatically) {
        this.startStreamFetcherAutomatically = startStreamFetcherAutomatically;
    }

    public boolean isDeleteDASHFilesOnEnded() {
        return this.deleteDASHFilesOnEnded;
    }

    public void setDeleteDASHFilesOnEnded(boolean deleteDASHFilesOnEnded) {
        this.deleteDASHFilesOnEnded = deleteDASHFilesOnEnded;
    }

    public String getTargetLatency() {
        return this.targetLatency;
    }

    public void setTargetLatency(String targetLatency) {
        this.targetLatency = targetLatency;
    }

    public int getHeightRtmpForwarding() {
        return this.heightRtmpForwarding;
    }

    public void setHeightRtmpForwarding(int heightRtmpForwarding) {
        this.heightRtmpForwarding = heightRtmpForwarding;
    }

    public int getAudioBitrateSFU() {
        return this.audioBitrateSFU;
    }

    public void setAudioBitrateSFU(int audioBitrateSFU) {
        this.audioBitrateSFU = audioBitrateSFU;
    }

    public void setAacEncodingEnabled(boolean aacEncodingEnabled) {
        this.aacEncodingEnabled = aacEncodingEnabled;
    }

    public boolean isAacEncodingEnabled() {
        return this.aacEncodingEnabled;
    }

    public int getGopSize() {
        return this.gopSize;
    }

    public void setGopSize(int gopSize) {
        this.gopSize = gopSize;
    }

    public String getConstantRateFactor() {
        return this.constantRateFactor;
    }

    public void setConstantRateFactor(String constantRateFactor) {
        this.constantRateFactor = constantRateFactor;
    }

    public int getWebRTCViewerLimit() {
        return this.webRTCViewerLimit;
    }

    public void setWebRTCViewerLimit(int webRTCViewerLimit) {
        this.webRTCViewerLimit = webRTCViewerLimit;
    }

    public String getDashFragmentDuration() {
        return this.dashFragmentDuration;
    }

    public void setDashFragmentDuration(String dashFragmentDuration) {
        this.dashFragmentDuration = dashFragmentDuration;
    }

    public String getDashSegDuration() {
        return this.dashSegDuration;
    }

    public void setDashSegDuration(String dashSegDuration) {
        this.dashSegDuration = dashSegDuration;
    }

    public String getDashWindowSize() {
        return this.dashWindowSize;
    }

    public void setDashWindowSize(String dashWindowSize) {
        this.dashWindowSize = dashWindowSize;
    }

    public String getDashExtraWindowSize() {
        return this.dashExtraWindowSize;
    }

    public void setDashExtraWindowSize(String dashExtraWindowSize) {
        this.dashExtraWindowSize = dashExtraWindowSize;
    }

    public String getJwtSecretKey() {
        return this.jwtSecretKey;
    }

    public void setJwtSecretKey(String jwtSecretKey) {
        this.jwtSecretKey = jwtSecretKey;
    }

    public boolean isJwtControlEnabled() {
        return this.jwtControlEnabled;
    }

    public void setJwtControlEnabled(boolean jwtControlEnabled) {
        this.jwtControlEnabled = jwtControlEnabled;
    }

    public boolean isIpFilterEnabled() {
        return this.ipFilterEnabled;
    }

    public void setIpFilterEnabled(boolean ipFilterEnabled) {
        this.ipFilterEnabled = ipFilterEnabled;
    }

    public int getIngestingStreamLimit() {
        return this.ingestingStreamLimit;
    }

    public void setIngestingStreamLimit(int ingestingStreamLimit) {
        this.ingestingStreamLimit = ingestingStreamLimit;
    }

    public int getTimeTokenPeriod() {
        return this.timeTokenPeriod;
    }

    public void setTimeTokenPeriod(int timeTokenPeriod) {
        this.timeTokenPeriod = timeTokenPeriod;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public void setToBeDeleted(boolean toBeDeleted) {
        this.toBeDeleted = toBeDeleted;
    }

    public boolean isPullWarFile() {
        return this.pullWarFile;
    }

    public void setPullWarFile(boolean pullWarFile) {
        this.pullWarFile = pullWarFile;
    }

    public int getWebRTCKeyframeTime() {
        return this.webRTCKeyframeTime;
    }

    public void setWebRTCKeyframeTime(int webRTCKeyframeTime) {
        this.webRTCKeyframeTime = webRTCKeyframeTime;
    }

    public String getJwtStreamSecretKey() {
        return this.jwtStreamSecretKey;
    }

    public void setJwtStreamSecretKey(String jwtStreamSecretKey) {
        this.jwtStreamSecretKey = jwtStreamSecretKey;
    }

    public boolean isPublishJwtControlEnabled() {
        return this.publishJwtControlEnabled;
    }

    public void setPublishJwtControlEnabled(boolean publishJwtControlEnabled) {
        this.publishJwtControlEnabled = publishJwtControlEnabled;
    }

    public boolean isPlayJwtControlEnabled() {
        return this.playJwtControlEnabled;
    }

    public void setPlayJwtControlEnabled(boolean playJwtControlEnabled) {
        this.playJwtControlEnabled = playJwtControlEnabled;
    }

    public boolean islLDashEnabled() {
        return this.lLDashEnabled;
    }

    public void setlLDashEnabled(boolean lLDashEnabled) {
        this.lLDashEnabled = lLDashEnabled;
    }

    public boolean islLHLSEnabled() {
        return this.lLHLSEnabled;
    }

    public void setlLHLSEnabled(boolean lLHLSEnabled) {
        this.lLHLSEnabled = lLHLSEnabled;
    }

    public boolean isHlsEnabledViaDash() {
        return this.hlsEnabledViaDash;
    }

    public void setHlsEnabledViaDash(boolean hlsEnabledViaDash) {
        this.hlsEnabledViaDash = hlsEnabledViaDash;
    }

    public boolean isUseTimelineDashMuxing() {
        return this.useTimelineDashMuxing;
    }

    public void setUseTimelineDashMuxing(boolean useTimelineDashMuxing) {
        this.useTimelineDashMuxing = useTimelineDashMuxing;
    }

    public boolean isDashHttpStreaming() {
        return this.dashHttpStreaming;
    }

    public void setDashHttpStreaming(boolean dashHttpStreaming) {
        this.dashHttpStreaming = dashHttpStreaming;
    }

    public String getS3StreamsFolderPath() {
        return this.s3StreamsFolderPath;
    }

    public String getDashHttpEndpoint() {
        return this.dashHttpEndpoint;
    }

    public boolean isS3RecordingEnabled() {
        return this.s3RecordingEnabled;
    }

    public void setS3RecordingEnabled(boolean s3RecordingEnabled) {
        this.s3RecordingEnabled = s3RecordingEnabled;
    }

    public String getS3SecretKey() {
        return this.s3SecretKey;
    }

    public void setS3SecretKey(String s3SecretKey) {
        this.s3SecretKey = s3SecretKey;
    }

    public String getS3AccessKey() {
        return this.s3AccessKey;
    }

    public void setS3AccessKey(String s3AccessKey) {
        this.s3AccessKey = s3AccessKey;
    }

    public String getS3RegionName() {
        return this.s3RegionName;
    }

    public void setS3RegionName(String s3RegionName) {
        this.s3RegionName = s3RegionName;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public String getS3Endpoint() {
        return this.s3Endpoint;
    }

    public void setS3Endpoint(String s3Endpoint) {
        this.s3Endpoint = s3Endpoint;
    }

    public String getS3CacheControl() {
        return this.s3CacheControl;
    }

    public void setS3CacheControl(String s3CacheControl) {
        this.s3CacheControl = s3CacheControl;
    }

    public void setDashHttpEndpoint(String dashHttpEndpoint) {
        this.dashHttpEndpoint = dashHttpEndpoint;
    }

    public String getHlsEncryptionKeyInfoFile() {
        return this.hlsEncryptionKeyInfoFile;
    }

    public void setHlsEncryptionKeyInfoFile(String hlsEncryptionKeyInfoFile) {
        this.hlsEncryptionKeyInfoFile = hlsEncryptionKeyInfoFile;
    }

    public void setS3StreamsFolderPath(String s3StreamsFolderPath) {
        this.s3StreamsFolderPath = s3StreamsFolderPath;
    }

    public String getS3PreviewsFolderPath() {
        return this.s3PreviewsFolderPath;
    }

    public void setS3PreviewsFolderPath(String s3PreviewsFolderPath) {
        this.s3PreviewsFolderPath = s3PreviewsFolderPath;
    }

    public boolean isForceDecoding() {
        return this.forceDecoding;
    }

    public void setForceDecoding(boolean forceDecoding) {
        this.forceDecoding = forceDecoding;
    }

    public boolean isAddOriginalMuxerIntoHLSPlaylist() {
        return this.addOriginalMuxerIntoHLSPlaylist;
    }

    public void setAddOriginalMuxerIntoHLSPlaylist(boolean addOriginalMuxerIntoHLSPlaylist) {
        this.addOriginalMuxerIntoHLSPlaylist = addOriginalMuxerIntoHLSPlaylist;
    }

    public String getJwksURL() {
        return this.jwksURL;
    }

    public void setJwksURL(String jwksURL) {
        this.jwksURL = jwksURL;
    }

    public String getWebhookAuthenticateURL() {
        return this.webhookAuthenticateURL;
    }

    public void setWebhookAuthenticateURL(String webhookAuthenticateURL) {
        this.webhookAuthenticateURL = webhookAuthenticateURL;
    }

    public boolean isForceAspectRatioInTranscoding() {
        return this.forceAspectRatioInTranscoding;
    }

    public void setForceAspectRatioInTranscoding(boolean forceAspectRatioInTranscoding) {
        this.forceAspectRatioInTranscoding = forceAspectRatioInTranscoding;
    }

    public String getS3Permission() {
        return this.s3Permission;
    }

    public void setS3Permission(String s3Permission) {
        this.s3Permission = s3Permission;
    }

    public int getMaxAudioTrackCount() {
        return this.maxAudioTrackCount;
    }

    public void setMaxAudioTrackCount(int maxAudioTrackCount) {
        this.maxAudioTrackCount = maxAudioTrackCount;
    }

    public String getWarFileOriginServerAddress() {
        return this.warFileOriginServerAddress;
    }

    public void setWarFileOriginServerAddress(String warFileOriginServerAddress) {
        this.warFileOriginServerAddress = warFileOriginServerAddress;
    }

    public void setVodUploadFinishScript(String vodUploadFinishScript) {
        this.vodUploadFinishScript = vodUploadFinishScript;
    }

    public int getMaxVideoTrackCount() {
        return this.maxVideoTrackCount;
    }

    public void setMaxVideoTrackCount(int maxVideoTrackCount) {
        this.maxVideoTrackCount = maxVideoTrackCount;
    }

    public String getContentSecurityPolicyHeaderValue() {
        return this.contentSecurityPolicyHeaderValue;
    }

    public void setContentSecurityPolicyHeaderValue(String contentSecurityPolicyHeaderValue) {
        this.contentSecurityPolicyHeaderValue = contentSecurityPolicyHeaderValue;
    }

    public String getTurnServerUsername() {
        return this.turnServerUsername;
    }

    public void setTurnServerUsername(String turnServerUsername) {
        this.turnServerUsername = turnServerUsername;
    }

    public String getTurnServerCredential() {
        return this.turnServerCredential;
    }

    public void setTurnServerCredential(String turnServerCredential) {
        this.turnServerCredential = turnServerCredential;
    }

    public String getHlsHttpEndpoint() {
        return this.hlsHttpEndpoint;
    }

    public void setHlsHttpEndpoint(String hlsHttpEndpoint) {
        this.hlsHttpEndpoint = hlsHttpEndpoint;
    }

    public boolean isRtmpPlaybackEnabled() {
        return this.rtmpPlaybackEnabled;
    }

    public void setRtmpPlaybackEnabled(boolean rtmpPlaybackEnabled) {
        this.rtmpPlaybackEnabled = rtmpPlaybackEnabled;
    }

    public int getOriginEdgeIdleTimeout() {
        return this.originEdgeIdleTimeout;
    }

    public void setOriginEdgeIdleTimeout(int originEdgeIdleTimeout) {
        this.originEdgeIdleTimeout = originEdgeIdleTimeout;
    }

    public boolean isAddDateTimeToHlsFileName() {
        return this.addDateTimeToHlsFileName;
    }

    public void setAddDateTimeToHlsFileName(boolean addDateTimeToHlsFileName) {
        this.addDateTimeToHlsFileName = addDateTimeToHlsFileName;
    }

    public boolean isPlayWebRTCStreamOnceForEachSession() {
        return this.playWebRTCStreamOnceForEachSession;
    }

    public void setPlayWebRTCStreamOnceForEachSession(boolean playWebRTCStreamOnceForEachSession) {
        this.playWebRTCStreamOnceForEachSession = playWebRTCStreamOnceForEachSession;
    }

    public boolean isStatsBasedABREnabled() {
        return this.statsBasedABREnabled;
    }

    public void setStatsBasedABREnabled(boolean statsBasedABREnabled) {
        this.statsBasedABREnabled = statsBasedABREnabled;
    }

    public float getAbrDownScalePacketLostRatio() {
        return this.abrDownScalePacketLostRatio;
    }

    public void setAbrDownScalePacketLostRatio(float abrDownScalePacketLostRatio) {
        this.abrDownScalePacketLostRatio = abrDownScalePacketLostRatio;
    }

    public float getAbrUpScalePacketLostRatio() {
        return this.abrUpScalePacketLostRatio;
    }

    public void setAbrUpScalePacketLostRatio(float abrUpScalePacketLostRatio) {
        this.abrUpScalePacketLostRatio = abrUpScalePacketLostRatio;
    }

    public int getAbrUpScaleRTTMs() {
        return this.abrUpScaleRTTMs;
    }

    public void setAbrUpScaleRTTMs(int abrUpScaleRTTMs) {
        this.abrUpScaleRTTMs = abrUpScaleRTTMs;
    }

    public int getAbrUpScaleJitterMs() {
        return this.abrUpScaleJitterMs;
    }

    public void setAbrUpScaleJitterMs(int abrUpScaleJitterMs) {
        this.abrUpScaleJitterMs = abrUpScaleJitterMs;
    }

    public String getClusterCommunicationKey() {
        return this.clusterCommunicationKey;
    }

    public void setClusterCommunicationKey(String clusterCommunicationKey) {
        this.clusterCommunicationKey = clusterCommunicationKey;
    }

    public int getMaxFpsAccept() {
        return this.maxFpsAccept;
    }

    public void setMaxFpsAccept(int maxFpsAccept) {
        this.maxFpsAccept = maxFpsAccept;
    }

    public String getDataChannelWebHookURL() {
        return this.dataChannelWebHookURL;
    }

    public String getVodUploadFinishScript() {
        return this.vodUploadFinishScript;
    }

    public void setObjectDetectionEnabled(boolean objectDetectionEnabled) {
        this.objectDetectionEnabled = objectDetectionEnabled;
    }

    public boolean isId3TagEnabled() {
        return this.id3TagEnabled;
    }

    public void setId3TagEnabled(boolean id3TagEnabled) {
        this.id3TagEnabled = id3TagEnabled;
    }

    public boolean isSendAudioLevelToViewers() {
        return this.sendAudioLevelToViewers;
    }

    public void setSendAudioLevelToViewers(boolean sendAudioLevelToViewers) {
        this.sendAudioLevelToViewers = sendAudioLevelToViewers;
    }

    public String getTimeTokenSecretForPublish() {
        return this.timeTokenSecretForPublish;
    }

    public void setTimeTokenSecretForPublish(String timeTokenSecretForPublish) {
        this.timeTokenSecretForPublish = timeTokenSecretForPublish;
    }

    public String getTimeTokenSecretForPlay() {
        return this.timeTokenSecretForPlay;
    }

    public void setTimeTokenSecretForPlay(String timeTokenSecretForPlay) {
        this.timeTokenSecretForPlay = timeTokenSecretForPlay;
    }
}

