/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.datastore;

import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.console.datastore.MapDBStore;
import io.antmedia.console.datastore.MongoStore;
import io.antmedia.console.datastore.RedisStore;
import io.vertx.core.Vertx;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ConsoleDataStoreFactory
implements ApplicationContextAware {
    private AbstractConsoleDataStore dataStore;
    @Value(value="${db.app.name:#{null}}")
    private String appName;
    @Value(value="${db.name:#{null}}")
    private String dbName;
    @Value(value="${db.type:#{null}}")
    private String dbType;
    @Value(value="${db.host:#{null}}")
    private String dbHost;
    @Deprecated(since="2.7.0", forRemoval=true)
    @Value(value="${db.user:#{null}}")
    private String dbUser;
    @Deprecated(since="2.7.0", forRemoval=true)
    @Value(value="${db.password:#{null}}")
    private String dbPassword;
    private Vertx vertx;

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.vertx = (Vertx)applicationContext.getBean("vertxCore");
    }

    public AbstractConsoleDataStore getDataStore() {
        if (this.dataStore == null) {
            if (this.dbType.contentEquals("mongodb")) {
                this.dataStore = new MongoStore(this.dbHost, this.dbUser, this.dbPassword);
            } else if (this.dbType.contentEquals("mapdb")) {
                this.dataStore = new MapDBStore(this.vertx);
            } else if (this.dbType.contentEquals("redisdb")) {
                this.dataStore = new RedisStore(this.dbHost);
            }
        }
        return this.dataStore;
    }
}

