/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.rest;

import ch.qos.logback.classic.Level;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.SystemUtils;
import io.antmedia.cluster.IClusterNotifier;
import io.antmedia.console.AdminApplication;
import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.console.datastore.ConsoleDataStoreFactory;
import io.antmedia.datastore.db.types.Licence;
import io.antmedia.datastore.db.types.User;
import io.antmedia.datastore.preference.PreferenceStore;
import io.antmedia.licence.ILicenceService;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.model.Result;
import io.antmedia.rest.model.SslConfigurationType;
import io.antmedia.rest.model.UserType;
import io.antmedia.rest.model.Version;
import io.antmedia.security.SslConfigurator;
import io.antmedia.settings.ServerSettings;
import io.antmedia.statistic.IStatsCollector;
import io.antmedia.statistic.StatsCollector;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.red5.server.Launcher;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CommonRestService {
    private static final String LOG_TYPE_ERROR = "error";
    private static final String FILE_NOT_EXIST = "There is no log yet";
    private static final String ERROR_LOG_LOCATION = "log/antmedia-error.log";
    private static final String SERVER_LOG_LOCATION = "log/ant-media-server.log";
    private static final String LOG_CONTENT = "logContent";
    private static final String LOG_CONTENT_SIZE = "logContentSize";
    private static final String LOG_FILE_SIZE = "logFileSize";
    private static final int MAX_CHAR_SIZE = 512000;
    private static final String LOG_LEVEL_ALL = "ALL";
    private static final String LOG_LEVEL_TRACE = "TRACE";
    private static final String LOG_LEVEL_DEBUG = "DEBUG";
    private static final String LOG_LEVEL_INFO = "INFO";
    private static final String LOG_LEVEL_WARN = "WARN";
    private static final String LOG_LEVEL_ERROR = "ERROR";
    private static final String LOG_LEVEL_OFF = "OFF";
    public static final String USER_PASSWORD = "user.password";
    public static final String USER_EMAIL = "user.email";
    public static final String IS_AUTHENTICATED = "isAuthenticated";
    public static final String SERVER_NAME = "server.name";
    public static final String LICENSE_KEY = "server.licence_key";
    public static final String MARKET_BUILD = "server.market_build";
    public static final String NODE_GROUP = "nodeGroup";
    Gson gson = new Gson();
    private AbstractConsoleDataStore dataStore;
    private static final String LOG_LEVEL = "logLevel";
    private static final String RED5_PROPERTIES_PATH = "conf/red5.properties";
    protected static final Logger logger = LoggerFactory.getLogger(CommonRestService.class);
    private static final String LICENSE_STATUS = "license";
    protected ApplicationContext applicationContext;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest servletRequest;
    private ConsoleDataStoreFactory dataStoreFactory;
    private ServerSettings serverSettings;
    private ILicenceService licenceService;
    private IStatsCollector statsCollector;
    private static final int BLOCKED_LOGIN_TIMEOUT_SECS = 300;
    private static final int ALLOWED_LOGIN_ATTEMPTS = 2;
    public static final String SESSION_SCOPE_KEY = "scope";
    public static final String USER_TYPE = "user-type";
    public static final String SCOPE_SYSTEM = "system";

    public int getAllowedLoginAttempts() {
        return 2;
    }

    public Result addUser(final User user) {
        boolean result = false;
        String message = "";
        if (user != null) {
            if (!this.getDataStore().doesUsernameExist(user.getEmail()) && user.getPassword() != null && user.getEmail() != null && user.getUserType() != null) {
                user.setPassword(this.getMD5Hash(user.getPassword()));
                result = this.getDataStore().addUser(user);
                logger.info("added user = {} user type = {} -> {}", new Object[]{user.getEmail(), user.getUserType(), result});
                new Thread(){

                    @Override
                    public void run() {
                        CommonRestService.this.sendUserInfo(user.getEmail(), user.getFirstName(), user.getLastName(), user.getScope(), user.getUserType().toString());
                    }
                }.start();
            } else {
                message = "User with the same e-mail already exists";
            }
        } else {
            message = "User object is null";
        }
        Result operationResult = new Result(result);
        operationResult.setMessage(message);
        return operationResult;
    }

    public Result addInitialUser(final User user) {
        boolean result = false;
        int errorId = -1;
        user.setPassword(this.getMD5Hash(user.getPassword()));
        user.setUserType(UserType.ADMIN);
        user.setScope(SCOPE_SYSTEM);
        if (this.getDataStore().getNumberOfUserRecords() == 0) {
            result = this.getDataStore().addUser(user);
        }
        Result operationResult = new Result(result);
        operationResult.setErrorId(errorId);
        new Thread(){

            @Override
            public void run() {
                CommonRestService.this.sendUserInfo(user.getEmail(), user.getFirstName(), user.getLastName(), user.getScope(), user.getUserType().toString());
            }
        }.start();
        return operationResult;
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendUserInfo(String email, String firstname, String lastname, String scope, String userType) {
        boolean success = false;
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            Version version = RestServiceBase.getSoftwareVersion();
            HttpPost httpPost = new HttpPost("https://antmedia.io/livedemo/ams_web_panel_registration.php");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setSocketTimeout(5000).build();
            httpPost.setConfig(requestConfig);
            firstname = Objects.requireNonNullElse(firstname, "");
            lastname = Objects.requireNonNullElse(lastname, "");
            email = Objects.requireNonNullElse(email, "");
            String isEnterprise = Objects.requireNonNullElse(RestServiceBase.isEnterprise(), "");
            String licenseKey = Objects.requireNonNullElse(this.getServerSettings().getLicenceKey(), "");
            String versionStr = Objects.requireNonNullElse(version.getVersionType(), "") + " " + Objects.requireNonNullElse(version.getVersionName(), "") + " " + Objects.requireNonNullElse(version.getBuildNumber(), "");
            String marketplace = Objects.requireNonNullElse(this.getServerSettings().getMarketplace(), "");
            String instanceId = Objects.requireNonNullElse(Launcher.getInstanceId(), "");
            scope = Objects.requireNonNullElse(scope, "");
            userType = Objects.requireNonNullElse(userType, "");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addTextBody("firstname", firstname);
            builder.addTextBody("lastname", lastname);
            builder.addTextBody("email", email);
            builder.addTextBody("isEnterprise", isEnterprise);
            builder.addTextBody("licenseKey", licenseKey);
            builder.addTextBody("version", versionStr);
            builder.addTextBody("marketplace", marketplace);
            builder.addTextBody("instanceId", instanceId);
            builder.addTextBody("userScope", scope);
            builder.addTextBody("userType", userType);
            HttpEntity httpEntity = builder.build();
            httpPost.setEntity(httpEntity);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                if (response.getStatusLine().getStatusCode() == 200) {
                    success = true;
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return success;
    }

    protected static String getWebAppsDirectory() {
        return String.format("%s/webapps", System.getProperty("red5.root"));
    }

    protected static String getTmpDirectory() {
        return String.format("%s/tmp", System.getProperty("red5.root"));
    }

    public Result isFirstLogin() {
        boolean result = false;
        if (this.getDataStore().getNumberOfUserRecords() == 0) {
            result = true;
        }
        return new Result(result);
    }

    public Result authenticateUser(User user) {
        Object message = "";
        boolean tryToAuthenticate = false;
        if (user != null && user.getEmail() != null) {
            if (this.getDataStore().isUserBlocked(user.getEmail())) {
                if (Instant.now().getEpochSecond() - this.getDataStore().getBlockTime(user.getEmail()) > 300L) {
                    logger.info("Unblocking the user -> {}", (Object)user.getEmail());
                    this.getDataStore().setUnBlocked(user.getEmail());
                    this.getDataStore().resetInvalidLoginCount(user.getEmail());
                    tryToAuthenticate = true;
                } else {
                    message = "Too many login attempts. User is blocked for 300 secs";
                }
            } else {
                tryToAuthenticate = true;
            }
        }
        boolean result = false;
        if (tryToAuthenticate) {
            boolean bl = result = this.getDataStore().doesUserExist(user.getEmail(), user.getPassword()) || this.getDataStore().doesUserExist(user.getEmail(), this.getMD5Hash(user.getPassword()));
            if (result) {
                HttpSession session = this.servletRequest.getSession();
                session.setAttribute(IS_AUTHENTICATED, (Object)true);
                session.setAttribute(USER_EMAIL, (Object)user.getEmail());
                session.setAttribute(USER_PASSWORD, (Object)this.getMD5Hash(user.getPassword()));
                user = this.getDataStore().getUser(user.getEmail());
                message = user.getScope() + "/" + user.getUserType();
                this.getDataStore().resetInvalidLoginCount(user.getEmail());
            } else {
                this.getDataStore().incrementInvalidLoginCount(user.getEmail());
                logger.info("Increased invalid login count to: {}", (Object)this.getDataStore().getInvalidLoginCount(user.getEmail()));
                if (this.getDataStore().getInvalidLoginCount(user.getEmail()) > 2) {
                    this.getDataStore().setBlocked(user.getEmail());
                    this.getDataStore().setBlockTime(user.getEmail(), Instant.now().getEpochSecond());
                    logger.info("User is blocked: {}", (Object)this.getDataStore().doesUsernameExist(user.getEmail()));
                }
            }
        }
        return new Result(result, (String)message);
    }

    public void setRequestForTest(HttpServletRequest testRequest) {
        this.servletRequest = testRequest;
    }

    public Result isAdmin() {
        User currentUser;
        HttpSession session = this.servletRequest.getSession();
        if (CommonRestService.isAuthenticated(session) && (currentUser = this.getDataStore().getUser(session.getAttribute(USER_EMAIL).toString())).getUserType().equals((Object)UserType.ADMIN)) {
            return new Result(true, "User is admin");
        }
        return new Result(false, "User is not admin");
    }

    public Result editUser(User user) {
        boolean result = false;
        String message = "";
        HttpSession session = this.servletRequest.getSession();
        String userEmail = (String)session.getAttribute(USER_EMAIL);
        if (user != null && user.getEmail() != null && this.getDataStore().doesUsernameExist(user.getEmail())) {
            if (!userEmail.equals(user.getEmail())) {
                if (user.getNewPassword() != null && !user.getNewPassword().isEmpty()) {
                    logger.info("Changing password of user: {}", (Object)user.getEmail());
                    user.setPassword(this.getMD5Hash(user.getNewPassword()));
                    user.setNewPassword(null);
                } else {
                    User userOriginal = this.getDataStore().getUser(user.getEmail());
                    user.setPassword(userOriginal.getPassword());
                }
                result = this.getDataStore().editUser(user);
            } else {
                message = "User cannot edit itself";
            }
        } else {
            message = "Edited user is not found in database";
        }
        return new Result(result, message);
    }

    public Result deleteUser(String userName) {
        HttpSession session = this.servletRequest.getSession();
        String userEmail = (String)session.getAttribute(USER_EMAIL);
        boolean result = false;
        String message = "";
        if (!userEmail.equals(userName)) {
            result = this.getDataStore().deleteUser(userName);
            if (!result) {
                logger.info("Could not delete the user: {}", (Object)userName);
            }
        } else {
            message = "You cannot delete yourself";
        }
        if (result) {
            logger.info("Deleted user: {} ", (Object)userName);
        }
        return new Result(result, message);
    }

    public List<User> getUserList() {
        return this.getDataStore().getUserList();
    }

    public Result changeUserPassword(User user) {
        String userMail = (String)this.servletRequest.getSession().getAttribute(USER_EMAIL);
        return this.changeUserPasswordInternal(userMail, user);
    }

    public Result changeUserPasswordInternal(String userMail, User user) {
        boolean result = false;
        String message = null;
        if (userMail != null && user.getNewPassword() != null) {
            boolean bl = result = this.getDataStore().doesUserExist(userMail, user.getPassword()) || this.getDataStore().doesUserExist(userMail, this.getMD5Hash(user.getPassword()));
            if (result) {
                User userFromDB = this.getDataStore().getUser(userMail);
                userFromDB.setPassword(this.getMD5Hash(user.getNewPassword()));
                userFromDB.setNewPassword(null);
                result = this.getDataStore().editUser(userFromDB);
                if (result) {
                    message = "Success";
                    HttpSession session = this.servletRequest.getSession();
                    if (session != null) {
                        session.setAttribute(IS_AUTHENTICATED, (Object)true);
                        session.setAttribute(USER_EMAIL, (Object)userMail);
                        session.setAttribute(USER_PASSWORD, (Object)this.getMD5Hash(user.getPassword()));
                    }
                }
            } else {
                message = "User not exist with that name and pass";
            }
        } else {
            message = "User name does not exist or there is no new password";
        }
        return new Result(result, message);
    }

    public Result isAuthenticatedRest() {
        return new Result(CommonRestService.isAuthenticated(this.servletRequest.getSession()));
    }

    public static boolean isAuthenticated(HttpSession session) {
        Object isAuthenticated = session.getAttribute(IS_AUTHENTICATED);
        Object userEmail = session.getAttribute(USER_EMAIL);
        Object userPassword = session.getAttribute(USER_PASSWORD);
        boolean result = false;
        if (isAuthenticated != null && userEmail != null && userPassword != null) {
            result = true;
        }
        return result;
    }

    public String getSystemInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getSystemInfoJSObject());
    }

    public String getJVMMemoryInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getJVMMemoryInfoJSObject());
    }

    public String getSystemMemoryInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getSysteMemoryInfoJSObject());
    }

    public String getFileSystemInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getFileSystemInfoJSObject());
    }

    public String getCPUInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getCPUInfoJSObject());
    }

    public String getThreadDump() {
        return Arrays.toString(StatsCollector.getThreadDump());
    }

    public String getThreadDumpJSON() {
        return this.gson.toJson((JsonElement)StatsCollector.getThreadDumpJSON());
    }

    public String getThreadsInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getThreadInfoJSONObject());
    }

    public Response getHeapDump() {
        SystemUtils.getHeapDump("heapdump.hprof");
        File file = new File("heapdump.hprof");
        return Response.ok((Object)file, (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\"")).build();
    }

    public String getServerTime() {
        return this.gson.toJson((JsonElement)StatsCollector.getServerTime());
    }

    public String getSystemResourcesInfo() {
        AdminApplication application = this.getApplication();
        IScope rootScope = application.getRootScope();
        int totalLiveStreams = 0;
        LinkedList<IScope> scopes = new LinkedList<IScope>();
        List<String> appNames = application.getApplications();
        for (String name : appNames) {
            IScope scope = rootScope.getScope(name);
            scopes.add(scope);
            totalLiveStreams += application.getAppLiveStreamCount(scope);
        }
        JsonObject jsonObject = StatsCollector.getSystemResourcesInfo(scopes);
        jsonObject.addProperty("totalLiveStreamSize", (Number)totalLiveStreams);
        jsonObject.add(LICENSE_STATUS, this.gson.toJsonTree((Object)this.getLicenceStatus()));
        return this.gson.toJson((JsonElement)jsonObject);
    }

    public String getGPUInfo() {
        return this.gson.toJson((JsonElement)StatsCollector.getGPUInfoJSObject());
    }

    public String getVersion() {
        return this.gson.toJson((Object)RestServiceBase.getSoftwareVersion());
    }

    public String getApplications() {
        List<String> applications = this.getApplication().getApplications();
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (String appName : applications) {
            if (appName.equals("ConsoleApp")) continue;
            jsonArray.add(appName);
        }
        jsonObject.add("applications", (JsonElement)jsonArray);
        return this.gson.toJson((JsonElement)jsonObject);
    }

    public String getLiveClientsSize() {
        int totalConnectionSize = this.getApplication().getTotalConnectionSize();
        int totalLiveStreamSize = this.getApplication().getTotalLiveStreamSize();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("totalConnectionSize", (Number)totalConnectionSize);
        jsonObject.addProperty("totalLiveStreamSize", (Number)totalLiveStreamSize);
        return this.gson.toJson((JsonElement)jsonObject);
    }

    public String getApplicationInfo() {
        List<AdminApplication.ApplicationInfo> info = this.getApplication().getApplicationInfo();
        return this.gson.toJson(info);
    }

    public String getAppLiveStreams(@PathParam(value="appname") String name) {
        List<AdminApplication.BroadcastInfo> appLiveStreams = this.getApplication().getAppLiveStreams(name);
        return this.gson.toJson(appLiveStreams);
    }

    public String deleteVoDStream(@PathParam(value="appname") String name, @FormParam(value="streamName") String streamName) {
        boolean deleteVoDStream = this.getApplication().deleteVoDStream(name, streamName);
        return this.gson.toJson((Object)new Result(deleteVoDStream));
    }

    public String changeSettings(@PathParam(value="appname") String appname, AppSettings newSettings) {
        AntMediaApplicationAdapter adapter = (AntMediaApplicationAdapter)this.getApplication().getApplicationContext(appname).getBean("web.handler");
        return this.gson.toJson((Object)new Result(adapter.updateSettings(newSettings, true, false)));
    }

    public boolean getShutdownStatus(@QueryParam(value="appNames") String appNamesArray) {
        String[] appNames;
        boolean appShutdownProblemExists = false;
        if (appNamesArray != null && (appNames = appNamesArray.split(",")) != null) {
            for (String appName : appNames) {
                AntMediaApplicationAdapter appAdaptor = this.getAppAdaptor(appName);
                if (appAdaptor.isShutdownProperly()) continue;
                appShutdownProblemExists = true;
                break;
            }
        }
        return !appShutdownProblemExists;
    }

    public AntMediaApplicationAdapter getAppAdaptor(String appName) {
        ApplicationContext context;
        AntMediaApplicationAdapter appAdaptor = null;
        AdminApplication application = this.getApplication();
        if (application != null && (context = application.getApplicationContext(appName)) != null) {
            appAdaptor = (AntMediaApplicationAdapter)context.getBean("web.handler");
        }
        return appAdaptor;
    }

    public Response isShutdownProperly(@QueryParam(value="appNames") String appNamesArray) {
        boolean appShutdownProblemExists = false;
        Response response = null;
        if (appNamesArray != null) {
            String[] appNames = appNamesArray.split(",");
            if (appNames != null) {
                for (String appName : appNames) {
                    AntMediaApplicationAdapter appAdaptor = this.getAppAdaptor(appName);
                    if (appAdaptor != null) {
                        if (appAdaptor.isShutdownProperly()) continue;
                        appShutdownProblemExists = true;
                    } else {
                        response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Result(false, "Either server may not be initialized or application name that does not exist is requested. ")).build();
                    }
                    break;
                }
            } else {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Bad parameter for appNames. ")).build();
            }
        } else {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Result(false, "Bad parameter for appNames. ")).build();
        }
        if (response == null) {
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)new Result(!appShutdownProblemExists)).build();
        }
        return response;
    }

    public boolean setShutdownStatus(@QueryParam(value="appNames") String appNamesArray) {
        String[] appNames = appNamesArray.split(",");
        boolean result = true;
        for (String appName : appNames) {
            AntMediaApplicationAdapter appAdaptor = this.getAppAdaptor(appName);
            if (appAdaptor == null) continue;
            appAdaptor.setShutdownProperly(true);
        }
        return result;
    }

    public static String extractFQDN(String domainName) {
        String regex = "([A-Za-z0-9-]{1,63}\\.){1,10}[A-Za-z]{2,6}";
        Pattern pattern = Pattern.compile(regex);
        if (domainName != null) {
            Matcher matcher = pattern.matcher(domainName);
            if (matcher.find()) {
                return matcher.group();
            }
            return null;
        }
        return null;
    }

    public Result configureSsl(String domainName, String type, InputStream fullChainFile, FormDataContentDisposition fullChainFileDetail, InputStream privateKeyFile, FormDataContentDisposition privateKeyFileDetail, InputStream chainFile, FormDataContentDisposition chainFileDetail) {
        boolean parametersValid = false;
        String responseMessage = null;
        SslConfigurator sslConfigurator = new SslConfigurator();
        File sslTempDir = null;
        SslConfigurationType sslConfigurationType = this.getSSLConfigurationType(type);
        String fqdn = CommonRestService.extractFQDN(domainName);
        if (fqdn == null && sslConfigurationType != SslConfigurationType.ANTMEDIA_SUBDOMAIN) {
            responseMessage = "Invalid domain name parameter";
        } else if (sslConfigurationType == SslConfigurationType.CUSTOM_CERTIFICATE) {
            if (this.isCustomCertificateParamsValid(fullChainFile, fullChainFileDetail, privateKeyFile, privateKeyFileDetail, chainFile, chainFileDetail)) {
                String systemTempDir = System.getProperty("java.io.tmpdir");
                String sslTempDirName = "ssl-tmp-ant-media";
                sslTempDir = new File(systemTempDir, sslTempDirName);
                sslTempDir.mkdirs();
                File fullChainOutputFile = new File(sslTempDir, FilenameUtils.getName((String)fullChainFileDetail.getFileName()));
                File privateKeyOutputFile = new File(sslTempDir, FilenameUtils.getName((String)privateKeyFileDetail.getFileName()));
                File chainOutputFile = new File(sslTempDir, FilenameUtils.getName((String)chainFileDetail.getFileName()));
                sslConfigurator.setFullChainFile(fullChainOutputFile);
                sslConfigurator.setPrivateKeyFile(privateKeyOutputFile);
                sslConfigurator.setChainFile(chainOutputFile);
                Result tmp = this.prepareCertificateFiles(fullChainFile, fullChainOutputFile, privateKeyFile, privateKeyOutputFile, chainFile, chainOutputFile);
                parametersValid = tmp.isSuccess();
                responseMessage = tmp.getMessage();
            } else {
                responseMessage = "Missing parameters for custom SSL certificate. Please provide domain name, fullChain, private key, and chain";
            }
        } else if (sslConfigurationType == SslConfigurationType.CUSTOM_DOMAIN || sslConfigurationType == SslConfigurationType.ANTMEDIA_SUBDOMAIN) {
            parametersValid = true;
        } else {
            responseMessage = "Unknown SSL configuration type";
        }
        Result result = new Result(false);
        if (parametersValid) {
            sslConfigurator.setDomain(fqdn);
            sslConfigurator.setType(sslConfigurationType);
            String command = sslConfigurator.getCommand();
            if (command != null) {
                AdminApplication adminApplication = this.getApplication();
                if (adminApplication != null) {
                    result.setSuccess(adminApplication.runCommand(command));
                }
            } else {
                result.setMessage("Undefined configuration type");
            }
        } else {
            result.setMessage(responseMessage);
        }
        this.deleteSSLTempDirIfExists(sslTempDir);
        return result;
    }

    private SslConfigurationType getSSLConfigurationType(String type) {
        if (type != null) {
            try {
                return SslConfigurationType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return null;
    }

    private boolean isCustomCertificateParamsValid(InputStream fullChainFile, FormDataContentDisposition fullChainFileDetail, InputStream privateKeyFile, FormDataContentDisposition privateKeyFileDetail, InputStream chainFile, FormDataContentDisposition chainFileDetail) {
        return fullChainFile != null && fullChainFileDetail != null && fullChainFileDetail.getFileName() != null && !fullChainFileDetail.getFileName().isEmpty() && privateKeyFile != null && privateKeyFileDetail != null && privateKeyFileDetail.getFileName() != null && !privateKeyFileDetail.getFileName().isEmpty() && chainFile != null && chainFileDetail != null && chainFileDetail.getFileName() != null && !chainFileDetail.getFileName().isEmpty();
    }

    private Result prepareCertificateFiles(InputStream fullChainFile, File fullChainOutputFile, InputStream privateKeyFile, File privateKeyOutputFile, InputStream chainFile, File chainOutputFile) {
        boolean result = false;
        String message = null;
        try {
            Files.copy(fullChainFile, fullChainOutputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(privateKeyFile, privateKeyOutputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(chainFile, chainOutputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            result = true;
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            message = "Certificate file operation is not succesful due to " + e.getMessage();
        }
        return new Result(result, message);
    }

    private void deleteSSLTempDirIfExists(File sslTempDir) {
        if (sslTempDir != null && sslTempDir.exists()) {
            try {
                FileUtils.forceDelete((File)sslTempDir);
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public String changeServerSettings(ServerSettings serverSettings) {
        PreferenceStore store = new PreferenceStore(RED5_PROPERTIES_PATH);
        String serverName = "";
        String licenceKey = "";
        if (serverSettings.getServerName() != null) {
            serverName = serverSettings.getServerName();
        }
        store.put(SERVER_NAME, serverName);
        this.getServerSettingsInternal().setServerName(serverName);
        if (serverSettings.getLicenceKey() != null) {
            licenceKey = serverSettings.getLicenceKey();
        }
        store.put(LICENSE_KEY, licenceKey);
        this.getServerSettingsInternal().setLicenceKey(licenceKey);
        store.put(NODE_GROUP, String.valueOf(serverSettings.getNodeGroup()));
        this.getServerSettingsInternal().setNodeGroup(serverSettings.getNodeGroup());
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        if (LOG_LEVEL_ALL.equals(serverSettings.getLogLevel()) || LOG_LEVEL_TRACE.equals(serverSettings.getLogLevel()) || LOG_LEVEL_DEBUG.equals(serverSettings.getLogLevel()) || LOG_LEVEL_INFO.equals(serverSettings.getLogLevel()) || LOG_LEVEL_WARN.equals(serverSettings.getLogLevel()) || LOG_LEVEL_ERROR.equals(serverSettings.getLogLevel()) || LOG_LEVEL_OFF.equals(serverSettings.getLogLevel())) {
            rootLogger.setLevel(this.currentLevelDetect(serverSettings.getLogLevel()));
            store.put(LOG_LEVEL, serverSettings.getLogLevel());
            this.getServerSettingsInternal().setLogLevel(serverSettings.getLogLevel());
        }
        return this.gson.toJson((Object)new Result(store.save()));
    }

    public Result isEnterpriseEdition() {
        boolean isEnterprise = RestServiceBase.isEnterprise();
        return new Result(isEnterprise, "");
    }

    public AppSettings getSettings(String appname) {
        AntMediaApplicationAdapter appAdaptor = this.getAppAdaptor(appname);
        if (appAdaptor != null) {
            return appAdaptor.getAppSettings();
        }
        logger.warn("getSettings for app: {} returns null. It's likely not initialized.", (Object)appname);
        return null;
    }

    public IStatsCollector getStatsCollector() {
        WebApplicationContext ctxt;
        if (this.statsCollector == null && (ctxt = this.getContext()) != null) {
            this.statsCollector = (IStatsCollector)ctxt.getBean("statsCollector");
        }
        return this.statsCollector;
    }

    public ServerSettings getServerSettings() {
        return this.getServerSettingsInternal();
    }

    public Licence getLicenceStatus(@QueryParam(value="key") String key) {
        if (key == null) {
            return null;
        }
        return this.getLicenceServiceInstance().checkLicence(key);
    }

    public Licence getLicenceStatus() {
        return this.getLicenceServiceInstance().getLastLicenseStatus();
    }

    public Result resetBroadcast(@PathParam(value="appname") String appname) {
        AntMediaApplicationAdapter appAdaptor = this.getAppAdaptor(appname);
        if (appAdaptor != null) {
            return appAdaptor.resetBroadcasts();
        }
        return new Result(false, "No application adaptor with this name " + appname);
    }

    public void setDataStore(AbstractConsoleDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public AbstractConsoleDataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.getDataStoreFactory().getDataStore();
        }
        return this.dataStore;
    }

    public WebApplicationContext getContext() {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
    }

    public ServerSettings getServerSettingsInternal() {
        WebApplicationContext ctxt;
        if (this.serverSettings == null && (ctxt = this.getContext()) != null) {
            this.serverSettings = (ServerSettings)ctxt.getBean("ant.media.server.settings");
        }
        return this.serverSettings;
    }

    public ILicenceService getLicenceServiceInstance() {
        WebApplicationContext ctxt;
        if (this.licenceService == null && (ctxt = this.getContext()) != null) {
            this.licenceService = (ILicenceService)ctxt.getBean(ILicenceService.BeanName.LICENCE_SERVICE.toString());
        }
        return this.licenceService;
    }

    public AdminApplication getApplication() {
        WebApplicationContext ctxt = this.getContext();
        if (ctxt != null) {
            return (AdminApplication)ctxt.getBean("web.handler");
        }
        return null;
    }

    public ConsoleDataStoreFactory getDataStoreFactory() {
        WebApplicationContext ctxt;
        if (this.dataStoreFactory == null && (ctxt = this.getContext()) != null) {
            this.dataStoreFactory = (ConsoleDataStoreFactory)ctxt.getBean("dataStoreFactory");
        }
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(ConsoleDataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public Result isInClusterMode() {
        return new Result(this.isClusterMode(), "");
    }

    public String changeLogSettings(@PathParam(value="level") String logLevel) {
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        PreferenceStore store = new PreferenceStore(RED5_PROPERTIES_PATH);
        if (logLevel.equals(LOG_LEVEL_ALL) || logLevel.equals(LOG_LEVEL_TRACE) || logLevel.equals(LOG_LEVEL_DEBUG) || logLevel.equals(LOG_LEVEL_INFO) || logLevel.equals(LOG_LEVEL_WARN) || logLevel.equals(LOG_LEVEL_ERROR) || logLevel.equals(LOG_LEVEL_OFF)) {
            rootLogger.setLevel(this.currentLevelDetect(logLevel));
            store.put(LOG_LEVEL, logLevel);
        }
        return this.gson.toJson((Object)new Result(store.save()));
    }

    public Level currentLevelDetect(String logLevel) {
        if (logLevel.equals(LOG_LEVEL_OFF)) {
            Level currentLevel = Level.OFF;
            return currentLevel;
        }
        if (logLevel.equals(LOG_LEVEL_ERROR)) {
            Level currentLevel = Level.ERROR;
            return currentLevel;
        }
        if (logLevel.equals(LOG_LEVEL_WARN)) {
            Level currentLevel = Level.WARN;
            return currentLevel;
        }
        if (logLevel.equals(LOG_LEVEL_DEBUG)) {
            Level currentLevel = Level.DEBUG;
            return currentLevel;
        }
        if (logLevel.equals(LOG_LEVEL_TRACE)) {
            Level currentLevel = Level.ALL;
            return currentLevel;
        }
        if (logLevel.equals(LOG_LEVEL_ALL)) {
            Level currentLevel = Level.ALL;
            return currentLevel;
        }
        Level currentLevel = Level.INFO;
        return currentLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogFile(@PathParam(value="charSize") int charSize, @QueryParam(value="logType") String logType, @PathParam(value="offsetSize") long offsetSize) throws IOException {
        long skipValue = 0L;
        int countKb = 0;
        int maxCount = 500;
        String logLocation = SERVER_LOG_LOCATION;
        if (logType.equals(LOG_TYPE_ERROR)) {
            logLocation = ERROR_LOG_LOCATION;
        }
        JsonObject jsonObject = new JsonObject();
        String logContent = "";
        File file = new File(logLocation);
        if (!file.isFile()) {
            logContent = FILE_NOT_EXIST;
            jsonObject.addProperty(LOG_CONTENT, logContent);
            return jsonObject.toString();
        }
        if (charSize > 512000) {
            charSize = 512000;
        }
        if (offsetSize != -1L) {
            skipValue = offsetSize;
            maxCount = charSize / 1024;
        } else if (file.length() > (long)charSize) {
            skipValue = file.length() - (long)charSize;
        }
        int contentSize = 0;
        if (file.length() > skipValue) {
            ByteArrayOutputStream ous = null;
            InputStream ios = null;
            try {
                byte[] buffer = new byte[1024];
                ous = new ByteArrayOutputStream();
                ios = new FileInputStream(file);
                ios.skip(skipValue);
                int read = 0;
                while ((read = ios.read(buffer)) != -1) {
                    ous.write(buffer, 0, read);
                    contentSize += read;
                    if (++countKb != maxCount) continue;
                    break;
                }
            }
            finally {
                try {
                    if (ous != null) {
                        ous.close();
                    }
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
                try {
                    if (ios != null) {
                        ios.close();
                    }
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
            logContent = ous.toString("UTF-8");
        }
        jsonObject.addProperty(LOG_CONTENT, logContent);
        jsonObject.addProperty(LOG_CONTENT_SIZE, (Number)contentSize);
        jsonObject.addProperty(LOG_FILE_SIZE, (Number)file.length());
        return jsonObject.toString();
    }

    public String getMD5Hash(String pass) {
        String passResult = "";
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.reset();
            m.update(pass.getBytes(Charset.forName("UTF8")));
            byte[] digestResult = m.digest();
            passResult = Hex.encodeHexString((byte[])digestResult);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return passResult;
    }

    public Result createApplication(String appName, InputStream inputStream) {
        appName = appName.replaceAll("[\n\r\t]", "_");
        File warFile = null;
        if (inputStream != null && (warFile = AdminApplication.saveWARFile(appName, inputStream)) == null) {
            return new Result(false, "Cannot save the WAR file for appName:{}", appName);
        }
        if (this.isClusterMode()) {
            IClusterNotifier clusterNotifier = this.getApplication().getClusterNotifier();
            long deletedRecordCount = clusterNotifier.getClusterStore().deleteAppSettings(appName);
            if (deletedRecordCount > 0L) {
                logger.info("App detected in the database. It's likely the app with the same name {} is re-creating. ", (Object)appName);
            }
            if (warFile != null) {
                AppSettings tempSetting = new AppSettings();
                tempSetting.setAppName(appName);
                tempSetting.setPullWarFile(true);
                tempSetting.setWarFileOriginServerAddress(this.getServerSettings().getHostAddress());
                clusterNotifier.getClusterStore().saveSettings(tempSetting);
            }
        }
        Result result = new Result(false);
        if (this.getApplication().createApplication(appName, warFile != null ? warFile.getAbsolutePath() : null)) {
            result.setSuccess(true);
            boolean applicationCreated = false;
            for (int i = 0; i < 20; ++i) {
                try {
                    Thread.sleep(1000L);
                    IScope scope = this.getApplication().getRootScope().getScope(appName);
                    if (scope == null) continue;
                    applicationCreated = true;
                    break;
                }
                catch (InterruptedException e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    Thread.currentThread().interrupt();
                }
            }
            if (!applicationCreated) {
                result.setSuccess(applicationCreated);
                result.setMessage("Application " + appName + "is not created in the 20 seconds.");
            }
        }
        return result;
    }

    public Result deleteApplication(String appName, boolean deleteDB) {
        appName = appName.replaceAll("[\n\r\t]", "_");
        boolean result = false;
        Object message = "";
        if (appName != null && appName.matches("^[a-zA-Z0-9]*$")) {
            logger.info("delete application http request:{}", (Object)appName);
            AppSettings appSettings = this.getSettings(appName);
            if (appSettings != null) {
                appSettings.setToBeDeleted(true);
                this.changeSettings(appName, appSettings);
                result = this.getApplication().deleteApplication(appName, deleteDB);
            } else {
                logger.info("App settings is not available for app name:{}. App may be initializing", (Object)appName);
                message = "AppSettings is not available for app: " + appName + ". It's not available or it's being initialized";
            }
        } else {
            message = "appname contains invalid character and does not match regexp ^[a-zA-Z0-9]*$";
        }
        return new Result(result, (String)message);
    }

    public boolean isClusterMode() {
        boolean result = false;
        WebApplicationContext ctxt = this.getContext();
        if (ctxt != null) {
            result = ctxt.containsBean("tomcat.cluster");
        }
        return result;
    }

    public Result getBlockedStatus(String usermail) {
        return new Result(this.getDataStore().isUserBlocked(usermail));
    }
}

