/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.antmedia.AppSettings;
import io.antmedia.console.rest.CommonRestService;
import io.antmedia.datastore.db.types.Licence;
import io.antmedia.datastore.db.types.User;
import io.antmedia.rest.model.Result;
import io.antmedia.settings.ServerSettings;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Contact;
import io.swagger.annotations.ExternalDocs;
import io.swagger.annotations.Info;
import io.swagger.annotations.License;
import io.swagger.annotations.SwaggerDefinition;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Api(value="ManagementRestService")
@SwaggerDefinition(info=@Info(description="Ant Media Server Management Panel REST API", version="v2.0", title="Ant Media Server Management Panel REST API", contact=@Contact(name="Ant Media Info", email="contact@antmedia.io", url="https://antmedia.io"), license=@License(name="Apache 2.0", url="http://www.apache.org")), consumes={"application/json"}, produces={"application/json"}, schemes={SwaggerDefinition.Scheme.HTTP, SwaggerDefinition.Scheme.HTTPS}, externalDocs=@ExternalDocs(value="External Docs", url="https://antmedia.io"))
@Component
@Path(value="/v2")
public class RestServiceV2
extends CommonRestService {
    @Override
    @ApiOperation(value="Creates a new user. If user object is null or if user is not authenticated, new user won't be created.", response=Result.class)
    @POST
    @Path(value="/users")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result addUser(@ApiParam(value="User object. If it is null, new user won't be created.", required=true, readOnly=true) User user) {
        return super.addUser(user);
    }

    @Override
    @ApiOperation(value="Edit the user in the server management panel's user list. It can change password or user type(admin, read only) ", response=List.class)
    @PUT
    @Path(value="/users")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result editUser(@ApiParam(value="User to be edited. It finds the user with username.", required=true) User user) {
        return super.editUser(user);
    }

    @Override
    @ApiOperation(value="Delete the user from the server management panel's user list", response=List.class)
    @DELETE
    @Path(value="/users/{username}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Result deleteUser(@ApiParam(value="User name or e-mail of the user to be deleted", required=true) @PathParam(value="username") String userName) {
        return super.deleteUser(userName);
    }

    @Override
    @ApiOperation(value="Returns if user is blocked. User is blocked for a specific time if there are login attempts")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/users/{usermail}/blocked")
    @Produces(value={"application/json"})
    public Result getBlockedStatus(@ApiParam(value="User name or e-mail of the user to check it status") @PathParam(value="usermail") String usermail) {
        return super.getBlockedStatus(usermail);
    }

    @Override
    @ApiOperation(value="Returns user list in the server management panel", response=List.class)
    @GET
    @Path(value="/user-list")
    @Produces(value={"application/json"})
    public List<User> getUserList() {
        return super.getUserList();
    }

    @Override
    @ApiOperation(value="Returns whether current user is admin or not. If user is admin, it can call POST/PUT/DELETE methods", response=Result.class)
    @GET
    @Path(value="/admin-status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result isAdmin() {
        return super.isAdmin();
    }

    @Override
    @ApiOperation(value="Creates initial user. This is a one time scenario when initial user creation required and shouldn't be used otherwise. User object is required and can't be null", response=Result.class)
    @POST
    @Path(value="/users/initial")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result addInitialUser(@ApiParam(value="User object. If it is null, new user won't be created.", required=true) User user) {
        return super.addInitialUser(user);
    }

    @Override
    @ApiOperation(value="Checks first login status. If server being logged in first time, it returns true, otherwise false.", response=Result.class)
    @GET
    @Path(value="/first-login-status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result isFirstLogin() {
        return super.isFirstLogin();
    }

    @Override
    @ApiOperation(value="Authenticates user with given username and password. Requires user object to authenticate.", response=Result.class)
    @POST
    @Path(value="/users/authenticate")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result authenticateUser(@ApiParam(value="User object to authenticate", required=true) User user) {
        return super.authenticateUser(user);
    }

    @Override
    @ApiOperation(value="Changes the given user's password.", response=Result.class)
    @POST
    @Path(value="/users/password")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result changeUserPassword(@ApiParam(value="User object to change the password", required=true) User user) {
        return super.changeUserPassword(user);
    }

    @Override
    @ApiOperation(value="Returns true if user is authenticated to call rest api operations.", response=Result.class)
    @GET
    @Path(value="/authentication-status")
    @Produces(value={"application/json"})
    public Result isAuthenticatedRest() {
        return super.isAuthenticatedRest();
    }

    @Override
    @ApiOperation(value="Returns system information which includes many information such as JVM memory, OS information, Available File Space, Physical memory informations in detail.", response=Result.class)
    @GET
    @Path(value="/system-status")
    @Produces(value={"application/json"})
    public String getSystemInfo() {
        return super.getSystemInfo();
    }

    @Override
    @ApiOperation(value="Returns JVM memory informations. Max, total, free, in-use and available processors are returned.", response=Result.class)
    @GET
    @Path(value="/jvm-memory-status")
    @Produces(value={"application/json"})
    public String getJVMMemoryInfo() {
        return super.getJVMMemoryInfo();
    }

    @Override
    @ApiOperation(value="Gets system memory status. Returns Virtual, total physical, available physical, currently in use, total swap space, available swap space and in use swap space. ", response=Result.class)
    @GET
    @Path(value="/system-memory-status")
    @Produces(value={"application/json"})
    public String getSystemMemoryInfo() {
        return super.getSystemMemoryInfo();
    }

    @Override
    @ApiOperation(value="Gets system file status. Returns usable space, total space, available space and in use space.", response=Result.class)
    @GET
    @Path(value="/file-system-status")
    @Produces(value={"application/json"})
    public String getFileSystemInfo() {
        return super.getFileSystemInfo();
    }

    @Override
    @ApiOperation(value="Returns system cpu load, process cpu load and process cpu time.", response=Result.class)
    @GET
    @Path(value="/cpu-status")
    @Produces(value={"application/json"})
    public String getCPUInfo() {
        return super.getCPUInfo();
    }

    @Override
    @ApiOperation(value="Gets thread dump in plain text.Includes very detailed information such as thread name, thread id, blocked time of thread, thread state and many more information are returned.", response=Result.class)
    @GET
    @Path(value="/thread-dump")
    @Produces(value={"text/plain"})
    public String getThreadDump() {
        return super.getThreadDump();
    }

    @Override
    @ApiOperation(value="Gets thread dump in json format. Includes very detailed information such as thread name, thread id, blocked time of thread, thread state and many more information are returned.", response=Result.class)
    @GET
    @Path(value="/thread-dump")
    @Produces(value={"application/json"})
    public String getThreadDumpJSON() {
        return super.getThreadDumpJSON();
    }

    @Override
    @ApiOperation(value="Returns processor's thread information. Includes number of dead locked threads, thread count, and thread peek count.", response=Result.class)
    @GET
    @Path(value="/threads")
    @Produces(value={"application/json"})
    public String getThreadsInfo() {
        return super.getThreadsInfo();
    }

    @Override
    @ApiOperation(value="Returns heap dump.", response=Result.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Returns the heap dump")})
    @GET
    @Path(value="/heap-dump")
    @Produces(value={"application/octet-stream"})
    public Response getHeapDump() {
        return super.getHeapDump();
    }

    @Override
    @ApiOperation(value="Gets server time. Returns server uptime and start time in milliseconds in JSON.", response=Result.class)
    @GET
    @Path(value="/server-time")
    @Produces(value={"application/json"})
    public String getServerTime() {
        return super.getServerTime();
    }

    @Override
    @ApiOperation(value="Gets system resource information. Returns number of total live streams, cpu usage, system information, jvm information, file system information, license status, gpu status etc. Basically returns most of the information in one package.", response=Result.class)
    @GET
    @Path(value="/system-resources")
    @Produces(value={"application/json"})
    public String getSystemResourcesInfo() {
        return super.getSystemResourcesInfo();
    }

    @Override
    @ApiOperation(value="Gets GPU information. Returns whether you have GPU or not. If yes, information of the gpu and the number of total gpus.", response=Result.class)
    @GET
    @Path(value="/gpu-status")
    @Produces(value={"application/json"})
    public String getGPUInfo() {
        return super.getGPUInfo();
    }

    @Override
    @ApiOperation(value="Returns the version of Ant Media Server.", response=Result.class)
    @GET
    @Path(value="/version")
    @Produces(value={"application/json"})
    public String getVersion() {
        return super.getVersion();
    }

    @ApiOperation(value="Trigger garbage collector.", notes="", response=Result.class)
    @POST
    @Path(value="/system/gc")
    @Produces(value={"application/json"})
    public Result triggerGc() {
        System.gc();
        return new Result(true);
    }

    @Override
    @ApiOperation(value="Gets the applications in the server. Returns the name of the applications in JSON format.", response=Result.class)
    @GET
    @Path(value="/applications")
    @Produces(value={"application/json"})
    public String getApplications() {
        return super.getApplications();
    }

    @Override
    @ApiOperation(value="Returns total number of live streams and total number of connections.", response=Result.class)
    @GET
    @Path(value="/live-clients-size")
    @Produces(value={"application/json"})
    public String getLiveClientsSize() {
        return super.getLiveClientsSize();
    }

    @Override
    @ApiOperation(value="Gets application info. Application info includes live stream count, vod count and application name.", response=Result.class)
    @GET
    @Path(value="/applications-info")
    @Produces(value={"application/json"})
    public String getApplicationInfo() {
        return super.getApplicationInfo();
    }

    @Override
    @ApiOperation(value="Returns live streams in the specified application. Retrieves broadcast names and the consumer size.", response=Result.class)
    @GET
    @Path(value="/applications/live-streams/{appname}")
    @Produces(value={"application/json"})
    public String getAppLiveStreams(@ApiParam(value="Application name", required=true) @PathParam(value="appname") String name) {
        return super.getAppLiveStreams(name);
    }

    @Override
    @ApiOperation(value="Changes the application settings with the given settings. Null fields will be set to default values.", response=Result.class)
    @POST
    @Path(value="/applications/settings/{appname}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String changeSettings(@ApiParam(value="Application name", required=true) @PathParam(value="appname") String appname, @ApiParam(value="New application settings, null fields will be set to default values", required=true) AppSettings newSettings) {
        return super.changeSettings(appname, newSettings);
    }

    @Override
    @ApiOperation(value="Checks whether application or applications have shutdown properly or not.", response=Result.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Returns the shutdown status of entered applications."), @ApiResponse(code=400, message="Either entered in wrong format or typed incorrectly application names")})
    @GET
    @Path(value="/shutdown-proper-status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response isShutdownProperly(@ApiParam(value="Application name", required=true) @QueryParam(value="appNames") String appNamesArray) {
        return super.isShutdownProperly(appNamesArray);
    }

    @Override
    @ApiOperation(value="Set application or applications shutdown property to true", response=Result.class)
    @GET
    @Path(value="/shutdown-properly")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public boolean setShutdownStatus(@ApiParam(value="Application name", required=true) @QueryParam(value="appNames") String appNamesArray) {
        return super.setShutdownStatus(appNamesArray);
    }

    @Override
    @ApiOperation(value="Changes server settings. Sets Server Name, license key, market build status and node group.", response=Result.class)
    @POST
    @Path(value="/server-settings")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String changeServerSettings(@ApiParam(value="Server settings", required=true) ServerSettings serverSettings) {
        return super.changeServerSettings(serverSettings);
    }

    @Override
    @ApiOperation(value="Changes ssl settings. Sets ssl configuration type. After this method is called, server will be restarted.", response=Result.class)
    @POST
    @Path(value="/ssl-settings")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Result configureSsl(@ApiParam(value="SSL settings", required=true) @QueryParam(value="domain") String domain, @QueryParam(value="type") String type, @FormDataParam(value="fullChainFile") InputStream fullChainFile, @FormDataParam(value="fullChainFile") FormDataContentDisposition fullChainFileDetail, @FormDataParam(value="privateKeyFile") InputStream privateKeyFile, @FormDataParam(value="privateKeyFile") FormDataContentDisposition privateKeyFileDetail, @FormDataParam(value="chainFile") InputStream chainFile, @FormDataParam(value="chainFile") FormDataContentDisposition chainFileDetail) {
        return super.configureSsl(domain, type, fullChainFile, fullChainFileDetail, privateKeyFile, privateKeyFileDetail, chainFile, chainFileDetail);
    }

    @Override
    @ApiOperation(value="Returns true if the server is enterprise edition.", response=Result.class)
    @GET
    @Path(value="/enterprise-edition")
    @Produces(value={"application/json"})
    public Result isEnterpriseEdition() {
        return super.isEnterpriseEdition();
    }

    @Override
    @ApiOperation(value="Returns the specified application settings", response=Result.class)
    @GET
    @Path(value="/applications/settings/{appname}")
    @Produces(value={"application/json"})
    public AppSettings getSettings(@ApiParam(value="Application name", required=true) @PathParam(value="appname") String appname) {
        return super.getSettings(appname);
    }

    @Override
    @ApiOperation(value="Returns the server settings. From log level to measurement period of cpu, license key of the server host address,ssl configuration and many more settings are returned at once.", response=Result.class)
    @GET
    @Path(value="/server-settings")
    @Produces(value={"application/json"})
    public ServerSettings getServerSettings() {
        return super.getServerSettings();
    }

    @Override
    @ApiOperation(value="Returns license status. Includes license ID, status, owner, start date, end date, type and license count.", response=Result.class)
    @GET
    @Path(value="/licence-status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Licence getLicenceStatus(@ApiParam(value="License key", required=true) @QueryParam(value="key") String key) {
        return super.getLicenceStatus(key);
    }

    @Override
    @ApiOperation(value="Returns the last checked license status. Includes license ID, owner, start date, end date, type and license count.", response=Result.class)
    @GET
    @Path(value="/last-licence-status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Licence getLicenceStatus() {
        return super.getLicenceStatus();
    }

    @Override
    @ApiOperation(value="Resets the viewer counts and broadcasts statuses in the db. This can be used after server crashes to recover db. It's not intended to use to ignore the crash.", response=Result.class)
    @POST
    @Path(value="/applications/{appname}/reset")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Result resetBroadcast(@ApiParam(value="Application name", required=true) @PathParam(value="appname") String appname) {
        return super.resetBroadcast(appname);
    }

    @Override
    @ApiOperation(value="Returns the server mode. If it is in the cluster mode, result will be true.", response=Result.class)
    @GET
    @Path(value="/cluster-mode-status")
    @Produces(value={"application/json"})
    public Result isInClusterMode() {
        return super.isInClusterMode();
    }

    @Override
    @ApiOperation(value="Gets log file. Char size of the log, offset or log type can be specified.", response=Result.class)
    @GET
    @Path(value="/log-file/{offsetSize}/{charSize}")
    @Produces(value={"application/json"})
    public String getLogFile(@ApiParam(value="Char size of the log", required=true) @PathParam(value="charSize") int charSize, @ApiParam(value="Log type. ERROR can be used to get only error logs", required=true) @QueryParam(value="logType") String logType, @ApiParam(value="Offset of the retrieved log", required=true) @PathParam(value="offsetSize") long offsetSize) throws IOException {
        return super.getLogFile(charSize, logType, offsetSize);
    }

    @ApiOperation(value="Creates a new application with given name. It just creates default app", response=Result.class)
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/applications/{appName}")
    @Produces(value={"application/json"})
    public Result createApplication(@ApiParam(value="Name for the new application", required=true) @PathParam(value="appName") String appName) {
        return this.createApplication(appName, null);
    }

    @Override
    @ApiOperation(value="Creates a new application with given name. It supports uploading custom WAR files", response=Result.class)
    @PUT
    @Consumes(value={"multipart/form-data"})
    @Path(value="/applications/{appName}")
    @Produces(value={"application/json"})
    public Result createApplication(@ApiParam(value="Name for the new application", required=true) @PathParam(value="appName") String appName, @ApiParam(value="file", required=true) @FormDataParam(value="file") InputStream inputStream) {
        boolean applicationAlreadyExist;
        Result result = appName != null && appName.matches("^[a-zA-Z0-9]*$") ? (!(applicationAlreadyExist = this.isApplicationExists(appName)) ? super.createApplication(appName, inputStream) : new Result(false, "Application with the same name already exists")) : new Result(false, "Application name is not alphanumeric. Please provide alphanumeric characters");
        return result;
    }

    public boolean isApplicationExists(String appName) {
        return this.getApplication().getRootScope().getScope(appName) != null;
    }

    @Override
    @ApiOperation(value="Deletes application with the given name.", response=Result.class)
    @DELETE
    @Path(value="/applications/{appName}")
    @Produces(value={"application/json"})
    public Result deleteApplication(@ApiParam(value="Name of the application to delete", required=true) @PathParam(value="appName") String appName, @QueryParam(value="deleteDB") boolean deleteDB) {
        if (appName != null) {
            return super.deleteApplication(appName, deleteDB);
        }
        return new Result(false, "Application name is not defined");
    }

    @ApiOperation(value="Returns the hostname to check liveness with HTTP type healthcheck.", response=Response.class)
    @GET
    @Path(value="/liveness")
    @Produces(value={"application/json"})
    public Response liveness() {
        Response.Status statusCode;
        String status;
        long startTimeMs = System.currentTimeMillis();
        JsonObject jsonObject = new JsonObject();
        String hostname = this.getHostname();
        if (hostname != null) {
            status = "ok";
            statusCode = Response.Status.OK;
        } else {
            hostname = "unknown";
            status = "error";
            statusCode = Response.Status.INTERNAL_SERVER_ERROR;
        }
        jsonObject.addProperty("host", hostname);
        jsonObject.addProperty("status", status);
        Gson gson = new Gson();
        long elapsedTimeMs = System.currentTimeMillis() - startTimeMs;
        if (elapsedTimeMs > 1000L) {
            logger.warn("GET liveness method takes {}ms to return", (Object)elapsedTimeMs);
        }
        return Response.status((Response.Status)statusCode).entity((Object)gson.toJson((JsonElement)jsonObject)).build();
    }

    public String getHostname() {
        String hostname = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostname = inetAddress.getHostName();
        }
        catch (UnknownHostException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return hostname;
    }
}

