/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.P2PConnection;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.datastore.db.types.WebRTCViewerInfo;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDataStore
extends DataStore {
    protected static Logger logger = LoggerFactory.getLogger(InMemoryDataStore.class);
    private Map<String, Broadcast> broadcastMap = new LinkedHashMap<String, Broadcast>();
    private Map<String, VoD> vodMap = new LinkedHashMap<String, VoD>();
    private Map<String, List<TensorFlowObject>> detectionMap = new LinkedHashMap<String, List<TensorFlowObject>>();
    private Map<String, Token> tokenMap = new LinkedHashMap<String, Token>();
    private Map<String, Subscriber> subscriberMap = new LinkedHashMap<String, Subscriber>();
    private Map<String, ConferenceRoom> roomMap = new LinkedHashMap<String, ConferenceRoom>();
    private Map<String, WebRTCViewerInfo> webRTCViewerMap = new LinkedHashMap<String, WebRTCViewerInfo>();

    public InMemoryDataStore(String dbName) {
        this.available = true;
    }

    @Override
    public String save(Broadcast broadcast) {
        String streamId = null;
        if (broadcast != null) {
            try {
                if (broadcast.getStreamId() == null || broadcast.getStreamId().isEmpty()) {
                    streamId = RandomStringUtils.randomNumeric((int)24);
                    broadcast.setStreamId(streamId);
                }
                streamId = broadcast.getStreamId();
                Object rtmpURL = broadcast.getRtmpURL();
                if (rtmpURL != null) {
                    rtmpURL = (String)rtmpURL + streamId;
                }
                broadcast.setRtmpURL((String)rtmpURL);
                if (broadcast.getStatus() == null) {
                    broadcast.setStatus("created");
                }
                this.broadcastMap.put(streamId, broadcast);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                streamId = null;
            }
        }
        return streamId;
    }

    @Override
    public Broadcast get(String id) {
        return this.broadcastMap.get(id);
    }

    @Override
    public VoD getVoD(String id) {
        return this.vodMap.get(id);
    }

    @Override
    public boolean updateStatus(String id, String status) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setStatus(status);
            if (status.equals("broadcasting")) {
                broadcast.setStartTime(System.currentTimeMillis());
            } else if (status.equals("finished")) {
                broadcast.setRtmpViewerCount(0);
                broadcast.setWebRTCViewerCount(0);
                broadcast.setHlsViewerCount(0);
            }
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    @Override
    public boolean updateDuration(String id, long duration) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setDuration(duration);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    @Override
    public boolean addEndpoint(String id, Endpoint endpoint) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null && endpoint != null) {
            List<Endpoint> endPointList = broadcast.getEndPointList();
            if (endPointList == null) {
                endPointList = new ArrayList<Endpoint>();
            }
            endPointList.add(endpoint);
            broadcast.setEndPointList(endPointList);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    @Override
    public boolean removeEndpoint(String id, Endpoint endpoint, boolean checkRTMPUrl) {
        List<Endpoint> endPointList;
        boolean result = false;
        Broadcast broadcast = this.broadcastMap.get(id);
        if (broadcast != null && endpoint != null && (endPointList = broadcast.getEndPointList()) != null) {
            Iterator<Endpoint> iterator = endPointList.iterator();
            while (iterator.hasNext()) {
                Endpoint endpointItem = iterator.next();
                if (checkRTMPUrl) {
                    if (!endpointItem.getRtmpUrl().equals(endpoint.getRtmpUrl())) continue;
                    iterator.remove();
                    result = true;
                    break;
                }
                if (!endpointItem.getEndpointServiceId().equals(endpoint.getEndpointServiceId())) continue;
                iterator.remove();
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public long getBroadcastCount() {
        return this.broadcastMap.size();
    }

    @Override
    public long getActiveBroadcastCount() {
        Collection<Broadcast> values = this.broadcastMap.values();
        long activeBroadcastCount = 0L;
        for (Broadcast broadcast : values) {
            String status = broadcast.getStatus();
            if (status == null || !status.equals("broadcasting")) continue;
            ++activeBroadcastCount;
        }
        return activeBroadcastCount;
    }

    @Override
    public long getLocalLiveBroadcastCount(String hostAddress) {
        return this.getActiveBroadcastCount();
    }

    @Override
    public List<Broadcast> getLocalLiveBroadcasts(String hostAddress) {
        ArrayList<Broadcast> broadcastList = new ArrayList<Broadcast>();
        Collection<Broadcast> values = this.broadcastMap.values();
        for (Broadcast broadcast : values) {
            String status = broadcast.getStatus();
            if (!"broadcasting".equals(status)) continue;
            broadcastList.add(broadcast);
        }
        return broadcastList;
    }

    @Override
    public boolean delete(String id) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            result = this.broadcastMap.remove(id) != null;
        }
        return result;
    }

    @Override
    public List<Broadcast> getBroadcastList(int offset, int size, String type, String sortBy, String orderBy, String search) {
        Collection<Broadcast> values = this.broadcastMap.values();
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        if (type != null && !type.isEmpty()) {
            for (Broadcast broadcast : values) {
                if (!type.equals(broadcast.getType())) continue;
                list.add(broadcast);
            }
        } else {
            for (Broadcast broadcast : values) {
                list.add(broadcast);
            }
        }
        if (search != null && !search.isEmpty()) {
            logger.info("server side search called for String = {}", (Object)search);
            list = this.searchOnServer(list, search);
        }
        return this.sortAndCropBroadcastList(list, offset, size, sortBy, orderBy);
    }

    @Override
    public List<Broadcast> getExternalStreamsList() {
        Collection<Broadcast> values = this.broadcastMap.values();
        ArrayList<Broadcast> streamsList = new ArrayList<Broadcast>();
        for (Broadcast broadcast : values) {
            String type = broadcast.getType();
            String status = broadcast.getStatus();
            if (!type.equals("ipCamera") && !type.equals("streamSource") || status.equals("broadcasting") || status.equals("preparing")) continue;
            streamsList.add(broadcast);
            broadcast.setStatus("preparing");
            this.broadcastMap.replace(broadcast.getStreamId(), broadcast);
        }
        return streamsList;
    }

    @Override
    public void close(boolean deleteDB) {
        this.available = false;
    }

    @Override
    public String addVod(VoD vod) {
        String id = null;
        boolean result = false;
        if (vod != null) {
            try {
                if (vod.getVodId() == null) {
                    vod.setVodId(RandomStringUtils.randomNumeric((int)24));
                }
                this.vodMap.put(vod.getVodId(), vod);
                result = true;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (result) {
            id = vod.getVodId();
        }
        return id;
    }

    @Override
    public List<VoD> getVodList(int offset, int size, String sortBy, String orderBy, String filterStreamId, String search) {
        ArrayList<VoD> vods = null;
        if (filterStreamId != null && !filterStreamId.isEmpty()) {
            vods = new ArrayList();
            for (VoD vod : this.vodMap.values()) {
                if (!vod.getStreamId().equals(filterStreamId)) continue;
                vods.add(vod);
            }
        } else {
            vods = new ArrayList<VoD>(this.vodMap.values());
        }
        if (search != null && !search.isEmpty()) {
            logger.info("server side search called for VoD searchString = {}", (Object)search);
            vods = this.searchOnServerVod(vods, search);
        }
        return this.sortAndCropVodList(vods, offset, size, sortBy, orderBy);
    }

    @Override
    public boolean deleteVod(String id) {
        return this.vodMap.remove(id) != null;
    }

    @Override
    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        Broadcast broadcast = this.broadcastMap.get(id);
        if (broadcast != null) {
            broadcast.setEndPointList(null);
            this.broadcastMap.replace(id, broadcast);
            result = true;
        }
        return result;
    }

    @Override
    public long getTotalVodNumber() {
        return this.vodMap.size();
    }

    @Override
    public int fetchUserVodList(File userfile) {
        if (userfile == null) {
            return 0;
        }
        int numberOfSavedFiles = 0;
        Collection<VoD> vodCollection = this.vodMap.values();
        Iterator<VoD> iterator = vodCollection.iterator();
        while (iterator.hasNext()) {
            VoD vod = iterator.next();
            if (!vod.getType().equals("userVod")) continue;
            iterator.remove();
        }
        File[] listOfFiles = userfile.listFiles();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                String fileExtension = FilenameUtils.getExtension((String)file.getName());
                if (!file.isFile() || !"mp4".equals(fileExtension) && !"flv".equals(fileExtension) && !"mkv".equals(fileExtension)) continue;
                long fileSize = file.length();
                long unixTime = System.currentTimeMillis();
                String filePath = file.getPath();
                String[] subDirs = filePath.split(Pattern.quote(File.separator));
                String relativePath = "streams/" + subDirs[subDirs.length - 2] + "/" + subDirs[subDirs.length - 1];
                String vodId = RandomStringUtils.randomNumeric((int)24);
                VoD newVod = new VoD("vodFile", "vodFile", relativePath, file.getName(), unixTime, 0L, 0L, fileSize, "userVod", vodId, null);
                this.addVod(newVod);
                ++numberOfSavedFiles;
            }
        }
        return numberOfSavedFiles;
    }

    @Override
    public boolean updateSourceQualityParametersLocal(String id, String quality, double speed, int pendingPacketSize) {
        Broadcast broadcast;
        boolean result = false;
        if (id != null && (broadcast = this.broadcastMap.get(id)) != null) {
            if (quality != null) {
                broadcast.setQuality(quality);
            }
            broadcast.setSpeed(speed);
            broadcast.setPendingPacketSize(pendingPacketSize);
            this.broadcastMap.replace(id, broadcast);
            result = true;
        }
        return result;
    }

    @Override
    public long getTotalBroadcastNumber() {
        return this.broadcastMap.size();
    }

    @Override
    public void saveDetection(String id, long timeElapsed, List<TensorFlowObject> detectedObjects) {
        if (detectedObjects != null) {
            for (TensorFlowObject tensorFlowObject : detectedObjects) {
                tensorFlowObject.setDetectionTime(timeElapsed);
            }
            this.detectionMap.put(id, detectedObjects);
        }
    }

    @Override
    public long getPartialBroadcastNumber(String search) {
        ArrayList<Broadcast> broadcasts = new ArrayList<Broadcast>(this.broadcastMap.values());
        if (search != null && !search.isEmpty()) {
            broadcasts = this.searchOnServer(broadcasts, search);
        }
        return broadcasts.size();
    }

    @Override
    public long getPartialVodNumber(String search) {
        ArrayList<VoD> vods = new ArrayList<VoD>(this.vodMap.values());
        if (search != null && !search.isEmpty()) {
            vods = this.searchOnServerVod(vods, search);
        }
        return vods.size();
    }

    @Override
    public List<TensorFlowObject> getDetectionList(String idFilter, int offsetSize, int batchSize) {
        int offsetCount = 0;
        int batchCount = 0;
        ArrayList<TensorFlowObject> list = new ArrayList<TensorFlowObject>();
        Set<String> keySet = this.detectionMap.keySet();
        if (batchSize > 250) {
            batchSize = 250;
        }
        for (String keyValue : keySet) {
            if (!keyValue.startsWith(idFilter)) continue;
            if (offsetCount < offsetSize) {
                ++offsetCount;
                continue;
            }
            if (batchCount >= batchSize) break;
            List<TensorFlowObject> detectedList = this.detectionMap.get(keyValue);
            list.addAll(detectedList);
            batchCount = list.size();
        }
        return list;
    }

    @Override
    public long getObjectDetectedTotal(String id) {
        ArrayList<TensorFlowObject> list = new ArrayList<TensorFlowObject>();
        Set<String> keySet = this.detectionMap.keySet();
        for (String keyValue : keySet) {
            if (!keyValue.startsWith(id)) continue;
            List<TensorFlowObject> detectedList = this.detectionMap.get(keyValue);
            list.addAll(detectedList);
        }
        return list.size();
    }

    @Override
    public List<TensorFlowObject> getDetection(String id) {
        if (id != null) {
            List<TensorFlowObject> detectedObjects = this.detectionMap.get(id);
            return detectedObjects;
        }
        return null;
    }

    @Override
    public boolean updateBroadcastFields(String streamId, Broadcast broadcast) {
        boolean result = false;
        try {
            Broadcast oldBroadcast = this.get(streamId);
            if (oldBroadcast != null) {
                this.updateStreamInfo(oldBroadcast, broadcast);
                this.broadcastMap.replace(oldBroadcast.getStreamId(), oldBroadcast);
                result = true;
            }
        }
        catch (Exception e) {
            logger.error("error in editStreamSourceInfo: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            result = false;
        }
        return result;
    }

    @Override
    public synchronized boolean updateHLSViewerCountLocal(String streamId, int diffCount) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.broadcastMap.get(streamId)) != null) {
            int hlsViewerCount = broadcast.getHlsViewerCount();
            broadcast.setHlsViewerCount(hlsViewerCount += diffCount);
            this.broadcastMap.replace(streamId, broadcast);
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean updateDASHViewerCountLocal(String streamId, int diffCount) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.broadcastMap.get(streamId)) != null) {
            int dashViewerCount = broadcast.getDashViewerCount();
            broadcast.setDashViewerCount(dashViewerCount += diffCount);
            this.broadcastMap.replace(streamId, broadcast);
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean updateWebRTCViewerCountLocal(String streamId, boolean increment) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.broadcastMap.get(streamId)) != null) {
            int webRTCViewerCount = broadcast.getWebRTCViewerCount();
            webRTCViewerCount = increment ? ++webRTCViewerCount : --webRTCViewerCount;
            if (webRTCViewerCount >= 0) {
                broadcast.setWebRTCViewerCount(webRTCViewerCount);
                this.broadcastMap.replace(streamId, broadcast);
                result = true;
            }
        }
        return result;
    }

    @Override
    public synchronized boolean updateRtmpViewerCountLocal(String streamId, boolean increment) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.broadcastMap.get(streamId)) != null) {
            int rtmpViewerCount = broadcast.getRtmpViewerCount();
            rtmpViewerCount = increment ? ++rtmpViewerCount : --rtmpViewerCount;
            if (rtmpViewerCount >= 0) {
                broadcast.setRtmpViewerCount(rtmpViewerCount);
                this.broadcastMap.replace(streamId, broadcast);
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean saveToken(Token token) {
        boolean result = false;
        if (token.getStreamId() != null && token.getTokenId() != null) {
            try {
                this.tokenMap.put(token.getTokenId(), token);
                result = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    @Override
    public Token validateToken(Token token) {
        Token fetchedToken = null;
        if (token.getTokenId() != null) {
            fetchedToken = this.tokenMap.get(token.getTokenId());
            if (fetchedToken != null && fetchedToken.getType().equals(token.getType()) && Instant.now().getEpochSecond() < fetchedToken.getExpireDate()) {
                if (token.getRoomId() == null || token.getRoomId().isEmpty()) {
                    if (fetchedToken.getStreamId().equals(token.getStreamId())) {
                        this.tokenMap.remove(token.getTokenId());
                    } else {
                        fetchedToken = null;
                    }
                }
                return fetchedToken;
            }
            fetchedToken = null;
        }
        return fetchedToken;
    }

    @Override
    public boolean revokeTokens(String streamId) {
        boolean result = false;
        Collection<Token> tokenCollection = this.tokenMap.values();
        Iterator<Token> iterator = tokenCollection.iterator();
        while (iterator.hasNext()) {
            Token token = iterator.next();
            if (token.getStreamId().equals(streamId)) {
                iterator.remove();
                this.tokenMap.remove(token.getTokenId());
            }
            result = true;
        }
        return result;
    }

    @Override
    public List<Token> listAllTokens(String streamId, int offset, int size) {
        ArrayList<Token> list = new ArrayList<Token>();
        ArrayList<Token> returnList = new ArrayList<Token>();
        Collection<Token> values = this.tokenMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 250) {
            size = 250;
        }
        if (offset < 0) {
            offset = 0;
        }
        for (Token token : values) {
            if (!token.getStreamId().equals(streamId)) continue;
            list.add(token);
        }
        Iterator iterator = list.iterator();
        while (itemCount < size && iterator.hasNext()) {
            if (t < offset) {
                ++t;
                iterator.next();
                continue;
            }
            returnList.add((Token)iterator.next());
            ++itemCount;
        }
        return returnList;
    }

    @Override
    public List<Subscriber> listAllSubscribers(String streamId, int offset, int size) {
        ArrayList<Subscriber> list = new ArrayList<Subscriber>();
        ArrayList<Subscriber> returnList = new ArrayList<Subscriber>();
        Collection<Subscriber> values = this.subscriberMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 250) {
            size = 250;
        }
        if (offset < 0) {
            offset = 0;
        }
        for (Subscriber subscriber : values) {
            if (!subscriber.getStreamId().equals(streamId)) continue;
            list.add(subscriber);
        }
        Iterator iterator = list.iterator();
        while (itemCount < size && iterator.hasNext()) {
            if (t < offset) {
                ++t;
                iterator.next();
                continue;
            }
            returnList.add((Subscriber)iterator.next());
            ++itemCount;
        }
        return returnList;
    }

    @Override
    public boolean addSubscriber(String streamId, Subscriber subscriber) {
        boolean result = false;
        if (subscriber != null && subscriber.getStreamId() != null && subscriber.getSubscriberId() != null) {
            try {
                this.subscriberMap.put(subscriber.getSubscriberKey(), subscriber);
                result = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    @Override
    public boolean deleteSubscriber(String streamId, String subscriberId) {
        boolean result = false;
        if (streamId != null && subscriberId != null) {
            try {
                Subscriber sub = this.subscriberMap.remove(Subscriber.getDBKey(streamId, subscriberId));
                result = sub != null;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    @Override
    public boolean blockSubscriber(String streamId, String subscriberId, String blockedType, int seconds) {
        boolean result = false;
        if (streamId != null && subscriberId != null) {
            try {
                Subscriber subscriber = this.subscriberMap.get(Subscriber.getDBKey(streamId, subscriberId));
                if (subscriber == null) {
                    subscriber = new Subscriber();
                    subscriber.setStreamId(streamId);
                    subscriber.setSubscriberId(subscriberId);
                }
                subscriber.setBlockedType(blockedType);
                subscriber.setBlockedUntilUnitTimeStampMs(System.currentTimeMillis() + (long)(seconds * 1000));
                this.subscriberMap.put(subscriber.getSubscriberKey(), subscriber);
                result = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    @Override
    public boolean revokeSubscribers(String streamId) {
        boolean result = false;
        Collection<Subscriber> subscriberCollection = this.subscriberMap.values();
        Iterator<Subscriber> iterator = subscriberCollection.iterator();
        while (iterator.hasNext()) {
            Subscriber subscriber = iterator.next();
            String subscriberStreamId = subscriber.getStreamId();
            if (subscriberStreamId != null && subscriberStreamId.equals(streamId)) {
                iterator.remove();
                this.subscriberMap.remove(subscriber.getSubscriberKey());
            }
            result = true;
        }
        return result;
    }

    @Override
    public Subscriber getSubscriber(String streamId, String subscriberId) {
        return this.subscriberMap.get(Subscriber.getDBKey(streamId, subscriberId));
    }

    @Override
    public boolean resetSubscribersConnectedStatus() {
        for (Subscriber subscriber : this.subscriberMap.values()) {
            if (subscriber == null) continue;
            subscriber.setConnected(false);
            subscriber.setCurrentConcurrentConnections(0);
        }
        return true;
    }

    @Override
    public List<StreamInfo> getStreamInfoList(String streamId) {
        return new ArrayList<StreamInfo>();
    }

    @Override
    public void clearStreamInfoList(String streamId) {
    }

    @Override
    public boolean setMp4Muxing(String streamId, int enabled) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.broadcastMap.get(streamId)) != null && (enabled == 1 || enabled == 0 || enabled == -1)) {
            broadcast.setMp4Enabled(enabled);
            this.broadcastMap.replace(streamId, broadcast);
            result = true;
        }
        return result;
    }

    @Override
    public boolean setWebMMuxing(String streamId, int enabled) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.broadcastMap.get(streamId)) != null && (enabled == 1 || enabled == 0 || enabled == -1)) {
            broadcast.setWebMEnabled(enabled);
            this.broadcastMap.replace(streamId, broadcast);
            result = true;
        }
        return result;
    }

    @Override
    public void saveStreamInfo(StreamInfo streamInfo) {
    }

    @Override
    public boolean createConferenceRoom(ConferenceRoom room) {
        boolean result = false;
        if (room != null && room.getRoomId() != null) {
            this.roomMap.put(room.getRoomId(), room);
            result = true;
        }
        return result;
    }

    @Override
    public boolean editConferenceRoom(String roomId, ConferenceRoom room) {
        boolean result = false;
        if (room != null && room.getRoomId() != null) {
            return this.roomMap.replace(roomId, room) != null;
        }
        return result;
    }

    @Override
    public boolean deleteConferenceRoom(String roomName) {
        boolean result = false;
        if (roomName != null && roomName.length() > 0) {
            this.roomMap.remove(roomName);
            result = true;
        }
        return result;
    }

    @Override
    public List<ConferenceRoom> getConferenceRoomList(int offset, int size, String sortBy, String orderBy, String search) {
        Collection<ConferenceRoom> values = this.roomMap.values();
        ArrayList<ConferenceRoom> list = new ArrayList<ConferenceRoom>();
        for (ConferenceRoom room : values) {
            list.add(room);
        }
        if (search != null && !search.isEmpty()) {
            logger.info("server side search called for Conference Room = {}", (Object)search);
            list = this.searchOnServerConferenceRoom(list, search);
        }
        return this.sortAndCropConferenceRoomList(list, offset, size, sortBy, orderBy);
    }

    @Override
    public ConferenceRoom getConferenceRoom(String roomName) {
        return this.roomMap.get(roomName);
    }

    @Override
    public boolean deleteToken(String tokenId) {
        return this.tokenMap.remove(tokenId) != null;
    }

    @Override
    public Token getToken(String tokenId) {
        return this.tokenMap.get(tokenId);
    }

    @Override
    public boolean createP2PConnection(P2PConnection conn) {
        return false;
    }

    @Override
    public boolean deleteP2PConnection(String streamId) {
        return false;
    }

    @Override
    public P2PConnection getP2PConnection(String streamId) {
        return null;
    }

    @Override
    public boolean addSubTrack(String mainTrackId, String subTrackId) {
        boolean result = false;
        Broadcast mainTrack = this.broadcastMap.get(mainTrackId);
        if (mainTrack != null && subTrackId != null) {
            List<String> subTracks = mainTrack.getSubTrackStreamIds();
            if (subTracks == null) {
                subTracks = new ArrayList<String>();
            }
            subTracks.add(subTrackId);
            mainTrack.setSubTrackStreamIds(subTracks);
            this.broadcastMap.put(mainTrackId, mainTrack);
            result = true;
        }
        return result;
    }

    @Override
    public boolean removeSubTrack(String mainTrackId, String subTrackId) {
        List<String> subTracks;
        boolean result = false;
        Broadcast mainTrack = this.broadcastMap.get(mainTrackId);
        if (mainTrack != null && subTrackId != null && (subTracks = mainTrack.getSubTrackStreamIds()).remove(subTrackId)) {
            mainTrack.setSubTrackStreamIds(subTracks);
            this.broadcastMap.put(mainTrackId, mainTrack);
            result = true;
        }
        return result;
    }

    @Override
    public int resetBroadcasts(String hostAddress) {
        Set<Map.Entry<String, Broadcast>> entrySet = this.broadcastMap.entrySet();
        Iterator<Map.Entry<String, Broadcast>> iterator = entrySet.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, Broadcast> next = iterator.next();
            if (next.getValue().isZombi()) {
                iterator.remove();
                ++i;
            }
            if (!next.getValue().getStatus().equals("broadcasting") && !next.getValue().getStatus().equals("preparing")) continue;
            next.getValue().setStatus("finished");
            next.getValue().setWebRTCViewerCount(0);
            next.getValue().setHlsViewerCount(0);
            next.getValue().setRtmpViewerCount(0);
            ++i;
        }
        return i;
    }

    @Override
    public int getTotalWebRTCViewersCount() {
        long now = System.currentTimeMillis();
        if (now - this.totalWebRTCViewerCountLastUpdateTime > 5000L) {
            int total = 0;
            for (Broadcast broadcast : this.broadcastMap.values()) {
                total += broadcast.getWebRTCViewerCount();
            }
            this.totalWebRTCViewerCount = total;
            this.totalWebRTCViewerCountLastUpdateTime = now;
        }
        return this.totalWebRTCViewerCount;
    }

    @Override
    public void saveViewerInfo(WebRTCViewerInfo info) {
        this.webRTCViewerMap.put(info.getViewerId(), info);
    }

    @Override
    public List<WebRTCViewerInfo> getWebRTCViewerList(int offset, int size, String sortBy, String orderBy, String search) {
        Collection<WebRTCViewerInfo> values = this.webRTCViewerMap.values();
        ArrayList<WebRTCViewerInfo> list = new ArrayList<WebRTCViewerInfo>();
        for (WebRTCViewerInfo info : values) {
            list.add(info);
        }
        if (search != null && !search.isEmpty()) {
            logger.info("server side search called for Conference Room = {}", (Object)search);
            list = this.searchOnWebRTCViewerInfo(list, search);
        }
        return this.sortAndCropWebRTCViewerInfoList(list, offset, size, sortBy, orderBy);
    }

    @Override
    public boolean deleteWebRTCViewerInfo(String viewerId) {
        this.webRTCViewerMap.remove(viewerId);
        return true;
    }

    @Override
    public boolean updateStreamMetaData(String streamId, String metaData) {
        Broadcast broadcast = this.broadcastMap.get(streamId);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setMetaData(metaData);
            this.broadcastMap.put(streamId, broadcast);
            result = true;
        }
        return result;
    }
}

