/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.P2PConnection;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.datastore.db.types.WebRTCViewerInfo;
import java.io.File;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapBasedDataStore
extends DataStore {
    protected Map<String, String> map;
    protected Map<String, String> vodMap;
    protected Map<String, String> detectionMap;
    protected Map<String, String> tokenMap;
    protected Map<String, String> subscriberMap;
    protected Map<String, String> conferenceRoomMap;
    protected Map<String, String> webRTCViewerMap;
    public static final String REPLACE_CHARS_REGEX = "[\n|\r|\t]";
    protected Gson gson;
    protected String dbName;
    protected static Logger logger = LoggerFactory.getLogger(MapBasedDataStore.class);

    public MapBasedDataStore(String dbName) {
        this.dbName = dbName;
        GsonBuilder builder = new GsonBuilder();
        this.gson = builder.create();
        this.available = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String save(Broadcast broadcast) {
        String streamId = null;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            if (broadcast != null) {
                Broadcast updatedBroadcast = super.saveBroadcast(broadcast);
                streamId = updatedBroadcast.getStreamId();
                this.map.put(updatedBroadcast.getStreamId(), this.gson.toJson((Object)updatedBroadcast));
            }
            return streamId;
        }
    }

    @Override
    public Broadcast get(String id) {
        return super.get(this.map, id, this.gson);
    }

    @Override
    public VoD getVoD(String id) {
        return super.getVoD(this.vodMap, id, this.gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStatus(String id, String status) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (id != null && (broadcast = this.getBroadcastFromMap(id)) != null) {
                broadcast.setStatus(status);
                if (status.equals("broadcasting")) {
                    broadcast.setStartTime(System.currentTimeMillis());
                } else if (status.equals("finished")) {
                    broadcast.setRtmpViewerCount(0);
                    broadcast.setWebRTCViewerCount(0);
                    broadcast.setHlsViewerCount(0);
                    broadcast.setDashViewerCount(0);
                }
                this.setBroadcastToMap(broadcast, id);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateDuration(String id, long duration) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (id != null && (broadcast = this.getBroadcastFromMap(id)) != null) {
                broadcast.setDuration(duration);
                this.setBroadcastToMap(broadcast, id);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addEndpoint(String id, Endpoint endpoint) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (id != null && endpoint != null && (broadcast = this.getBroadcastFromMap(id)) != null) {
                List<Endpoint> endPointList = broadcast.getEndPointList();
                if (endPointList == null) {
                    endPointList = new ArrayList<Endpoint>();
                }
                endPointList.add(endpoint);
                broadcast.setEndPointList(endPointList);
                this.setBroadcastToMap(broadcast, id);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEndpoint(String id, Endpoint endpoint, boolean checkRTMPUrl) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            List<Endpoint> endPointList;
            Broadcast broadcast;
            if (id != null && endpoint != null && (broadcast = this.getBroadcastFromMap(id)) != null && (endPointList = broadcast.getEndPointList()) != null) {
                Iterator<Endpoint> iterator = endPointList.iterator();
                while (iterator.hasNext()) {
                    Endpoint endpointItem = iterator.next();
                    if (checkRTMPUrl) {
                        if (!endpointItem.getRtmpUrl().equals(endpoint.getRtmpUrl())) continue;
                        iterator.remove();
                        result = true;
                        break;
                    }
                    if (!endpointItem.getEndpointServiceId().equals(endpoint.getEndpointServiceId())) continue;
                    iterator.remove();
                    result = true;
                    break;
                }
                if (result) {
                    broadcast.setEndPointList(endPointList);
                    this.setBroadcastToMap(broadcast, id);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast = this.getBroadcastFromMap(id);
            if (broadcast != null) {
                broadcast.setEndPointList(null);
                this.setBroadcastToMap(broadcast, id);
                result = true;
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public long getBroadcastCount() {
        return super.getBroadcastCount(this.map);
    }

    @Override
    public long getActiveBroadcastCount() {
        return super.getActiveBroadcastCount(this.map, this.gson, null);
    }

    public List<Broadcast> getActiveBroadcastList(String hostAddress) {
        return super.getActiveBroadcastList(this.map, this.gson, hostAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String id) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            result = this.map.remove(id) != null;
        }
        return result;
    }

    @Override
    public List<ConferenceRoom> getConferenceRoomList(int offset, int size, String sortBy, String orderBy, String search) {
        return super.getConferenceRoomList(this.conferenceRoomMap, offset, size, sortBy, orderBy, search, this.gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> getBroadcastListV2(String type, String search) {
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            if (type != null && !type.isEmpty()) {
                for (String broadcastString : this.map.values()) {
                    Broadcast broadcast = (Broadcast)this.gson.fromJson(broadcastString, Broadcast.class);
                    if (!broadcast.getType().equals(type)) continue;
                    list.add(broadcast);
                }
            } else {
                for (String broadcastString : this.map.values()) {
                    Broadcast broadcast = (Broadcast)this.gson.fromJson(broadcastString, Broadcast.class);
                    list.add(broadcast);
                }
            }
        }
        if (search != null && !search.isEmpty()) {
            search = search.replaceAll(REPLACE_CHARS_REGEX, "_");
            logger.info("server side search called for Broadcast searchString = {}", (Object)search);
            list = this.searchOnServer(list, search);
        }
        return list;
    }

    @Override
    public List<Broadcast> getBroadcastList(int offset, int size, String type, String sortBy, String orderBy, String search) {
        List<Broadcast> list = null;
        list = this.getBroadcastListV2(type, search);
        return this.sortAndCropBroadcastList(list, offset, size, sortBy, orderBy);
    }

    public List<VoD> getVodListV2(String streamId, String search) {
        return super.getVodListV2(this.vodMap, streamId, search, this.gson, this.dbName);
    }

    @Override
    public List<VoD> getVodList(int offset, int size, String sortBy, String orderBy, String streamId, String search) {
        List<VoD> vods = null;
        vods = this.getVodListV2(streamId, search);
        return this.sortAndCropVodList(vods, offset, size, sortBy, orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addVod(VoD vod) {
        String id = null;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            try {
                if (vod.getVodId() == null) {
                    vod.setVodId(RandomStringUtils.randomNumeric((int)24));
                }
                id = vod.getVodId();
                this.vodMap.put(vod.getVodId(), this.gson.toJson((Object)vod));
                logger.warn("VoD is saved to DB {} with voID {}", (Object)vod.getVodName(), (Object)id);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                id = null;
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Broadcast> getExternalStreamsList() {
        ArrayList<Broadcast> streamsList = new ArrayList<Broadcast>();
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            int i;
            Object[] objectArray = this.map.values().toArray();
            Broadcast[] broadcastArray = new Broadcast[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                broadcastArray[i] = (Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class);
            }
            for (i = 0; i < broadcastArray.length; ++i) {
                String type = broadcastArray[i].getType();
                String status = broadcastArray[i].getStatus();
                if (!type.equals("ipCamera") && !type.equals("streamSource") || status.equals("broadcasting") || status.equals("preparing")) continue;
                streamsList.add((Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class));
                broadcastArray[i].setStatus("preparing");
                this.setBroadcastToMap(broadcastArray[i], broadcastArray[i].getStreamId());
            }
        }
        return streamsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteVod(String id) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            result = this.vodMap.remove(id) != null;
        }
        return result;
    }

    @Override
    public long getTotalVodNumber() {
        return super.getTotalVodNumber(this.vodMap);
    }

    @Override
    public long getPartialVodNumber(String search) {
        List<VoD> vods = this.getVodListV2(null, search);
        return vods.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fetchUserVodList(File filedir) {
        if (filedir == null) {
            return 0;
        }
        int numberOfSavedFiles = 0;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            int i = 0;
            Collection<Object> vodFiles = new ArrayList();
            if (this.vodMap != null) {
                vodFiles = this.vodMap.values();
            }
            int size = vodFiles.size();
            ArrayList<VoD> vodList = new ArrayList<VoD>();
            for (Object vodString : vodFiles) {
                vodList.add((VoD)this.gson.fromJson((String)vodString, VoD.class));
                if (++i <= size) continue;
                logger.error("Inconsistency in DB. It's likely db file({}) is damaged", (Object)this.dbName);
                break;
            }
            boolean result = false;
            for (VoD vod : vodList) {
                if (!vod.getType().equals("userVod")) continue;
                if (this.vodMap != null) {
                    boolean bl = result = this.vodMap.remove(vod.getVodId()) != null;
                }
                if (result) continue;
                logger.error("MapDB VoD is not synchronized. It's likely db files({}) is damaged", (Object)this.dbName);
            }
            File[] listOfFiles = filedir.listFiles();
            if (listOfFiles != null) {
                for (File file : listOfFiles) {
                    String fileExtension = FilenameUtils.getExtension((String)file.getName());
                    if (!file.isFile() || !"mp4".equals(fileExtension) && !"flv".equals(fileExtension) && !"mkv".equals(fileExtension)) continue;
                    long fileSize = file.length();
                    long unixTime = System.currentTimeMillis();
                    String path = file.getPath();
                    String[] subDirs = path.split(Pattern.quote(File.separator));
                    Integer pathLength = subDirs.length;
                    String relativePath = "streams/" + subDirs[pathLength - 2] + "/" + subDirs[pathLength - 1];
                    String vodId = RandomStringUtils.randomNumeric((int)24);
                    VoD newVod = new VoD("vodFile", "vodFile", relativePath, file.getName(), unixTime, 0L, 0L, fileSize, "userVod", vodId, null);
                    this.addVod(newVod);
                    ++numberOfSavedFiles;
                }
            }
        }
        return numberOfSavedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean updateSourceQualityParametersLocal(String id, String quality, double speed, int pendingPacketQueue) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (id != null && (broadcast = this.getBroadcastFromMap(id)) != null) {
                broadcast.setSpeed(speed);
                if (quality != null) {
                    broadcast.setQuality(quality);
                }
                broadcast.setPendingPacketSize(pendingPacketQueue);
                this.setBroadcastToMap(broadcast, id);
                result = true;
            }
        }
        return result;
    }

    @Override
    public long getTotalBroadcastNumber() {
        return super.getTotalBroadcastNumber(this.map);
    }

    @Override
    public long getPartialBroadcastNumber(String search) {
        return this.getBroadcastListV2(null, search).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDetection(String id, long timeElapsed, List<TensorFlowObject> detectedObjects) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            try {
                if (detectedObjects != null) {
                    for (TensorFlowObject tensorFlowObject : detectedObjects) {
                        tensorFlowObject.setDetectionTime(timeElapsed);
                    }
                    this.detectionMap.put(id, this.gson.toJson(detectedObjects));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    @Override
    public List<TensorFlowObject> getDetection(String id) {
        return super.getDetection(this.detectionMap, id, this.gson);
    }

    @Override
    public List<TensorFlowObject> getDetectionList(String idFilter, int offsetSize, int batchSize) {
        return super.getDetectionList(this.detectionMap, idFilter, offsetSize, batchSize, this.gson);
    }

    @Override
    public long getObjectDetectedTotal(String id) {
        return super.getObjectDetectedTotal(this.detectionMap, id, this.gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateBroadcastFields(String streamId, Broadcast broadcast) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            try {
                logger.debug("inside of updateBroadcastFields {}", (Object)broadcast.getStreamId());
                Broadcast oldBroadcast = this.get(streamId);
                if (oldBroadcast != null) {
                    this.updateStreamInfo(oldBroadcast, broadcast);
                    this.setBroadcastToMap(oldBroadcast, streamId);
                    result = true;
                }
            }
            catch (Exception e) {
                result = false;
            }
        }
        logger.debug("result inside updateBroadcastFields:{} ", (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean updateHLSViewerCountLocal(String streamId, int diffCount) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.get(streamId)) != null) {
                int hlsViewerCount = broadcast.getHlsViewerCount();
                broadcast.setHlsViewerCount(hlsViewerCount += diffCount);
                this.setBroadcastToMap(broadcast, streamId);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean updateDASHViewerCountLocal(String streamId, int diffCount) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.get(streamId)) != null) {
                int dashViewerCount = broadcast.getDashViewerCount();
                broadcast.setDashViewerCount(dashViewerCount += diffCount);
                this.setBroadcastToMap(broadcast, streamId);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean updateWebRTCViewerCountLocal(String streamId, boolean increment) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.get(streamId)) != null) {
                int webRTCViewerCount = broadcast.getWebRTCViewerCount();
                webRTCViewerCount = increment ? ++webRTCViewerCount : --webRTCViewerCount;
                if (webRTCViewerCount >= 0) {
                    broadcast.setWebRTCViewerCount(webRTCViewerCount);
                    this.setBroadcastToMap(broadcast, streamId);
                    result = true;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean updateRtmpViewerCountLocal(String streamId, boolean increment) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.get(streamId)) != null) {
                int rtmpViewerCount = broadcast.getRtmpViewerCount();
                rtmpViewerCount = increment ? ++rtmpViewerCount : --rtmpViewerCount;
                if (rtmpViewerCount >= 0) {
                    broadcast.setRtmpViewerCount(rtmpViewerCount);
                    this.map.replace(streamId, this.gson.toJson((Object)broadcast));
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    public void clearStreamInfoList(String streamId) {
    }

    @Override
    public List<StreamInfo> getStreamInfoList(String streamId) {
        return new ArrayList<StreamInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToken(Token token) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            if (token.getStreamId() != null && token.getTokenId() != null) {
                try {
                    this.tokenMap.put(token.getTokenId(), this.gson.toJson((Object)token));
                    result = true;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token validateToken(Token token) {
        Token fetchedToken = null;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            String jsonToken;
            if (token.getTokenId() != null && (jsonToken = this.tokenMap.get(token.getTokenId())) != null) {
                fetchedToken = (Token)this.gson.fromJson(jsonToken, Token.class);
                if (fetchedToken.getType().equals(token.getType()) && Instant.now().getEpochSecond() < fetchedToken.getExpireDate()) {
                    if (token.getRoomId() == null || token.getRoomId().isEmpty()) {
                        if (fetchedToken.getStreamId().equals(token.getStreamId())) {
                            this.tokenMap.remove(token.getTokenId());
                        } else {
                            fetchedToken = null;
                        }
                    }
                    return fetchedToken;
                }
                fetchedToken = null;
            }
        }
        return fetchedToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokeTokens(String streamId) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            int i;
            Object[] objectArray = this.tokenMap.values().toArray();
            Token[] tokenArray = new Token[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                tokenArray[i] = (Token)this.gson.fromJson((String)objectArray[i], Token.class);
            }
            for (i = 0; i < tokenArray.length; ++i) {
                if (!tokenArray[i].getStreamId().equals(streamId)) continue;
                boolean bl = result = this.tokenMap.remove(tokenArray[i].getTokenId()) != null;
                if (!result) break;
            }
        }
        return result;
    }

    @Override
    public List<Token> listAllTokens(String streamId, int offset, int size) {
        return super.listAllTokens(this.tokenMap, streamId, offset, size, this.gson);
    }

    @Override
    public List<Subscriber> listAllSubscribers(String streamId, int offset, int size) {
        return super.listAllSubscribers(this.subscriberMap, streamId, offset, size, this.gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSubscriber(String streamId, Subscriber subscriber) {
        boolean result = false;
        if (subscriber != null) {
            MapBasedDataStore mapBasedDataStore = this;
            synchronized (mapBasedDataStore) {
                if (subscriber.getStreamId() != null && subscriber.getSubscriberId() != null) {
                    try {
                        this.subscriberMap.put(subscriber.getSubscriberKey(), this.gson.toJson((Object)subscriber));
                        result = true;
                    }
                    catch (Exception e) {
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean blockSubscriber(String streamId, String subscriberId, String blockedType, int seconds) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            if (streamId != null && subscriberId != null) {
                try {
                    Subscriber subscriber = (Subscriber)this.gson.fromJson(this.subscriberMap.get(Subscriber.getDBKey(streamId, subscriberId)), Subscriber.class);
                    if (subscriber == null) {
                        subscriber = new Subscriber();
                        subscriber.setStreamId(streamId);
                        subscriber.setSubscriberId(subscriberId);
                    }
                    subscriber.setBlockedType(blockedType);
                    subscriber.setBlockedUntilUnitTimeStampMs(System.currentTimeMillis() + (long)(seconds * 1000));
                    this.subscriberMap.put(subscriber.getSubscriberKey(), this.gson.toJson((Object)subscriber));
                    result = true;
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteSubscriber(String streamId, String subscriberId) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            try {
                result = this.subscriberMap.remove(Subscriber.getDBKey(streamId, subscriberId)) != null;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokeSubscribers(String streamId) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            int i;
            Object[] objectArray = this.subscriberMap.values().toArray();
            Subscriber[] subscriberArray = new Subscriber[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                subscriberArray[i] = (Subscriber)this.gson.fromJson((String)objectArray[i], Subscriber.class);
            }
            for (i = 0; i < subscriberArray.length; ++i) {
                String subscriberStreamId = subscriberArray[i].getStreamId();
                if (subscriberStreamId == null || !subscriberStreamId.equals(streamId)) continue;
                boolean bl = result = this.subscriberMap.remove(subscriberArray[i].getSubscriberKey()) != null;
                if (!result) break;
            }
        }
        return result;
    }

    @Override
    public Subscriber getSubscriber(String streamId, String subscriberId) {
        return super.getSubscriber(this.subscriberMap, streamId, subscriberId, this.gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetSubscribersConnectedStatus() {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            try {
                Collection<String> subcribersRaw = this.subscriberMap.values();
                for (String subscriberRaw : subcribersRaw) {
                    Subscriber subscriber;
                    if (subscriberRaw == null || (subscriber = (Subscriber)this.gson.fromJson(subscriberRaw, Subscriber.class)) == null) continue;
                    subscriber.setConnected(false);
                    subscriber.setCurrentConcurrentConnections(0);
                    this.subscriberMap.put(subscriber.getSubscriberKey(), this.gson.toJson((Object)subscriber));
                }
                return true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resetBroadcasts(String hostAddress) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            int size = this.map.size();
            int updateOperations = 0;
            int zombieStreamCount = 0;
            Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
            Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Map.Entry<String, String> next = iterator.next();
                if (next != null) {
                    Broadcast broadcast = (Broadcast)this.gson.fromJson(next.getValue(), Broadcast.class);
                    ++i;
                    if (broadcast.getOriginAdress() == null || broadcast.getOriginAdress().isEmpty() || hostAddress.equals(broadcast.getOriginAdress())) {
                        if (broadcast.isZombi()) {
                            iterator.remove();
                            ++zombieStreamCount;
                        } else {
                            broadcast.setStatus("finished");
                            broadcast.setWebRTCViewerCount(0);
                            broadcast.setHlsViewerCount(0);
                            broadcast.setRtmpViewerCount(0);
                            broadcast.setDashViewerCount(0);
                            this.map.put(broadcast.getStreamId(), this.gson.toJson((Object)broadcast));
                            ++updateOperations;
                        }
                    }
                }
                if (i <= size) continue;
                logger.error("Inconsistency in DB found in resetting broadcasts for dbName:{}", (Object)this.dbName);
                break;
            }
            logger.info("Reset broadcasts result in deleting {} zombi streams and {} update operations", (Object)zombieStreamCount, (Object)updateOperations);
            return updateOperations + zombieStreamCount;
        }
    }

    @Override
    public void saveStreamInfo(StreamInfo streamInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setMp4Muxing(String streamId, int enabled) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.getBroadcastFromMap(streamId)) != null && (enabled == 1 || enabled == 0 || enabled == -1)) {
                broadcast.setMp4Enabled(enabled);
                this.setBroadcastToMap(broadcast, streamId);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setWebMMuxing(String streamId, int enabled) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.getBroadcastFromMap(streamId)) != null && (enabled == 1 || enabled == 0 || enabled == -1)) {
                broadcast.setWebMEnabled(enabled);
                this.setBroadcastToMap(broadcast, streamId);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createConferenceRoom(ConferenceRoom room) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            boolean result = false;
            if (room != null && room.getRoomId() != null) {
                this.conferenceRoomMap.put(room.getRoomId(), this.gson.toJson((Object)room));
                result = true;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editConferenceRoom(String roomId, ConferenceRoom room) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            boolean result = false;
            if (roomId != null && room != null && room.getRoomId() != null) {
                result = this.conferenceRoomMap.replace(roomId, this.gson.toJson((Object)room)) != null;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteConferenceRoom(String roomId) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            boolean result = false;
            if (roomId != null && !roomId.isEmpty()) {
                result = this.conferenceRoomMap.remove(roomId) != null;
            }
            return result;
        }
    }

    @Override
    public ConferenceRoom getConferenceRoom(String roomId) {
        return super.getConferenceRoom(this.conferenceRoomMap, roomId, this.gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteToken(String tokenId) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            result = this.tokenMap.remove(tokenId) != null;
        }
        return result;
    }

    @Override
    public Token getToken(String tokenId) {
        return super.getToken(this.tokenMap, tokenId, this.gson);
    }

    @Override
    public boolean createP2PConnection(P2PConnection conn) {
        return false;
    }

    @Override
    public boolean deleteP2PConnection(String streamId) {
        return false;
    }

    @Override
    public P2PConnection getP2PConnection(String streamId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSubTrack(String mainTrackId, String subTrackId) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast = this.getBroadcastFromMap(mainTrackId);
            if (broadcast != null && subTrackId != null) {
                List<String> subTracks = broadcast.getSubTrackStreamIds();
                if (subTracks == null) {
                    subTracks = new ArrayList<String>();
                }
                subTracks.add(subTrackId);
                broadcast.setSubTrackStreamIds(subTracks);
                this.setBroadcastToMap(broadcast, mainTrackId);
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSubTrack(String mainTrackId, String subTrackId) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            List<String> subTracks;
            Broadcast mainTrack = this.getBroadcastFromMap(mainTrackId);
            if (mainTrack != null && subTrackId != null && (subTracks = mainTrack.getSubTrackStreamIds()).remove(subTrackId)) {
                mainTrack.setSubTrackStreamIds(subTracks);
                this.setBroadcastToMap(mainTrack, mainTrackId);
                result = true;
            }
        }
        return result;
    }

    @Override
    public int getTotalWebRTCViewersCount() {
        return super.getTotalWebRTCViewersCount(this.map, this.gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveViewerInfo(WebRTCViewerInfo info) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            if (info != null) {
                try {
                    this.webRTCViewerMap.put(info.getViewerId(), this.gson.toJson((Object)info));
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    @Override
    public List<WebRTCViewerInfo> getWebRTCViewerList(int offset, int size, String sortBy, String orderBy, String search) {
        return super.getWebRTCViewerList(this.webRTCViewerMap, offset, size, sortBy, orderBy, search, this.gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteWebRTCViewerInfo(String viewerId) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            return this.webRTCViewerMap.remove(viewerId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStreamMetaData(String streamId, String metaData) {
        boolean result = false;
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.getBroadcastFromMap(streamId)) != null) {
                broadcast.setMetaData(metaData);
                this.setBroadcastToMap(broadcast, streamId);
                result = true;
            }
        }
        return result;
    }

    public void setBroadcastToMap(Broadcast broadcast, String streamId) {
        String jsonVal = this.gson.toJson((Object)broadcast);
        String previousValue = null;
        previousValue = this.map.replace(streamId, jsonVal);
        streamId = streamId.replaceAll(REPLACE_CHARS_REGEX, "_");
        logger.debug("replacing id {} having value {} to {}", new Object[]{streamId, previousValue, jsonVal});
    }

    public Broadcast getBroadcastFromMap(String streamId) {
        String jsonString = this.map.get(streamId);
        if (jsonString != null) {
            return (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
        }
        return null;
    }
}

