/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import io.antmedia.datastore.db.MapBasedDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.P2PConnection;
import io.antmedia.datastore.db.types.StreamInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.redisson.Redisson;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisStore
extends MapBasedDataStore {
    protected static Logger logger = LoggerFactory.getLogger(RedisStore.class);
    RedissonClient redisson;
    private RMap<Object, Object> streamInfoMap;
    private RMap<Object, Object> p2pMap;

    public RedisStore(String redisConnectionUrl, String dbName) {
        super(dbName);
        try {
            Config config;
            File file = new File(redisConnectionUrl);
            if (file.exists()) {
                config = Config.fromYAML((File)file);
            } else {
                config = new Config();
                config.useSingleServer().setAddress(redisConnectionUrl);
            }
            this.redisson = Redisson.create((Config)config);
            this.map = this.redisson.getMap(dbName + "Broadcasts");
            this.vodMap = this.redisson.getMap(dbName + "Vods");
            this.conferenceRoomMap = this.redisson.getMap(dbName + "Conferences");
            this.detectionMap = this.redisson.getMap(dbName + "Detections");
            this.tokenMap = this.redisson.getMap(dbName + "Tokens");
            this.subscriberMap = this.redisson.getMap(dbName + "Subscribers");
            this.webRTCViewerMap = this.redisson.getMap(dbName + "WebRTCViewers");
            this.streamInfoMap = this.redisson.getMap(dbName + "StreamInfo");
            this.p2pMap = this.redisson.getMap(dbName + "P2P");
            this.available = true;
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean deleteDB) {
        RedisStore redisStore = this;
        synchronized (redisStore) {
            this.available = false;
            if (deleteDB) {
                this.redisson.getMap(this.dbName + "Broadcasts").delete();
                this.redisson.getMap(this.dbName + "Vods").delete();
                this.redisson.getMap(this.dbName + "Conferences").delete();
                this.redisson.getMap(this.dbName + "Detections").delete();
                this.redisson.getMap(this.dbName + "tokens").delete();
                this.redisson.getMap(this.dbName + "Subscribers").delete();
                this.redisson.getMap(this.dbName + "webRTCViewers").delete();
                this.redisson.getMap(this.dbName + "StreamInfo").delete();
                this.redisson.getMap(this.dbName + "P2P").delete();
            }
            this.redisson.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int resetBroadcasts(String hostAddress) {
        RedisStore redisStore = this;
        synchronized (redisStore) {
            int resetBroadcasts = super.resetBroadcasts(hostAddress);
            Collection streamInfoValues = this.streamInfoMap.values();
            if (streamInfoValues != null) {
                Iterator streamInfoListIterator = streamInfoValues.iterator();
                while (streamInfoListIterator.hasNext()) {
                    List streamInfoList = (List)streamInfoListIterator.next();
                    Iterator streamInfoIterator = streamInfoList.iterator();
                    while (streamInfoIterator.hasNext()) {
                        StreamInfo streamInfo = (StreamInfo)streamInfoIterator.next();
                        if (!hostAddress.equals(streamInfo.getHost())) continue;
                        streamInfoIterator.remove();
                    }
                    if (!streamInfoList.isEmpty()) continue;
                    streamInfoListIterator.remove();
                }
            }
            return resetBroadcasts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StreamInfo> getStreamInfoList(String streamId) {
        RedisStore redisStore = this;
        synchronized (redisStore) {
            List object = (List)this.streamInfoMap.get((Object)streamId);
            return object != null ? object : new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStreamInfoList(String streamId) {
        RedisStore redisStore = this;
        synchronized (redisStore) {
            this.streamInfoMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveStreamInfo(StreamInfo streamInfo) {
        RedisStore redisStore = this;
        synchronized (redisStore) {
            ArrayList<StreamInfo> streamInfoList = (ArrayList<StreamInfo>)this.streamInfoMap.get((Object)streamInfo.getStreamId());
            if (streamInfoList == null) {
                streamInfoList = new ArrayList<StreamInfo>();
            }
            streamInfoList.add(streamInfo);
            this.streamInfoMap.put((Object)streamInfo.getStreamId(), streamInfoList);
        }
    }

    @Override
    public boolean createP2PConnection(P2PConnection conn) {
        if (conn != null) {
            this.p2pMap.put((Object)conn.getStreamId(), (Object)conn);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteP2PConnection(String streamId) {
        return this.p2pMap.remove((Object)streamId) != null;
    }

    @Override
    public P2PConnection getP2PConnection(String streamId) {
        return (P2PConnection)this.p2pMap.get((Object)streamId);
    }

    @Override
    public long getLocalLiveBroadcastCount(String hostAddress) {
        return this.getActiveBroadcastCount(this.map, this.gson, hostAddress);
    }

    @Override
    public List<Broadcast> getLocalLiveBroadcasts(String hostAddress) {
        return this.getActiveBroadcastList(hostAddress);
    }
}

