/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import io.antmedia.datastore.db.types.SubscriberStats;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.bson.types.ObjectId;

@Entity(value="subscriber")
@Indexes(value={@Index(fields={@Field(value="subscriberId")}), @Index(fields={@Field(value="streamId")})})
@ApiModel(value="Subscriber", description="The time based token subscriber class")
public class Subscriber {
    @JsonIgnore
    public static final String PLAY_TYPE = "play";
    @JsonIgnore
    public static final String PUBLISH_TYPE = "publish";
    @JsonIgnore
    public static final String PUBLISH_AND_PLAY_TYPE = "publish_play";
    @JsonIgnore
    @Id
    @ApiModelProperty(value="the db id of the subscriber")
    private ObjectId dbId;
    @ApiModelProperty(value="the subscriber id of the subscriber")
    private String subscriberId;
    @ApiModelProperty(value="the stream id of the token")
    private String streamId;
    @ApiModelProperty(value="stats for this subscriber")
    private SubscriberStats stats = new SubscriberStats();
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @ApiModelProperty(value="secret code of the subscriber")
    private String b32Secret;
    @ApiModelProperty(value=" type of subscriber (play or publish). Pay attention that 'publish' type can also play the streams for making easy to join video conferencing")
    private String type;
    @Deprecated(since="2.4.3", forRemoval=true)
    @ApiModelProperty(value="is subscriber connected")
    private boolean connected;
    @ApiModelProperty(value=" count of subscriber usage")
    private int currentConcurrentConnections = 0;
    @ApiModelProperty(value=" count of subscriber usage")
    private int concurrentConnectionsLimit = 1;
    private String blockedType;
    private long blockedUntilUnitTimeStampMs = 0L;
    private String registeredNodeIp;

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public void setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getB32Secret() {
        return this.b32Secret;
    }

    public void setB32Secret(String b32Secret) {
        this.b32Secret = b32Secret;
    }

    public SubscriberStats getStats() {
        return this.stats;
    }

    @JsonIgnore
    public void setStats(SubscriberStats stats) {
        if (stats != null) {
            stats.setStreamId(this.streamId);
            stats.setSubscriberId(this.subscriberId);
        }
        this.stats = stats;
    }

    @JsonIgnore
    public String getSubscriberKey() {
        return Subscriber.getDBKey(this.streamId, this.subscriberId);
    }

    public static String getDBKey(String streamId, String subscriberId) {
        return streamId + "-" + subscriberId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (PLAY_TYPE.equals(type) || PUBLISH_TYPE.equals(type)) {
            this.type = type;
        }
    }

    @Deprecated(since="2.4.3", forRemoval=true)
    public boolean isConnected() {
        return this.connected;
    }

    @Deprecated(since="2.4.3", forRemoval=true)
    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public int getCurrentConcurrentConnections() {
        return this.currentConcurrentConnections;
    }

    public void setCurrentConcurrentConnections(int currentConcurrentConnections) {
        this.currentConcurrentConnections = currentConcurrentConnections;
    }

    public int getConcurrentConnectionsLimit() {
        return this.concurrentConnectionsLimit;
    }

    public void setConcurrentConnectionsLimit(int concurrentConnectionsLimit) {
        this.concurrentConnectionsLimit = concurrentConnectionsLimit;
    }

    public String getRegisteredNodeIp() {
        return this.registeredNodeIp;
    }

    public void setRegisteredNodeIp(String registeredNodeIp) {
        this.registeredNodeIp = registeredNodeIp;
    }

    public boolean isBlocked(String type) {
        long currTime = System.currentTimeMillis();
        return (type.equals(this.blockedType) || PUBLISH_AND_PLAY_TYPE.equals(this.blockedType)) && this.getBlockedUntilUnitTimeStampMs() != 0L && this.getBlockedUntilUnitTimeStampMs() >= currTime;
    }

    public String getBlockedType() {
        return this.blockedType;
    }

    public void setBlockedType(String blockedType) {
        this.blockedType = blockedType;
    }

    public long getBlockedUntilUnitTimeStampMs() {
        return this.blockedUntilUnitTimeStampMs;
    }

    public void setBlockedUntilUnitTimeStampMs(long blockedUntilUnitTimeStampMs) {
        this.blockedUntilUnitTimeStampMs = blockedUntilUnitTimeStampMs;
    }
}

