/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.filter.TokenFilterManager;
import io.antmedia.statistic.IStreamStats;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashStatisticsFilter
extends AbstractFilter {
    protected static Logger logger = LoggerFactory.getLogger(DashStatisticsFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod();
        if ("GET".equals(method) && httpRequest.getRequestURI().endsWith("m4s")) {
            String sessionId = httpRequest.getSession().getId();
            String streamId = TokenFilterManager.getStreamId(httpRequest.getRequestURI());
            String subscriberId = ((HttpServletRequest)request).getParameter("subscriberId");
            Broadcast broadcast = this.getBroadcast((HttpServletRequest)request, streamId);
            if (broadcast != null && broadcast.getDashViewerLimit() != -1 && broadcast.getDashViewerCount() >= broadcast.getDashViewerLimit()) {
                ((HttpServletResponse)response).sendError(403, "Viewer Limit Reached");
                return;
            }
            chain.doFilter(request, response);
            int status = ((HttpServletResponse)response).getStatus();
            if (200 <= status && status <= 400 && streamId != null) {
                logger.debug("req ip {} session id {} stream id {} status {}", new Object[]{request.getRemoteHost(), sessionId, streamId, status});
                IStreamStats stats = this.getStreamStats("dash.viewerstats");
                if (stats != null) {
                    stats.registerNewViewer(streamId, sessionId, subscriberId);
                }
            }
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }
}

