/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import io.antmedia.filter.AbstractFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpForwardFilter
extends AbstractFilter {
    private static final String SLASH = "/";
    protected static Logger logger = LoggerFactory.getLogger(HttpForwardFilter.class);
    private static final String COMMA = ",";
    private static final String DOUBLE_DOT = "..";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AppSettings appSettings;
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        if (requestURI != null && !requestURI.isEmpty() && (appSettings = this.getAppSettings()) != null) {
            String httpForwardingExtension = appSettings.getHttpForwardingExtension();
            String httpForwardingBaseURL = appSettings.getHttpForwardingBaseURL();
            if (httpForwardingExtension != null && !httpForwardingExtension.isEmpty() && httpForwardingBaseURL != null && !httpForwardingBaseURL.isEmpty()) {
                String[] extension = httpForwardingExtension.split(COMMA);
                for (int i = 0; i < extension.length; ++i) {
                    if (!requestURI.endsWith(extension[i])) continue;
                    String redirectUri = httpForwardingBaseURL + requestURI.substring(requestURI.indexOf(SLASH, 1));
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    if (redirectUri.contains(DOUBLE_DOT)) {
                        throw new IOException("URI is not well formatted");
                    }
                    httpResponse.sendRedirect(redirectUri);
                    return;
                }
                logger.trace("Extensions({}) does match the request uri: {}", (Object)extension, (Object)requestURI);
            } else {
                logger.trace("No forwarding because extension or url not set for request: {}", (Object)requestURI);
            }
        }
        chain.doFilter(request, response);
    }
}

