/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.filter.AbstractFilter;
import io.antmedia.settings.ServerSettings;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFilterDashboard
extends AbstractFilter {
    protected static Logger logger = LoggerFactory.getLogger(IPFilterDashboard.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isAllowedDashboard(request.getRemoteAddr())) {
            chain.doFilter(request, response);
            return;
        }
        ((HttpServletResponse)response).sendError(403, "Not allowed IP");
    }

    public boolean isAllowedDashboard(String remoteIPAdrress) {
        ServerSettings serverSettings = this.getServerSettings();
        if (serverSettings != null) {
            return this.checkCIDRList(serverSettings.getAllowedCIDRList(), remoteIPAdrress);
        }
        return false;
    }
}

