/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.antmedia.muxer.RecordMuxer;
import io.antmedia.storage.StorageClient;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.bytedeco.ffmpeg.avcodec.AVBSFContext;
import org.bytedeco.ffmpeg.avcodec.AVBitStreamFilter;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVIOContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;

public class Mp4Muxer
extends RecordMuxer {
    private AVBSFContext bsfContext;
    private boolean isAVCConversionRequired = false;
    private static int[] MP4_SUPPORTED_CODECS = new int[]{94213, 12, 27, 173, 86018, 86061, 2, 2, 2, 2, 2, 2, 86018, 86017, 86016, 1, 86017, 7, 61, 88, 70, 116, 86019, 86056, 86020, 167, 163, 86021, 94208, 86040, 131073, 131073, 0};

    public Mp4Muxer(StorageClient storageClient, Vertx vertx, String s3FolderPath) {
        super(storageClient, vertx, s3FolderPath);
        this.options.put("movflags", "faststart");
        this.extension = ".mp4";
        this.format = "mp4";
        this.SUPPORTED_CODECS = MP4_SUPPORTED_CODECS;
    }

    @Override
    public synchronized boolean addVideoStream(int width, int height, AVRational timebase, int codecId, int streamIndex, boolean isAVC, AVCodecParameters codecpar) {
        this.isAVCConversionRequired = !isAVC;
        return super.addVideoStream(width, height, timebase, codecId, streamIndex, isAVC, codecpar);
    }

    @Override
    protected boolean prepareAudioOutStream(AVStream inStream, AVStream outStream) {
        if (this.bsfVideoName != null) {
            AVBitStreamFilter adtsToAscBsf = avcodec.av_bsf_get_by_name((String)this.bsfVideoName);
            this.bsfContext = new AVBSFContext(null);
            int ret = avcodec.av_bsf_alloc((AVBitStreamFilter)adtsToAscBsf, (AVBSFContext)this.bsfContext);
            if (ret < 0) {
                this.logger.info("cannot allocate bsf context for {}", (Object)this.streamId);
                return false;
            }
            ret = avcodec.avcodec_parameters_copy((AVCodecParameters)this.bsfContext.par_in(), (AVCodecParameters)inStream.codecpar());
            if (ret < 0) {
                this.logger.info("cannot copy input codec parameters for {}", (Object)this.streamId);
                return false;
            }
            this.bsfContext.time_base_in(inStream.time_base());
            ret = avcodec.av_bsf_init((AVBSFContext)this.bsfContext);
            if (ret < 0) {
                this.logger.info("cannot init bit stream filter context for {}", (Object)this.streamId);
                return false;
            }
            ret = avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)this.bsfContext.par_out());
            if (ret < 0) {
                this.logger.info("cannot copy codec parameters to output for {}", (Object)this.streamId);
                return false;
            }
        } else {
            return super.prepareAudioOutStream(inStream, outStream);
        }
        outStream.time_base(this.bsfContext.time_base_out());
        return true;
    }

    public static void remux(String srcFile, String dstFile, int rotation) {
        AVFormatContext inputContext = new AVFormatContext(null);
        int ret = avformat.avformat_open_input((AVFormatContext)inputContext, (String)srcFile, null, null);
        if (ret < 0) {
            loggerStatic.warn("cannot open input context {} errror code: {}", (Object)srcFile, (Object)ret);
            return;
        }
        ret = avformat.avformat_find_stream_info((AVFormatContext)inputContext, (AVDictionary)null);
        if (ret < 0) {
            loggerStatic.warn("Cannot find stream info {}", (Object)srcFile);
            return;
        }
        AVFormatContext outputContext = new AVFormatContext(null);
        avformat.avformat_alloc_output_context2((AVFormatContext)outputContext, null, null, (String)dstFile);
        int streamCount = inputContext.nb_streams();
        for (int i = 0; i < streamCount; ++i) {
            AVStream stream = avformat.avformat_new_stream((AVFormatContext)outputContext, null);
            ret = avcodec.avcodec_parameters_copy((AVCodecParameters)stream.codecpar(), (AVCodecParameters)inputContext.streams(i).codecpar());
            if (ret < 0) {
                loggerStatic.warn("Cannot copy codecpar parameters from {} to {} for stream index {}", new Object[]{srcFile, dstFile, i});
                return;
            }
            stream.codecpar().codec_tag(0);
            if (stream.codecpar().codec_type() != 0) continue;
            int size = 9 * Pointer.sizeof(IntPointer.class);
            IntPointer rotationMatrixPointer = new IntPointer(avutil.av_malloc((long)size)).capacity((long)size);
            avutil.av_display_rotation_set((IntPointer)rotationMatrixPointer, (double)rotation);
            BytePointer bytePointer = new BytePointer((Pointer)rotationMatrixPointer);
            bytePointer.limit((long)rotationMatrixPointer.sizeof() * rotationMatrixPointer.limit());
            ret = avformat.av_stream_add_side_data((AVStream)stream, (int)5, (BytePointer)bytePointer, (long)bytePointer.limit());
            if (ret >= 0) continue;
            loggerStatic.error("Cannot add rotation matrix side data to file:{}", (Object)dstFile);
        }
        AVIOContext pb = new AVIOContext(null);
        ret = avformat.avio_open((AVIOContext)pb, (String)dstFile, (int)2);
        if (ret < 0) {
            loggerStatic.warn("Cannot open io context {}", (Object)dstFile);
            return;
        }
        outputContext.pb(pb);
        ret = avformat.avformat_write_header((AVFormatContext)outputContext, (AVDictionary)null);
        if (ret < 0) {
            loggerStatic.warn("Cannot write header to {}", (Object)dstFile);
            return;
        }
        AVPacket pkt = new AVPacket();
        while (avformat.av_read_frame((AVFormatContext)inputContext, (AVPacket)pkt) == 0) {
            AVStream inStream = inputContext.streams(pkt.stream_index());
            AVStream outStream = outputContext.streams(pkt.stream_index());
            pkt.pts(avutil.av_rescale_q_rnd((long)pkt.pts(), (AVRational)inStream.time_base(), (AVRational)outStream.time_base(), (int)8197));
            pkt.dts(avutil.av_rescale_q_rnd((long)pkt.dts(), (AVRational)inStream.time_base(), (AVRational)outStream.time_base(), (int)8197));
            pkt.duration(avutil.av_rescale_q((long)pkt.duration(), (AVRational)inStream.time_base(), (AVRational)outStream.time_base()));
            pkt.pos(-1L);
            avformat.av_write_frame((AVFormatContext)outputContext, (AVPacket)pkt);
            avcodec.av_packet_unref((AVPacket)pkt);
        }
        avformat.av_write_trailer((AVFormatContext)outputContext);
        avformat.avformat_close_input((AVFormatContext)inputContext);
        avformat.avio_closep((AVIOContext)outputContext.pb());
        avformat.avformat_free_context((AVFormatContext)outputContext);
    }

    @Override
    protected void finalizeRecordFile(File file) throws IOException {
        if (this.isAVCConversionRequired) {
            this.logger.info("AVC conversion needed for MP4 {}", (Object)this.fileTmp.getName());
            Mp4Muxer.remux(this.fileTmp.getAbsolutePath(), file.getAbsolutePath(), this.rotation);
            Files.delete(this.fileTmp.toPath());
        } else {
            super.finalizeRecordFile(file);
        }
    }

    @Override
    public synchronized void clearResource() {
        super.clearResource();
        if (this.bsfContext != null) {
            avcodec.av_bsf_free((AVBSFContext)this.bsfContext);
            this.bsfContext = null;
        }
    }

    @Override
    protected void writeAudioFrame(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, AVFormatContext context, long dts) {
        if (this.bsfContext != null) {
            int ret = avcodec.av_bsf_send_packet((AVBSFContext)this.bsfContext, (AVPacket)this.getTmpPacket());
            if (ret < 0) {
                return;
            }
            while (avcodec.av_bsf_receive_packet((AVBSFContext)this.bsfContext, (AVPacket)this.getTmpPacket()) == 0) {
                ret = avformat.av_write_frame((AVFormatContext)context, (AVPacket)this.getTmpPacket());
                if (ret >= 0 || !this.logger.isInfoEnabled()) continue;
                this.logger.info("cannot write audio frame to muxer({}) av_bsf_receive_packet. Error is {} ", (Object)this.file.getName(), (Object)Mp4Muxer.getErrorDefinition(ret));
                this.logger.info("input timebase num/den {}/{}output timebase num/den {}/{}", new Object[]{inputTimebase.num(), inputTimebase.den(), outputTimebase.num(), outputTimebase.den()});
                this.logger.info("received dts {}", (Object)dts);
                this.logger.info("calculated dts {}", (Object)pkt.dts());
            }
        } else {
            super.writeAudioFrame(pkt, inputTimebase, outputTimebase, context, dts);
        }
    }
}

