/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.security;

import com.amazonaws.util.Base32;
import com.google.common.primitives.Longs;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TOTPGenerator {
    protected static Logger logger = LoggerFactory.getLogger(TOTPGenerator.class);
    private static final long[] DIGITS_POWER = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L};

    private static byte[] hmac_sha(String crypto, byte[] keyBytes, byte[] text) {
        try {
            Mac hmac = Mac.getInstance(crypto);
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
            hmac.init(macKey);
            return hmac.doFinal(text);
        }
        catch (GeneralSecurityException gse) {
            throw new UndeclaredThrowableException(gse);
        }
    }

    public static String getSecretCodeForNotRecordedSubscriberId(String subscriberId, String streamId, String type, String secretFromSettings) {
        String secretCode = null;
        if (secretFromSettings != null) {
            secretCode = secretFromSettings + subscriberId + streamId + type;
            int remainder = secretCode.length() % 8;
            if (remainder != 0) {
                int paddingLength = 8 - remainder;
                secretCode = secretCode + StringUtils.repeat((char)'X', (int)paddingLength);
            }
            return Base32.encodeAsString((byte[])secretCode.getBytes());
        }
        streamId = streamId.replaceAll("[\n\r]", "_");
        subscriberId = subscriberId.replaceAll("[\n\r]", "_");
        logger.warn("TOTP secret is not valid. It should be not null and it's length must multiple of 8 for streamId:{} and subsriberId:{}", (Object)streamId, (Object)subscriberId);
        return null;
    }

    public static String generateTOTPWithTimeConstant(byte[] secretBytes, int codeDigits, String crypto, long timeConstant) {
        Object result = null;
        byte[] msg = Longs.toByteArray((long)timeConstant);
        byte[] k = secretBytes;
        byte[] hash = TOTPGenerator.hmac_sha(crypto, k, msg);
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        long otp = (long)binary % DIGITS_POWER[codeDigits];
        result = Long.toString(otp);
        while (((String)result).length() < codeDigits) {
            result = "0" + (String)result;
        }
        return result;
    }

    public static String generateTOTP(byte[] secretBytes, int duration, int codeDigits, String crypto) {
        long durationMs = (long)duration * 1000L;
        double division = (double)System.currentTimeMillis() / (double)durationMs;
        long timeConstant = (long)Math.floor(division);
        return TOTPGenerator.generateTOTPWithTimeConstant(secretBytes, codeDigits, crypto, timeConstant);
    }
}

