/*
 * Decompiled with CFR 0.152.
 */
package org.red5.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.selector.ContextSelector;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.red5.logging.LoggingContextSelector;
import org.red5.logging.Red5LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class LoggerContextFilter
implements Filter {
    private String contextName;

    public void init(FilterConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        this.contextName = servletContext.getContextPath().replaceAll("/", "");
        if ("".equals(this.contextName)) {
            this.contextName = "root";
        }
        System.out.printf("Filter init: %s%n", this.contextName);
        ConfigurableWebApplicationContext appctx = (ConfigurableWebApplicationContext)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (appctx != null) {
            System.out.printf("ConfigurableWebApplicationContext is not null in LoggerContextFilter for: %s, this indicates a misconfiguration or load order problem%n", this.contextName);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LoggerContext context = (LoggerContext)request.getServletContext().getAttribute("logger.context");
        ContextSelector selector = Red5LoggerFactory.getContextSelector();
        if (context != null) {
            ((LoggingContextSelector)selector).setLocalContext(context);
        } else {
            System.err.printf("No context named %s was found%n", this.contextName);
        }
        chain.doFilter(request, response);
        ((LoggingContextSelector)selector).removeLocalContext();
    }

    public void destroy() {
    }
}

