/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.bandwidth;

import java.util.HashMap;
import java.util.Map;
import org.red5.server.api.IConnection;
import org.red5.server.api.Red5;
import org.red5.server.api.service.IPendingServiceCall;
import org.red5.server.api.service.IPendingServiceCallback;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServerDetection
implements IPendingServiceCallback {
    protected static Logger log = LoggerFactory.getLogger(ClientServerDetection.class);

    @Override
    public void resultReceived(IPendingServiceCall call) {
        if (32 == call.getStatus()) {
            log.debug("Pending call skipped due to being no longer connected");
        }
    }

    private IStreamCapableConnection getStats() {
        IConnection conn = Red5.getConnectionLocal();
        if (conn instanceof IStreamCapableConnection) {
            return (IStreamCapableConnection)conn;
        }
        return null;
    }

    public Map<String, Object> checkBandwidth(Object[] params) {
        IStreamCapableConnection stats = this.getStats();
        HashMap<String, Object> statsValues = new HashMap<String, Object>();
        Number time = 0;
        if (params.length > 0) {
            time = params[0] instanceof Double ? (Number)((Double)params[0]) : (Number)((Integer)params[0]);
        }
        statsValues.put("cOutBytes", stats.getReadBytes());
        statsValues.put("cInBytes", stats.getWrittenBytes());
        statsValues.put("time", time.intValue());
        log.debug("cOutBytes: {} cInBytes: {} time: {}", new Object[]{stats.getReadBytes(), stats.getWrittenBytes(), time});
        return statsValues;
    }
}

