/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConferenceRoom;
import io.antmedia.datastore.db.types.ConnectionEvent;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.P2PConnection;
import io.antmedia.datastore.db.types.StreamInfo;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.datastore.db.types.SubscriberStats;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.datastore.db.types.WebRTCViewerInfo;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataStore {
    public static final int MAX_ITEM_IN_ONE_LIST = 250;
    private static final String REPLACE_CHARS_REGEX = "[\n|\r|\t]";
    private boolean writeStatsToDatastore = true;
    protected volatile boolean available = false;
    protected static Logger logger = LoggerFactory.getLogger(DataStore.class);
    public static final long TOTAL_WEBRTC_VIEWER_COUNT_CACHE_TIME = 5000L;
    protected int totalWebRTCViewerCount = 0;
    protected long totalWebRTCViewerCountLastUpdateTime = 0L;

    public abstract String save(Broadcast var1);

    public Broadcast saveBroadcast(Broadcast broadcast) {
        Object streamId = null;
        try {
            if (broadcast.getStreamId() == null || broadcast.getStreamId().isEmpty()) {
                streamId = RandomStringUtils.randomAlphanumeric((int)16) + System.currentTimeMillis();
                broadcast.setStreamId((String)streamId);
            }
            streamId = broadcast.getStreamId();
            Object rtmpURL = broadcast.getRtmpURL();
            if (rtmpURL != null) {
                rtmpURL = (String)rtmpURL + (String)streamId;
            }
            broadcast.setRtmpURL((String)rtmpURL);
            if (broadcast.getStatus() == null) {
                broadcast.setStatus("created");
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return broadcast;
    }

    public abstract Broadcast get(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Broadcast get(Map<String, String> broadcastMap, String streamId, Gson gson) {
        DataStore dataStore = this;
        synchronized (dataStore) {
            Broadcast broadcast = null;
            String jsonString = null;
            if (streamId != null) {
                jsonString = broadcastMap.get(streamId);
                if (jsonString != null) {
                    return (Broadcast)gson.fromJson(jsonString, Broadcast.class);
                }
                return broadcast;
            }
        }
        return null;
    }

    public abstract VoD getVoD(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoD getVoD(Map<String, String> vodMap, String vodId, Gson gson) {
        DataStore dataStore = this;
        synchronized (dataStore) {
            if (vodId != null) {
                String jsonString = null;
                jsonString = vodMap.get(vodId);
                if (jsonString != null) {
                    return (VoD)gson.fromJson(jsonString, VoD.class);
                }
            }
        }
        return null;
    }

    public abstract boolean updateStatus(String var1, String var2);

    public boolean updateSourceQualityParameters(String id, String quality, double speed, int pendingPacketQueue) {
        if (this.writeStatsToDatastore) {
            return this.updateSourceQualityParametersLocal(id, quality, speed, pendingPacketQueue);
        }
        return false;
    }

    protected abstract boolean updateSourceQualityParametersLocal(String var1, String var2, double var3, int var5);

    public abstract boolean updateDuration(String var1, long var2);

    public abstract long getPartialVodNumber(String var1);

    public abstract long getPartialBroadcastNumber(String var1);

    public abstract boolean addEndpoint(String var1, Endpoint var2);

    public abstract String addVod(VoD var1);

    @Deprecated
    public abstract long getBroadcastCount();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBroadcastCount(Map<String, String> broadcastMap) {
        DataStore dataStore = this;
        synchronized (dataStore) {
            return broadcastMap.size();
        }
    }

    public abstract boolean delete(String var1);

    public abstract boolean deleteVod(String var1);

    public abstract List<Broadcast> getBroadcastList(int var1, int var2, String var3, String var4, String var5, String var6);

    public abstract List<ConferenceRoom> getConferenceRoomList(int var1, int var2, String var3, String var4, String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConferenceRoom> getConferenceRoomList(Map<String, String> conferenceMap, int offset, int size, String sortBy, String orderBy, String search, Gson gson) {
        ArrayList<ConferenceRoom> list = new ArrayList<ConferenceRoom>();
        DataStore dataStore = this;
        synchronized (dataStore) {
            Collection<String> conferenceRooms = null;
            conferenceRooms = conferenceMap.values();
            for (String roomString : conferenceRooms) {
                ConferenceRoom room = (ConferenceRoom)gson.fromJson(roomString, ConferenceRoom.class);
                list.add(room);
            }
        }
        if (search != null && !search.isEmpty()) {
            search = search.replaceAll(REPLACE_CHARS_REGEX, "_");
            logger.info("server side search called for Conference Room = {}", (Object)search);
            list = this.searchOnServerConferenceRoom(list, search);
        }
        return this.sortAndCropConferenceRoomList(list, offset, size, sortBy, orderBy);
    }

    public abstract boolean removeEndpoint(String var1, Endpoint var2, boolean var3);

    public abstract List<Broadcast> getExternalStreamsList();

    public abstract void close(boolean var1);

    public abstract List<VoD> getVodList(int var1, int var2, String var3, String var4, String var5, String var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VoD> getVodListV2(Map<String, String> vodMap, String streamId, String search, Gson gson, String dbName) {
        ArrayList<VoD> vods = new ArrayList<VoD>();
        DataStore dataStore = this;
        synchronized (dataStore) {
            int length = vodMap.size();
            int i = 0;
            for (String vodString : vodMap.values()) {
                VoD vod = (VoD)gson.fromJson(vodString, VoD.class);
                if (streamId != null && !streamId.isEmpty()) {
                    if (vod.getStreamId().equals(streamId)) {
                        vods.add(vod);
                    }
                } else {
                    vods.add(vod);
                }
                if (++i <= length) continue;
                logger.error("Inconsistency in DB. It's likely db file({}) is damaged", (Object)dbName);
                break;
            }
            if (search != null && !search.isEmpty()) {
                search = search.replaceAll(REPLACE_CHARS_REGEX, "_");
                logger.info("server side search called for VoD searchString = {}", (Object)search);
                vods = this.searchOnServerVod(vods, search);
            }
            return vods;
        }
    }

    public abstract boolean removeAllEndpoints(String var1);

    public abstract long getTotalVodNumber();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalVodNumber(Map<String, String> broadcastMap) {
        DataStore dataStore = this;
        synchronized (dataStore) {
            return broadcastMap.size();
        }
    }

    public abstract long getTotalBroadcastNumber();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalBroadcastNumber(Map<String, String> broadcastMap) {
        DataStore dataStore = this;
        synchronized (dataStore) {
            return broadcastMap.size();
        }
    }

    public abstract void saveDetection(String var1, long var2, List<TensorFlowObject> var4);

    public abstract List<TensorFlowObject> getDetectionList(String var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TensorFlowObject> getDetectionList(Map<String, String> detectionMap, String idFilter, int offsetSize, int batchSize, Gson gson) {
        ArrayList<TensorFlowObject> list = new ArrayList<TensorFlowObject>();
        DataStore dataStore = this;
        synchronized (dataStore) {
            Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
            int offsetCount = 0;
            int batchCount = 0;
            if (batchSize > 250) {
                batchSize = 250;
            }
            for (String keyValue : detectionMap.keySet()) {
                if (!keyValue.startsWith(idFilter)) continue;
                if (offsetCount < offsetSize) {
                    ++offsetCount;
                    continue;
                }
                if (batchCount >= batchSize) break;
                List detectedList = (List)gson.fromJson(detectionMap.get(keyValue), listType);
                list.addAll(detectedList);
                batchCount = list.size();
            }
        }
        return list;
    }

    public abstract List<TensorFlowObject> getDetection(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TensorFlowObject> getDetection(Map<String, String> detectionMap, String id, Gson gson) {
        DataStore dataStore = this;
        synchronized (dataStore) {
            String jsonString;
            if (id != null && (jsonString = detectionMap.get(id)) != null) {
                Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
                return (List)gson.fromJson(jsonString, listType);
            }
        }
        return null;
    }

    public abstract boolean saveToken(Token var1);

    public abstract List<Token> listAllTokens(String var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token> listAllTokens(Map<String, String> tokenMap, String streamId, int offset, int size, Gson gson) {
        ArrayList<Token> list = new ArrayList<Token>();
        ArrayList<Token> listToken = new ArrayList<Token>();
        DataStore dataStore = this;
        synchronized (dataStore) {
            Collection<String> values = tokenMap.values();
            int t = 0;
            int itemCount = 0;
            if (size > 250) {
                size = 250;
            }
            if (offset < 0) {
                offset = 0;
            }
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                Token token = (Token)gson.fromJson(iterator.next(), Token.class);
                if (!token.getStreamId().equals(streamId)) continue;
                list.add(token);
            }
            Iterator listIterator = list.iterator();
            while (itemCount < size && listIterator.hasNext()) {
                if (t < offset) {
                    ++t;
                    listIterator.next();
                    continue;
                }
                listToken.add((Token)listIterator.next());
                ++itemCount;
            }
        }
        return listToken;
    }

    public abstract Token validateToken(Token var1);

    public abstract boolean revokeTokens(String var1);

    public abstract boolean deleteToken(String var1);

    public abstract Token getToken(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken(Map<String, String> tokenMap, String tokenId, Gson gson) {
        Token token = null;
        DataStore dataStore = this;
        synchronized (dataStore) {
            String jsonString;
            if (tokenId != null && (jsonString = tokenMap.get(tokenId)) != null) {
                token = (Token)gson.fromJson(jsonString, Token.class);
            }
        }
        return token;
    }

    public abstract List<Subscriber> listAllSubscribers(String var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Subscriber> listAllSubscribers(Map<String, String> subscriberMap, String streamId, int offset, int size, Gson gson) {
        ArrayList<Subscriber> list = new ArrayList<Subscriber>();
        ArrayList<Subscriber> listSubscriber = new ArrayList<Subscriber>();
        DataStore dataStore = this;
        synchronized (dataStore) {
            Collection<String> values = subscriberMap.values();
            int t = 0;
            int itemCount = 0;
            if (size > 250) {
                size = 250;
            }
            if (offset < 0) {
                offset = 0;
            }
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                Subscriber subscriber = (Subscriber)gson.fromJson(iterator.next(), Subscriber.class);
                if (!subscriber.getStreamId().equals(streamId)) continue;
                list.add(subscriber);
            }
            Iterator listIterator = list.iterator();
            while (itemCount < size && listIterator.hasNext()) {
                if (t < offset) {
                    ++t;
                    listIterator.next();
                    continue;
                }
                listSubscriber.add((Subscriber)listIterator.next());
                ++itemCount;
            }
        }
        return listSubscriber;
    }

    public List<SubscriberStats> listAllSubscriberStats(String streamId, int offset, int size) {
        List<Subscriber> subscribers = this.listAllSubscribers(streamId, offset, size);
        ArrayList<SubscriberStats> subscriberStats = new ArrayList<SubscriberStats>();
        for (Subscriber subscriber : subscribers) {
            SubscriberStats stat = subscriber.getStats();
            stat.setStreamId(subscriber.getStreamId());
            stat.setSubscriberId(subscriber.getSubscriberId());
            subscriberStats.add(stat);
        }
        return subscriberStats;
    }

    public abstract boolean addSubscriber(String var1, Subscriber var2);

    public abstract boolean deleteSubscriber(String var1, String var2);

    public abstract boolean blockSubscriber(String var1, String var2, String var3, int var4);

    public abstract boolean revokeSubscribers(String var1);

    public abstract Subscriber getSubscriber(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscriber getSubscriber(Map<String, String> subscriberMap, String streamId, String subscriberId, Gson gson) {
        Subscriber subscriber = null;
        DataStore dataStore = this;
        synchronized (dataStore) {
            String jsonString;
            if (subscriberId != null && streamId != null && (jsonString = subscriberMap.get(Subscriber.getDBKey(streamId, subscriberId))) != null) {
                subscriber = (Subscriber)gson.fromJson(jsonString, Subscriber.class);
            }
        }
        return subscriber;
    }

    public boolean isSubscriberConnected(String streamId, String subscriberId) {
        Subscriber subscriber = this.getSubscriber(streamId, subscriberId);
        if (subscriber != null) {
            return subscriber.isConnected();
        }
        return false;
    }

    public boolean addSubscriberConnectionEvent(String streamId, String subscriberId, ConnectionEvent event) {
        boolean result = false;
        Subscriber subscriber = this.getSubscriber(streamId, subscriberId);
        if (subscriber != null) {
            this.handleConnectionEvent(subscriber, event);
            this.addSubscriber(streamId, subscriber);
            result = true;
        }
        return result;
    }

    protected void handleConnectionEvent(Subscriber subscriber, ConnectionEvent event) {
        if ("connected".equals(event.getEventType())) {
            subscriber.setConnected(true);
            subscriber.setCurrentConcurrentConnections(subscriber.getCurrentConcurrentConnections() + 1);
        } else if ("disconnected".equals(event.getEventType())) {
            subscriber.setConnected(false);
            subscriber.setCurrentConcurrentConnections(subscriber.getCurrentConcurrentConnections() - 1);
        }
        subscriber.getStats().addConnectionEvent(event);
    }

    public boolean updateSubscriberBitrateEvent(String streamId, String subscriberId, long avgVideoBitrate, long avgAudioBitrate) {
        boolean result = false;
        Subscriber subscriber = this.getSubscriber(streamId, subscriberId);
        if (subscriber != null) {
            subscriber.getStats().setAvgVideoBitrate(avgVideoBitrate);
            subscriber.getStats().setAvgAudioBitrate(avgAudioBitrate);
            this.addSubscriber(streamId, subscriber);
            result = true;
        }
        return result;
    }

    public abstract boolean resetSubscribersConnectedStatus();

    public abstract boolean setMp4Muxing(String var1, int var2);

    public abstract boolean setWebMMuxing(String var1, int var2);

    public abstract int fetchUserVodList(File var1);

    public abstract long getActiveBroadcastCount();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActiveBroadcastCount(Map<String, String> broadcastMap, Gson gson, String hostAddress) {
        int activeBroadcastCount = 0;
        DataStore dataStore = this;
        synchronized (dataStore) {
            Collection<String> values = broadcastMap.values();
            for (String broadcastString : values) {
                Broadcast broadcast = (Broadcast)gson.fromJson(broadcastString, Broadcast.class);
                String status = broadcast.getStatus();
                if (!"broadcasting".equals(status) || !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{hostAddress, broadcast.getOriginAdress()}) && !hostAddress.equals(broadcast.getOriginAdress())) continue;
                ++activeBroadcastCount;
            }
        }
        return activeBroadcastCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> getActiveBroadcastList(Map<String, String> broadcastMap, Gson gson, String hostAddress) {
        ArrayList<Broadcast> broadcastList = new ArrayList<Broadcast>();
        DataStore dataStore = this;
        synchronized (dataStore) {
            Collection<String> values = broadcastMap.values();
            for (String broadcastString : values) {
                Broadcast broadcast = (Broadcast)gson.fromJson(broadcastString, Broadcast.class);
                String status = broadcast.getStatus();
                if (!"broadcasting".equals(status) || !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{hostAddress, broadcast.getOriginAdress()}) && !hostAddress.equals(broadcast.getOriginAdress())) continue;
                broadcastList.add(broadcast);
            }
        }
        return broadcastList;
    }

    public abstract boolean updateBroadcastFields(String var1, Broadcast var2);

    public boolean updateHLSViewerCount(String streamId, int diffCount) {
        if (this.writeStatsToDatastore) {
            return this.updateHLSViewerCountLocal(streamId, diffCount);
        }
        return false;
    }

    protected abstract boolean updateHLSViewerCountLocal(String var1, int var2);

    public boolean updateDASHViewerCount(String streamId, int diffCount) {
        if (this.writeStatsToDatastore) {
            return this.updateDASHViewerCountLocal(streamId, diffCount);
        }
        return false;
    }

    protected abstract boolean updateDASHViewerCountLocal(String var1, int var2);

    public abstract long getObjectDetectedTotal(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getObjectDetectedTotal(Map<String, String> detectionMap, String streamId, Gson gson) {
        ArrayList list = new ArrayList();
        Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
        DataStore dataStore = this;
        synchronized (dataStore) {
            for (String keyValue : detectionMap.keySet()) {
                if (!keyValue.startsWith(streamId)) continue;
                List detectedList = (List)gson.fromJson(detectionMap.get(keyValue), listType);
                list.addAll(detectedList);
            }
        }
        return list.size();
    }

    public boolean updateWebRTCViewerCount(String streamId, boolean increment) {
        if (this.writeStatsToDatastore) {
            return this.updateWebRTCViewerCountLocal(streamId, increment);
        }
        return false;
    }

    protected abstract boolean updateWebRTCViewerCountLocal(String var1, boolean var2);

    public boolean updateRtmpViewerCount(String streamId, boolean increment) {
        if (this.writeStatsToDatastore) {
            return this.updateRtmpViewerCountLocal(streamId, increment);
        }
        return false;
    }

    protected abstract boolean updateRtmpViewerCountLocal(String var1, boolean var2);

    public abstract void saveStreamInfo(StreamInfo var1);

    public abstract List<StreamInfo> getStreamInfoList(String var1);

    public abstract void clearStreamInfoList(String var1);

    public boolean isWriteStatsToDatastore() {
        return this.writeStatsToDatastore;
    }

    public void setWriteStatsToDatastore(boolean writeStatsToDatastore) {
        this.writeStatsToDatastore = writeStatsToDatastore;
    }

    public abstract boolean createConferenceRoom(ConferenceRoom var1);

    public abstract boolean editConferenceRoom(String var1, ConferenceRoom var2);

    public abstract boolean deleteConferenceRoom(String var1);

    public abstract ConferenceRoom getConferenceRoom(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConferenceRoom getConferenceRoom(Map<String, String> conferenceRoomMap, String roomId, Gson gson) {
        DataStore dataStore = this;
        synchronized (dataStore) {
            String jsonString;
            if (roomId != null && (jsonString = conferenceRoomMap.get(roomId)) != null) {
                return (ConferenceRoom)gson.fromJson(jsonString, ConferenceRoom.class);
            }
        }
        return null;
    }

    protected void updateStreamInfo(Broadcast broadcast, Broadcast newBroadcast) {
        if (newBroadcast.getName() != null) {
            broadcast.setName(newBroadcast.getName());
        }
        if (newBroadcast.getDescription() != null) {
            broadcast.setDescription(newBroadcast.getDescription());
        }
        if (newBroadcast.getUsername() != null) {
            broadcast.setUsername(newBroadcast.getUsername());
        }
        if (newBroadcast.getPassword() != null) {
            broadcast.setPassword(newBroadcast.getPassword());
        }
        if (newBroadcast.getIpAddr() != null) {
            broadcast.setIpAddr(newBroadcast.getIpAddr());
        }
        if (newBroadcast.getStreamUrl() != null) {
            broadcast.setStreamUrl(newBroadcast.getStreamUrl());
        }
        if (newBroadcast.getLatitude() != null) {
            broadcast.setLatitude(newBroadcast.getLatitude());
        }
        if (newBroadcast.getLongitude() != null) {
            broadcast.setLongitude(newBroadcast.getLongitude());
        }
        if (newBroadcast.getAltitude() != null) {
            broadcast.setAltitude(newBroadcast.getAltitude());
        }
        if (newBroadcast.getMainTrackStreamId() != null) {
            broadcast.setMainTrackStreamId(newBroadcast.getMainTrackStreamId());
        }
        if (newBroadcast.getStartTime() != 0L) {
            broadcast.setStartTime(newBroadcast.getStartTime());
        }
        if (newBroadcast.getOriginAdress() != null) {
            broadcast.setOriginAdress(newBroadcast.getOriginAdress());
        }
        if (newBroadcast.getStatus() != null) {
            broadcast.setStatus(newBroadcast.getStatus());
        }
        if (newBroadcast.getAbsoluteStartTimeMs() != 0L) {
            broadcast.setAbsoluteStartTimeMs(newBroadcast.getAbsoluteStartTimeMs());
        }
        if (newBroadcast.getUpdateTime() != 0L) {
            broadcast.setUpdateTime(newBroadcast.getUpdateTime());
        }
        if (newBroadcast.getPlayListItemList() != null) {
            broadcast.setPlayListItemList(newBroadcast.getPlayListItemList());
        }
        if (newBroadcast.getPlayListStatus() != null) {
            broadcast.setPlayListStatus(newBroadcast.getPlayListStatus());
        }
        if (newBroadcast.getEndPointList() != null) {
            broadcast.setEndPointList(newBroadcast.getEndPointList());
        }
        if (newBroadcast.getSubFolder() != null) {
            broadcast.setSubFolder(newBroadcast.getSubFolder());
        }
        if (newBroadcast.getListenerHookURL() != null && !newBroadcast.getListenerHookURL().isEmpty()) {
            broadcast.setListenerHookURL(newBroadcast.getListenerHookURL());
        }
        if (newBroadcast.getSpeed() != 0.0) {
            broadcast.setSpeed(newBroadcast.getSpeed());
        }
        if (newBroadcast.getMetaData() != null) {
            broadcast.setMetaData(newBroadcast.getMetaData());
        }
        broadcast.setCurrentPlayIndex(newBroadcast.getCurrentPlayIndex());
        broadcast.setReceivedBytes(newBroadcast.getReceivedBytes());
        broadcast.setDuration(newBroadcast.getDuration());
        broadcast.setBitrate(newBroadcast.getBitrate());
        broadcast.setUserAgent(newBroadcast.getUserAgent());
        broadcast.setWebRTCViewerLimit(newBroadcast.getWebRTCViewerLimit());
        broadcast.setHlsViewerLimit(newBroadcast.getHlsViewerLimit());
        broadcast.setDashViewerCount(newBroadcast.getDashViewerCount());
        broadcast.setSubTrackStreamIds(newBroadcast.getSubTrackStreamIds());
        broadcast.setPlaylistLoopEnabled(newBroadcast.isPlaylistLoopEnabled());
    }

    public abstract long getLocalLiveBroadcastCount(String var1);

    public abstract List<Broadcast> getLocalLiveBroadcasts(String var1);

    protected ArrayList<VoD> searchOnServerVod(ArrayList<VoD> broadcastList, String search) {
        if (search != null && !search.isEmpty()) {
            Iterator<VoD> i = broadcastList.iterator();
            while (i.hasNext()) {
                VoD item = i.next();
                if (item.getVodName() != null && item.getStreamName() != null && item.getStreamId() != null && item.getVodId() != null) {
                    if (item.getVodName().toLowerCase().contains(search.toLowerCase()) || item.getStreamId().toLowerCase().contains(search.toLowerCase()) || item.getStreamName().toLowerCase().contains(search.toLowerCase()) || item.getVodId().toLowerCase().contains(search.toLowerCase())) continue;
                    i.remove();
                    continue;
                }
                if (item.getVodName() != null && item.getVodId() != null) {
                    if (item.getVodName().toLowerCase().contains(search.toLowerCase()) || item.getVodId().toLowerCase().contains(search.toLowerCase())) continue;
                    i.remove();
                    continue;
                }
                if (item.getVodId() == null || item.getVodId().toLowerCase().contains(search.toLowerCase())) continue;
                i.remove();
            }
        }
        return broadcastList;
    }

    protected List<VoD> sortAndCropVodList(List<VoD> vodList, int offset, int size, String sortBy, String orderBy) {
        int toIndex;
        if (("name".equals(sortBy) || "date".equals(sortBy)) && orderBy != null) {
            Collections.sort(vodList, (vod1, vod2) -> {
                Object c1 = null;
                Object c2 = null;
                if (sortBy.contentEquals("name")) {
                    c1 = vod1.getVodName().toLowerCase();
                    c2 = vod2.getVodName().toLowerCase();
                } else if (sortBy.contentEquals("date")) {
                    c1 = vod1.getCreationDate();
                    c2 = vod2.getCreationDate();
                }
                int result = 0;
                if (c1 != null && c2 != null) {
                    result = orderBy.contentEquals("desc") ? c2.compareTo(c1) : c1.compareTo(c2);
                }
                return result;
            });
        }
        if (size > 250) {
            size = 250;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= (toIndex = Math.min(offset + size, vodList.size()))) {
            return new ArrayList<VoD>();
        }
        return vodList.subList(offset, Math.min(offset + size, vodList.size()));
    }

    protected ArrayList<Broadcast> searchOnServer(ArrayList<Broadcast> broadcastList, String search) {
        if (search != null && !search.isEmpty()) {
            Iterator<Broadcast> i = broadcastList.iterator();
            while (i.hasNext()) {
                Broadcast item = i.next();
                if (item.getName() != null && item.getStreamId() != null) {
                    if (item.getName().toLowerCase().contains(search.toLowerCase()) || item.getStreamId().toLowerCase().contains(search.toLowerCase())) continue;
                    i.remove();
                    continue;
                }
                if (item.getStreamId().toLowerCase().contains(search.toLowerCase())) continue;
                i.remove();
            }
        }
        return broadcastList;
    }

    protected List<Broadcast> sortAndCropBroadcastList(List<Broadcast> broadcastList, int offset, int size, final String sortBy, final String orderBy) {
        int toIndex;
        if (("name".equals(sortBy) || "date".equals(sortBy) || "status".equals(sortBy)) && orderBy != null) {
            Collections.sort(broadcastList, new Comparator<Broadcast>(){

                @Override
                public int compare(Broadcast broadcast1, Broadcast broadcast2) {
                    Object c1 = null;
                    Object c2 = null;
                    if (sortBy.equals("name")) {
                        c1 = broadcast1.getName().toLowerCase();
                        c2 = broadcast2.getName().toLowerCase();
                    } else if (sortBy.equals("date")) {
                        c1 = broadcast1.getDate();
                        c2 = broadcast2.getDate();
                    } else if (sortBy.equals("status")) {
                        c1 = broadcast1.getStatus();
                        c2 = broadcast2.getStatus();
                    }
                    int result = 0;
                    if (c1 != null && c2 != null) {
                        result = orderBy.equals("desc") ? c2.compareTo(c1) : c1.compareTo(c2);
                    }
                    return result;
                }
            });
        }
        if (size > 250) {
            size = 250;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= (toIndex = Math.min(offset + size, broadcastList.size()))) {
            return new ArrayList<Broadcast>();
        }
        return broadcastList.subList(offset, toIndex);
    }

    protected ArrayList<ConferenceRoom> searchOnServerConferenceRoom(ArrayList<ConferenceRoom> roomList, String search) {
        if (search != null && !search.isEmpty()) {
            Iterator<ConferenceRoom> i = roomList.iterator();
            while (i.hasNext()) {
                ConferenceRoom item = i.next();
                if (item.getRoomId() == null || item.getRoomId().toLowerCase().contains(search.toLowerCase())) continue;
                i.remove();
            }
        }
        return roomList;
    }

    protected List<ConferenceRoom> sortAndCropConferenceRoomList(List<ConferenceRoom> roomList, int offset, int size, String sortBy, String orderBy) {
        int toIndex;
        if ("roomId".equals(sortBy) || "startDate".equals(sortBy) || "endDate".equals(sortBy)) {
            Collections.sort(roomList, (room1, room2) -> {
                Object c1 = null;
                Object c2 = null;
                if (sortBy.equals("roomId")) {
                    c1 = room1.getRoomId().toLowerCase();
                    c2 = room2.getRoomId().toLowerCase();
                } else if (sortBy.equals("startDate")) {
                    c1 = room1.getStartDate();
                    c2 = room2.getStartDate();
                } else if (sortBy.equals("endDate")) {
                    c1 = room1.getEndDate();
                    c2 = room2.getEndDate();
                }
                int result = 0;
                if (c1 != null && c2 != null) {
                    result = "desc".equals(orderBy) ? c2.compareTo(c1) : c1.compareTo(c2);
                }
                return result;
            });
        }
        if (size > 250) {
            size = 250;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= (toIndex = Math.min(offset + size, roomList.size()))) {
            return new ArrayList<ConferenceRoom>();
        }
        return roomList.subList(offset, toIndex);
    }

    public abstract boolean createP2PConnection(P2PConnection var1);

    public abstract P2PConnection getP2PConnection(String var1);

    public abstract boolean deleteP2PConnection(String var1);

    public abstract boolean addSubTrack(String var1, String var2);

    public abstract boolean removeSubTrack(String var1, String var2);

    public abstract int resetBroadcasts(String var1);

    public boolean isAvailable() {
        return this.available;
    }

    public abstract int getTotalWebRTCViewersCount();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalWebRTCViewersCount(Map<String, String> broadcastMap, Gson gson) {
        long now = System.currentTimeMillis();
        if (now - this.totalWebRTCViewerCountLastUpdateTime > 5000L) {
            int total = 0;
            DataStore dataStore = this;
            synchronized (dataStore) {
                for (String json : broadcastMap.values()) {
                    Broadcast broadcast = (Broadcast)gson.fromJson(json, Broadcast.class);
                    total += broadcast.getWebRTCViewerCount();
                }
            }
            this.totalWebRTCViewerCount = total;
            this.totalWebRTCViewerCountLastUpdateTime = now;
        }
        return this.totalWebRTCViewerCount;
    }

    protected ArrayList<WebRTCViewerInfo> searchOnWebRTCViewerInfo(ArrayList<WebRTCViewerInfo> list, String search) {
        if (search != null && !search.isEmpty()) {
            Iterator<WebRTCViewerInfo> i = list.iterator();
            while (i.hasNext()) {
                WebRTCViewerInfo item = i.next();
                if (item.getViewerId() == null || item.getViewerId().toLowerCase().contains(search.toLowerCase())) continue;
                i.remove();
            }
        }
        return list;
    }

    protected List<WebRTCViewerInfo> sortAndCropWebRTCViewerInfoList(List<WebRTCViewerInfo> list, int offset, int size, String sortBy, String orderBy) {
        int toIndex;
        if ("viewerId".equals(sortBy)) {
            Collections.sort(list, (viewer1, viewer2) -> {
                String c1 = viewer1.getViewerId();
                String c2 = viewer2.getViewerId();
                return "desc".equals(orderBy) ? c2.compareTo(c1) : c1.compareTo(c2);
            });
        }
        if (size > 250) {
            size = 250;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset >= (toIndex = Math.min(offset + size, list.size()))) {
            return new ArrayList<WebRTCViewerInfo>();
        }
        return list.subList(offset, toIndex);
    }

    public abstract void saveViewerInfo(WebRTCViewerInfo var1);

    public abstract List<WebRTCViewerInfo> getWebRTCViewerList(int var1, int var2, String var3, String var4, String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebRTCViewerInfo> getWebRTCViewerList(Map<String, String> webRTCViewerMap, int offset, int size, String sortBy, String orderBy, String search, Gson gson) {
        ArrayList<WebRTCViewerInfo> list = new ArrayList<WebRTCViewerInfo>();
        DataStore dataStore = this;
        synchronized (dataStore) {
            Collection<String> webRTCViewers = webRTCViewerMap.values();
            for (String infoString : webRTCViewers) {
                WebRTCViewerInfo info = (WebRTCViewerInfo)gson.fromJson(infoString, WebRTCViewerInfo.class);
                list.add(info);
            }
        }
        if (search != null && !search.isEmpty()) {
            search = search.replaceAll(REPLACE_CHARS_REGEX, "_");
            logger.info("server side search called for Conference Room = {}", (Object)search);
            list = this.searchOnWebRTCViewerInfo(list, search);
        }
        return this.sortAndCropWebRTCViewerInfoList(list, offset, size, sortBy, orderBy);
    }

    public abstract boolean deleteWebRTCViewerInfo(String var1);

    public abstract boolean updateStreamMetaData(String var1, String var2);
}

