/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.filter.JWTFilter;
import io.antmedia.rest.servlet.EndpointProxy;
import io.antmedia.settings.ServerSettings;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class RestProxyFilter
extends AbstractFilter {
    protected static Logger log = LoggerFactory.getLogger(RestProxyFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block12: {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String method = httpRequest.getMethod();
            if ("POST".equals(method) || "PUT".equals(method) || "DELETE".equals(method)) {
                String streamId = this.getStreamId(httpRequest.getRequestURI());
                if (streamId != null && !streamId.isEmpty()) {
                    Broadcast broadcast = this.getBroadcast(httpRequest, streamId);
                    boolean subscriberBlockReq = this.isSubscriberBlockReq(httpRequest.getRequestURI());
                    log.debug("STREAM ID = {} BROADCAST = {} ", (Object)streamId, (Object)broadcast);
                    if (broadcast != null && subscriberBlockReq) {
                        try {
                            String subscriberId = this.getSubscriberId(httpRequest.getRequestURI());
                            if (subscriberId != null) {
                                DataStore dataStore = this.getDataStore();
                                Subscriber subscriber = dataStore.getSubscriber(streamId, subscriberId);
                                if (subscriber != null && !StringUtils.isBlank((CharSequence)subscriber.getRegisteredNodeIp()) && !this.isRequestDestinedForThisNode(request.getRemoteAddr(), subscriber.getRegisteredNodeIp()) && this.isHostRunning(subscriber.getRegisteredNodeIp(), this.getServerSettings().getDefaultHttpPort())) {
                                    this.forwardRequestToNode(request, response, subscriber.getRegisteredNodeIp());
                                } else {
                                    chain.doFilter(request, response);
                                }
                                break block12;
                            }
                            chain.doFilter(request, response);
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage());
                        }
                    } else if (broadcast != null && AntMediaApplicationAdapter.isStreaming(broadcast) && !this.isRequestDestinedForThisNode(request.getRemoteAddr(), broadcast.getOriginAdress()) && this.isHostRunning(broadcast.getOriginAdress(), this.getServerSettings().getDefaultHttpPort())) {
                        this.forwardRequestToNode(request, response, broadcast.getOriginAdress());
                    } else {
                        chain.doFilter(request, response);
                    }
                }
            } else {
                chain.doFilter(request, response);
            }
        }
    }

    public boolean isHostRunning(String address, int port) {
        try (Socket socket = new Socket();){
            InetSocketAddress sockaddr = new InetSocketAddress(address, port);
            socket.connect(sockaddr, 5000);
        }
        catch (IOException | NumberFormatException e) {
            return false;
        }
        return true;
    }

    public void forwardRequestToNode(ServletRequest request, ServletResponse response, String registeredNodeIp) throws IOException, ServletException {
        String jwtToken = JWTFilter.generateJwtToken(this.getAppSettings().getClusterCommunicationKey(), System.currentTimeMillis() + 5000L);
        AppSettings appSettings = this.getAppSettings();
        ServerSettings serverSettings = this.getServerSettings();
        String restRouteOfSubscriberNode = "http://" + registeredNodeIp + ":" + serverSettings.getDefaultHttpPort() + File.separator + appSettings.getAppName() + File.separator + "rest";
        log.info("Redirecting the request({}) to node {}", (Object)((HttpServletRequest)request).getRequestURI(), (Object)registeredNodeIp);
        EndpointProxy endpointProxy = new EndpointProxy(jwtToken);
        endpointProxy.initTarget(restRouteOfSubscriberNode);
        endpointProxy.service(request, response);
    }

    public String getStreamId(String reqURI) {
        try {
            reqURI = reqURI.split("broadcasts/")[1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        if (reqURI.contains("/")) {
            reqURI = reqURI.substring(0, reqURI.indexOf("/"));
        }
        return reqURI;
    }

    private String getSubscriberId(String reqURI) {
        try {
            reqURI = reqURI.split("subscribers/")[1];
            return reqURI.substring(0, reqURI.indexOf("/"));
        }
        catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException e) {
            logger.warn("There is no subscriber id in the URI");
            return null;
        }
    }

    public boolean isSubscriberBlockReq(String requestUri) {
        return requestUri.contains("subscribers") && requestUri.contains("block");
    }

    public boolean isRequestDestinedForThisNode(String requestAddress, String nodeAddress) {
        ConfigurableWebApplicationContext context = this.getAppContext();
        boolean isCluster = context.containsBean("tomcat.cluster");
        return !isCluster || requestAddress.equals(this.getServerSettings().getHostAddress()) || this.getServerSettings().getHostAddress().equals(nodeAddress);
    }

    public static boolean isNodeCommunicationTokenValid(String jwtInternalCommunicationToken, String jwtSecretKey, String requestURI) {
        boolean result = false;
        if (jwtInternalCommunicationToken != null) {
            result = JWTFilter.isJWTTokenValid(jwtSecretKey, jwtInternalCommunicationToken);
            if (result) {
                logger.info("Request forwarded:{} by another node is validated successfully", (Object)requestURI);
            } else {
                logger.warn("Requested forwarded:{} by another node is failed because cluster jwt token is valid", (Object)requestURI);
            }
        } else {
            logger.debug("Node communicaiton header:{} is not found ", (Object)"ClusterAuthorization");
        }
        return result;
    }
}

