/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.streamsource;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.muxer.Muxer;
import io.antmedia.rest.model.Result;
import io.vertx.core.Vertx;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFetcher {
    protected static Logger logger = LoggerFactory.getLogger(StreamFetcher.class);
    private WorkerThread thread;
    private int timeoutMicroSeconds;
    private boolean exceptionInThread = false;
    private long lastPacketReceivedTime = 0L;
    private AtomicBoolean threadActive = new AtomicBoolean(false);
    private Result cameraError = new Result(false, "");
    private static final int PACKET_RECEIVED_INTERVAL_TIMEOUT = 3000;
    private IScope scope;
    private AntMediaApplicationAdapter appInstance;
    private long[] lastDTS;
    private MuxAdaptor muxAdaptor = null;
    private boolean restartStream = true;
    private volatile boolean stopRequestReceived = false;
    private int bufferTime = 0;
    private static final int COUNT_TO_LOG_BUFFER = 5000;
    private int bufferLogCounter;
    private AppSettings appSettings;
    private Vertx vertx;
    private DataStore dataStore;
    IStreamFetcherListener streamFetcherListener;
    private String streamUrl;
    private String streamId;
    private String streamType;

    public IStreamFetcherListener getStreamFetcherListener() {
        return this.streamFetcherListener;
    }

    public void setStreamFetcherListener(IStreamFetcherListener streamFetcherListener) {
        this.streamFetcherListener = streamFetcherListener;
    }

    public StreamFetcher(String streamUrl, String streamId, String streamType, IScope scope, Vertx vertx) {
        if (streamUrl == null || streamId == null) {
            throw new NullPointerException("Stream is not initialized properly. Check  stream id (" + streamId + ") and stream url (" + streamUrl + ") values");
        }
        this.streamUrl = streamUrl;
        this.streamType = streamType;
        this.streamId = streamId;
        this.scope = scope;
        this.vertx = vertx;
        this.bufferTime = this.getAppSettings().getStreamFetcherBufferTime();
    }

    public Result prepareInput(AVFormatContext inputFormatContext) {
        int timeout = this.appSettings.getRtspTimeoutDurationMs();
        this.setConnectionTimeout(timeout);
        Result result = new Result(false);
        if (inputFormatContext == null) {
            logger.info("cannot allocate input context for {}", (Object)this.streamId);
            return result;
        }
        AVDictionary optionsDictionary = new AVDictionary();
        String transportType = this.appSettings.getRtspPullTransportType();
        if (this.streamUrl.startsWith("rtsp://") && !transportType.isEmpty()) {
            logger.info("Setting rtsp transport type to {} for stream source: {} and timeout:{}us", new Object[]{transportType, this.streamUrl, this.timeoutMicroSeconds});
            avutil.av_dict_set((AVDictionary)optionsDictionary, (String)"rtsp_transport", (String)transportType, (int)0);
            String timeoutStr = String.valueOf(this.timeoutMicroSeconds);
            avutil.av_dict_set((AVDictionary)optionsDictionary, (String)"timeout", (String)timeoutStr, (int)0);
        }
        int analyzeDurationUs = this.appSettings.getMaxAnalyzeDurationMS() * 1000;
        String analyzeDuration = String.valueOf(analyzeDurationUs);
        avutil.av_dict_set((AVDictionary)optionsDictionary, (String)"analyzeduration", (String)analyzeDuration, (int)0);
        logger.debug("open stream url: {}  ", (Object)this.streamUrl);
        int ret = avformat.avformat_open_input((AVFormatContext)inputFormatContext, (String)this.streamUrl, null, (AVDictionary)optionsDictionary);
        if (ret < 0) {
            String errorStr = Muxer.getErrorDefinition(ret);
            result.setMessage(errorStr);
            logger.error("cannot open stream: {} with error:: {} and streamId:{}", new Object[]{this.streamUrl, result.getMessage(), this.streamId});
            avutil.av_dict_free((AVDictionary)optionsDictionary);
            optionsDictionary.close();
            return result;
        }
        avutil.av_dict_free((AVDictionary)optionsDictionary);
        optionsDictionary.close();
        logger.debug("find stream info: {}  ", (Object)this.streamUrl);
        ret = avformat.avformat_find_stream_info((AVFormatContext)inputFormatContext, (AVDictionary)null);
        if (ret < 0) {
            result.setMessage("Could not find stream information\n");
            logger.error(result.getMessage());
            return result;
        }
        this.lastDTS = new long[inputFormatContext.nb_streams()];
        for (int i = 0; i < this.lastDTS.length; ++i) {
            this.lastDTS[i] = -1L;
        }
        result.setSuccess(true);
        return result;
    }

    public Result prepare(AVFormatContext inputFormatContext) {
        Result result = this.prepareInput(inputFormatContext);
        this.setCameraError(result);
        return result;
    }

    public void startStream() {
        new Thread(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (StreamFetcher.this.threadActive.get()) {
                        Thread.sleep(100L);
                        if (i % 50 == 0) {
                            logger.info("waiting for thread to be finished for stream {}", (Object)StreamFetcher.this.streamUrl);
                            i = 0;
                        }
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                    Thread.currentThread().interrupt();
                }
                StreamFetcher.this.exceptionInThread = false;
                StreamFetcher.this.thread = new WorkerThread();
                StreamFetcher.this.thread.start();
                logger.info("StartStream called, new thread is started for {}", (Object)StreamFetcher.this.streamId);
            }
        }.start();
    }

    public DataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.getInstance().getDataStore();
        }
        return this.dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public AVPacket getAVPacket() {
        return new AVPacket();
    }

    public boolean isStreamAlive() {
        return System.currentTimeMillis() - this.lastPacketReceivedTime < 3000L;
    }

    public boolean isStopped() {
        return this.thread.isInterrupted();
    }

    public void stopStream() {
        logger.info("stop stream called for {}", (Object)this.streamUrl);
        this.stopRequestReceived = true;
    }

    public boolean isStopRequestReceived() {
        return this.stopRequestReceived;
    }

    public WorkerThread getThread() {
        return this.thread;
    }

    public void setThread(WorkerThread thread) {
        this.thread = thread;
    }

    public void restart() {
        this.stopStream();
        new Thread(){

            @Override
            public void run() {
                try {
                    while (StreamFetcher.this.threadActive.get()) {
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                    Thread.currentThread().interrupt();
                }
                StreamFetcher.this.startStream();
            }
        }.start();
    }

    public void setConnectionTimeout(int timeoutMs) {
        this.timeoutMicroSeconds = timeoutMs * 1000;
    }

    public boolean isExceptionInThread() {
        return this.exceptionInThread;
    }

    public void setThreadActive(boolean threadActive) {
        this.threadActive.set(threadActive);
    }

    public boolean isThreadActive() {
        return this.threadActive.get();
    }

    public Result getCameraError() {
        return this.cameraError;
    }

    public void setCameraError(Result cameraError) {
        this.cameraError = cameraError;
    }

    public IScope getScope() {
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public AntMediaApplicationAdapter getInstance() {
        if (this.appInstance == null) {
            this.appInstance = (AntMediaApplicationAdapter)this.scope.getContext().getApplicationContext().getBean("web.handler");
        }
        return this.appInstance;
    }

    public MuxAdaptor getMuxAdaptor() {
        return this.muxAdaptor;
    }

    public void setMuxAdaptor(MuxAdaptor muxAdaptor) {
        this.muxAdaptor = muxAdaptor;
    }

    public boolean isRestartStream() {
        return this.restartStream;
    }

    public void setRestartStream(boolean restartStream) {
        this.restartStream = restartStream;
    }

    public int getBufferTime() {
        return this.bufferTime;
    }

    public void setBufferTime(int bufferTime) {
        this.bufferTime = bufferTime;
    }

    private AppSettings getAppSettings() {
        if (this.appSettings == null) {
            this.appSettings = (AppSettings)this.scope.getContext().getApplicationContext().getBean("app.settings");
        }
        return this.appSettings;
    }

    public void debugSetStopRequestReceived(boolean stopRequest) {
        this.stopRequestReceived = stopRequest;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getStreamUrl() {
        return this.streamUrl;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public void setStreamUrl(String streamUrl) {
        this.streamUrl = streamUrl;
    }

    public static interface IStreamFetcherListener {
        public void streamFinished(IStreamFetcherListener var1);
    }

    public class WorkerThread
    extends Thread {
        private static final int PACKET_WRITER_PERIOD_IN_MS = 10;
        private static final long STREAM_FETCH_RE_TRY_PERIOD_MS = 3000L;
        private volatile boolean streamPublished = false;
        protected AtomicBoolean isJobRunning = new AtomicBoolean(false);
        AVFormatContext inputFormatContext = null;
        private AtomicBoolean buffering = new AtomicBoolean(false);
        private ConcurrentSkipListSet<AVPacket> bufferQueue = null;
        private volatile long bufferingFinishTimeMs;
        private volatile long firstPacketReadyToSentTimeMs;
        private long lastPacketTimeMsInQueue;
        long firstPacketTime = 0L;
        long bufferDuration = 0L;
        long timeOffset = 0L;
        long packetWriterJobName = -1L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AVPacket pkt = null;
            try {
                Broadcast broadcast = StreamFetcher.this.getDataStore().get(StreamFetcher.this.streamId);
                if (broadcast == null) {
                    logger.info("Broadcast with streamId:{} should be deleted before its thread is started", (Object)StreamFetcher.this.streamId);
                    return;
                }
                StreamFetcher.this.getInstance().updateBroadcastStatus(StreamFetcher.this.streamId, 0L, "Pull", broadcast, "preparing");
                StreamFetcher.this.setThreadActive(true);
                this.inputFormatContext = new AVFormatContext(null);
                pkt = avcodec.av_packet_alloc();
                if (this.prepareInputContext(broadcast)) {
                    boolean readTheNextFrame = true;
                    while (readTheNextFrame) {
                        try {
                            readTheNextFrame = this.readMore(pkt);
                        }
                        catch (Exception e) {
                            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                            StreamFetcher.this.exceptionInThread = true;
                        }
                    }
                    logger.info("Leaving the stream fetcher loop for stream: {}", (Object)StreamFetcher.this.streamId);
                }
                this.close(pkt);
                StreamFetcher.this.setThreadActive(false);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                StreamFetcher.this.exceptionInThread = true;
            }
            finally {
                this.close(pkt);
                StreamFetcher.this.setThreadActive(false);
            }
        }

        public boolean readMore(AVPacket pkt) {
            boolean readTheNextFrame = true;
            int readResult = this.readNextPacket(pkt);
            if (readResult >= 0) {
                this.packetRead(pkt);
                this.unReferencePacket(pkt);
            } else if ("VoD".equals(StreamFetcher.this.streamType) && readResult != avutil.AVERROR_EOF) {
                String errorDefinition = Muxer.getErrorDefinition(readResult);
                logger.warn("Frame can't be read for VOD {} error is {}", (Object)StreamFetcher.this.streamUrl, (Object)errorDefinition);
                this.unReferencePacket(pkt);
            } else {
                readTheNextFrame = false;
            }
            if (StreamFetcher.this.stopRequestReceived) {
                logger.warn("Stop request received, breaking the loop for {} ", (Object)StreamFetcher.this.streamId);
                readTheNextFrame = false;
            }
            return readTheNextFrame;
        }

        public int readNextPacket(AVPacket pkt) {
            return avformat.av_read_frame((AVFormatContext)this.inputFormatContext, (AVPacket)pkt);
        }

        public void unReferencePacket(AVPacket pkt) {
            avcodec.av_packet_unref((AVPacket)pkt);
        }

        public boolean prepareInputContext(Broadcast broadcast) throws Exception {
            logger.info("Preparing the StreamFetcher for {} for streamId:{}", (Object)StreamFetcher.this.streamUrl, (Object)StreamFetcher.this.streamId);
            Result result = StreamFetcher.this.prepare(this.inputFormatContext);
            if (result.isSuccess()) {
                boolean audioExist = false;
                boolean videoExist = false;
                for (int i = 0; i < this.inputFormatContext.nb_streams(); ++i) {
                    if (this.inputFormatContext.streams(i).codecpar().codec_type() == 1) {
                        audioExist = true;
                        if (avcodec.avcodec_find_decoder((int)this.inputFormatContext.streams(i).codecpar().codec_id()) != null) continue;
                        logger.error("avcodec_find_decoder() error: Unsupported audio format or codec not found");
                        audioExist = false;
                        continue;
                    }
                    if (this.inputFormatContext.streams(i).codecpar().codec_type() != 0) continue;
                    videoExist = true;
                    if (avcodec.avcodec_find_decoder((int)this.inputFormatContext.streams(i).codecpar().codec_id()) != null) continue;
                    logger.error("avcodec_find_decoder() error: Unsupported video format or codec not found");
                    videoExist = false;
                }
                StreamFetcher.this.muxAdaptor = MuxAdaptor.initializeMuxAdaptor(null, true, StreamFetcher.this.scope);
                StreamFetcher.this.muxAdaptor.setFirstKeyFrameReceivedChecked(!videoExist);
                StreamFetcher.this.muxAdaptor.setEnableVideo(videoExist);
                StreamFetcher.this.muxAdaptor.setEnableAudio(audioExist);
                StreamFetcher.this.muxAdaptor.setBroadcast(broadcast);
                StreamFetcher.this.muxAdaptor.setAvc(!StreamFetcher.this.streamUrl.toLowerCase().startsWith("rtsp"));
                MuxAdaptor.setUpEndPoints(StreamFetcher.this.muxAdaptor, broadcast, StreamFetcher.this.vertx);
                StreamFetcher.this.muxAdaptor.init(StreamFetcher.this.scope, StreamFetcher.this.streamId, false);
                logger.info("{} stream count in stream {} is {}", new Object[]{StreamFetcher.this.streamId, StreamFetcher.this.streamUrl, this.inputFormatContext.nb_streams()});
                if (StreamFetcher.this.muxAdaptor.prepareFromInputFormatContext(this.inputFormatContext)) {
                    return true;
                }
                logger.error("MuxAdaptor.Prepare for {} returned false", (Object)StreamFetcher.this.streamId);
            } else {
                logger.error("Prepare for opening the {} has failed for streamId:{}", (Object)StreamFetcher.this.streamUrl, (Object)StreamFetcher.this.streamId);
                StreamFetcher.this.setCameraError(result);
            }
            return false;
        }

        public void packetRead(AVPacket pkt) {
            if (!this.streamPublished) {
                long currentTime = System.currentTimeMillis();
                StreamFetcher.this.muxAdaptor.setStartTime(currentTime);
                StreamFetcher.this.getInstance().startPublish(StreamFetcher.this.streamId, 0L, "Pull");
                if (StreamFetcher.this.bufferTime > 0) {
                    this.bufferQueue = new ConcurrentSkipListSet((a, b) -> {
                        long packet1TimeStamp = avutil.av_rescale_q((long)a.dts(), (AVRational)this.inputFormatContext.streams(a.stream_index()).time_base(), (AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                        long packet2TimeStamp = avutil.av_rescale_q((long)b.dts(), (AVRational)this.inputFormatContext.streams(b.stream_index()).time_base(), (AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                        return Long.compare(packet1TimeStamp, packet2TimeStamp);
                    });
                    this.packetWriterJobName = StreamFetcher.this.vertx.setPeriodic(10L, l -> StreamFetcher.this.vertx.executeBlocking(() -> {
                        this.writeBufferedPacket();
                        return null;
                    }, false));
                }
            }
            this.streamPublished = true;
            StreamFetcher.this.lastPacketReceivedTime = System.currentTimeMillis();
            if (StreamFetcher.this.bufferTime > 0) {
                AVPacket packet = StreamFetcher.this.getAVPacket();
                avcodec.av_packet_ref((AVPacket)packet, (AVPacket)pkt);
                this.bufferQueue.add(packet);
                try {
                    AVPacket pktHead = this.bufferQueue.first();
                    AVPacket pktTrailer = this.bufferQueue.last();
                    this.lastPacketTimeMsInQueue = avutil.av_rescale_q((long)pktTrailer.dts(), (AVRational)this.inputFormatContext.streams(pkt.stream_index()).time_base(), (AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                    this.firstPacketTime = avutil.av_rescale_q((long)pktHead.pts(), (AVRational)this.inputFormatContext.streams(pktHead.stream_index()).time_base(), (AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                    this.bufferDuration = this.lastPacketTimeMsInQueue - this.firstPacketTime;
                    if (this.bufferDuration > (long)StreamFetcher.this.bufferTime) {
                        if (this.buffering.get()) {
                            this.bufferingFinishTimeMs = System.currentTimeMillis();
                            this.firstPacketReadyToSentTimeMs = this.firstPacketTime;
                        }
                        this.buffering.set(false);
                    }
                    this.logBufferStatus();
                }
                catch (NoSuchElementException e) {
                    logger.warn("You may or may not ignore this exception. I mean It can happen time to time in multithread environment -> {}", (Object)e.getMessage());
                }
            } else {
                if ("VoD".equals(StreamFetcher.this.streamType)) {
                    if (this.firstPacketTime == 0L) {
                        int streamIndex = pkt.stream_index();
                        this.firstPacketTime = System.currentTimeMillis();
                        long firstPacketDtsInMs = avutil.av_rescale_q((long)pkt.dts(), (AVRational)this.inputFormatContext.streams(streamIndex).time_base(), (AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                        this.timeOffset = 0L - firstPacketDtsInMs;
                    }
                    long latestTime = System.currentTimeMillis();
                    int streamIndex = pkt.stream_index();
                    AVRational timeBase = this.inputFormatContext.streams(streamIndex).time_base();
                    long pktTime = avutil.av_rescale_q((long)pkt.dts(), (AVRational)timeBase, (AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                    long durationInMs = latestTime - this.firstPacketTime;
                    long dtsInMS = this.timeOffset + pktTime;
                    while (dtsInMS > durationInMs) {
                        durationInMs = System.currentTimeMillis() - this.firstPacketTime;
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                this.writePacket(this.inputFormatContext.streams(pkt.stream_index()), pkt);
            }
        }

        public void close(AVPacket pkt) {
            try {
                if (this.packetWriterJobName != -1L) {
                    logger.info("Removing packet writer job {}", (Object)this.packetWriterJobName);
                    StreamFetcher.this.vertx.cancelTimer(this.packetWriterJobName);
                }
                this.writeAllBufferedPackets();
                if (StreamFetcher.this.muxAdaptor != null) {
                    logger.info("Writing trailer in Muxadaptor {}", (Object)StreamFetcher.this.streamId);
                    StreamFetcher.this.muxAdaptor.writeTrailer();
                    StreamFetcher.this.getInstance().muxAdaptorRemoved(StreamFetcher.this.muxAdaptor);
                    StreamFetcher.this.muxAdaptor = null;
                }
                if (pkt != null) {
                    avcodec.av_packet_free((AVPacket)pkt);
                    pkt.close();
                }
                if (this.inputFormatContext != null) {
                    try {
                        avformat.avformat_close_input((AVFormatContext)this.inputFormatContext);
                    }
                    catch (Exception e) {
                        logger.info(e.getMessage());
                    }
                    this.inputFormatContext = null;
                }
                boolean closeCalled = false;
                if (this.streamPublished) {
                    StreamFetcher.this.getInstance().closeBroadcast(StreamFetcher.this.streamId);
                    this.streamPublished = false;
                    closeCalled = true;
                }
                if (StreamFetcher.this.streamFetcherListener != null) {
                    StreamFetcher.this.stopRequestReceived = true;
                    StreamFetcher.this.restartStream = false;
                    logger.info("Calling streamFinished listener for streamId:{} and it will not restart the stream automatically because callback is getting the responsbility", (Object)StreamFetcher.this.streamId);
                    StreamFetcher.this.streamFetcherListener.streamFinished(StreamFetcher.this.streamFetcherListener);
                }
                if (!StreamFetcher.this.stopRequestReceived && StreamFetcher.this.restartStream) {
                    logger.info("Stream fetcher will try to fetch source {} after {} ms for streamId:{}", new Object[]{StreamFetcher.this.streamUrl, 3000L, StreamFetcher.this.streamId});
                    StreamFetcher.this.vertx.setTimer(3000L, l -> {
                        StreamFetcher.this.thread = new WorkerThread();
                        StreamFetcher.this.thread.start();
                    });
                } else {
                    logger.info("Stream fetcher will not try again for streamUrl:{} because stopRequestReceived:{} and restartStream:{}", new Object[]{StreamFetcher.this.streamUrl, StreamFetcher.this.stopRequestReceived, StreamFetcher.this.restartStream});
                    if (!closeCalled) {
                        StreamFetcher.this.getInstance().closeBroadcast(StreamFetcher.this.streamId);
                    }
                }
                logger.debug("Leaving thread for {}", (Object)StreamFetcher.this.streamUrl);
                StreamFetcher.this.stopRequestReceived = false;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeAllBufferedPackets() {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                if (this.bufferQueue != null) {
                    AVPacket pkt;
                    logger.info("write all buffered packets for stream: {}", (Object)StreamFetcher.this.streamId);
                    while (!this.bufferQueue.isEmpty()) {
                        pkt = this.bufferQueue.pollFirst();
                        this.writePacket(this.inputFormatContext.streams(pkt.stream_index()), pkt);
                        this.unReferencePacket(pkt);
                    }
                    while ((pkt = this.bufferQueue.pollFirst()) != null) {
                        pkt.close();
                    }
                }
            }
        }

        public void writePacket(AVStream stream, AVPacket pkt) {
            int packetIndex = pkt.stream_index();
            if (StreamFetcher.this.lastDTS[packetIndex] >= pkt.dts()) {
                logger.info("last dts: {} is bigger than incoming dts: {} for stream index:{} - If you see this log frequently, TRY TO FIX it by setting \"streamFetcherBufferTime\"(to ie. 1000) in Application Settings", new Object[]{StreamFetcher.this.lastDTS[packetIndex], pkt.dts(), packetIndex});
                pkt.dts(StreamFetcher.this.lastDTS[packetIndex] + 1L);
            }
            StreamFetcher.this.lastDTS[packetIndex] = pkt.dts();
            if (pkt.dts() > pkt.pts()) {
                logger.info("dts ({}) is bigger than pts({}) - If you see this log frequently, TRY TO FIX it by setting \"streamFetcherBufferTime\"(to ie. 1000) in Application Settings", (Object)pkt.dts(), (Object)pkt.pts());
                pkt.pts(pkt.dts());
            }
            StreamFetcher.this.muxAdaptor.writePacket(stream, pkt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeBufferedPacket() {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                if (this.isJobRunning.compareAndSet(false, true)) {
                    try {
                        if (!this.buffering.get()) {
                            long now;
                            long passedTime;
                            AVPacket tempPacket;
                            long pktTime;
                            long pktTimeDifferenceMs;
                            while (!this.bufferQueue.isEmpty() && (pktTimeDifferenceMs = (pktTime = avutil.av_rescale_q((long)(tempPacket = this.bufferQueue.first()).pts(), (AVRational)this.inputFormatContext.streams(tempPacket.stream_index()).time_base(), (AVRational)MuxAdaptor.TIME_BASE_FOR_MS)) - this.firstPacketReadyToSentTimeMs) < (passedTime = (now = System.currentTimeMillis()) - this.bufferingFinishTimeMs)) {
                                this.writePacket(this.inputFormatContext.streams(tempPacket.stream_index()), tempPacket);
                                this.unReferencePacket(tempPacket);
                                this.bufferQueue.remove(tempPacket);
                            }
                            this.buffering.set(this.bufferQueue.isEmpty());
                        }
                        this.logBufferStatus();
                    }
                    finally {
                        this.isJobRunning.compareAndSet(true, false);
                    }
                }
            }
        }

        public void logBufferStatus() {
            ++StreamFetcher.this.bufferLogCounter;
            if (StreamFetcher.this.bufferLogCounter % 5000 == 0) {
                logger.info("WriteBufferedPacket -> Buffering status {}, buffer duration {}ms buffer time {}ms stream: {}", new Object[]{this.buffering, this.getBufferedDurationMs(), StreamFetcher.this.bufferTime, StreamFetcher.this.streamId});
                StreamFetcher.this.bufferLogCounter = 0;
            }
        }

        public long getBufferedDurationMs() {
            if (this.bufferQueue != null && !this.bufferQueue.isEmpty()) {
                AVPacket pktHead = this.bufferQueue.first();
                long firstPacketInQueueTime = avutil.av_rescale_q((long)pktHead.pts(), (AVRational)this.inputFormatContext.streams(pktHead.stream_index()).time_base(), (AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                return this.lastPacketTimeMsInQueue - firstPacketInQueueTime;
            }
            return 0L;
        }

        public ConcurrentSkipListSet<AVPacket> getBufferQueue() {
            return this.bufferQueue;
        }

        public void setInputFormatContext(AVFormatContext inputFormatContext) {
            this.inputFormatContext = inputFormatContext;
        }
    }
}

