/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.websocket;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.StreamIdValidator;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.webrtc.adaptor.RTMPAdaptor;
import jakarta.websocket.Session;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.webrtc.IceCandidate;
import org.webrtc.SessionDescription;

public class WebSocketCommunityHandler {
    public static final String WEBRTC_VERTX_BEAN_NAME = "webRTCVertx";
    private static Logger logger = LoggerFactory.getLogger(WebSocketCommunityHandler.class);
    protected AppSettings appSettings;
    private ApplicationContext appContext;
    protected Session session;
    private String appName;
    private AntMediaApplicationAdapter appAdaptor;
    protected String userAgent = "N/A";

    public WebSocketCommunityHandler(ApplicationContext appContext, Session session) {
        this.appContext = appContext;
        this.session = session;
        this.appSettings = (AppSettings)this.getAppContext().getBean("app.settings");
        this.appAdaptor = (AntMediaApplicationAdapter)appContext.getBean("web.handler");
        this.appName = this.appAdaptor.getScope().getName();
    }

    public void onClose(Session session) {
        RTMPAdaptor connectionContext = (RTMPAdaptor)session.getUserProperties().get(session.getId());
        if (connectionContext != null) {
            connectionContext.stop();
        }
    }

    public void onError(Session session, Throwable throwable) {
    }

    public void onMessage(Session session, String message) {
        JSONParser jsonParser = new JSONParser();
        try {
            if (message == null) {
                logger.error("Received message null for session id: {}", (Object)session.getId());
                return;
            }
            JSONObject jsonObject = (JSONObject)jsonParser.parse(message);
            String cmd = (String)jsonObject.get((Object)"command");
            if (cmd == null) {
                logger.error("Received message does not contain any command for session id: {}", (Object)session.getId());
                return;
            }
            String streamId = (String)jsonObject.get((Object)"streamId");
            if ((streamId == null || streamId.isEmpty()) && !cmd.equals("ping")) {
                this.sendNoStreamIdSpecifiedError(session);
                return;
            }
            if (!StreamIdValidator.isStreamIdValid(streamId)) {
                this.sendInvalidStreamNameError(streamId, session);
                return;
            }
            if (cmd.equals("publish")) {
                String status;
                Broadcast broadcast = this.appAdaptor.getDataStore().get(streamId);
                if (broadcast != null && ((status = broadcast.getStatus()).endsWith("broadcasting") || status.endsWith("preparing"))) {
                    logger.error("Sending stream id in use error for stream:{} session:{}", (Object)streamId, (Object)session.getId());
                    this.sendStreamIdInUse(streamId, session);
                    return;
                }
                boolean enableVideo = jsonObject.containsKey((Object)"video") ? (Boolean)jsonObject.get((Object)"video") : true;
                this.startRTMPAdaptor(session, streamId, enableVideo);
            } else if (cmd.equals("takeConfiguration")) {
                RTMPAdaptor connectionContext = (RTMPAdaptor)session.getUserProperties().get(session.getId());
                String typeString = (String)jsonObject.get((Object)"type");
                String sdpDescription = (String)jsonObject.get((Object)"sdp");
                this.setRemoteDescription(connectionContext, typeString, sdpDescription, streamId);
            } else if (cmd.equals("takeCandidate")) {
                RTMPAdaptor connectionContext = (RTMPAdaptor)session.getUserProperties().get(session.getId());
                String sdpMid = (String)jsonObject.get((Object)"id");
                String sdp = (String)jsonObject.get((Object)"candidate");
                long sdpMLineIndex = (Long)jsonObject.get((Object)"label");
                this.addICECandidate(streamId, connectionContext, sdpMid != null ? sdpMid : "0", sdp, sdpMLineIndex);
            } else if (cmd.equals("stop")) {
                RTMPAdaptor connectionContext = (RTMPAdaptor)session.getUserProperties().get(session.getId());
                if (connectionContext != null) {
                    connectionContext.stop();
                } else {
                    logger.warn("Connection context is null for stop. Wrong message order for stream: {}", (Object)streamId);
                }
            } else if (cmd.equals("ping")) {
                this.sendPongMessage(session);
            } else if (cmd.equals("getStreamInfo") || cmd.equals("play")) {
                this.sendNotFoundJSON(streamId, session);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void startRTMPAdaptor(Session session, String streamId, boolean enableVideo) {
        int rtmpPort = this.appAdaptor.getServerSettings().getRtmpPort();
        String outputURL = "rtmp://127.0.0.1:" + rtmpPort + "/" + this.appName + "/" + streamId;
        RTMPAdaptor connectionContext = this.getNewRTMPAdaptor(outputURL, this.appSettings.getHeightRtmpForwarding());
        session.getUserProperties().put(session.getId(), connectionContext);
        connectionContext.setSession(session);
        connectionContext.setStreamId(streamId);
        connectionContext.setPortRange(this.appSettings.getWebRTCPortRangeMin(), this.appSettings.getWebRTCPortRangeMax());
        connectionContext.setStunServerUri(this.appSettings.getStunServerURI(), this.appSettings.getTurnServerUsername(), this.appSettings.getTurnServerCredential());
        connectionContext.setTcpCandidatesEnabled(this.appSettings.isWebRTCTcpCandidatesEnabled());
        connectionContext.setEnableVideo(enableVideo);
        connectionContext.start();
    }

    public RTMPAdaptor getNewRTMPAdaptor(String outputURL, int height) {
        return new RTMPAdaptor(outputURL, this, height, "flv");
    }

    public void addICECandidate(String streamId, RTMPAdaptor connectionContext, String sdpMid, String sdp, long sdpMLineIndex) {
        if (connectionContext != null) {
            IceCandidate iceCandidate = new IceCandidate(sdpMid, (int)sdpMLineIndex, sdp);
            connectionContext.addIceCandidate(iceCandidate);
        } else {
            logger.warn("Connection context is null for take candidate. Wrong message order for stream: {}", (Object)streamId);
        }
    }

    private void setRemoteDescription(RTMPAdaptor connectionContext, String typeString, String sdpDescription, String streamId) {
        if (connectionContext != null) {
            SessionDescription.Type type;
            if ("offer".equals(typeString)) {
                type = SessionDescription.Type.OFFER;
                logger.info("received sdp type is offer {}", (Object)streamId);
            } else {
                type = SessionDescription.Type.ANSWER;
                logger.info("received sdp type is answer {}", (Object)streamId);
            }
            SessionDescription sdp = new SessionDescription(type, sdpDescription);
            connectionContext.setRemoteDescription(sdp);
        } else {
            logger.warn("Connection context is null. Wrong message order for stream: {}", (Object)streamId);
        }
    }

    public void sendSDPConfiguration(String description, String type, String streamId, Session session, Map<String, String> midSidMap, String linkedSessionForSignaling, String subscriberId) {
        this.sendMessage(WebSocketCommunityHandler.getSDPConfigurationJSON(description, type, streamId, midSidMap, linkedSessionForSignaling, subscriberId).toJSONString(), session);
    }

    public void sendPublishStartedMessage(String streamId, Session session, String roomName, String subscriberId) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"command", (Object)"notification");
        jsonObj.put((Object)"definition", (Object)"publish_started");
        jsonObj.put((Object)"streamId", (Object)streamId);
        if (roomName != null) {
            jsonObj.put((Object)"ATTR_ROOM_NAME", (Object)roomName);
            jsonObj.put((Object)"room", (Object)roomName);
        }
        jsonObj.put((Object)"subscriberId", (Object)subscriberId);
        this.sendMessage(jsonObj.toJSONString(), session);
    }

    public void sendStreamIdInUse(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"streamIdInUse");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendPongMessage(Session session) {
        JSONObject jsonResponseObject = new JSONObject();
        jsonResponseObject.put((Object)"command", (Object)"pong");
        this.sendMessage(jsonResponseObject.toJSONString(), session);
    }

    public void sendPublishFinishedMessage(String streamId, Session session, String subscriberId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"notification");
        jsonObject.put((Object)"definition", (Object)"publish_finished");
        jsonObject.put((Object)"streamId", (Object)streamId);
        jsonObject.put((Object)"subscriberId", (Object)subscriberId);
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public void sendStartMessage(String streamId, Session session, String subscriberId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"start");
        jsonObject.put((Object)"streamId", (Object)streamId);
        jsonObject.put((Object)"subscriberId", (Object)subscriberId);
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public final void sendNoStreamIdSpecifiedError(Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"noStreamNameSpecified");
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendTakeCandidateMessage(long sdpMLineIndex, String sdpMid, String sdp, String streamId, Session session, String linkedSessionForSignaling, String subscriberId) {
        this.sendMessage(WebSocketCommunityHandler.getTakeCandidateJSON(sdpMLineIndex, sdpMid, sdp, streamId, linkedSessionForSignaling, subscriberId).toJSONString(), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String message, Session session) {
        WebSocketCommunityHandler webSocketCommunityHandler = this;
        synchronized (webSocketCommunityHandler) {
            block6: {
                if (session.isOpen()) {
                    try {
                        session.getBasicRemote().sendText(message);
                    }
                    catch (Exception e) {
                        String exceptioMessage = e.getMessage();
                        if (exceptioMessage != null && exceptioMessage.contains("WebSocket session has been closed")) break block6;
                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
        }
    }

    public void sendRoomNotActiveInformation(String roomId) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"no_active_streams_in_room");
        jsonResponse.put((Object)"room", (Object)roomId);
        this.sendMessage(jsonResponse.toJSONString(), this.session);
    }

    public void sendRoomInformation(Map<String, String> streamIdNameMap, String roomId) {
        JSONObject jsObject = new JSONObject();
        JSONArray jsonStreamIdArray = new JSONArray();
        JSONArray jsonStreamListArray = new JSONArray();
        this.prepareStreamListJSON(streamIdNameMap, jsonStreamIdArray, jsonStreamListArray, new HashMap<String, String>());
        jsObject.put((Object)"command", (Object)"roomInformation");
        jsObject.put((Object)"streams", (Object)jsonStreamIdArray);
        jsObject.put((Object)"streamList", (Object)jsonStreamListArray);
        jsObject.put((Object)"ATTR_ROOM_NAME", (Object)roomId);
        jsObject.put((Object)"room", (Object)roomId);
        String jsonString = jsObject.toJSONString();
        this.sendMessage(jsonString, this.session);
    }

    private void prepareStreamListJSON(Map<String, String> streamIdNameMap, JSONArray jsonStreamIdArray, JSONArray jsonStreamListArray, HashMap<String, String> streamMetaDataMap) {
        if (streamIdNameMap != null) {
            for (Map.Entry<String, String> e : streamIdNameMap.entrySet()) {
                jsonStreamIdArray.add((Object)e.getKey());
                JSONObject jsStreamObject = new JSONObject();
                jsStreamObject.put((Object)"streamId", (Object)e.getKey());
                jsStreamObject.put((Object)"streamName", (Object)e.getValue());
                jsStreamObject.put((Object)"metaData", (Object)streamMetaDataMap.get(e.getKey()));
                jsonStreamListArray.add((Object)jsStreamObject);
            }
        }
    }

    public void sendJoinedRoomMessage(String room, String newStreamId, Map<String, String> streamIdNameMap, HashMap<String, String> streamMetaDataMap) {
        JSONObject jsonResponse = new JSONObject();
        JSONArray jsonStreamIdArray = new JSONArray();
        JSONArray jsonStreamListArray = new JSONArray();
        this.prepareStreamListJSON(streamIdNameMap, jsonStreamIdArray, jsonStreamListArray, streamMetaDataMap);
        jsonResponse.put((Object)"command", (Object)"notification");
        jsonResponse.put((Object)"definition", (Object)"joinedTheRoom");
        jsonResponse.put((Object)"streamId", (Object)newStreamId);
        jsonResponse.put((Object)"streams", (Object)jsonStreamIdArray);
        jsonResponse.put((Object)"streamList", (Object)jsonStreamListArray);
        jsonResponse.put((Object)"ATTR_ROOM_NAME", (Object)room);
        jsonResponse.put((Object)"room", (Object)room);
        jsonResponse.put((Object)"maxTrackCount", (Object)this.appSettings.getMaxVideoTrackCount());
        this.sendMessage(jsonResponse.toJSONString(), this.session);
    }

    public static JSONObject getTakeCandidateJSON(long sdpMLineIndex, String sdpMid, String sdp, String streamId, String linkedSessionForSignaling, String subscriberId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"takeCandidate");
        jsonObject.put((Object)"label", (Object)sdpMLineIndex);
        jsonObject.put((Object)"id", (Object)sdpMid);
        jsonObject.put((Object)"candidate", (Object)sdp);
        jsonObject.put((Object)"streamId", (Object)streamId);
        jsonObject.put((Object)"linkSession", (Object)linkedSessionForSignaling);
        jsonObject.put((Object)"subscriberId", (Object)subscriberId);
        return jsonObject;
    }

    public static JSONObject getSDPConfigurationJSON(String description, String type, String streamId, Map<String, String> midSidMap, String linkedSessionForSignaling, String subscriberId) {
        JSONObject jsonResponseObject = new JSONObject();
        jsonResponseObject.put((Object)"command", (Object)"takeConfiguration");
        jsonResponseObject.put((Object)"sdp", (Object)description);
        jsonResponseObject.put((Object)"type", (Object)type);
        jsonResponseObject.put((Object)"streamId", (Object)streamId);
        jsonResponseObject.put((Object)"linkSession", (Object)linkedSessionForSignaling);
        jsonResponseObject.put((Object)"subscriberId", (Object)subscriberId);
        if (midSidMap != null) {
            JSONObject jsonIdMappingObject = new JSONObject();
            for (Map.Entry<String, String> entry : midSidMap.entrySet()) {
                jsonIdMappingObject.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            jsonResponseObject.put((Object)"idMapping", (Object)jsonIdMappingObject);
        }
        return jsonResponseObject;
    }

    public void sendInvalidStreamNameError(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"invalidStreamName");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public ApplicationContext getAppContext() {
        return this.appContext;
    }

    public void setAppContext(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    public void setAppAdaptor(AntMediaApplicationAdapter appAdaptor) {
        this.appAdaptor = appAdaptor;
    }

    public void sendRemoteDescriptionSetFailure(Session session, String streamId, String subscriberId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"error");
        jsonObject.put((Object)"definition", (Object)"notSetRemoteDescription");
        jsonObject.put((Object)"streamId", (Object)streamId);
        jsonObject.put((Object)"subscriberId", (Object)subscriberId);
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public void sendLocalDescriptionSetFailure(Session session, String streamId, String subscriberId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"error");
        jsonObject.put((Object)"definition", (Object)"notSetLocalDescription");
        jsonObject.put((Object)"streamId", (Object)streamId);
        jsonObject.put((Object)"subscriberId", (Object)subscriberId);
        this.sendMessage(jsonObject.toJSONString(), session);
    }

    public void sendNotFoundJSON(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"error_code", (Object)"404");
        jsonResponse.put((Object)"definition", (Object)"no_stream_exist");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void sendServerError(String streamId, Session session) {
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put((Object)"command", (Object)"error");
        jsonResponse.put((Object)"definition", (Object)"server_error_check_logs");
        jsonResponse.put((Object)"streamId", (Object)streamId);
        this.sendMessage(jsonResponse.toJSONString(), session);
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

