/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.AudioDecoderFactoryFactory;
import org.webrtc.CalledByNative;

public class BuiltinAudioDecoderFactoryFactory
implements AudioDecoderFactoryFactory {
    private AudioPacketListener audioPacketListener;
    private boolean customDecoder = false;
    private long audioDecoderFactory = -1L;
    ByteBuffer buffer = ByteBuffer.allocateDirect(4096);

    @Override
    public long createNativeAudioDecoderFactory() {
        this.audioDecoderFactory = BuiltinAudioDecoderFactoryFactory.nativeCreateBuiltinAudioDecoderFactory(this, this.customDecoder, this.buffer);
        return this.audioDecoderFactory;
    }

    @CalledByNative
    void onAudioPacket(int size, long timestamp, int audioLevel, boolean voiceActivity, boolean hasAudioLevel) {
        byte[] data = new byte[size];
        this.buffer.rewind();
        this.buffer.get(data, 0, size);
        this.audioPacketListener.onAudioPacketData(ByteBuffer.wrap(data), timestamp, audioLevel, voiceActivity, hasAudioLevel);
    }

    public void setAudioPacketListener(AudioPacketListener audioPacketListener) {
        this.audioPacketListener = audioPacketListener;
    }

    public AudioPacketListener getAudioPacketListener() {
        return this.audioPacketListener;
    }

    private static native long nativeCreateBuiltinAudioDecoderFactory(BuiltinAudioDecoderFactoryFactory var0, boolean var1, ByteBuffer var2);

    public void setCustomDecoder(boolean customDecoder) {
        this.customDecoder = customDecoder;
    }

    public static interface AudioPacketListener {
        public void onAudioPacketData(ByteBuffer var1, long var2, int var4, boolean var5, boolean var6);
    }
}

