/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.engine.node.entities;

import io.cloudslang.engine.data.AbstractIdentifiable;
import io.cloudslang.engine.node.entities.Worker;
import io.cloudslang.score.api.nodes.WorkerStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;

@Entity
@Table(name="OO_WORKER_NODES")
@DynamicUpdate(value=true)
@SelectBeforeUpdate(value=true)
public class WorkerNode
extends AbstractIdentifiable
implements Worker {
    public static final String[] DEFAULT_WORKER_GROUPS = new String[]{"RAS_Operator_Path"};
    @Column(name="UUID", nullable=false, unique=true, length=48)
    private String uuid;
    @Column(name="STATUS", nullable=false, length=20)
    private WorkerStatus status;
    @Column(name="IS_ACTIVE", nullable=false)
    private boolean active = true;
    @Column(name="HOST_NAME", length=128, nullable=false)
    private String hostName;
    @Column(name="INSTALL_PATH", nullable=false)
    private String installPath;
    @Size(max=255)
    @Column(name="DESCRIPTION", length=255)
    private @Size(max=255) String description;
    @Column(name="PASSWORD", length=80, nullable=false)
    private String password;
    @Column(name="MIGRATED_PASSWORD", length=80)
    private String migratedPassword;
    @Size(max=64)
    @Column(name="OS", length=64)
    private @Size(max=64) String os;
    @Size(max=64)
    @Column(name="JVM", length=64)
    private @Size(max=64) String jvm;
    @Size(max=16)
    @Column(name="DOT_NET_VERSION", length=16)
    private @Size(max=16) String dotNetVersion;
    @Column(name="ACK_TIME")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date ackTime;
    @Column(name="IS_DELETED", nullable=false)
    private boolean deleted = false;
    @Column(name="ACK_VERSION", nullable=false)
    private long ackVersion;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="OO_WORKER_GROUPS", joinColumns={@JoinColumn(name="WORKER_ID")})
    @Column(name="GROUP_NAME")
    private List<String> groups = new ArrayList<String>();
    @Column(name="BULK_NUMBER", length=48)
    private String bulkNumber;
    @Column(name="WRV", length=48)
    private String workerRecoveryVersion;
    @Column(name="VERSION", length=48, nullable=false)
    private String version = "";
    @Column(name="VERSION_ID", length=48, nullable=false)
    private String versionId = "";
    @Column(name="QUEUE_SYNC", nullable=false)
    private boolean queueSync = false;
    @Column(name="PERCENTAGE_UTILIZATION")
    private String workerBusynessValue;

    @Override
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public WorkerStatus getStatus() {
        return this.status;
    }

    public void setStatus(WorkerStatus status) {
        this.status = status;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public String getInstallPath() {
        return this.installPath;
    }

    public void setInstallPath(String installPath) {
        this.installPath = installPath;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMigratedPassword() {
        return this.migratedPassword;
    }

    public void setMigratedPassword(String migratedPassword) {
        this.migratedPassword = migratedPassword;
    }

    @Override
    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    @Override
    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    @Override
    public String getDotNetVersion() {
        return this.dotNetVersion;
    }

    public void setDotNetVersion(String dotNetVersion) {
        this.dotNetVersion = dotNetVersion;
    }

    public Date getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(Date ackTime) {
        this.ackTime = ackTime;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public List<String> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public long getAckVersion() {
        return this.ackVersion;
    }

    public void setAckVersion(long ackVersion) {
        this.ackVersion = ackVersion;
    }

    public String getBulkNumber() {
        return this.bulkNumber;
    }

    public void setBulkNumber(String bulkNumber) {
        this.bulkNumber = bulkNumber;
    }

    public String getWorkerRecoveryVersion() {
        return this.workerRecoveryVersion;
    }

    public void setWorkerRecoveryVersion(String workerRecoveryVersion) {
        this.workerRecoveryVersion = workerRecoveryVersion;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Override
    public boolean isQueueSync() {
        return this.queueSync;
    }

    public void setQueueSync(boolean queueSync) {
        this.queueSync = queueSync;
    }

    @Override
    public String getWorkerBusynessValue() {
        return this.workerBusynessValue;
    }

    public void setWorkerBusynessValue(String workerBusynessValue) {
        this.workerBusynessValue = workerBusynessValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerNode that = (WorkerNode)o;
        if (this.active != that.active) {
            return false;
        }
        if (this.deleted != that.deleted) {
            return false;
        }
        if (this.ackVersion != that.ackVersion) {
            return false;
        }
        if (this.queueSync != that.queueSync) {
            return false;
        }
        if (this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(that.hostName) : that.hostName != null) {
            return false;
        }
        if (this.installPath != null ? !this.installPath.equals(that.installPath) : that.installPath != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.os != null ? !this.os.equals(that.os) : that.os != null) {
            return false;
        }
        if (this.jvm != null ? !this.jvm.equals(that.jvm) : that.jvm != null) {
            return false;
        }
        if (this.dotNetVersion != null ? !this.dotNetVersion.equals(that.dotNetVersion) : that.dotNetVersion != null) {
            return false;
        }
        if (this.ackTime != null ? !this.ackTime.equals(that.ackTime) : that.ackTime != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.bulkNumber != null ? !this.bulkNumber.equals(that.bulkNumber) : that.bulkNumber != null) {
            return false;
        }
        if (this.workerRecoveryVersion != null ? !this.workerRecoveryVersion.equals(that.workerRecoveryVersion) : that.workerRecoveryVersion != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return !(this.versionId == null ? that.versionId != null : !this.versionId.equals(that.versionId));
    }

    public int hashCode() {
        int result = this.uuid != null ? this.uuid.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.active ? 1 : 0);
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        result = 31 * result + (this.installPath != null ? this.installPath.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.os != null ? this.os.hashCode() : 0);
        result = 31 * result + (this.jvm != null ? this.jvm.hashCode() : 0);
        result = 31 * result + (this.dotNetVersion != null ? this.dotNetVersion.hashCode() : 0);
        result = 31 * result + (this.ackTime != null ? this.ackTime.hashCode() : 0);
        result = 31 * result + (this.deleted ? 1 : 0);
        result = 31 * result + (this.queueSync ? 1 : 0);
        result = 31 * result + (int)(this.ackVersion ^ this.ackVersion >>> 32);
        result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
        result = 31 * result + (this.bulkNumber != null ? this.bulkNumber.hashCode() : 0);
        result = 31 * result + (this.workerRecoveryVersion != null ? this.workerRecoveryVersion.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.versionId != null ? this.versionId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WorkerNode{uuid='" + this.uuid + '\'' + ", status=" + this.status + ", active=" + this.active + ", hostName='" + this.hostName + '\'' + ", installPath='" + this.installPath + '\'' + ", description='" + this.description + '\'' + ", os='" + this.os + '\'' + ", jvm='" + this.jvm + '\'' + ", dotNetVersion='" + this.dotNetVersion + '\'' + ", ackTime=" + this.ackTime + ", deleted=" + this.deleted + ", ackVersion=" + this.ackVersion + ", groups=" + this.groups + ", bulkNumber='" + this.bulkNumber + '\'' + ", workerRecoveryVersion='" + this.workerRecoveryVersion + '\'' + ", version='" + this.version + '\'' + ", versionId='" + this.versionId + '\'' + ", queueSync='" + this.queueSync + '\'' + '}';
    }
}

