/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.packaging.manifest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum DeliveryGuarantee {
    AT_LEAST_ONCE("at_least_once", "atLeastOnce"),
    EXACTLY_ONCE("exactly_once", "exactlyOnce");

    private static final Map<String, DeliveryGuarantee> TYPES_BY_JSON_NAME;
    private static final Map<String, DeliveryGuarantee> TYPES_BY_XML_NAME;
    private final String displayName;
    private final String xmlName;

    public static Set<String> names() {
        return TYPES_BY_XML_NAME.keySet();
    }

    @JsonCreator
    public static DeliveryGuarantee parseJson(String displayName) {
        if (displayName != null) {
            displayName = displayName.toLowerCase();
        }
        return TYPES_BY_JSON_NAME.get(displayName);
    }

    public static DeliveryGuarantee parseXml(String xmlName) {
        return TYPES_BY_XML_NAME.get(xmlName);
    }

    private DeliveryGuarantee(String displayName, String xmlName) {
        this.displayName = displayName;
        this.xmlName = xmlName;
    }

    @JsonValue
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    static {
        HashMap<String, DeliveryGuarantee> typesByJsonName = new HashMap<String, DeliveryGuarantee>();
        HashMap<String, DeliveryGuarantee> typesByXmlName = new HashMap<String, DeliveryGuarantee>();
        for (DeliveryGuarantee type : DeliveryGuarantee.values()) {
            typesByJsonName.put(type.getDisplayName().toLowerCase(), type);
            typesByXmlName.put(type.xmlName, type);
        }
        TYPES_BY_JSON_NAME = Collections.unmodifiableMap(typesByJsonName);
        TYPES_BY_XML_NAME = Collections.unmodifiableMap(typesByXmlName);
    }
}

