/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.crnk.client.action.ActionStubFactory;
import io.crnk.client.action.ActionStubFactoryContext;
import io.crnk.client.http.HttpAdapter;
import io.crnk.client.http.HttpAdapterProvider;
import io.crnk.client.http.apache.HttpClientAdapterProvider;
import io.crnk.client.http.okhttp.OkHttpAdapterProvider;
import io.crnk.client.internal.ClientDocumentMapper;
import io.crnk.client.internal.ClientStubInvocationHandler;
import io.crnk.client.internal.RelationshipRepositoryStubImpl;
import io.crnk.client.internal.ResourceRepositoryStubImpl;
import io.crnk.client.internal.proxy.BasicProxyFactory;
import io.crnk.client.internal.proxy.ClientProxyFactory;
import io.crnk.client.internal.proxy.ClientProxyFactoryContext;
import io.crnk.client.legacy.RelationshipRepositoryStub;
import io.crnk.client.legacy.ResourceRepositoryStub;
import io.crnk.client.module.ClientModule;
import io.crnk.client.module.ClientModuleFactory;
import io.crnk.client.module.HttpAdapterAware;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.information.repository.RepositoryInformationProvider;
import io.crnk.core.engine.information.repository.RepositoryInformationProviderContext;
import io.crnk.core.engine.information.repository.RepositoryMethodAccess;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceInformationProvider;
import io.crnk.core.engine.internal.exception.ExceptionMapperLookup;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistryBuilder;
import io.crnk.core.engine.internal.information.repository.ResourceRepositoryInformationImpl;
import io.crnk.core.engine.internal.jackson.JacksonModule;
import io.crnk.core.engine.internal.registry.ResourceRegistryImpl;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.JsonApiUrlBuilder;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.UrlUtils;
import io.crnk.core.engine.registry.DefaultResourceRegistryPart;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.url.ConstantServiceUrlProvider;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.exception.InvalidResourceException;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.discovery.ResourceLookup;
import io.crnk.core.module.internal.DefaultRepositoryInformationProviderContext;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.utils.Optional;
import io.crnk.legacy.internal.DirectResponseRelationshipEntry;
import io.crnk.legacy.internal.DirectResponseResourceEntry;
import io.crnk.legacy.registry.RepositoryInstanceBuilder;
import io.crnk.legacy.repository.RelationshipRepository;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class CrnkClient {
    private HttpAdapter httpAdapter;
    private ObjectMapper objectMapper;
    private ResourceRegistry resourceRegistry;
    private ModuleRegistry moduleRegistry;
    private JsonApiUrlBuilder urlBuilder;
    private boolean initialized = false;
    private ExceptionMapperRegistry exceptionMapperRegistry;
    private boolean pushAlways = false;
    private ActionStubFactory actionStubFactory;
    private ClientDocumentMapper documentMapper;
    private List<HttpAdapterProvider> httpAdapterProviders = new ArrayList<HttpAdapterProvider>();

    public CrnkClient(String serviceUrl) {
        this((ServiceUrlProvider)new ConstantServiceUrlProvider(UrlUtils.removeTrailingSlash((String)serviceUrl)));
    }

    public CrnkClient(ServiceUrlProvider serviceUrlProvider) {
        this.registerHttpAdapterProvider(new OkHttpAdapterProvider());
        this.registerHttpAdapterProvider(new HttpClientAdapterProvider());
        this.moduleRegistry = new ModuleRegistry(false);
        this.moduleRegistry.getHttpRequestContextProvider().setServiceUrlProvider(serviceUrlProvider);
        this.moduleRegistry.addModule((Module)new ClientModule());
        this.resourceRegistry = new ClientResourceRegistry(this.moduleRegistry);
        this.urlBuilder = new JsonApiUrlBuilder(this.resourceRegistry);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.moduleRegistry.addModule((Module)new JacksonModule(this.objectMapper));
        this.documentMapper = new ClientDocumentMapper(this.moduleRegistry, this.objectMapper, null);
        this.setProxyFactory(new BasicProxyFactory());
    }

    public void findModules() {
        ServiceLoader<ClientModuleFactory> loader = ServiceLoader.load(ClientModuleFactory.class);
        for (ClientModuleFactory factory : loader) {
            Module module = factory.create();
            this.addModule(module);
        }
    }

    public void setProxyFactory(ClientProxyFactory proxyFactory) {
        proxyFactory.init(new ClientProxyFactoryContext(){

            @Override
            public ModuleRegistry getModuleRegistry() {
                return CrnkClient.this.moduleRegistry;
            }

            @Override
            public <T> DefaultResourceList<T> getCollection(Class<T> resourceClass, String url) {
                RegistryEntry entry = CrnkClient.this.resourceRegistry.findEntry(resourceClass);
                ResourceInformation resourceInformation = entry.getResourceInformation();
                ResourceRepositoryStubImpl repositoryStub = new ResourceRepositoryStubImpl(CrnkClient.this, resourceClass, resourceInformation, CrnkClient.this.urlBuilder);
                return repositoryStub.findAll(url);
            }
        });
        this.documentMapper.setProxyFactory(proxyFactory);
    }

    public void registerHttpAdapterProvider(HttpAdapterProvider httpAdapterProvider) {
        this.httpAdapterProviders.add(httpAdapterProvider);
    }

    public List<HttpAdapterProvider> getHttpAdapterProviders() {
        return this.httpAdapterProviders;
    }

    protected HttpAdapter detectHttpAdapter() {
        for (HttpAdapterProvider httpAdapterProvider : this.httpAdapterProviders) {
            if (!httpAdapterProvider.isAvailable()) continue;
            return httpAdapterProvider.newInstance();
        }
        throw new IllegalStateException("no httpAdapter can be initialized, add okhttp3 (com.squareup.okhttp3:okhttp) or apache http client (org.apache.httpcomponents:httpclient) to the classpath");
    }

    public boolean getPushAlways() {
        return this.pushAlways;
    }

    public void setPushAlways(boolean pushAlways) {
        this.pushAlways = pushAlways;
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initHttpAdapter();
        this.initModuleRegistry();
        this.initExceptionMapperRegistry();
        this.initResources();
    }

    private void initHttpAdapter() {
        if (this.httpAdapter == null) {
            this.httpAdapter = this.detectHttpAdapter();
        }
    }

    private void initResources() {
        ResourceLookup resourceLookup = this.moduleRegistry.getResourceLookup();
        for (Class resourceClass : resourceLookup.getResourceClasses()) {
            this.getQuerySpecRepository(resourceClass);
        }
    }

    private void initModuleRegistry() {
        this.moduleRegistry.init(this.objectMapper);
    }

    private void initExceptionMapperRegistry() {
        ExceptionMapperLookup exceptionMapperLookup = this.moduleRegistry.getExceptionMapperLookup();
        this.exceptionMapperRegistry = new ExceptionMapperRegistryBuilder().build(exceptionMapperLookup);
    }

    private <T, I extends Serializable> RegistryEntry allocateRepository(Class<T> resourceClass) {
        ResourceInformationProvider resourceInformationProvider = this.moduleRegistry.getResourceInformationBuilder();
        ResourceInformation resourceInformation = resourceInformationProvider.build(resourceClass);
        final ResourceRepositoryStubImpl repositoryStub = new ResourceRepositoryStubImpl(this, resourceClass, resourceInformation, this.urlBuilder);
        RepositoryInstanceBuilder repositoryInstanceBuilder = new RepositoryInstanceBuilder(null, null){

            public Object buildRepository() {
                return repositoryStub;
            }
        };
        ResourceRepositoryInformationImpl repositoryInformation = new ResourceRepositoryInformationImpl(resourceInformation.getResourceType(), resourceInformation, RepositoryMethodAccess.ALL);
        DirectResponseResourceEntry resourceEntry = new DirectResponseResourceEntry(repositoryInstanceBuilder);
        ArrayList relationshipEntries = new ArrayList();
        RegistryEntry registryEntry = new RegistryEntry(resourceInformation, (ResourceRepositoryInformation)repositoryInformation, (ResourceEntry)resourceEntry, relationshipEntries);
        registryEntry.initialize(this.moduleRegistry);
        this.resourceRegistry.addEntry(resourceClass, registryEntry);
        this.allocateRepositoryRelations(registryEntry);
        return registryEntry;
    }

    private void allocateRepositoryRelations(RegistryEntry registryEntry) {
        ResourceInformation resourceInformation = registryEntry.getResourceInformation();
        List relationshipFields = resourceInformation.getRelationshipFields();
        for (ResourceField relationshipField : relationshipFields) {
            Class targetClass = relationshipField.getElementType();
            Class sourceClass = resourceInformation.getResourceClass();
            this.allocateRepositoryRelation(sourceClass, targetClass);
        }
    }

    private void allocateRepositoryRelation(Class sourceClass, Class targetClass) {
        RegistryEntry targetEntry;
        ResourceInformation targetResourceInformation;
        RegistryEntry sourceEntry;
        Optional optRelationshipEntry;
        ClientResourceRegistry clientResourceRegistry = (ClientResourceRegistry)this.resourceRegistry;
        if (!clientResourceRegistry.isInitialized(sourceClass)) {
            this.allocateRepository(sourceClass);
        }
        if (!clientResourceRegistry.isInitialized(targetClass)) {
            this.allocateRepository(targetClass);
        }
        if (!(optRelationshipEntry = (sourceEntry = this.resourceRegistry.getEntry(sourceClass)).getRelationshipEntry((targetResourceInformation = (targetEntry = this.resourceRegistry.getEntry(targetClass)).getResourceInformation()).getResourceType())).isPresent()) {
            final RelationshipRepositoryStubImpl relationshipRepositoryStub = new RelationshipRepositoryStubImpl(this, sourceClass, targetClass, sourceEntry.getResourceInformation(), this.urlBuilder);
            RepositoryInstanceBuilder<RelationshipRepository> relationshipRepositoryInstanceBuilder = new RepositoryInstanceBuilder<RelationshipRepository>(null, null){

                public RelationshipRepository buildRepository() {
                    return relationshipRepositoryStub;
                }
            };
            DirectResponseRelationshipEntry relationshipEntry = new DirectResponseRelationshipEntry((RepositoryInstanceBuilder)relationshipRepositoryInstanceBuilder){

                public String getTargetResourceType() {
                    return targetResourceInformation.getResourceType();
                }
            };
            sourceEntry.getRelationshipEntries().add(relationshipEntry);
        }
    }

    @Deprecated
    public <R extends ResourceRepositoryV2<?, ?>> R getResourceRepository(Class<R> repositoryInterfaceClass) {
        return this.getRepositoryForInterface(repositoryInterfaceClass);
    }

    public <R extends ResourceRepositoryV2<?, ?>> R getRepositoryForInterface(Class<R> repositoryInterfaceClass) {
        this.init();
        RepositoryInformationProvider informationBuilder = this.moduleRegistry.getRepositoryInformationBuilder();
        PreconditionUtil.assertTrue((String)"no a valid repository interface", (boolean)informationBuilder.accept(repositoryInterfaceClass));
        ResourceRepositoryInformation repositoryInformation = (ResourceRepositoryInformation)informationBuilder.build(repositoryInterfaceClass, (RepositoryInformationProviderContext)new DefaultRepositoryInformationProviderContext(this.moduleRegistry));
        Class resourceClass = ((ResourceInformation)repositoryInformation.getResourceInformation().get()).getResourceClass();
        ResourceRepositoryV2 actionStub = this.actionStubFactory != null ? (ResourceRepositoryV2)this.actionStubFactory.createStub(repositoryInterfaceClass) : null;
        ResourceRepositoryV2 repositoryStub = this.getQuerySpecRepository(resourceClass);
        ClassLoader classLoader = repositoryInterfaceClass.getClassLoader();
        ClientStubInvocationHandler invocationHandler = new ClientStubInvocationHandler(repositoryInterfaceClass, repositoryStub, actionStub);
        return (R)((ResourceRepositoryV2)Proxy.newProxyInstance(classLoader, new Class[]{repositoryInterfaceClass, ResourceRepositoryV2.class}, (InvocationHandler)invocationHandler));
    }

    @Deprecated
    public <T, I extends Serializable> ResourceRepositoryStub<T, I> getQueryParamsRepository(Class<T> resourceClass) {
        this.init();
        RegistryEntry entry = this.resourceRegistry.findEntry(resourceClass);
        ResourceRepositoryAdapter repositoryAdapter = entry.getResourceRepository(null);
        return (ResourceRepositoryStub)repositoryAdapter.getResourceRepository();
    }

    public <T, I extends Serializable> ResourceRepositoryV2<T, I> getRepositoryForType(Class<T> resourceClass) {
        this.init();
        RegistryEntry entry = this.resourceRegistry.findEntry(resourceClass);
        ResourceRepositoryAdapter repositoryAdapter = entry.getResourceRepository(null);
        return (ResourceRepositoryV2)repositoryAdapter.getResourceRepository();
    }

    public ResourceRepositoryV2<Resource, String> getRepositoryForPath(String resourceType) {
        this.init();
        ResourceInformation resourceInformation = new ResourceInformation(this.moduleRegistry.getTypeParser(), Resource.class, resourceType, null, null);
        return new ResourceRepositoryStubImpl<Resource, String>(this, Resource.class, resourceInformation, this.urlBuilder);
    }

    public RelationshipRepositoryV2<Resource, String, Resource, String> getRepositoryForPath(String sourceResourceType, String targetResourceType) {
        this.init();
        ResourceInformation sourceResourceInformation = new ResourceInformation(this.moduleRegistry.getTypeParser(), Resource.class, sourceResourceType, null, null);
        return new RelationshipRepositoryStubImpl<Resource, String, Resource, String>(this, Resource.class, Resource.class, sourceResourceInformation, this.urlBuilder);
    }

    @Deprecated
    public <T, I extends Serializable> ResourceRepositoryV2<T, I> getQuerySpecRepository(Class<T> resourceClass) {
        return this.getRepositoryForType(resourceClass);
    }

    public <T, I extends Serializable, D, J extends Serializable> RelationshipRepositoryStub<T, I, D, J> getQueryParamsRepository(Class<T> sourceClass, Class<D> targetClass) {
        this.init();
        RegistryEntry sourceEntry = this.resourceRegistry.findEntry(sourceClass);
        RegistryEntry targetEntry = this.resourceRegistry.findEntry(targetClass);
        RelationshipRepositoryAdapter repositoryAdapter = sourceEntry.getRelationshipRepositoryForType(targetEntry.getResourceInformation().getResourceType(), null);
        return (RelationshipRepositoryStub)repositoryAdapter.getRelationshipRepository();
    }

    public <T, I extends Serializable, D, J extends Serializable> RelationshipRepositoryV2<T, I, D, J> getRepositoryForType(Class<T> sourceClass, Class<D> targetClass) {
        this.init();
        RegistryEntry sourceEntry = this.resourceRegistry.findEntry(sourceClass);
        RegistryEntry targetEntry = this.resourceRegistry.findEntry(targetClass);
        this.allocateRepositoryRelation(sourceClass, targetClass);
        RelationshipRepositoryAdapter repositoryAdapter = sourceEntry.getRelationshipRepositoryForType(targetEntry.getResourceInformation().getResourceType(), null);
        return (RelationshipRepositoryV2)repositoryAdapter.getRelationshipRepository();
    }

    @Deprecated
    public <T, I extends Serializable, D, J extends Serializable> RelationshipRepositoryV2<T, I, D, J> getQuerySpecRepository(Class<T> sourceClass, Class<D> targetClass) {
        return this.getRepositoryForType(sourceClass, targetClass);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ResourceRegistry getRegistry() {
        this.init();
        return this.resourceRegistry;
    }

    public void addModule(Module module) {
        PreconditionUtil.assertFalse((String)"already initialized, cannot add module", (boolean)this.initialized);
        if (module instanceof HttpAdapterAware) {
            ((HttpAdapterAware)module).setHttpAdapter(this.getHttpAdapter());
        }
        this.moduleRegistry.addModule(module);
    }

    public HttpAdapter getHttpAdapter() {
        this.initHttpAdapter();
        return this.httpAdapter;
    }

    public void setHttpAdapter(HttpAdapter httpAdapter) {
        this.httpAdapter = httpAdapter;
        List modules = this.moduleRegistry.getModules();
        for (Module module : modules) {
            if (!(module instanceof HttpAdapterAware)) continue;
            ((HttpAdapterAware)module).setHttpAdapter(this.getHttpAdapter());
        }
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        this.init();
        return this.exceptionMapperRegistry;
    }

    public ActionStubFactory getActionStubFactory() {
        return this.actionStubFactory;
    }

    public void setActionStubFactory(ActionStubFactory actionStubFactory) {
        this.actionStubFactory = actionStubFactory;
        if (actionStubFactory != null) {
            actionStubFactory.init(new ActionStubFactoryContext(){

                @Override
                public ServiceUrlProvider getServiceUrlProvider() {
                    return CrnkClient.this.moduleRegistry.getHttpRequestContextProvider().getServiceUrlProvider();
                }

                @Override
                public HttpAdapter getHttpAdapter() {
                    return CrnkClient.this.httpAdapter;
                }
            });
        }
    }

    public ModuleRegistry getModuleRegistry() {
        return this.moduleRegistry;
    }

    public ClientDocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.moduleRegistry.getHttpRequestContextProvider().getServiceUrlProvider();
    }

    class ClientResourceRegistry
    extends ResourceRegistryImpl {
        public ClientResourceRegistry(ModuleRegistry moduleRegistry) {
            super((ResourceRegistryPart)new DefaultResourceRegistryPart(), moduleRegistry);
        }

        protected synchronized RegistryEntry findEntry(Class<?> clazz, boolean allowNull) {
            RegistryEntry entry = this.getEntry(clazz);
            if (entry == null) {
                ResourceInformationProvider informationBuilder = CrnkClient.this.moduleRegistry.getResourceInformationBuilder();
                if (!informationBuilder.accept(clazz)) {
                    throw new InvalidResourceException(clazz.getName() + " not recognized as resource class, consider adding @JsonApiResource annotation");
                }
                entry = CrnkClient.this.allocateRepository(clazz);
            }
            return entry;
        }

        public boolean isInitialized(Class<?> clazz) {
            return super.getEntry(clazz) != null;
        }
    }
}

